/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.env.actor2;

import com.caucho.env.actor.ActorProcessor;
import com.caucho.env.actor.ActorQueueApi;
import com.caucho.env.actor2.QueueRing;
import com.caucho.env.actor2.QueueRingFixed;
import com.caucho.env.thread.AbstractTaskWorker;
import com.caucho.util.L10N;
import java.util.concurrent.TimeUnit;

public class ActorQueue2<T>
implements ActorQueueApi<T> {
    private static final L10N L = new L10N(ActorQueue2.class);
    private final QueueRing<T> _actorQueue;
    private final ActorWorker<T> _worker;

    public ActorQueue2(int capacity, ActorProcessor<? super T> processor) {
        if (processor == null) {
            throw new NullPointerException();
        }
        this._actorQueue = new QueueRingFixed<T>(capacity);
        this._worker = new ActorWorker<T>(this._actorQueue, processor);
    }

    @Override
    public int getAvailable() {
        return this._actorQueue.remainingCapacity();
    }

    @Override
    public boolean isEmpty() {
        return this._actorQueue.isEmpty();
    }

    @Override
    public int getSize() {
        return this._actorQueue.size();
    }

    @Override
    public final void offer(T value) {
        this.offer(value, true);
    }

    @Override
    public final boolean offer(T value, boolean isWait) {
        QueueRing<T> queue = this._actorQueue;
        if (!queue.offer(value, 0L, TimeUnit.SECONDS)) {
            if (!isWait) {
                return false;
            }
            this.wake();
            if (!queue.offer(value, 5L, TimeUnit.MINUTES)) {
                throw new IllegalStateException(L.l("offer timeout {0} {1}", (Object)this, (Object)value));
            }
        }
        this.wake();
        return true;
    }

    public String getWorkerState() {
        return this._worker.getState();
    }

    @Override
    public void wake() {
        this._worker.wake();
    }

    public void close() {
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[" + this._actorQueue + "]";
    }

    private static class ActorWorker<T>
    extends AbstractTaskWorker {
        private final ActorProcessor<? super T> _processor;
        private final QueueRing<T> _queue;

        ActorWorker(QueueRing<T> queue, ActorProcessor<? super T> processor) {
            this._queue = queue;
            this._processor = processor;
        }

        @Override
        protected String getThreadName() {
            return this._processor.getThreadName();
        }

        @Override
        protected boolean isRetry() {
            return !this._queue.isEmpty();
        }

        @Override
        public final long runTask() {
            try {
                try {
                    this._processor.onProcessStart();
                    this._queue.deliver(this._processor);
                }
                finally {
                    this._processor.onProcessComplete();
                }
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
            return 0L;
        }

        @Override
        public String toString() {
            return this.getClass().getSimpleName() + "[" + this._processor + "]";
        }
    }
}

