/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.env.meter;

import com.caucho.env.meter.AbstractMeter;
import com.caucho.env.meter.SemaphoreSensor;
import java.util.concurrent.atomic.AtomicLong;

public final class SemaphoreMeter
extends AbstractMeter
implements SemaphoreSensor {
    private final AtomicLong _acquireCount = new AtomicLong();
    private final AtomicLong _releaseCount = new AtomicLong();
    private final AtomicLong _min = new AtomicLong();
    private final AtomicLong _max = new AtomicLong();
    private long _lastAcquireCount;
    private long _value;

    public SemaphoreMeter(String name) {
        super(name);
    }

    public AbstractMeter createCount(String name) {
        return new CountProbe(name);
    }

    public AbstractMeter createMin(String name) {
        return new MinProbe(name);
    }

    public AbstractMeter createMax(String name) {
        return new MaxProbe(name);
    }

    @Override
    public final void acquire() {
        long max;
        long acquire = this._acquireCount.incrementAndGet();
        long release = this._releaseCount.get();
        long count = acquire - release;
        while ((max = this._max.get()) < count) {
            this._max.compareAndSet(max, count);
        }
    }

    @Override
    public final void release() {
        long min;
        long acquire = this._acquireCount.get();
        long release = this._releaseCount.incrementAndGet();
        long count = acquire - release;
        while (count < (min = this._min.get())) {
            this._min.compareAndSet(min, count);
        }
    }

    @Override
    public final void sample() {
        this._value = this._acquireCount.get() - this._releaseCount.get();
    }

    @Override
    public final double calculate() {
        return this._value;
    }

    public final double sampleCount() {
        long lastAcquireCount = this._lastAcquireCount;
        this._lastAcquireCount = this._acquireCount.get();
        return this._lastAcquireCount - lastAcquireCount;
    }

    public final double sampleMax() {
        long count = this._acquireCount.get() - this._releaseCount.get();
        long max = this._max.getAndSet(count);
        return max;
    }

    public final double sampleMin() {
        long count = this._acquireCount.get() - this._releaseCount.get();
        long min = this._min.getAndSet(count);
        return min;
    }

    class MinProbe
    extends AbstractMeter {
        private double _value;

        MinProbe(String name) {
            super(name);
        }

        @Override
        public void sample() {
            this._value = SemaphoreMeter.this.sampleMin();
        }

        @Override
        public double calculate() {
            return this._value;
        }
    }

    class MaxProbe
    extends AbstractMeter {
        private double _value;

        MaxProbe(String name) {
            super(name);
        }

        @Override
        public void sample() {
            this._value = SemaphoreMeter.this.sampleMax();
        }

        @Override
        public double calculate() {
            return this._value;
        }
    }

    class CountProbe
    extends AbstractMeter {
        private double _value;

        CountProbe(String name) {
            super(name);
        }

        @Override
        public void sample() {
            this._value = SemaphoreMeter.this.sampleCount();
        }

        @Override
        public double calculate() {
            return this._value;
        }
    }
}

