/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.env.thread1;

import com.caucho.env.warning.WarningService;
import com.caucho.util.CurrentTime;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.locks.LockSupport;
import java.util.logging.Level;
import java.util.logging.Logger;

public abstract class AbstractTaskWorker1
implements Runnable {
    private static final Logger log = Logger.getLogger(AbstractTaskWorker1.class.getName());
    private static final int TASK_PARK = 0;
    private static final int TASK_SLEEP = 1;
    private static final int TASK_READY = 2;
    private static final AtomicLong _idGen = new AtomicLong();
    private final AtomicInteger _taskState = new AtomicInteger();
    private final AtomicBoolean _isActive = new AtomicBoolean();
    private final ClassLoader _classLoader;
    private final String _threadName;
    private long _workerIdleTimeout = 30000L;
    private boolean _isClosed;
    private int _loopCount = 0;
    private volatile Thread _thread;

    protected AbstractTaskWorker1(ClassLoader classLoader) {
        this._classLoader = classLoader;
        this._threadName = this.toString() + "-" + _idGen.incrementAndGet();
    }

    protected boolean isPermanent() {
        return false;
    }

    protected void setWorkerIdleTimeout(long timeout) {
        if (timeout < 0L) {
            throw new IllegalArgumentException();
        }
        this._workerIdleTimeout = timeout;
    }

    protected void setLoopCount(int count) {
        this._loopCount = count;
    }

    public boolean isTaskActive() {
        return this._isActive.get();
    }

    public boolean isClosed() {
        return this._isClosed;
    }

    public abstract long runTask();

    public void destroy() {
        this._isClosed = true;
        this.wake();
        Thread thread = this._thread;
        if (thread != null) {
            LockSupport.unpark(thread);
        }
    }

    public final void wake() {
        Thread thread;
        int oldState = this._taskState.getAndSet(2);
        if (!this._isActive.getAndSet(true)) {
            this.startWorkerThread();
        }
        if (oldState == 0 && (thread = this._thread) != null) {
            LockSupport.unpark(thread);
        }
    }

    protected abstract void startWorkerThread();

    protected String getThreadName() {
        return this._threadName;
    }

    protected void onThreadStart() {
    }

    protected void onThreadComplete() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void run() {
        Thread thread = Thread.currentThread();
        String oldName = thread.getName();
        try {
            this._thread = thread;
            thread.setContextClassLoader(this._classLoader);
            this._thread.setName(this.getThreadName());
            this.onThreadStart();
            long now = this.getCurrentTimeActual();
            long expires = this._workerIdleTimeout > 0L ? now + this._workerIdleTimeout : 0L;
            while (true) {
                if (this._taskState.getAndSet(1) == 2) {
                    thread.setContextClassLoader(this._classLoader);
                    long delta = this.runTask();
                    now = this.getCurrentTimeActual();
                    if (delta > 0L) {
                        expires = now + delta;
                        continue;
                    }
                    if (delta == 0L) {
                        expires = 0L;
                        continue;
                    }
                    if (this._workerIdleTimeout > 0L) {
                        expires = now + this._workerIdleTimeout;
                        continue;
                    }
                    expires = 0L;
                    continue;
                }
                if (this.isClosed()) {
                    return;
                }
                for (int i = this._loopCount; i >= 0 && this._taskState.get() != 2; --i) {
                }
                if (expires > 0L && this._taskState.compareAndSet(1, 0)) {
                    Thread.interrupted();
                    LockSupport.parkUntil(expires);
                }
                if (this.isPermanent()) {
                    this._taskState.set(2);
                }
                if (this._taskState.get() != 2 && !this.isPermanent() && this.getCurrentTimeActual() >= expires) break;
            }
        }
        catch (Throwable e) {
            WarningService.sendCurrentWarning((Object)this, e);
            log.log(Level.WARNING, e.toString(), e);
        }
        finally {
            this._thread = null;
            this._isActive.set(false);
            this.onThreadComplete();
            if (this._taskState.get() == 2) {
                this.wake();
            }
            thread.setName(oldName);
        }
    }

    protected long getCurrentTimeActual() {
        return CurrentTime.getCurrentTimeActual();
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[]";
    }
}

