/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.loader;

import com.caucho.config.ConfigException;
import com.caucho.loader.CompilingLoader;
import com.caucho.loader.EnvironmentClassLoader;
import com.caucho.loader.LibraryLoader;
import com.caucho.loader.ModuleConfig;
import com.caucho.loader.SimpleLoader;
import com.caucho.loader.TreeLoader;
import com.caucho.loader.enhancer.EnhancerManager;
import com.caucho.loader.ivy.IvyLoader;
import com.caucho.util.L10N;
import javax.annotation.PostConstruct;

public class ClassLoaderConfig {
    private static final L10N L = new L10N(ClassLoaderConfig.class);
    private EnvironmentClassLoader _classLoader;
    private int _index;

    public ClassLoaderConfig() throws ConfigException {
        Thread thread = Thread.currentThread();
        ClassLoader loader = thread.getContextClassLoader();
        if (!(loader instanceof EnvironmentClassLoader)) {
            throw new ConfigException(L.l("<class-loader> requires an EnvironmentClassLoader."));
        }
        this._classLoader = (EnvironmentClassLoader)loader;
    }

    public void setServletHack(boolean hack) {
        this._classLoader.setServletHack(hack);
    }

    public SimpleLoader createSimpleLoader() {
        return new SimpleLoader(this._classLoader);
    }

    public IvyLoader createIvyLoader() {
        IvyLoader loader = new IvyLoader();
        loader.setLoader(this._classLoader);
        return loader;
    }

    public ModuleConfig createDependency() {
        ModuleConfig module = new ModuleConfig();
        return module;
    }

    public void addDependency(ModuleConfig config) {
    }

    public void addIvyLoader(IvyLoader loader) {
        this._classLoader.addLoader(loader, this._index++);
    }

    public LibraryLoader createLibraryLoader() {
        return new LibraryLoader(this._classLoader);
    }

    public ModuleConfig createModule() {
        ModuleConfig module = new ModuleConfig();
        return module;
    }

    public CompilingLoader createCompilingLoader() {
        return new CompilingLoader(this._classLoader);
    }

    public TreeLoader createTreeLoader() {
        return new TreeLoader(this._classLoader);
    }

    public EnhancerManager createEnhancer() throws ConfigException {
        return EnhancerManager.create();
    }

    public void addPriorityPackage(String priorityPackage) {
        this._classLoader.addPriorityPackage(priorityPackage);
    }

    @PostConstruct
    public void init() throws ConfigException {
        this._classLoader.init();
        this._classLoader.validate();
    }

    public String toString() {
        return "ClassLoaderConfig[]";
    }
}

