/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.loader;

import com.caucho.loader.EnvironmentClassLoader;
import java.util.concurrent.atomic.AtomicLong;

public class EnvironmentLocal<E> {
    private static Boolean _isSystemClassLoader;
    private static AtomicLong _varCount;
    private String _varName;
    private E _globalValue;

    public EnvironmentLocal() {
        this._varName = "resin:var-" + _varCount.incrementAndGet();
    }

    public EnvironmentLocal(String varName) {
        this._varName = varName;
    }

    public String getVariable() {
        return this._varName;
    }

    public E get() {
        Thread thread = Thread.currentThread();
        Object value = null;
        for (ClassLoader loader = thread.getContextClassLoader(); loader != null; loader = loader.getParent()) {
            EnvironmentClassLoader envLoader;
            if (!(loader instanceof EnvironmentClassLoader) || (value = (envLoader = (EnvironmentClassLoader)loader).getAttribute(this._varName)) == null) continue;
            return (E)value;
        }
        return this._globalValue;
    }

    public E get(ClassLoader loader) {
        Object value = null;
        while (loader != null) {
            EnvironmentClassLoader envLoader;
            if (loader instanceof EnvironmentClassLoader && (value = (envLoader = (EnvironmentClassLoader)loader).getAttribute(this._varName)) != null) {
                return (E)value;
            }
            loader = loader.getParent();
        }
        return this._globalValue;
    }

    public E getLevel() {
        Thread thread = Thread.currentThread();
        for (ClassLoader loader = thread.getContextClassLoader(); loader != null; loader = loader.getParent()) {
            if (!(loader instanceof EnvironmentClassLoader)) continue;
            EnvironmentClassLoader envLoader = (EnvironmentClassLoader)loader;
            return (E)envLoader.getAttribute(this._varName);
        }
        return this._globalValue;
    }

    public E getLevel(ClassLoader loader) {
        while (loader != null) {
            if (loader instanceof EnvironmentClassLoader) {
                EnvironmentClassLoader envLoader = (EnvironmentClassLoader)loader;
                return (E)envLoader.getAttribute(this._varName);
            }
            loader = loader.getParent();
        }
        return this._globalValue;
    }

    public final E set(E value) {
        Thread thread = Thread.currentThread();
        for (ClassLoader loader = thread.getContextClassLoader(); loader != null; loader = loader.getParent()) {
            if (!(loader instanceof EnvironmentClassLoader)) continue;
            EnvironmentClassLoader envLoader = (EnvironmentClassLoader)loader;
            return (E)envLoader.setAttribute(this._varName, value);
        }
        return this.setGlobal(value);
    }

    public final E set(E value, ClassLoader loader) {
        while (loader != null) {
            if (loader instanceof EnvironmentClassLoader) {
                EnvironmentClassLoader envLoader = (EnvironmentClassLoader)loader;
                return (E)envLoader.setAttribute(this._varName, value);
            }
            loader = loader.getParent();
        }
        return this.setGlobal(value);
    }

    public final E remove() {
        Thread thread = Thread.currentThread();
        for (ClassLoader loader = thread.getContextClassLoader(); loader != null; loader = loader.getParent()) {
            if (!(loader instanceof EnvironmentClassLoader)) continue;
            EnvironmentClassLoader envLoader = (EnvironmentClassLoader)loader;
            return (E)envLoader.removeAttribute(this._varName);
        }
        return this.setGlobal(null);
    }

    public final E remove(ClassLoader loader) {
        while (loader != null) {
            if (loader instanceof EnvironmentClassLoader) {
                EnvironmentClassLoader envLoader = (EnvironmentClassLoader)loader;
                return (E)envLoader.removeAttribute(this._varName);
            }
            loader = loader.getParent();
        }
        return this.setGlobal(null);
    }

    public E setGlobal(E value) {
        E oldValue = this._globalValue;
        this._globalValue = value;
        ClassLoader systemLoader = EnvironmentLocal.getSystemClassLoader();
        if (systemLoader instanceof EnvironmentClassLoader) {
            ((EnvironmentClassLoader)systemLoader).setAttribute(this._varName, value);
        } else {
            this._globalValue = value;
        }
        return oldValue;
    }

    public E getGlobal() {
        ClassLoader systemLoader = EnvironmentLocal.getSystemClassLoader();
        if (systemLoader instanceof EnvironmentClassLoader) {
            return (E)((EnvironmentClassLoader)systemLoader).getAttribute(this._varName);
        }
        return this._globalValue;
    }

    public static ClassLoader getSystemClassLoader() {
        if (_isSystemClassLoader == null) {
            _isSystemClassLoader = false;
            try {
                ClassLoader.getSystemClassLoader();
                _isSystemClassLoader = true;
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        if (_isSystemClassLoader.booleanValue()) {
            return ClassLoader.getSystemClassLoader();
        }
        return null;
    }

    static {
        _varCount = new AtomicLong();
    }
}

