/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.loader.ivy;

import com.caucho.config.ConfigException;
import com.caucho.loader.JarListLoader;
import com.caucho.loader.ivy.IvyCache;
import com.caucho.loader.ivy.IvyDependency;
import com.caucho.loader.ivy.IvyManager;
import com.caucho.vfs.Path;
import java.util.ArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.PostConstruct;

public class IvyLoader
extends JarListLoader {
    private static final Logger log = Logger.getLogger(IvyLoader.class.getName());
    private IvyManager _manager = new IvyManager();
    private Path _ivyFile;
    private ArrayList<IvyDependency> _dependencyList = new ArrayList();
    private ArrayList<Path> _pathList = new ArrayList();

    public void setIvyFile(Path path) {
        this._ivyFile = path;
    }

    public Path getIvyFile() {
        return this._ivyFile;
    }

    public IvyCache createCache() {
        return this._manager.createCache();
    }

    public void addDependency(IvyDependency dependency) {
        this._dependencyList.add(dependency);
    }

    @Override
    @PostConstruct
    public void init() throws ConfigException {
        this._manager.init();
        if (this._ivyFile != null && this._ivyFile.canRead()) {
            this._manager.configureIvyFile(this._ivyFile);
        }
        for (IvyDependency dependency : this._dependencyList) {
            this._manager.resolve(dependency);
        }
        for (Path path : this._manager.resolve()) {
            if (log.isLoggable(Level.FINE)) {
                log.fine("ivy-loader add " + path);
            }
            this.addJar(path);
        }
        super.init();
    }

    @Override
    public boolean isModified() {
        return false;
    }

    @Override
    public boolean logModified(Logger log) {
        if (this.isModified()) {
            log.info(this._ivyFile.getNativePath() + " has modified jar files");
            return true;
        }
        return false;
    }

    private void fillJars() {
        this._pathList.clear();
    }

    @Override
    public String toString() {
        return this.getClass().getSimpleName() + "[" + this._ivyFile + "]";
    }
}

