/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.quercus.env;

import com.caucho.quercus.env.ArgRef;
import com.caucho.quercus.env.ArrayValueImpl;
import com.caucho.quercus.env.BooleanValue;
import com.caucho.quercus.env.Callable;
import com.caucho.quercus.env.CallbackClassMethod;
import com.caucho.quercus.env.CallbackObjectMethod;
import com.caucho.quercus.env.ConstStringValue;
import com.caucho.quercus.env.DoubleValue;
import com.caucho.quercus.env.Env;
import com.caucho.quercus.env.JsonEncodeContext;
import com.caucho.quercus.env.LongValue;
import com.caucho.quercus.env.NullThisValue;
import com.caucho.quercus.env.NullValue;
import com.caucho.quercus.env.ObjectValue;
import com.caucho.quercus.env.QuercusClass;
import com.caucho.quercus.env.SerializeMap;
import com.caucho.quercus.env.StringValue;
import com.caucho.quercus.env.UnsetValue;
import com.caucho.quercus.env.Value;
import com.caucho.quercus.env.ValueType;
import com.caucho.quercus.env.Var;
import com.caucho.quercus.function.AbstractFunction;
import com.caucho.quercus.marshal.Marshal;
import com.caucho.quercus.marshal.MarshalFactory;
import com.caucho.vfs.WriteStream;
import java.io.IOException;
import java.io.Serializable;
import java.lang.reflect.Array;
import java.util.AbstractCollection;
import java.util.AbstractSet;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;

public abstract class ArrayValue
extends Value {
    private static final Logger log = Logger.getLogger(ArrayValue.class.getName());
    protected static final StringValue KEY = new ConstStringValue("key");
    protected static final StringValue VALUE = new ConstStringValue("value");
    public static final GetKey GET_KEY = new GetKey();
    public static final GetValue GET_VALUE = new GetValue();
    public static final StringValue ARRAY = new ConstStringValue("Array");
    private Entry _current;

    protected ArrayValue() {
    }

    @Override
    public String getType() {
        return "array";
    }

    @Override
    public ValueType getValueType() {
        return ValueType.ARRAY;
    }

    @Override
    public int toCharMarshalCost() {
        return 400;
    }

    @Override
    public int toStringMarshalCost() {
        return 400;
    }

    @Override
    public int toBinaryValueMarshalCost() {
        return 400;
    }

    @Override
    public int toStringValueMarshalCost() {
        return 400;
    }

    @Override
    public int toUnicodeValueMarshalCost() {
        return 400;
    }

    @Override
    public boolean toBoolean() {
        return this.getSize() != 0;
    }

    @Override
    public long toLong() {
        if (this.getSize() > 0) {
            return 1L;
        }
        return 0L;
    }

    @Override
    public double toDouble() {
        return this.toLong();
    }

    public String toString() {
        return "Array";
    }

    public Object toObject() {
        return null;
    }

    @Override
    public Value toAutoArray() {
        return this;
    }

    @Override
    public Object toJavaObject() {
        return this;
    }

    protected Entry getCurrent() {
        return this._current;
    }

    protected void setCurrent(Entry entry) {
        this._current = entry;
    }

    @Override
    public ArrayValue toArray() {
        return this;
    }

    @Override
    public ArrayValue toArrayValue(Env env) {
        return this;
    }

    @Override
    public Value toObject(Env env) {
        ObjectValue obj = env.createObject();
        Entry entry = this.getHead();
        while (entry != null) {
            Value key = entry.getKey();
            ((Value)obj).putField(env, key.toString(), entry.getValue());
            entry = entry._next;
        }
        return obj;
    }

    public Collection toJavaCollection(Env env, Class type) {
        Collection<Object> coll = null;
        if (type.isAssignableFrom(HashSet.class)) {
            coll = new HashSet();
        } else if (type.isAssignableFrom(TreeSet.class)) {
            coll = new TreeSet();
        } else {
            try {
                coll = (Collection)type.newInstance();
            }
            catch (Throwable e) {
                log.log(Level.FINE, e.toString(), e);
                env.warning(L.l("Can't assign array to {0}", (Object)type.getName()));
                return null;
            }
        }
        Entry entry = this.getHead();
        while (entry != null) {
            coll.add(entry.getValue().toJavaObject());
            entry = entry._next;
        }
        return coll;
    }

    public List toJavaList(Env env, Class type) {
        List list = null;
        if (type.isAssignableFrom(ArrayList.class)) {
            list = new ArrayList();
        } else if (type.isAssignableFrom(LinkedList.class)) {
            list = new LinkedList();
        } else if (type.isAssignableFrom(Vector.class)) {
            list = new Vector();
        } else {
            try {
                list = (List)type.newInstance();
            }
            catch (Throwable e) {
                log.log(Level.FINE, e.toString(), e);
                env.warning(L.l("Can't assign array to {0}", (Object)type.getName()));
                return null;
            }
        }
        Entry entry = this.getHead();
        while (entry != null) {
            list.add(entry.getValue().toJavaObject());
            entry = entry._next;
        }
        return list;
    }

    public Map toJavaMap(Env env, Class<?> type) {
        Map<Object, Object> map = null;
        if (type.isAssignableFrom(TreeMap.class)) {
            map = new TreeMap();
        } else if (type.isAssignableFrom(LinkedHashMap.class)) {
            map = new LinkedHashMap();
        } else {
            try {
                map = (Map)type.newInstance();
            }
            catch (Throwable e) {
                log.log(Level.FINE, e.toString(), e);
                env.warning(L.l("Can't assign array to {0}", (Object)type.getName()));
                return null;
            }
        }
        Entry entry = this.getHead();
        while (entry != null) {
            map.put(entry.getKey().toJavaObject(), entry.getValue().toJavaObject());
            entry = entry._next;
        }
        return map;
    }

    @Override
    public boolean isCallable(Env env, boolean isCheckSyntaxOnly, Value nameRef) {
        AbstractFunction fun;
        Value obj = this.get(LongValue.ZERO);
        Value nameV = this.get(LongValue.ONE);
        if (nameRef != null) {
            nameRef.set(NullValue.NULL);
        }
        if (!nameV.isString()) {
            return false;
        }
        if (isCheckSyntaxOnly) {
            if (obj.isObject() || obj.isString()) {
                if (nameRef != null) {
                    StringValue sb = env.createStringBuilder();
                    if (obj.isObject()) {
                        sb.append(obj.getClassName());
                    } else {
                        sb.append(obj);
                    }
                    sb.append("::");
                    sb.append(nameV);
                    nameRef.set(sb);
                }
                return true;
            }
            return false;
        }
        if (obj.isObject()) {
            StringValue nameStr = nameV.toStringValue(env);
            int p = nameStr.indexOf("::");
            if (p > 0) {
                String name = nameStr.toString();
                String clsName = name.substring(0, p);
                name = name.substring(p + 2);
                QuercusClass cls = env.findClass(clsName);
                if (cls == null) {
                    return false;
                }
                if (!obj.isA(env, cls)) {
                    return false;
                }
                nameStr = env.createString(name);
                fun = cls.findFunction(nameStr);
            } else {
                fun = obj.findFunction(nameStr);
            }
        } else {
            String clsName = obj.toString();
            QuercusClass cls = env.findClass(clsName);
            if (cls == null) {
                return false;
            }
            StringValue nameStr = nameV.toStringValue(env);
            fun = cls.findFunction(nameStr);
        }
        if (fun != null && fun.isPublic()) {
            if (nameRef != null) {
                StringValue sb = env.createStringBuilder();
                sb.append(fun.getDeclaringClass().getName());
                sb.append("::");
                sb.append(fun.getName());
                nameRef.set(sb);
            }
            return true;
        }
        return false;
    }

    @Override
    public Callable toCallable(Env env, boolean isOptional) {
        Value obj = this.get(LongValue.ZERO);
        Value nameV = this.get(LongValue.ONE);
        if (!nameV.isString()) {
            env.warning(L.l("'{0}' ({1}) is an unknown callback name", (Object)nameV, (Object)nameV.getClass().getSimpleName()));
            return super.toCallable(env, false);
        }
        String name = nameV.toString();
        if (obj.isObject()) {
            int p = name.indexOf("::");
            if (p > 0) {
                String clsName = name.substring(0, p);
                name = name.substring(p + 2);
                QuercusClass cls = env.findClass(clsName);
                if (cls == null) {
                    env.warning(L.l("Callback: '{0}' is not a valid callback class for {1}", (Object)clsName, (Object)name));
                    return super.toCallable(env, false);
                }
                return new CallbackClassMethod(cls, env.createString(name), obj);
            }
            return new CallbackObjectMethod((ObjectValue)obj, env.createString(name));
        }
        QuercusClass cl = env.findClass(obj.toString());
        if (cl == null) {
            env.warning(L.l("Callback: '{0}' is not a valid callback string for {1}", (Object)obj.toString(), (Object)obj));
            return super.toCallable(env, isOptional);
        }
        return new CallbackClassMethod(cl, env.createString(name), NullThisValue.NULL);
    }

    public final Value callCallback(Env env, Callable callback, Value key) {
        Value result;
        Value value = this.getRaw(key);
        if (value instanceof Var) {
            value = new ArgRef((Var)value);
            result = this.call(env, value);
        } else {
            Var aVar = new Var(value);
            result = callback.call(env, aVar);
            Value aNew = ((Value)aVar).toValue();
            if (aNew != value) {
                this.put(key, aNew);
            }
        }
        return result;
    }

    public final Value callCallback(Env env, Callable callback, Value key, Value a2) {
        Value result;
        Value value = this.getRaw(key);
        if (value instanceof Var) {
            value = new ArgRef((Var)value);
            result = callback.call(env, value, a2);
        } else {
            Var aVar = new Var(value);
            result = callback.call(env, aVar, a2);
            Value aNew = ((Value)aVar).toValue();
            if (aNew != value) {
                this.put(key, aNew);
            }
        }
        return result;
    }

    public final Value callCallback(Env env, Callable callback, Value key, Value a2, Value a3) {
        Value result;
        Value value = this.getRaw(key);
        if (value instanceof Var) {
            value = new ArgRef((Var)value);
            result = callback.call(env, value, a2, a3);
        } else {
            Var aVar = new Var(value);
            result = callback.call(env, aVar, a2, a3);
            Value aNew = ((Value)aVar).toValue();
            if (aNew != value) {
                this.put(key, aNew);
            }
        }
        return result;
    }

    @Override
    public boolean isArray() {
        return true;
    }

    @Override
    public Value copyReturn() {
        return this.copy();
    }

    @Override
    public abstract Value copy();

    @Override
    public Value toLocalRef() {
        return this.copy();
    }

    @Override
    public abstract Value copy(Env var1, IdentityHashMap<Value, Value> var2);

    @Override
    public abstract int getSize();

    @Override
    public int getCount(Env env) {
        return this.getSize();
    }

    @Override
    public int getCountRecursive(Env env) {
        int count = this.getCount(env);
        for (Map.Entry<Value, Value> entry : this.entrySet()) {
            Value value = entry.getValue();
            if (!value.isArray()) continue;
            count += value.getCountRecursive(env);
        }
        return count;
    }

    @Override
    public boolean isEmpty() {
        return this.getSize() == 0;
    }

    @Override
    public boolean isEmpty(Env env, Value key) {
        Value value = this.get(key);
        return value.isEmpty();
    }

    public abstract void clear();

    @Override
    public int cmp(Value rValue) {
        return this.cmpImpl(rValue, 1);
    }

    private int cmpImpl(Value rValue, int resultIfKeyMissing) {
        int rSize;
        if (!rValue.isArray()) {
            return 1;
        }
        int lSize = this.getSize();
        if (lSize != (rSize = rValue.toArray().getSize())) {
            return lSize < rSize ? -1 : 1;
        }
        for (Map.Entry<Value, Value> entry : this.entrySet()) {
            Value lElementValue = entry.getValue();
            Value rElementValue = rValue.get(entry.getKey());
            if (!rElementValue.isset()) {
                return resultIfKeyMissing;
            }
            int cmp = lElementValue.cmp(rElementValue);
            if (cmp == 0) continue;
            return cmp;
        }
        return 0;
    }

    @Override
    public boolean lt(Value rValue) {
        return this.cmpImpl(rValue, 1) < 0;
    }

    @Override
    public boolean leq(Value rValue) {
        return this.cmpImpl(rValue, 1) <= 0;
    }

    @Override
    public boolean gt(Value rValue) {
        return this.cmpImpl(rValue, -1) > 0;
    }

    @Override
    public boolean geq(Value rValue) {
        return this.cmpImpl(rValue, -1) >= 0;
    }

    @Override
    public Value put(Value key, Value value) {
        this.append(key, value);
        return value;
    }

    public final void put(StringValue keyBinary, StringValue keyUnicode, Value value, boolean isUnicode) {
        if (isUnicode) {
            this.append(keyUnicode, value);
        } else {
            this.append(keyBinary, value);
        }
    }

    @Override
    public abstract Value put(Value var1);

    public abstract ArrayValue unshift(Value var1);

    public abstract ArrayValue splice(int var1, int var2, ArrayValue var3);

    public ArrayValue slice(Env env, int start, int end, boolean isPreserveKeys) {
        ArrayValueImpl array = new ArrayValueImpl();
        Iterator<Map.Entry<Value, Value>> iter = array.getIterator(env);
        for (int i = 0; i < end && iter.hasNext(); ++i) {
            Map.Entry<Value, Value> entry = iter.next();
            if (start > i) continue;
            Value key = entry.getKey();
            Value value = entry.getValue();
            if (key.isString() || isPreserveKeys) {
                array.put(key, value);
                continue;
            }
            array.put(value);
        }
        return array;
    }

    @Override
    public Value getArray(Value index) {
        Value array;
        Value value = this.get(index);
        if (value != (array = value.toAutoArray())) {
            value = array;
            this.put(index, value);
        }
        return value;
    }

    @Override
    public abstract Value getArg(Value var1, boolean var2);

    @Override
    public Value getObject(Env env, Value fieldName) {
        Value object;
        Value value = this.get(fieldName);
        if (value != (object = value.toAutoObject(env))) {
            value = object;
            this.put(fieldName, value);
        }
        return value;
    }

    @Override
    public abstract Var putVar();

    public abstract Value createTailKey();

    @Override
    public Value add(Value rValue) {
        if (!(rValue = rValue.toValue()).isArray()) {
            return this.copy();
        }
        ArrayValueImpl result = new ArrayValueImpl(this);
        for (Map.Entry<Value, Value> entry : ((ArrayValue)rValue).entrySet()) {
            Value key = entry.getKey();
            if (((ArrayValue)result).get(key) != UnsetValue.UNSET) continue;
            result.put(key, entry.getValue().copy());
        }
        return result;
    }

    @Override
    public Iterator<Map.Entry<Value, Value>> getBaseIterator(Env env) {
        return new EntryIterator(this.getHead());
    }

    public Iterator<Map.Entry<Value, Value>> getIterator() {
        return new EntryIterator(this.getHead());
    }

    @Override
    public Iterator<Value> getKeyIterator(Env env) {
        return new KeyIterator(this.getHead());
    }

    @Override
    public Iterator<Value> getValueIterator(Env env) {
        return new ValueIterator(this.getHead());
    }

    @Override
    public abstract Value get(Value var1);

    public Value getRaw(Value key) {
        return this.get(key);
    }

    @Override
    public boolean isset(Value key) {
        Value value = this.get(key);
        return value != null && value.isset();
    }

    @Override
    public boolean keyExists(Value key) {
        Value value = this.get(key);
        return value != UnsetValue.UNSET;
    }

    @Override
    public abstract Value remove(Value var1);

    @Override
    public abstract Var getVar(Value var1);

    public Set<Value> keySet() {
        return new KeySet();
    }

    public Set<Map.Entry<Value, Value>> entrySet() {
        return new EntrySet();
    }

    public Collection<Value> values() {
        return new ValueCollection();
    }

    public void put(String key, String value) {
        this.put(StringValue.create(key), StringValue.create(value));
    }

    public void put(Env env, String key, String value) {
        this.put(env.createString(key), env.createString(value));
    }

    public void put(String key, char value) {
        this.put(StringValue.create(key), StringValue.create(value));
    }

    public void put(String key, long value) {
        this.put(StringValue.create(key), LongValue.create(value));
    }

    public void put(Env env, String key, long value) {
        this.put(env.createString(key), LongValue.create(value));
    }

    public void put(String key, double value) {
        this.put(StringValue.create(key), new DoubleValue(value));
    }

    public void put(String key, boolean value) {
        this.put(StringValue.create(key), value ? BooleanValue.TRUE : BooleanValue.FALSE);
    }

    public void put(Env env, String key, boolean value) {
        this.put(env.createString(key), value ? BooleanValue.TRUE : BooleanValue.FALSE);
    }

    public void put(String value) {
        this.put(StringValue.create(value));
    }

    public void put(long value) {
        this.put(LongValue.create(value));
    }

    @Override
    public abstract ArrayValue append(Value var1, Value var2);

    public ArrayValue append(Value value) {
        this.put(value);
        return this;
    }

    public void putAll(ArrayValue array) {
        for (Map.Entry<Value, Value> entry : array.entrySet()) {
            this.put(entry.getKey(), entry.getValue());
        }
    }

    public static Value toArray(Value value) {
        if ((value = value.toValue()) instanceof ArrayValue) {
            return value;
        }
        return new ArrayValueImpl().put(value);
    }

    @Override
    public void print(Env env) {
        env.print("Array");
    }

    @Override
    public abstract Value pop(Env var1);

    @Override
    public abstract Value shuffle();

    public abstract Entry getHead();

    protected abstract Entry getTail();

    @Override
    public Value current() {
        if (this._current != null) {
            return this._current.getValue();
        }
        return BooleanValue.FALSE;
    }

    @Override
    public Value key() {
        if (this._current != null) {
            return this._current.getKey();
        }
        return NullValue.NULL;
    }

    @Override
    public boolean hasCurrent() {
        return this._current != null;
    }

    @Override
    public Value next() {
        if (this._current != null) {
            this._current = this._current._next;
        }
        return this.current();
    }

    @Override
    public Value prev() {
        if (this._current != null) {
            this._current = this._current._prev;
        }
        return this.current();
    }

    public Value each() {
        if (this._current == null) {
            return BooleanValue.FALSE;
        }
        ArrayValueImpl result = new ArrayValueImpl();
        result.put(LongValue.ZERO, this._current.getKey());
        result.put(KEY, this._current.getKey());
        result.put(LongValue.ONE, this._current.getValue());
        result.put(VALUE, this._current.getValue());
        this._current = this._current._next;
        return result;
    }

    @Override
    public Value reset() {
        this._current = this.getHead();
        return this.current();
    }

    @Override
    public Value end() {
        this._current = this.getTail();
        return this.current();
    }

    public abstract Value contains(Value var1);

    public abstract Value containsStrict(Value var1);

    @Override
    public abstract Value containsKey(Value var1);

    public Map.Entry<Value, Value>[] toEntryArray() {
        ArrayList<Entry> array = new ArrayList<Entry>(this.getSize());
        Entry entry = this.getHead();
        while (entry != null) {
            array.add(entry);
            entry = entry._next;
        }
        Entry[] result = new Entry[array.size()];
        return array.toArray(result);
    }

    public void sort(Comparator<Map.Entry<Value, Value>> comparator, boolean resetKeys, boolean strict) {
        Entry[] entries = new Entry[this.getSize()];
        int i = 0;
        Entry entry = this.getHead();
        while (entry != null) {
            entries[i++] = entry;
            entry = entry._next;
        }
        Arrays.sort(entries, comparator);
        this.clear();
        long base = 0L;
        if (!resetKeys) {
            strict = false;
        }
        for (int j = 0; j < entries.length; ++j) {
            Value key = entries[j].getKey();
            if (resetKeys && (!(key instanceof StringValue) || strict)) {
                this.put(LongValue.create(base++), entries[j].getValue());
                continue;
            }
            this.put(entries[j].getKey(), entries[j].getValue());
        }
    }

    @Override
    public void serialize(Env env, StringBuilder sb, SerializeMap serializeMap) {
        sb.append("a:");
        sb.append(this.getSize());
        sb.append(":{");
        serializeMap.incrementIndex();
        Entry entry = this.getHead();
        while (entry != null) {
            entry.getKey().serialize(env, sb);
            entry.getRawValue().serialize(env, sb, serializeMap);
            entry = entry._next;
        }
        sb.append("}");
    }

    @Override
    protected void varExportImpl(StringValue sb, int level) {
        if (level != 0) {
            sb.append('\n');
        }
        for (int i = 0; i < level; ++i) {
            sb.append("  ");
        }
        sb.append("array (");
        sb.append('\n');
        Entry entry = this.getHead();
        while (entry != null) {
            Value key = entry.getKey();
            Value value = entry.getValue();
            for (int i = 0; i < level + 1; ++i) {
                sb.append("  ");
            }
            key.varExportImpl(sb, level + 1);
            sb.append(" => ");
            value.varExportImpl(sb, level + 1);
            sb.append(",\n");
            entry = entry._next;
        }
        for (int i = 0; i < level; ++i) {
            sb.append("  ");
        }
        sb.append(")");
    }

    @Override
    public void jsonEncode(Env env, JsonEncodeContext context, StringValue sb) {
        long length = 0L;
        Iterator<Value> keyIter = this.getKeyIterator(env);
        while (keyIter.hasNext()) {
            Value key = keyIter.next();
            if (!key.isLongConvertible() || key.toLong() != length) {
                this.jsonEncodeAssociative(env, context, sb);
                return;
            }
            ++length;
        }
        sb.append('[');
        length = 0L;
        for (Value value : this.values()) {
            if (length > 0L) {
                sb.append(',');
            }
            value.jsonEncode(env, context, sb);
            ++length;
        }
        sb.append(']');
    }

    public void jsonEncodeAssociative(Env env, JsonEncodeContext context, StringValue sb) {
        sb.append('{');
        int length = 0;
        Iterator<Map.Entry<Value, Value>> iter = this.getIterator(env);
        while (iter.hasNext()) {
            Map.Entry<Value, Value> entry = iter.next();
            if (length > 0) {
                sb.append(',');
            }
            entry.getKey().toStringValue(env).jsonEncode(env, context, sb);
            sb.append(':');
            entry.getValue().jsonEncode(env, context, sb);
            ++length;
        }
        sb.append('}');
    }

    public boolean keyReset(long base, boolean strict) {
        Entry[] entries = new Entry[this.getSize()];
        int i = 0;
        Entry entry = this.getHead();
        while (entry != null) {
            entries[i++] = entry;
            entry = entry._next;
        }
        this.clear();
        for (int j = 0; j < entries.length; ++j) {
            Value key = entries[j].getKey();
            if (!(key instanceof StringValue) || strict) {
                this.put(LongValue.create(base++), entries[j].getValue());
                continue;
            }
            this.put(entries[j].getKey(), entries[j].getValue());
        }
        return true;
    }

    @Override
    public boolean eq(Value rValue) {
        if (rValue == this) {
            return true;
        }
        if (rValue == null) {
            return false;
        }
        if (rValue.isObject()) {
            return false;
        }
        if (!rValue.isArray()) {
            return rValue.eq(this);
        }
        if (this.getSize() != rValue.getSize()) {
            return false;
        }
        rValue = rValue.toValue();
        for (Map.Entry<Value, Value> entry : this.entrySet()) {
            Value entryValue = entry.getValue();
            Value entryKey = entry.getKey();
            Value rEntryValue = rValue.get(entryKey);
            if (rEntryValue instanceof ArrayValue && !entryValue.eq((ArrayValue)rEntryValue)) {
                return false;
            }
            if (entryValue.eq(rEntryValue)) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean eql(Value rValue) {
        if (rValue == this) {
            return true;
        }
        if (rValue == null) {
            return false;
        }
        if (this.getSize() != rValue.getSize()) {
            return false;
        }
        if ((rValue = rValue.toValue()) == this) {
            return true;
        }
        if (!(rValue instanceof ArrayValue)) {
            return false;
        }
        ArrayValue rArray = (ArrayValue)rValue;
        Iterator<Map.Entry<Value, Value>> iterA = this.entrySet().iterator();
        Iterator<Map.Entry<Value, Value>> iterB = rArray.entrySet().iterator();
        while (iterA.hasNext() && iterB.hasNext()) {
            Map.Entry<Value, Value> entryA = iterA.next();
            Map.Entry<Value, Value> entryB = iterB.next();
            if (!entryA.getKey().eql(entryB.getKey())) {
                return false;
            }
            if (entryA.getValue().eql(entryB.getValue())) continue;
            return false;
        }
        return !iterA.hasNext() && !iterB.hasNext();
    }

    @Override
    public Value toKey() {
        return ARRAY;
    }

    @Override
    public void varDumpImpl(Env env, WriteStream out, int depth, IdentityHashMap<Value, String> valueSet) throws IOException {
        out.println("array(" + this.getSize() + ") {");
        for (Map.Entry<Value, Value> mapEntry : this.entrySet()) {
            this.varDumpEntry(env, out, depth + 1, valueSet, mapEntry);
            out.println();
        }
        this.printDepth(out, 2 * depth);
        out.print("}");
    }

    protected void varDumpEntry(Env env, WriteStream out, int depth, IdentityHashMap<Value, String> valueSet, Map.Entry<Value, Value> mapEntry) throws IOException {
        Entry entry = (Entry)mapEntry;
        entry.varDumpImpl(env, out, depth, valueSet);
    }

    @Override
    protected void printRImpl(Env env, WriteStream out, int depth, IdentityHashMap<Value, String> valueSet) throws IOException {
        out.println("Array");
        this.printDepth(out, 4 * depth);
        out.println("(");
        for (Map.Entry<Value, Value> mapEntry : this.entrySet()) {
            Entry entry = (Entry)mapEntry;
            entry.printRImpl(env, out, depth, valueSet);
        }
        this.printDepth(out, 4 * depth);
        out.println(")");
    }

    protected void printREntry(Env env, WriteStream out, int depth, IdentityHashMap<Value, String> valueSet, Map.Entry<Value, Value> mapEntry) throws IOException {
        Entry entry = (Entry)mapEntry;
        entry.printRImpl(env, out, depth, valueSet);
    }

    @Override
    public Value[] getKeyArray(Env env) {
        int len = this.getSize();
        Value[] keys = new Value[len];
        Iterator<Value> iter = this.getKeyIterator(env);
        for (int i = 0; i < len; ++i) {
            keys[i] = iter.next();
        }
        return keys;
    }

    @Override
    public Value[] getValueArray(Env env) {
        int len = this.getSize();
        Value[] values = new Value[len];
        Iterator<Value> iter = this.getValueIterator(env);
        for (int i = 0; i < len; ++i) {
            values[i] = iter.next();
        }
        return values;
    }

    public Value[] keysToArray() {
        Value[] values = new Value[this.getSize()];
        int i = 0;
        for (Entry ptr = this.getHead(); ptr != null; ptr = ptr.getNext()) {
            values[i++] = ptr.getKey();
        }
        return values;
    }

    public Value[] valuesToArray() {
        Value[] values = new Value[this.getSize()];
        int i = 0;
        for (Entry ptr = this.getHead(); ptr != null; ptr = ptr.getNext()) {
            values[i++] = ptr.getValue();
        }
        return values;
    }

    public Value getKeys() {
        return new ArrayValueImpl(this.keysToArray());
    }

    public Value getValues() {
        return new ArrayValueImpl(this.valuesToArray());
    }

    public Object valuesToArray(Env env, Class elementType) {
        int size = this.getSize();
        Object array = Array.newInstance(elementType, size);
        MarshalFactory factory = env.getModuleContext().getMarshalFactory();
        Marshal elementMarshal = factory.create(elementType);
        int i = 0;
        for (Entry ptr = this.getHead(); ptr != null; ptr = ptr.getNext()) {
            Array.set(array, i++, elementMarshal.marshal(env, ptr.getValue(), elementType));
        }
        return array;
    }

    public static class GetValue
    extends AbstractGet {
        public static final GetValue GET = new GetValue();

        private GetValue() {
        }

        @Override
        public Value get(Map.Entry<Value, Value> entry) {
            return entry.getValue();
        }
    }

    public static class GetKey
    extends AbstractGet {
        public static final GetKey GET = new GetKey();

        private GetKey() {
        }

        @Override
        public Value get(Map.Entry<Value, Value> entry) {
            return entry.getKey();
        }
    }

    public static abstract class AbstractGet {
        public abstract Value get(Map.Entry<Value, Value> var1);
    }

    public static class KeyComparator
    implements Comparator<Map.Entry<Value, Value>> {
        public static final KeyComparator CMP = new KeyComparator();

        private KeyComparator() {
        }

        @Override
        public int compare(Map.Entry<Value, Value> aEntry, Map.Entry<Value, Value> bEntry) {
            try {
                Value aKey = aEntry.getKey();
                Value bKey = bEntry.getKey();
                if (aKey.eq(bKey)) {
                    return 0;
                }
                if (aKey.lt(bKey)) {
                    return -1;
                }
                return 1;
            }
            catch (Throwable e) {
                throw new RuntimeException(e);
            }
        }
    }

    public static class ValueComparator
    implements Comparator<Map.Entry<Value, Value>> {
        public static final ValueComparator CMP = new ValueComparator();

        private ValueComparator() {
        }

        @Override
        public int compare(Map.Entry<Value, Value> aEntry, Map.Entry<Value, Value> bEntry) {
            try {
                Value aValue = aEntry.getValue();
                Value bValue = bEntry.getValue();
                if (aValue.eq(bValue)) {
                    return 0;
                }
                if (aValue.lt(bValue)) {
                    return -1;
                }
                return 1;
            }
            catch (Throwable e) {
                throw new RuntimeException(e);
            }
        }
    }

    public static class ValueIterator
    implements Iterator<Value> {
        private Entry _current;

        ValueIterator(Entry head) {
            this._current = head;
        }

        @Override
        public boolean hasNext() {
            return this._current != null;
        }

        @Override
        public Value next() {
            if (this._current != null) {
                Value next = this._current.getValue();
                this._current = this._current._next;
                return next;
            }
            return null;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    public static class KeyIterator
    implements Iterator<Value> {
        private Entry _current;

        KeyIterator(Entry head) {
            this._current = head;
        }

        @Override
        public boolean hasNext() {
            return this._current != null;
        }

        @Override
        public Value next() {
            if (this._current != null) {
                Value next = this._current.getKey();
                this._current = this._current._next;
                return next;
            }
            return null;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    public static class EntryIterator
    implements Iterator<Map.Entry<Value, Value>> {
        private Entry _current;

        EntryIterator(Entry head) {
            this._current = head;
        }

        @Override
        public boolean hasNext() {
            return this._current != null;
        }

        @Override
        public Map.Entry<Value, Value> next() {
            if (this._current != null) {
                Entry next = this._current;
                this._current = this._current._next;
                return next;
            }
            return null;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    public class ValueCollection
    extends AbstractCollection<Value> {
        ValueCollection() {
        }

        @Override
        public int size() {
            return ArrayValue.this.getSize();
        }

        @Override
        public Iterator<Value> iterator() {
            return new ValueIterator(ArrayValue.this.getHead());
        }
    }

    public class KeySet
    extends AbstractSet<Value> {
        KeySet() {
        }

        @Override
        public int size() {
            return ArrayValue.this.getSize();
        }

        @Override
        public Iterator<Value> iterator() {
            return new KeyIterator(ArrayValue.this.getHead());
        }
    }

    public class EntrySet
    extends AbstractSet<Map.Entry<Value, Value>> {
        EntrySet() {
        }

        @Override
        public int size() {
            return ArrayValue.this.getSize();
        }

        @Override
        public Iterator<Map.Entry<Value, Value>> iterator() {
            return new EntryIterator(ArrayValue.this.getHead());
        }
    }

    public static final class Entry
    implements Map.Entry<Value, Value>,
    Serializable {
        private final Value _key;
        private Value _value;
        Entry _prev;
        private Entry _next;
        private Entry _nextHash;

        public Entry(Value key) {
            this._key = key;
            this._value = NullValue.NULL;
        }

        public Entry(Value key, Value value) {
            this._key = key;
            this._value = value;
        }

        public Entry(Entry entry) {
            this._key = entry._key;
            this._value = entry._value.copyArrayItem();
        }

        public final Entry getNext() {
            return this._next;
        }

        public final void setNext(Entry next) {
            this._next = next;
        }

        public final Entry getPrev() {
            return this._prev;
        }

        public final void setPrev(Entry prev) {
            this._prev = prev;
        }

        public final Entry getNextHash() {
            return this._nextHash;
        }

        public final void setNextHash(Entry next) {
            this._nextHash = next;
        }

        public Value getRawValue() {
            return this._value;
        }

        @Override
        public Value getValue() {
            return this._value.toValue();
        }

        @Override
        public Value getKey() {
            return this._key;
        }

        public Value toValue() {
            return this._value.toValue();
        }

        public Var toVar() {
            Var var = this._value.toVar();
            this._value = var;
            return var;
        }

        public Var toRefVar() {
            Var var = this._value.toVar();
            this._value = var;
            return var;
        }

        public Value toArgValue() {
            return this._value.toValue();
        }

        @Override
        public Value setValue(Value value) {
            Value oldValue = this._value;
            this._value = value;
            return oldValue;
        }

        public Value set(Value value) {
            Value oldValue = this._value;
            this._value = value instanceof Var ? (Var)value : this._value.set(value);
            return oldValue;
        }

        public Value toRef() {
            Var var = this._value.toVar();
            this._value = var;
            return new ArgRef(var);
        }

        public Value toArgRef() {
            Var var = this._value.toVar();
            this._value = var;
            return new ArgRef(var);
        }

        public Value toArg() {
            Var var = this._value.toVar();
            this._value = var;
            return var;
        }

        public void varDumpImpl(Env env, WriteStream out, int depth, IdentityHashMap<Value, String> valueSet) throws IOException {
            this.printDepth(out, 2 * depth);
            out.print("[");
            if (this._key instanceof StringValue) {
                out.print("\"" + this._key + "\"");
            } else {
                out.print(this._key);
            }
            out.println("]=>");
            this.printDepth(out, 2 * depth);
            this.getRawValue().varDump(env, out, depth, valueSet);
        }

        protected void printRImpl(Env env, WriteStream out, int depth, IdentityHashMap<Value, String> valueSet) throws IOException {
            this.printDepth(out, 4 * (depth + 1));
            out.print("[");
            out.print(this._key);
            out.print("] => ");
            if (this.getRawValue() != null) {
                this.getRawValue().printR(env, out, depth + 2, valueSet);
            }
            out.println();
        }

        private void printDepth(WriteStream out, int depth) throws IOException {
            for (int i = depth; i > 0; --i) {
                out.print(' ');
            }
        }

        public String toString() {
            return "ArrayValue.Entry[" + this.getKey() + "]";
        }
    }
}

