/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.quercus.env;

import com.caucho.quercus.QuercusRuntimeException;
import com.caucho.quercus.env.Env;
import com.caucho.quercus.env.StringBuilderValue;
import com.caucho.quercus.env.StringValue;
import com.caucho.quercus.env.UnicodeBuilderValue;
import com.caucho.quercus.env.UnsetBinaryValue;
import com.caucho.quercus.env.Value;
import com.caucho.util.CurrentTime;
import com.caucho.vfs.TempBuffer;
import com.caucho.vfs.WriteStream;
import java.io.IOException;
import java.io.Reader;
import java.util.IdentityHashMap;
import java.util.Locale;

public class BinaryBuilderValue
extends StringBuilderValue {
    public static final BinaryBuilderValue EMPTY = new BinaryBuilderValue("");
    private static final BinaryBuilderValue[] CHAR_STRINGS = new BinaryBuilderValue[256];

    public BinaryBuilderValue() {
        super(128);
    }

    public BinaryBuilderValue(BinaryBuilderValue v) {
        super(v);
    }

    public BinaryBuilderValue(int capacity) {
        super(capacity);
    }

    public BinaryBuilderValue(byte[] buffer, int offset, int length) {
        super(buffer, offset, length);
    }

    public BinaryBuilderValue(byte[] buffer) {
        super(buffer);
    }

    public BinaryBuilderValue(String s) {
        super(s);
    }

    public BinaryBuilderValue(char[] buffer) {
        super(buffer);
    }

    public BinaryBuilderValue(char[] s, Value v1) {
        super(s, v1);
    }

    public BinaryBuilderValue(TempBuffer head) {
        this();
        this.append(head);
    }

    public BinaryBuilderValue(byte ch) {
        super(ch);
    }

    public static StringValue create(int value) {
        if (value < CHAR_STRINGS.length) {
            return CHAR_STRINGS[value];
        }
        return new BinaryBuilderValue(value);
    }

    public static StringValue create(char value) {
        if (value < CHAR_STRINGS.length) {
            return CHAR_STRINGS[value];
        }
        return new BinaryBuilderValue((int)value);
    }

    @Override
    public String getType() {
        return "string";
    }

    @Override
    public boolean isBinary() {
        return true;
    }

    @Override
    public int toByteMarshalCost() {
        if (this.isLongConvertible()) {
            return 200;
        }
        if (this.isDoubleConvertible()) {
            return 300;
        }
        return 320;
    }

    @Override
    public int toStringMarshalCost() {
        return 330;
    }

    @Override
    public int toCharArrayMarshalCost() {
        return 335;
    }

    @Override
    public int toByteArrayMarshalCost() {
        return 100;
    }

    @Override
    public int toBinaryValueMarshalCost() {
        return 0;
    }

    @Override
    public int toStringValueMarshalCost() {
        return 1;
    }

    @Override
    public StringValue toUnicode(Env env) {
        return new UnicodeBuilderValue(this);
    }

    @Override
    public StringValue toUnicodeValue() {
        return new UnicodeBuilderValue(this);
    }

    @Override
    public StringValue toUnicodeValue(Env env) {
        return new UnicodeBuilderValue(this);
    }

    @Override
    public StringValue toUnicodeValue(Env env, String charset) {
        return this.toUnicodeValue(env);
    }

    @Override
    public StringValue toStringBuilder() {
        return new BinaryBuilderValue(this);
    }

    @Override
    public Value charValueAt(long index) {
        int len = this.length();
        if (index < 0L || (long)len <= index) {
            return UnsetBinaryValue.UNSET;
        }
        return BinaryBuilderValue.create(this.getBuffer()[(int)index] & 0xFF);
    }

    @Override
    public CharSequence subSequence(int start, int end) {
        if (end <= start) {
            return EMPTY;
        }
        return new BinaryBuilderValue(this.getBuffer(), start, end - start);
    }

    @Override
    public StringValue toLowerCase(Locale locale) {
        int length = this.length();
        BinaryBuilderValue string = new BinaryBuilderValue(length);
        byte[] srcBuffer = this.getBuffer();
        byte[] dstBuffer = string.getBuffer();
        for (int i = 0; i < length; ++i) {
            byte ch = srcBuffer[i];
            dstBuffer[i] = 65 <= ch && ch <= 90 ? (byte)(ch + 97 - 65) : ch;
        }
        string.setLength(length);
        return string;
    }

    @Override
    public StringValue toUpperCase() {
        int length = this.length();
        BinaryBuilderValue string = new BinaryBuilderValue(length);
        byte[] srcBuffer = this.getBuffer();
        byte[] dstBuffer = string.getBuffer();
        for (int i = 0; i < length; ++i) {
            byte ch = srcBuffer[i];
            dstBuffer[i] = 97 <= ch && ch <= 122 ? (byte)(ch + 65 - 97) : ch;
        }
        string.setLength(length);
        return string;
    }

    @Override
    public BinaryBuilderValue createStringBuilder() {
        return new BinaryBuilderValue();
    }

    @Override
    public BinaryBuilderValue createStringBuilder(int length) {
        return new BinaryBuilderValue(length);
    }

    @Override
    public BinaryBuilderValue createStringBuilder(byte[] buffer, int offset, int length) {
        return new BinaryBuilderValue(length);
    }

    @Override
    public StringValue toStringBuilder(Env env) {
        return new BinaryBuilderValue(this.getBuffer(), 0, this.length());
    }

    @Override
    public StringValue toStringBuilder(Env env, Value value) {
        if (value.isUnicode()) {
            UnicodeBuilderValue sb = new UnicodeBuilderValue(this);
            value.appendTo(sb);
            return sb;
        }
        BinaryBuilderValue v = new BinaryBuilderValue(this);
        value.appendTo(v);
        return v;
    }

    @Override
    public StringValue toStringBuilder(Env env, StringValue value) {
        if (value.isUnicode()) {
            UnicodeBuilderValue sb = new UnicodeBuilderValue(this);
            value.appendTo(sb);
            return sb;
        }
        BinaryBuilderValue v = new BinaryBuilderValue(this);
        value.appendTo(v);
        return v;
    }

    public final StringValue append(BinaryBuilderValue sb, int head, int tail) {
        int length = tail - head;
        byte[] buffer = this.getBuffer();
        byte[] sbBuffer = sb.getBuffer();
        int offset = this.length();
        if (buffer.length < offset + length) {
            this.ensureCapacity(offset + length);
        }
        System.arraycopy(sbBuffer, head, buffer, offset, tail - head);
        this.setLength(offset + tail - head);
        return this;
    }

    @Override
    public final StringValue appendUnicode(char[] buf, int offset, int length) {
        UnicodeBuilderValue sb = new UnicodeBuilderValue();
        this.appendTo(sb);
        sb.append(buf, offset, length);
        return sb;
    }

    @Override
    public final StringValue appendUnicode(String s) {
        UnicodeBuilderValue sb = new UnicodeBuilderValue();
        this.appendTo(sb);
        sb.append(s);
        return sb;
    }

    @Override
    public final StringValue appendUnicode(String s, int start, int end) {
        UnicodeBuilderValue sb = new UnicodeBuilderValue();
        this.appendTo(sb);
        sb.append(s, start, end);
        return sb;
    }

    @Override
    public final StringValue appendUnicode(Value value) {
        if ((value = value.toValue()) instanceof BinaryBuilderValue) {
            this.append((BinaryBuilderValue)value);
            return this;
        }
        if (value.isString()) {
            UnicodeBuilderValue sb = new UnicodeBuilderValue();
            this.appendTo(sb);
            sb.append(value);
            return sb;
        }
        return value.appendTo(this);
    }

    @Override
    public final StringValue appendUnicode(char ch) {
        UnicodeBuilderValue sb = new UnicodeBuilderValue();
        this.appendTo(sb);
        sb.append(ch);
        return sb;
    }

    @Override
    public final StringValue appendUnicode(boolean v) {
        return this.append(v ? "true" : "false");
    }

    @Override
    public StringValue appendUnicode(long v) {
        return this.append(String.valueOf(v));
    }

    @Override
    public StringValue appendUnicode(double v) {
        return this.append(String.valueOf(v));
    }

    @Override
    public StringValue appendUnicode(Object v) {
        if (v instanceof String) {
            return this.appendUnicode(v.toString());
        }
        return this.append(v.toString());
    }

    @Override
    public StringValue appendTo(UnicodeBuilderValue sb) {
        if (this.length() == 0) {
            return sb;
        }
        Env env = Env.getInstance();
        try {
            Reader reader = env.getRuntimeEncodingFactory().create(this.toInputStream());
            if (reader != null) {
                sb.append(reader);
                reader.close();
            }
            return sb;
        }
        catch (IOException e) {
            throw new QuercusRuntimeException(e);
        }
    }

    @Override
    public String toDebugString() {
        StringBuilder sb = new StringBuilder();
        int length = this.length();
        sb.append("binary(");
        sb.append(length);
        sb.append(") \"");
        int appendLength = length > 256 ? 256 : length;
        for (int i = 0; i < appendLength; ++i) {
            sb.append(this.charAt(i));
        }
        if (length > 256) {
            sb.append(" ...");
        }
        sb.append('\"');
        return sb.toString();
    }

    @Override
    public void varDumpImpl(Env env, WriteStream out, int depth, IdentityHashMap<Value, String> valueSet) throws IOException {
        int length = this.length();
        if (length < 0) {
            length = 0;
        }
        if (CurrentTime.isTest()) {
            out.print("binary");
        } else {
            out.print("string");
        }
        out.print("(");
        out.print(length);
        out.print(") \"");
        for (int i = 0; i < length; ++i) {
            char ch = this.charAt(i);
            if (' ' <= ch && ch <= '\u007f' || ch == '\t' || ch == '\r' || ch == '\n') {
                out.print(ch);
                continue;
            }
            if (ch <= '\u00ff') {
                out.print("\\x" + Integer.toHexString(ch / 16) + Integer.toHexString(ch % 16));
                continue;
            }
            out.print("\\u" + Integer.toHexString(ch >> 12 & 0xF) + Integer.toHexString(ch >> 8 & 0xF) + Integer.toHexString(ch >> 4 & 0xF) + Integer.toHexString(ch & 0xF));
        }
        out.print("\"");
    }

    static {
        for (int i = 0; i < CHAR_STRINGS.length; ++i) {
            BinaryBuilderValue.CHAR_STRINGS[i] = new BinaryBuilderValue((byte)i);
        }
    }
}

