/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.quercus.env;

import com.caucho.quercus.env.Callable;
import com.caucho.quercus.env.Callback;
import com.caucho.quercus.env.Env;
import com.caucho.quercus.env.NullValue;
import com.caucho.quercus.env.StringValue;
import com.caucho.quercus.env.Value;
import com.caucho.quercus.env.Var;
import java.util.HashMap;

public abstract class Closure
extends Callback {
    private final String _name;
    private Value _qThis;
    private HashMap<StringValue, Var> _staticVarMap;

    public Closure(String name) {
        this(name, NullValue.NULL);
    }

    public Closure(String name, Value qThis) {
        this._name = name;
        this._qThis = qThis;
    }

    @Override
    public boolean isCallable(Env env, boolean isCheckSyntaxOnly, Value nameRef) {
        if (nameRef != null) {
            StringValue sb = env.createString("Closure::__invoke");
            nameRef.set(sb);
        }
        return true;
    }

    public final Value getThis() {
        return this._qThis;
    }

    @Override
    public Callable toCallable(Env env, boolean isOptional) {
        return this;
    }

    @Override
    public boolean isObject() {
        return true;
    }

    @Override
    public String getType() {
        return "object";
    }

    @Override
    public String getCallbackName() {
        return this._name;
    }

    @Override
    public boolean isInternal(Env env) {
        return false;
    }

    @Override
    public boolean isValid(Env env) {
        return true;
    }

    @Override
    public boolean isA(Env env, String name) {
        return "Closure".equalsIgnoreCase(name);
    }

    public Var getStaticVar(StringValue name) {
        HashMap<StringValue, Var> varMap = this._staticVarMap;
        Var var = null;
        if (varMap == null) {
            varMap = new HashMap();
            this._staticVarMap = varMap;
        } else {
            var = varMap.get(name);
        }
        if (var == null) {
            var = new Var();
            varMap.put(name, var);
        }
        return var;
    }

    @Override
    public Value callMethod(Env env, StringValue methodName, int hash, Value[] args) {
        if (methodName.equalsString("__invoke")) {
            return this.call(env, args);
        }
        return super.callMethod(env, methodName, hash, args);
    }

    @Override
    public abstract Value call(Env var1, Value[] var2);

    @Override
    public String toString() {
        return this.getClass().getSimpleName() + "[" + this._name + "]";
    }
}

