/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.quercus.env;

import com.caucho.quercus.env.DoubleValue;
import com.caucho.quercus.env.Env;
import com.caucho.quercus.env.LongValue;
import com.caucho.quercus.env.StringBuilderValue;
import com.caucho.quercus.env.StringValue;
import com.caucho.quercus.env.Value;
import com.caucho.quercus.env.ValueType;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Locale;

public class ConstStringValue
extends StringBuilderValue {
    public static final ConstStringValue EMPTY = new ConstStringValue();
    private LongValue _longValue;
    private DoubleValue _doubleValue;
    private String _string;
    private Value _key;
    private ValueType _valueType;
    private char[] _serializeValue;
    private StringValue _lowerCase;

    public ConstStringValue() {
    }

    public ConstStringValue(StringBuilderValue sb) {
        super(sb.getBuffer(), 0, sb.length());
    }

    public ConstStringValue(byte[] buffer, int offset, int length) {
        super(buffer, offset, length);
    }

    public ConstStringValue(char[] buffer, int offset, int length) {
        super(buffer, offset, length);
    }

    public ConstStringValue(char[] buffer, int length) {
        super(buffer, length);
    }

    public ConstStringValue(byte[] buffer) {
        super(buffer);
    }

    public ConstStringValue(char ch) {
        super(1, true);
        this.setLength(1);
        byte[] buffer = this.getBuffer();
        buffer[0] = (byte)(ch & 0xFF);
    }

    public ConstStringValue(byte ch) {
        super(1, true);
        this.setLength(1);
        byte[] buffer = this.getBuffer();
        buffer[0] = (byte)(ch & 0xFF);
    }

    public ConstStringValue(String s) {
        super(s);
        this._string = s;
    }

    public ConstStringValue(char[] s) {
        super(s);
    }

    public ConstStringValue(char[] s, Value v1) {
        super(s, v1);
    }

    public ConstStringValue(byte[] s, Value v1) {
        super(s, v1);
    }

    public ConstStringValue(Value v1) {
        super(v1);
    }

    public ConstStringValue(Value v1, Value v2) {
        super(v1, v2);
    }

    public ConstStringValue(Value v1, Value v2, Value v3) {
        super(v1, v2, v3);
    }

    public boolean isStatic() {
        return true;
    }

    protected void setLongValue(LongValue value) {
        this._longValue = value;
    }

    protected void setDoubleValue(DoubleValue value) {
        this._doubleValue = value;
    }

    protected void setString(String value) {
        this._string = value;
    }

    protected void setKey(Value value) {
        this._key = value;
    }

    protected void setValueType(ValueType valueType) {
        this._valueType = valueType;
    }

    protected void setLowerCase(StringValue lowerCase) {
        this._lowerCase = lowerCase;
    }

    @Override
    public LongValue toLongValue() {
        if (this._longValue == null) {
            this._longValue = LongValue.create(super.toLong());
        }
        return this._longValue;
    }

    @Override
    public DoubleValue toDoubleValue() {
        if (this._doubleValue == null) {
            this._doubleValue = new DoubleValue(super.toDouble());
        }
        return this._doubleValue;
    }

    @Override
    public long toLong() {
        return this.toLongValue().toLong();
    }

    @Override
    public double toDouble() {
        return this.toDoubleValue().toDouble();
    }

    @Override
    public ValueType getValueType() {
        if (this._valueType == null) {
            this._valueType = super.getValueType();
        }
        return this._valueType;
    }

    @Override
    public Value toKey() {
        if (this._key == null) {
            this._key = super.toKey();
        }
        return this._key;
    }

    @Override
    public StringValue toLowerCase(Locale locale) {
        if (this._lowerCase == null) {
            this._lowerCase = super.toLowerCase(locale);
        }
        return this._lowerCase;
    }

    @Override
    public void serialize(Env env, StringBuilder sb) {
        if (this._serializeValue == null) {
            StringBuilder s = new StringBuilder();
            super.serialize(env, s);
            int len = s.length();
            this._serializeValue = new char[len];
            s.getChars(0, len, this._serializeValue, 0);
        }
        sb.append(this._serializeValue, 0, this._serializeValue.length);
    }

    @Override
    public void generate(PrintWriter out) throws IOException {
        ConstStringValue.generateImpl(out, this);
    }

    public static void generateImpl(PrintWriter out, StringBuilderValue value) throws IOException {
        int maxSublen = 65534;
        int len = value.length();
        if (len == 1) {
            out.print("(ConstStringValue.create((char) '");
            ConstStringValue.printJavaChar(out, value.charAt(0));
            out.print("'))");
        } else if (len < maxSublen) {
            out.print("(new CompiledConstStringValue (\"");
            ConstStringValue.printJavaString(out, value);
            out.print("\", ");
            value.toLongValue().generate(out);
            out.print(", ");
            value.toDoubleValue().generate(out);
            out.print(", ");
            out.print(value.getValueType());
            out.print(", ");
            Value key = value.toKey();
            if (key instanceof LongValue) {
                key.generate(out);
                out.print(", ");
            }
            out.print(value.hashCode());
            out.print("))");
        } else {
            out.print("(new ConstStringValue(new StringBuilderValue(\"");
            for (int i = 0; i < len; i += maxSublen) {
                if (i != 0) {
                    out.print("\").append(\"");
                }
                ConstStringValue.printJavaString(out, value.substring(i, Math.min(i + maxSublen, len)));
            }
            out.print("\")))");
        }
    }

    @Override
    public String toString() {
        if (this._string == null) {
            this._string = super.toString();
        }
        return this._string;
    }
}

