/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.quercus.env;

import com.caucho.quercus.env.ArrayValueImpl;
import com.caucho.quercus.env.BooleanValue;
import com.caucho.quercus.env.Env;
import com.caucho.quercus.env.JavaCollectionAdapter;
import com.caucho.quercus.env.LongValue;
import com.caucho.quercus.env.NullValue;
import com.caucho.quercus.env.UnsetValue;
import com.caucho.quercus.env.Value;
import com.caucho.quercus.program.JavaClassDef;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;

public class JavaListAdapter
extends JavaCollectionAdapter {
    private static final Logger log = Logger.getLogger(JavaListAdapter.class.getName());
    private List _list;
    private int _next = 0;

    public JavaListAdapter(Env env, List list) {
        this(list, env.getJavaClassDefinition(list.getClass()));
    }

    public JavaListAdapter(List list, JavaClassDef def) {
        super(list, def);
        this._list = list;
    }

    @Override
    public Value putImpl(Value key, Value value) {
        int pos = key.toInt();
        int size = this.getSize();
        if (0 <= pos && pos <= size) {
            if (pos < size) {
                this._list.set(pos, value.toJavaObject());
            } else {
                this._list.add(pos, value.toJavaObject());
            }
            return value;
        }
        this.getEnv().warning(L.l("index {0} is out of range", pos));
        log.log(Level.FINE, L.l("index {0} is out of range", pos));
        return UnsetValue.UNSET;
    }

    @Override
    public Value get(Value key) {
        int pos = key.toInt();
        if (0 <= pos && pos < this.getSize()) {
            return this.wrapJava(this._list.get(pos));
        }
        return UnsetValue.UNSET;
    }

    @Override
    public Value remove(Value key) {
        int pos = key.toInt();
        if (0 <= pos && pos < this.getSize()) {
            return this.wrapJava(this._list.remove(pos));
        }
        return UnsetValue.UNSET;
    }

    @Override
    public Value pop(Env env) {
        if (this.getSize() == 0) {
            return NullValue.NULL;
        }
        return this.wrapJava(this._list.remove(0));
    }

    @Override
    public Value contains(Value value) {
        for (Map.Entry<Value, Value> entry : this.entrySet()) {
            if (!entry.getValue().equals(value)) continue;
            return entry.getKey();
        }
        return NullValue.NULL;
    }

    @Override
    public Value current() {
        if (this._next < this._list.size()) {
            return this.wrapJava(this._list.get(this._next));
        }
        return BooleanValue.FALSE;
    }

    @Override
    public Value key() {
        if (this._next < this._list.size()) {
            return LongValue.create(this._next);
        }
        return NullValue.NULL;
    }

    @Override
    public boolean hasCurrent() {
        return this._next < this._list.size();
    }

    @Override
    public Value next() {
        if (this._next < this._list.size()) {
            return this.wrapJava(this._list.get(this._next++));
        }
        return BooleanValue.FALSE;
    }

    @Override
    public Value prev() {
        if (this._next > 0) {
            return this.wrapJava(this._list.get(this._next--));
        }
        return BooleanValue.FALSE;
    }

    @Override
    public Value each() {
        if (this._next < this._list.size()) {
            ArrayValueImpl result = new ArrayValueImpl();
            result.put(LongValue.ZERO, this.key());
            result.put(KEY, this.key());
            result.put(LongValue.ONE, this.current());
            result.put(VALUE, this.current());
            ++this._next;
            return result;
        }
        return NullValue.NULL;
    }

    @Override
    public Value reset() {
        this._next = 0;
        return this.current();
    }

    @Override
    public Value end() {
        this._next = this._list.size();
        return this.current();
    }

    @Override
    public Value copy() {
        return new JavaListAdapter(this._list, this.getClassDef());
    }

    @Override
    public Value copy(Env env, IdentityHashMap<Value, Value> map) {
        return new JavaListAdapter(this._list, this.getClassDef());
    }
}

