/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.quercus.env;

import com.caucho.quercus.env.Env;
import com.caucho.quercus.env.EnvVar;
import com.caucho.quercus.env.EnvVarImpl;
import com.caucho.quercus.env.StringValue;
import com.caucho.quercus.env.Value;
import com.caucho.quercus.env.Var;
import com.caucho.util.IntMap;
import java.util.AbstractMap;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

public class LazySymbolMap
extends AbstractMap<StringValue, EnvVar> {
    private final IntMap _intMap;
    private final Value[] _values;
    private HashMap<StringValue, EnvVar> _extMap = new HashMap();

    public LazySymbolMap(IntMap intMap, Value[] values) {
        this._intMap = intMap;
        this._values = values;
    }

    @Override
    public EnvVar get(Object key) {
        return this.get((StringValue)key);
    }

    public EnvVar get(StringValue key) {
        int id;
        EnvVar envVar = this._extMap.get(key);
        if (envVar == null && (id = this._intMap.get(key)) >= 0 && this._values[id] != null) {
            Var var = new Var();
            envVar = new EnvVarImpl(var);
            this._extMap.put(key, envVar);
            Env env = Env.getCurrent();
            Value value = this._values[id].copy(env);
            envVar.set(value);
        }
        return envVar;
    }

    @Override
    public EnvVar put(StringValue key, EnvVar newVar) {
        return this._extMap.put(key, newVar);
    }

    @Override
    public Set<Map.Entry<StringValue, EnvVar>> entrySet() {
        return this._extMap.entrySet();
    }
}

