/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.quercus.env;

import com.caucho.quercus.env.ArrayValue;
import com.caucho.quercus.env.ArrayValueImpl;
import com.caucho.quercus.env.BinaryBuilderValue;
import com.caucho.quercus.env.Env;
import com.caucho.quercus.env.JsonEncodeContext;
import com.caucho.quercus.env.LargeStringBuilderValue;
import com.caucho.quercus.env.LongValue;
import com.caucho.quercus.env.StringBuilderValue;
import com.caucho.quercus.env.StringValue;
import com.caucho.quercus.env.UnicodeBuilderValue;
import com.caucho.quercus.env.Value;
import com.caucho.quercus.env.ValueType;
import com.caucho.vfs.WriteStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Serializable;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.net.URL;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;

public class NullValue
extends Value
implements Serializable {
    public static final NullValue NULL = new NullValue();

    protected NullValue() {
    }

    public static NullValue create() {
        return NULL;
    }

    @Override
    public String getType() {
        return "NULL";
    }

    @Override
    public ValueType getValueType() {
        return ValueType.NULL;
    }

    @Override
    public boolean isset() {
        return false;
    }

    @Override
    public boolean isEmpty() {
        return true;
    }

    @Override
    public int toDoubleMarshalCost() {
        return 310;
    }

    @Override
    public int toLongMarshalCost() {
        return 310;
    }

    @Override
    public int toIntegerMarshalCost() {
        return 310;
    }

    @Override
    public int toShortMarshalCost() {
        return 310;
    }

    @Override
    public int toByteMarshalCost() {
        return 310;
    }

    @Override
    public int toBooleanMarshalCost() {
        return 310;
    }

    @Override
    public boolean toBoolean() {
        return false;
    }

    @Override
    public boolean isNull() {
        return true;
    }

    @Override
    public long toLong() {
        return 0L;
    }

    @Override
    public double toDouble() {
        return 0.0;
    }

    public String toString() {
        return "";
    }

    @Override
    public StringValue toStringBuilder(Env env) {
        return env.createUnicodeBuilder();
    }

    @Override
    public Object toJavaObject() {
        return null;
    }

    public Object toJavaObject(Env env, Class type) {
        return null;
    }

    public Object toJavaObjectNotNull(Env env, Class type) {
        env.warning(L.l("null is an unexpected argument; expected '{0}'", (Object)type.getName()));
        return null;
    }

    @Override
    public Boolean toJavaBoolean() {
        return null;
    }

    @Override
    public Byte toJavaByte() {
        return null;
    }

    @Override
    public Short toJavaShort() {
        return null;
    }

    @Override
    public Integer toJavaInteger() {
        return null;
    }

    @Override
    public Long toJavaLong() {
        return null;
    }

    @Override
    public Float toJavaFloat() {
        return null;
    }

    @Override
    public Double toJavaDouble() {
        return null;
    }

    @Override
    public Character toJavaCharacter() {
        return null;
    }

    @Override
    public String toJavaString() {
        return null;
    }

    public Collection toJavaCollection(Env env, Class type) {
        return null;
    }

    public List toJavaList(Env env, Class type) {
        return null;
    }

    public Map toJavaMap(Env env, Class type) {
        return null;
    }

    @Override
    public Calendar toJavaCalendar() {
        return null;
    }

    @Override
    public Date toJavaDate() {
        return null;
    }

    @Override
    public URL toJavaURL(Env env) {
        return null;
    }

    @Override
    public Enum toJavaEnum(Env env, Class cls) {
        return null;
    }

    @Override
    public BigDecimal toBigDecimal() {
        return BigDecimal.ZERO;
    }

    @Override
    public BigInteger toBigInteger() {
        return BigInteger.ZERO;
    }

    public Object valuesToArray(Env env, Class elementType) {
        return null;
    }

    @Override
    public Value toObject(Env env) {
        return NULL;
    }

    @Override
    public ArrayValue toArray() {
        return new ArrayValueImpl();
    }

    @Override
    public Value toAutoArray() {
        return new ArrayValueImpl();
    }

    @Override
    public Value append(Value index, Value value) {
        return new ArrayValueImpl().append(index, value);
    }

    @Override
    public ArrayValue toArrayValue(Env env) {
        return null;
    }

    @Override
    public StringValue toStringValue() {
        Env env = Env.getInstance();
        if (env != null && env.isUnicodeSemantics()) {
            return UnicodeBuilderValue.EMPTY;
        }
        return StringBuilderValue.EMPTY;
    }

    @Override
    public int getCount(Env env) {
        return 0;
    }

    @Override
    public int getSize() {
        return 0;
    }

    @Override
    public Value toAutoObject(Env env) {
        return env.createObject();
    }

    @Override
    public Value toArgRef() {
        return this;
    }

    @Override
    public Value toKey() {
        return StringValue.EMPTY;
    }

    @Override
    public boolean eql(Value rValue) {
        return rValue.isNull();
    }

    @Override
    public Value add(long lLong) {
        return LongValue.create(lLong);
    }

    @Override
    public Value sub(long rLong) {
        return LongValue.create(-rLong);
    }

    @Override
    public boolean eq(Value rValue) {
        if (rValue.isString()) {
            return this.toString().equals(rValue.toString());
        }
        return this.toBoolean() == rValue.toBoolean();
    }

    @Override
    public int cmp(Value rValue) {
        if (!((rValue = rValue.toValue()) instanceof StringValue)) {
            int l = 0;
            int r = rValue.toBoolean() ? 1 : 0;
            return l - r;
        }
        if (rValue.isNumberConvertible()) {
            double l = 0.0;
            double r = rValue.toDouble();
            if (l == r) {
                return 0;
            }
            if (l < r) {
                return -1;
            }
            return 1;
        }
        return "".compareTo(rValue.toString());
    }

    @Override
    public void print(Env env) {
    }

    @Override
    public void serialize(Env env, StringBuilder sb) {
        sb.append("N;");
    }

    @Override
    protected void varExportImpl(StringValue sb, int level) {
        sb.append("NULL");
    }

    @Override
    public void jsonEncode(Env env, JsonEncodeContext context, StringValue sb) {
        sb.append("null");
    }

    @Override
    public Value getArray() {
        return new ArrayValueImpl();
    }

    @Override
    public StringValue appendTo(BinaryBuilderValue sb) {
        return sb;
    }

    @Override
    public StringValue appendTo(UnicodeBuilderValue sb) {
        return sb;
    }

    @Override
    public StringValue appendTo(StringBuilderValue sb) {
        return sb;
    }

    @Override
    public StringValue appendTo(LargeStringBuilderValue sb) {
        return sb;
    }

    @Override
    public void generate(PrintWriter out) throws IOException {
        out.print("NullValue.NULL");
    }

    @Override
    public Value getObject(Env env) {
        return env.createObject();
    }

    @Override
    public String toDebugString() {
        return "null";
    }

    @Override
    public void varDumpImpl(Env env, WriteStream out, int depth, IdentityHashMap<Value, String> valueSet) throws IOException {
        out.print("NULL");
    }

    private Object readResolve() {
        return NULL;
    }

    @Override
    public int hashCode() {
        return 17;
    }
}

