/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.quercus.env;

import com.caucho.quercus.QuercusModuleException;
import com.caucho.quercus.env.ArrayValueImpl;
import com.caucho.quercus.env.Callable;
import com.caucho.quercus.env.CallbackClassMethod;
import com.caucho.quercus.env.CallbackFunction;
import com.caucho.quercus.env.ConstStringValue;
import com.caucho.quercus.env.DoubleValue;
import com.caucho.quercus.env.Env;
import com.caucho.quercus.env.JsonEncodeContext;
import com.caucho.quercus.env.LongValue;
import com.caucho.quercus.env.NullValue;
import com.caucho.quercus.env.QuercusClass;
import com.caucho.quercus.env.StringBuilderValue;
import com.caucho.quercus.env.UnicodeBuilderValue;
import com.caucho.quercus.env.UnsetUnicodeValue;
import com.caucho.quercus.env.Value;
import com.caucho.quercus.env.ValueType;
import com.caucho.quercus.lib.file.BinaryInput;
import com.caucho.quercus.lib.i18n.Decoder;
import com.caucho.util.ByteAppendable;
import com.caucho.util.LruCache;
import com.caucho.vfs.ReadStream;
import com.caucho.vfs.TempBuffer;
import com.caucho.vfs.WriteStream;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.util.IdentityHashMap;
import java.util.Locale;
import java.util.zip.CRC32;

public abstract class StringValue
extends Value
implements CharSequence,
ByteAppendable {
    public static final StringValue EMPTY = new ConstStringValue("");
    protected static final int MIN_LENGTH = 32;
    protected static final int IS_STRING = 0;
    protected static final int IS_LONG = 1;
    protected static final int IS_DOUBLE = 2;
    private static final LruCache<StringValue, StringValue> _internMap = new LruCache(8192);

    public abstract StringValue createStringBuilder();

    public abstract StringValue createStringBuilder(int var1);

    public static Value create(String value) {
        if (value == null) {
            return NullValue.NULL;
        }
        return new ConstStringValue(value);
    }

    public static StringValue create(char value) {
        return ConstStringValue.create(value);
    }

    public static Value create(Object value) {
        if (value == null) {
            return NullValue.NULL;
        }
        return new StringBuilderValue(value.toString());
    }

    public StringValue create(Env env, StringValue unicodeStr, String charset) {
        if (!unicodeStr.isUnicode()) {
            return unicodeStr;
        }
        try {
            StringValue sb = this.createStringBuilder();
            byte[] bytes = unicodeStr.toString().getBytes(charset);
            sb.append(bytes);
            return sb;
        }
        catch (UnsupportedEncodingException e) {
            env.warning(e);
            return unicodeStr;
        }
    }

    @Override
    public String getType() {
        return "string";
    }

    @Override
    public ValueType getValueType() {
        return ValueType.STRING;
    }

    @Override
    public boolean isLongConvertible() {
        return this.getValueType().isLongCmp();
    }

    @Override
    public boolean isDoubleConvertible() {
        return this.getValueType().isNumberCmp();
    }

    public boolean isNumber() {
        return false;
    }

    @Override
    public boolean isNumeric() {
        return this.getValueType().isNumberCmp();
    }

    public boolean isScalar() {
        return true;
    }

    @Override
    public final boolean isString() {
        return true;
    }

    @Override
    public boolean isEmpty() {
        return this.length() == 0 || this.length() == 1 && this.charAt(0) == '0';
    }

    @Override
    public boolean isCallable(Env env, boolean isCheckSyntaxOnly, Value nameRef) {
        if (nameRef != null) {
            nameRef.set(this);
        }
        if (isCheckSyntaxOnly) {
            return true;
        }
        return env.findFunction(this) != null;
    }

    @Override
    public int toDoubleMarshalCost() {
        ValueType valueType = this.getValueType();
        if (valueType.isLongCmp()) {
            return 375;
        }
        if (valueType.isNumberCmp()) {
            return 365;
        }
        return 400;
    }

    @Override
    public int toFloatMarshalCost() {
        ValueType valueType = this.getValueType();
        if (valueType.isLongCmp()) {
            return 380;
        }
        if (valueType.isNumberCmp()) {
            return 370;
        }
        return 400;
    }

    @Override
    public int toLongMarshalCost() {
        ValueType valueType = this.getValueType();
        if (valueType.isLongCmp()) {
            return 365;
        }
        if (valueType.isNumberCmp()) {
            return 395;
        }
        return 400;
    }

    @Override
    public int toIntegerMarshalCost() {
        ValueType valueType = this.getValueType();
        if (valueType.isLongCmp()) {
            return 365;
        }
        if (valueType.isNumberCmp()) {
            return 395;
        }
        return 400;
    }

    @Override
    public int toShortMarshalCost() {
        ValueType valueType = this.getValueType();
        if (valueType.isLongCmp()) {
            return 385;
        }
        if (valueType.isNumberCmp()) {
            return 405;
        }
        return 400;
    }

    @Override
    public int toByteMarshalCost() {
        ValueType valueType = this.getValueType();
        if (valueType.isLongCmp()) {
            return 385;
        }
        if (valueType.isNumberCmp()) {
            return 405;
        }
        return 340;
    }

    @Override
    public int toCharMarshalCost() {
        return 320;
    }

    @Override
    public int toStringMarshalCost() {
        return 100;
    }

    @Override
    public int toCharArrayMarshalCost() {
        return 305;
    }

    @Override
    public int toStringValueMarshalCost() {
        return 0;
    }

    @Override
    public int toBinaryValueMarshalCost() {
        return 330;
    }

    @Override
    public int cmp(Value rValue) {
        if (rValue.isString()) {
            if (this.isNumberConvertible() && rValue.isNumberConvertible()) {
                double r;
                double l = this.toDouble();
                if (l == (r = rValue.toDouble())) {
                    return 0;
                }
                if (l < r) {
                    return -1;
                }
                return 1;
            }
            return this.toString().compareTo(rValue.toString());
        }
        int result = rValue.cmp(this);
        if (result == 0) {
            return 0;
        }
        if (result > 0) {
            return -1;
        }
        return 1;
    }

    @Override
    public boolean eq(Value rValue) {
        ValueType typeA = this.getValueType();
        ValueType typeB = rValue.getValueType();
        if (typeB.isNumber()) {
            double r;
            double l = this.toDouble();
            return l == (r = rValue.toDouble());
        }
        if (typeB.isBoolean()) {
            return this.toBoolean() == rValue.toBoolean();
        }
        if (typeA.isNumberCmp() && typeB.isNumberCmp()) {
            double r;
            double l = this.toDouble();
            return l == (r = rValue.toDouble());
        }
        if (rValue.isObject()) {
            return super.eq(rValue);
        }
        return this.toString().equals(rValue.toString());
    }

    public int cmpString(StringValue rValue) {
        return this.toString().compareTo(rValue.toString());
    }

    @Override
    public StringValue toStringValue() {
        return this;
    }

    @Override
    public StringValue toStringValue(Env env) {
        return this;
    }

    public static long toLong(String string) {
        return StringValue.parseLong(string);
    }

    static long parseLong(char[] buffer, int offset, int len) {
        int ch;
        if (len == 0) {
            return 0L;
        }
        long value = 0L;
        long sign = 1L;
        boolean isResultSet = false;
        long result = 0L;
        int end = offset + len;
        while (offset < end && Character.isWhitespace(buffer[offset])) {
            ++offset;
        }
        if (offset + 1 < end && buffer[offset] == '0' && ((ch = buffer[offset + 1]) == 120 || ch == 88)) {
            offset += 2;
            while (offset < end) {
                ch = buffer[offset] & 0xFF;
                long oldValue = value;
                if (48 <= ch && ch <= 57) {
                    value = value * 16L + (long)ch - 48L;
                } else if (97 <= ch && ch <= 122) {
                    value = value * 16L + (long)ch - 97L + 10L;
                } else if (65 <= ch && ch <= 90) {
                    value = value * 16L + (long)ch - 65L + 10L;
                } else {
                    return value;
                }
                if (value < oldValue) {
                    return Integer.MAX_VALUE;
                }
                ++offset;
            }
            return value;
        }
        if (offset < end && buffer[offset] == '-') {
            sign = -1L;
            ++offset;
        } else if (offset < end && buffer[offset] == '+') {
            sign = 1L;
            ++offset;
        }
        while (offset < end) {
            if (48 <= (ch = buffer[offset++]) && ch <= 57) {
                long newValue = 10L * value + (long)ch - 48L;
                if (newValue < value) {
                    result = Integer.MAX_VALUE;
                    isResultSet = true;
                    break;
                }
                value = newValue;
                continue;
            }
            result = sign * value;
            isResultSet = true;
            break;
        }
        if (!isResultSet) {
            result = sign * value;
        }
        return result;
    }

    static long parseLong(byte[] buffer, int offset, int len) {
        int ch;
        if (len == 0) {
            return 0L;
        }
        long value = 0L;
        long sign = 1L;
        boolean isResultSet = false;
        long result = 0L;
        int end = offset + len;
        while (offset < end && Character.isWhitespace(buffer[offset])) {
            ++offset;
        }
        if (offset + 1 < end && buffer[offset] == 48 && ((ch = buffer[offset + 1]) == 120 || ch == 88)) {
            offset += 2;
            while (offset < end) {
                ch = buffer[offset] & 0xFF;
                long oldValue = value;
                if (48 <= ch && ch <= 57) {
                    value = value * 16L + (long)ch - 48L;
                } else if (97 <= ch && ch <= 122) {
                    value = value * 16L + (long)ch - 97L + 10L;
                } else if (65 <= ch && ch <= 90) {
                    value = value * 16L + (long)ch - 65L + 10L;
                } else {
                    return value;
                }
                if (value < oldValue) {
                    return Integer.MAX_VALUE;
                }
                ++offset;
            }
            return value;
        }
        if (offset < end && buffer[offset] == 45) {
            sign = -1L;
            ++offset;
        } else if (offset < end && buffer[offset] == 43) {
            sign = 1L;
            ++offset;
        }
        while (offset < end) {
            if (48 <= (ch = buffer[offset++]) && ch <= 57) {
                long newValue = 10L * value + (long)ch - 48L;
                if (newValue < value) {
                    result = Integer.MAX_VALUE;
                    isResultSet = true;
                    break;
                }
                value = newValue;
                continue;
            }
            result = sign * value;
            isResultSet = true;
            break;
        }
        if (!isResultSet) {
            result = sign * value;
        }
        return result;
    }

    static long parseLong(CharSequence string) {
        int offset;
        int len = string.length();
        if (len == 0) {
            return 0L;
        }
        long value = 0L;
        long sign = 1L;
        boolean isResultSet = false;
        long result = 0L;
        int end = offset + len;
        for (offset = 0; offset < end && Character.isWhitespace(string.charAt(offset)); ++offset) {
        }
        if (offset < end && string.charAt(offset) == '-') {
            sign = -1L;
            ++offset;
        } else if (offset < end && string.charAt(offset) == '+') {
            sign = 1L;
            ++offset;
        }
        while (offset < end) {
            char ch;
            if ('0' <= (ch = string.charAt(offset++)) && ch <= '9') {
                long newValue = 10L * value + (long)ch - 48L;
                if (newValue < value) {
                    result = Integer.MAX_VALUE;
                    isResultSet = true;
                    break;
                }
                value = newValue;
                continue;
            }
            result = sign * value;
            isResultSet = true;
            break;
        }
        if (!isResultSet) {
            result = sign * value;
        }
        return result;
    }

    @Override
    public double toDouble() {
        return StringValue.toDouble(this.toString());
    }

    public static double toDouble(String s) {
        int i;
        int len = s.length();
        int start = 0;
        char ch = '\u0000';
        for (i = 0; i < len && Character.isWhitespace(s.charAt(i)); ++i) {
            ++start;
        }
        if (i + 1 < len && s.charAt(i) == '0' && ((ch = s.charAt(i)) == 'x' || ch == 'X')) {
            double value = 0.0;
            i += 2;
            while (i < len) {
                ch = s.charAt(i);
                if ('0' <= ch && ch <= '9') {
                    value = value * 16.0 + (double)ch - 48.0;
                } else if ('a' <= ch && ch <= 'z') {
                    value = value * 16.0 + (double)ch - 97.0 + 10.0;
                } else if ('A' <= ch && ch <= 'Z') {
                    value = value * 16.0 + (double)ch - 65.0 + 10.0;
                } else {
                    return value;
                }
                ++i;
            }
            return value;
        }
        if (i < len && ((ch = s.charAt(i)) == '+' || ch == '-')) {
            ++i;
        }
        while (i < len && '0' <= (ch = s.charAt(i)) && ch <= '9') {
            ++i;
        }
        if (ch == '.') {
            ++i;
            while (i < len && '0' <= (ch = s.charAt(i)) && ch <= '9') {
                ++i;
            }
        }
        if (ch == 'e' || ch == 'E') {
            int e = i++;
            if (i < len && (ch = s.charAt(i)) == '+' || ch == '-') {
                ++i;
            }
            while (i < len && '0' <= (ch = s.charAt(i)) && ch <= '9') {
                ++i;
            }
            if (i == e + 1) {
                i = e;
            }
        }
        if (i == 0) {
            return 0.0;
        }
        if (i == len && start == 0) {
            return Double.parseDouble(s);
        }
        return Double.parseDouble(s.substring(start, i));
    }

    @Override
    public boolean toBoolean() {
        int length = this.length();
        if (length == 0) {
            return false;
        }
        if (length > 1) {
            return true;
        }
        return this.charAt(0) != '0';
    }

    @Override
    public Value toKey() {
        int len = this.length();
        if (len == 0) {
            return this;
        }
        int sign = 1;
        long value = 0L;
        int i = 0;
        char ch = this.charAt(i);
        if (ch == '-') {
            if (len == 1) {
                return this;
            }
            sign = -1;
            ++i;
        }
        while (i < len) {
            ch = this.charAt(i);
            if ('0' > ch || ch > '9') {
                return this;
            }
            value = 10L * value + (long)ch - 48L;
            ++i;
        }
        return LongValue.create((long)sign * value);
    }

    @Override
    public final Value toAutoObject(Env env) {
        return env.createObject();
    }

    @Override
    public Value toAutoArray() {
        if (this.length() == 0) {
            return new ArrayValueImpl();
        }
        return this;
    }

    @Override
    public Object toJavaObject() {
        return this.toString();
    }

    public Object valuesToArray(Env env, Class elementType) {
        if (Character.TYPE.equals(elementType)) {
            return this.toUnicode(env).toCharArray();
        }
        if (Character.class.equals((Object)elementType)) {
            char[] chars = this.toUnicode(env).toCharArray();
            int length = chars.length;
            Character[] charObjects = new Character[length];
            for (int i = 0; i < length; ++i) {
                charObjects[i] = Character.valueOf(chars[i]);
            }
            return charObjects;
        }
        if (Byte.TYPE.equals(elementType)) {
            return this.toBinaryValue(env).toBytes();
        }
        if (Byte.class.equals((Object)elementType)) {
            byte[] bytes = this.toBinaryValue(env).toBytes();
            int length = bytes.length;
            Byte[] byteObjects = new Byte[length];
            for (int i = 0; i < length; ++i) {
                byteObjects[i] = bytes[i];
            }
            return byteObjects;
        }
        env.error(L.l("Can't assign {0} with type {1} to {2}", (Object)this, (Object)this.getClass(), (Object)elementType));
        return null;
    }

    @Override
    public Callable toCallable(Env env, boolean isOptional) {
        if (this.isEmpty()) {
            return super.toCallable(env, isOptional);
        }
        int p = this.indexOf("::");
        if (p < 0) {
            return new CallbackFunction(env, this);
        }
        StringValue className = this.substring(0, p);
        StringValue methodName = this.substring(p + 2);
        QuercusClass cl = env.findClass(className.toString());
        if (cl == null) {
            env.warning(L.l("can't find class {0}", (Object)className));
            return super.toCallable(env, false);
        }
        return new CallbackClassMethod(cl, methodName);
    }

    @Override
    public Value append(Value index, Value value) {
        if (this.length() == 0) {
            return new ArrayValueImpl().append(index, value);
        }
        return this;
    }

    @Override
    public Value putThisFieldArray(Env env, Value obj, StringValue fieldName, Value index, Value value) {
        Value newFieldValue = this.setCharValueAt(index.toLong(), value);
        if (newFieldValue != this) {
            obj.putThisField(env, fieldName, newFieldValue);
        }
        return newFieldValue.get(index);
    }

    @Override
    public Value get(Value key) {
        return this.charValueAt(key.toLong());
    }

    @Override
    public Value getArg(Value key, boolean isTop) {
        return this.charValueAt(key.toLong());
    }

    @Override
    public Value charValueAt(long index) {
        int len = this.length();
        if (index < 0L || (long)len <= index) {
            return UnsetUnicodeValue.UNSET;
        }
        return StringValue.create(this.charAt((int)index));
    }

    @Override
    public Value setCharValueAt(long index, Value value) {
        int len = this.length();
        if (index < 0L || (long)len <= index) {
            return this;
        }
        return this.createStringBuilder().append(this, 0, (int)index).append(value).append(this, (int)(index + 1L), this.length());
    }

    @Override
    public Value increment(int incr) {
        if (this.length() == 0) {
            if (incr == 1) {
                return this.createStringBuilder().append("1");
            }
            return LongValue.MINUS_ONE;
        }
        if (incr > 0) {
            StringBuilder tail = new StringBuilder();
            for (int i = this.length() - 1; i >= 0; --i) {
                char ch = this.charAt(i);
                if (ch == 'z') {
                    if (i == 0) {
                        return this.createStringBuilder().append("aa").append(tail);
                    }
                    tail.insert(0, 'a');
                    continue;
                }
                if ('a' <= ch && ch < 'z') {
                    return this.createStringBuilder().append(this, 0, i).append((char)(ch + '\u0001')).append(tail);
                }
                if (ch == 'Z') {
                    if (i == 0) {
                        return this.createStringBuilder().append("AA").append(tail);
                    }
                    tail.insert(0, 'A');
                    continue;
                }
                if ('A' <= ch && ch < 'Z') {
                    return this.createStringBuilder().append(this, 0, i).append((char)(ch + '\u0001')).append(tail);
                }
                if ('0' > ch || ch > '9' || i != this.length() - 1) continue;
                return LongValue.create(this.toLong() + (long)incr);
            }
            return this.createStringBuilder().append(tail.toString());
        }
        if (this.getValueType().isLongAdd()) {
            return LongValue.create(this.toLong() + (long)incr);
        }
        return this;
    }

    @Override
    public Value add(long rValue) {
        if (this.getValueType().isLongAdd()) {
            return LongValue.create(this.toLong() + rValue);
        }
        return DoubleValue.create(this.toDouble() + (double)rValue);
    }

    @Override
    public Value sub(long rValue) {
        if (this.getValueType().isLongAdd()) {
            return LongValue.create(this.toLong() - rValue);
        }
        return DoubleValue.create(this.toDouble() - (double)rValue);
    }

    @Override
    public Value bitAnd(Value rValue) {
        if (rValue.isString()) {
            StringValue rStr = (StringValue)rValue;
            int len = Math.min(this.length(), rValue.length());
            StringValue sb = this.createStringBuilder();
            for (int i = 0; i < len; ++i) {
                char l = this.charAt(i);
                char r = rStr.charAt(i);
                sb.appendByte(l & r);
            }
            return sb;
        }
        return LongValue.create(this.toLong() & rValue.toLong());
    }

    @Override
    public Value bitOr(Value rValue) {
        if (rValue.isString()) {
            StringValue rStr = (StringValue)rValue;
            int len = Math.min(this.length(), rValue.length());
            StringValue sb = this.createStringBuilder();
            for (int i = 0; i < len; ++i) {
                char l = this.charAt(i);
                char r = rStr.charAt(i);
                sb.appendByte(l | r);
            }
            if (len != this.length()) {
                sb.append(this.substring(len));
            } else if (len != rStr.length()) {
                sb.append(rStr.substring(len));
            }
            return sb;
        }
        return LongValue.create(this.toLong() | rValue.toLong());
    }

    @Override
    public Value bitXor(Value rValue) {
        if (rValue.isString()) {
            StringValue rStr = rValue.toStringValue();
            int len = Math.min(this.length(), rValue.length());
            StringValue sb = this.createStringBuilder();
            for (int i = 0; i < len; ++i) {
                char l = this.charAt(i);
                char r = rStr.charAt(i);
                sb.appendByte(l ^ r);
            }
            return sb;
        }
        return LongValue.create(this.toLong() ^ rValue.toLong());
    }

    @Override
    public void serialize(Env env, StringBuilder sb) {
        sb.append("s:");
        sb.append(this.length());
        sb.append(":\"");
        sb.append(this.toString());
        sb.append("\";");
    }

    @Override
    public void jsonEncode(Env env, JsonEncodeContext context, StringValue sb) {
        if (context.isCheckNumeric()) {
            if (this.isLongConvertible()) {
                this.toLongValue().jsonEncode(env, context, sb);
                return;
            }
            if (this.isDoubleConvertible()) {
                this.toDoubleValue().jsonEncode(env, context, sb);
                return;
            }
        }
        sb.append('\"');
        int len = this.length();
        block10: for (int i = 0; i < len; ++i) {
            char c = this.charAt(i);
            switch (c) {
                case '\b': {
                    sb.append('\\');
                    sb.append('b');
                    continue block10;
                }
                case '\f': {
                    sb.append('\\');
                    sb.append('f');
                    continue block10;
                }
                case '\n': {
                    sb.append('\\');
                    sb.append('n');
                    continue block10;
                }
                case '\r': {
                    sb.append('\\');
                    sb.append('r');
                    continue block10;
                }
                case '\t': {
                    sb.append('\\');
                    sb.append('t');
                    continue block10;
                }
                case '\\': {
                    sb.append('\\');
                    sb.append('\\');
                    continue block10;
                }
                case '\"': {
                    if (context.isEscapeQuote()) {
                        sb.append("\\u0022");
                        continue block10;
                    }
                    sb.append('\\');
                    sb.append('\"');
                    continue block10;
                }
                case '/': {
                    sb.append('\\');
                    sb.append('/');
                    continue block10;
                }
                default: {
                    char c1;
                    if (c <= '\u001f') {
                        this.jsonEncodeUnicode(sb, c);
                        continue block10;
                    }
                    if (c < '\u0080') {
                        this.jsonEncodeAscii(context, sb, c);
                        continue block10;
                    }
                    if ((c & 0xE0) == 192 && i + 1 < len) {
                        c1 = this.charAt(i + 1);
                        ++i;
                        int ch = ((c & 0x1F) << 6) + (c1 & 0x3F);
                        this.jsonEncodeUnicode(sb, ch);
                        continue block10;
                    }
                    if ((c & 0xF0) == 224 && i + 2 < len) {
                        c1 = this.charAt(i + 1);
                        char c2 = this.charAt(i + 2);
                        i += 2;
                        int ch = ((c & 0xF) << 12) + ((c1 & 0x3F) << 6) + (c2 & 0x3F);
                        this.jsonEncodeUnicode(sb, ch);
                        continue block10;
                    }
                    this.jsonEncodeUnicode(sb, c);
                }
            }
        }
        sb.append('\"');
    }

    private void jsonEncodeUnicode(StringValue sb, int c) {
        sb.append('\\');
        sb.append('u');
        int d = c >> 12 & 0xF;
        if (d < 10) {
            sb.append((char)(48 + d));
        } else {
            sb.append((char)(97 + d - 10));
        }
        d = c >> 8 & 0xF;
        if (d < 10) {
            sb.append((char)(48 + d));
        } else {
            sb.append((char)(97 + d - 10));
        }
        d = c >> 4 & 0xF;
        if (d < 10) {
            sb.append((char)(48 + d));
        } else {
            sb.append((char)(97 + d - 10));
        }
        d = c & 0xF;
        if (d < 10) {
            sb.append((char)(48 + d));
        } else {
            sb.append((char)(97 + d - 10));
        }
    }

    private void jsonEncodeAscii(JsonEncodeContext context, StringValue sb, char ch) {
        switch (ch) {
            case '<': {
                if (context.isEscapeTag()) {
                    sb.append("\\u003C");
                    break;
                }
                sb.append(ch);
                break;
            }
            case '>': {
                if (context.isEscapeTag()) {
                    sb.append("\\u003E");
                    break;
                }
                sb.append(ch);
                break;
            }
            case '&': {
                if (context.isEscapeAmp()) {
                    sb.append("\\u0026");
                    break;
                }
                sb.append(ch);
                break;
            }
            case '\'': {
                if (context.isEscapeApos()) {
                    sb.append("\\u0027");
                    break;
                }
                sb.append(ch);
                break;
            }
            case '\"': {
                if (context.isEscapeQuote()) {
                    sb.append("\\u0022");
                    break;
                }
                sb.append(ch);
                break;
            }
            default: {
                sb.append(ch);
            }
        }
    }

    public StringValue append(String s) {
        throw new UnsupportedOperationException(this.getClass().getName());
    }

    public StringValue append(String s, int start, int end) {
        throw new UnsupportedOperationException(this.getClass().getName());
    }

    public StringValue append(char[] buf, int offset, int length) {
        throw new UnsupportedOperationException(this.getClass().getName());
    }

    public StringValue append(char[] buf) {
        return this.append(buf, 0, buf.length);
    }

    public StringValue append(CharSequence buf, int head, int tail) {
        throw new UnsupportedOperationException(this.getClass().getName());
    }

    public StringValue append(StringBuilderValue sb, int head, int tail) {
        return this.append((CharSequence)sb, head, tail);
    }

    public StringValue append(UnicodeBuilderValue sb, int head, int tail) {
        return this.append((CharSequence)sb, head, tail);
    }

    public StringValue append(Env env, StringValue unicodeStr, String charset) {
        if (!unicodeStr.isUnicode()) {
            return this.append(unicodeStr);
        }
        try {
            byte[] bytes = unicodeStr.toString().getBytes(charset);
            this.append(bytes);
            return this;
        }
        catch (UnsupportedEncodingException e) {
            env.warning(e);
            return this.append(unicodeStr);
        }
    }

    public StringValue append(char v) {
        throw new UnsupportedOperationException(this.getClass().getName());
    }

    public StringValue append(boolean v) {
        return this.append(v ? "true" : "false");
    }

    public StringValue append(long v) {
        return this.append(String.valueOf(v));
    }

    public StringValue append(double v) {
        return this.append(String.valueOf(v));
    }

    public StringValue append(Object v) {
        return this.append(String.valueOf(v));
    }

    public StringValue append(Value v) {
        throw new UnsupportedOperationException(this.getClass().getName());
    }

    public void ensureAppendCapacity(int size) {
        throw new UnsupportedOperationException(this.getClass().getName());
    }

    public StringValue append(byte[] buf, int offset, int length) {
        throw new UnsupportedOperationException(this.getClass().getName());
    }

    public StringValue append(byte[] buf) {
        return this.append(buf, 0, buf.length);
    }

    public StringValue appendUtf8(byte[] buf, int offset, int length) {
        throw new UnsupportedOperationException(this.getClass().getName());
    }

    public StringValue appendUtf8(byte[] buf) {
        return this.appendUtf8(buf, 0, buf.length);
    }

    @Override
    public StringValue appendTo(UnicodeBuilderValue sb) {
        int length = this.length();
        for (int i = 0; i < length; ++i) {
            sb.append(this.charAt(i));
        }
        return this;
    }

    public StringValue appendUnicode(boolean v) {
        return this.append(v ? "true" : "false");
    }

    public StringValue appendUnicode(long v) {
        return this.append(String.valueOf(v));
    }

    public StringValue appendUnicode(double v) {
        return this.append(String.valueOf(v));
    }

    public StringValue appendUnicode(Object v) {
        return this.append(String.valueOf(v));
    }

    public StringValue appendUnicode(char v) {
        return this.append(v);
    }

    public StringValue appendUnicode(char[] buffer, int offset, int length) {
        return this.append(buffer, offset, length);
    }

    public StringValue appendUnicode(char[] buffer) {
        return this.append(buffer);
    }

    public StringValue appendUnicode(String value) {
        return this.append(value);
    }

    public StringValue appendUnicode(String value, int offset, int length) {
        return this.append(value, offset, length);
    }

    public StringValue appendUnicode(Value value) {
        return this.append(value);
    }

    public StringValue appendUnicode(Value v1, Value v2) {
        return this.append(v1).append(v2);
    }

    public StringValue appendByte(int v) {
        throw new UnsupportedOperationException(this.getClass().getName());
    }

    public StringValue appendBytes(String s) {
        StringValue sb = this;
        for (int i = 0; i < s.length(); ++i) {
            sb = sb.appendByte(s.charAt(i));
        }
        return sb;
    }

    public StringValue appendBytes(StringValue s) {
        StringValue sb = this;
        for (int i = 0; i < s.length(); ++i) {
            sb = sb.appendByte(s.charAt(i));
        }
        return sb;
    }

    public StringValue appendBytes(char[] buf, int offset, int length) {
        StringValue sb = this;
        int end = Math.min(buf.length, offset + length);
        while (offset < end) {
            sb = sb.appendByte(buf[offset++]);
        }
        return sb;
    }

    public StringValue appendBytes(byte[] bytes, int offset, int end) {
        StringValue sb = this;
        while (offset < end) {
            sb = sb.appendByte(bytes[offset++]);
        }
        return sb;
    }

    public StringValue append(TempBuffer ptr) {
        while (ptr != null) {
            this.append(ptr.getBuffer(), 0, ptr.getLength());
            ptr = ptr.getNext();
        }
        return this;
    }

    public StringValue append(Reader reader) throws IOException {
        int ch;
        while ((ch = reader.read()) >= 0) {
            this.append((char)ch);
        }
        return this;
    }

    public StringValue append(Reader reader, long length) throws IOException {
        int ch;
        while (length-- > 0L && (ch = reader.read()) >= 0) {
            this.append((char)ch);
        }
        return this;
    }

    public int appendRead(InputStream is, long length) {
        TempBuffer tBuf = TempBuffer.allocate();
        try {
            byte[] buffer = tBuf.getBuffer();
            int sublen = buffer.length;
            if (length < (long)sublen) {
                sublen = (int)length;
            }
            if ((sublen = is.read(buffer, 0, sublen)) > 0) {
                this.append(buffer, 0, sublen);
            }
            int n = sublen;
            return n;
        }
        catch (IOException e) {
            throw new QuercusModuleException(e);
        }
        finally {
            TempBuffer.free(tBuf);
        }
    }

    public int appendReadAll(InputStream is, long length) {
        TempBuffer tBuf = TempBuffer.allocate();
        try {
            byte[] buffer = tBuf.getBuffer();
            int readLength = 0;
            while (length > 0L) {
                int sublen = buffer.length;
                if (length < (long)sublen) {
                    sublen = (int)length;
                }
                if ((sublen = is.read(buffer, 0, sublen)) > 0) {
                    this.append(buffer, 0, sublen);
                    length -= (long)sublen;
                    readLength += sublen;
                    continue;
                }
                int n = readLength > 0 ? readLength : -1;
                return n;
            }
            int n = readLength;
            return n;
        }
        catch (IOException e) {
            throw new QuercusModuleException(e);
        }
        finally {
            TempBuffer.free(tBuf);
        }
    }

    public int appendReadAll(ReadStream is, long length) {
        TempBuffer tBuf = TempBuffer.allocate();
        try {
            byte[] buffer = tBuf.getBuffer();
            int readLength = 0;
            while (length > 0L) {
                int sublen = buffer.length;
                if (length < (long)sublen) {
                    sublen = (int)length;
                }
                if ((sublen = is.read(buffer, 0, sublen)) > 0) {
                    this.append(buffer, 0, sublen);
                    length -= (long)sublen;
                    readLength += sublen;
                    continue;
                }
                int n = readLength > 0 ? readLength : -1;
                return n;
            }
            int n = readLength;
            return n;
        }
        catch (IOException e) {
            throw new QuercusModuleException(e);
        }
        finally {
            TempBuffer.free(tBuf);
        }
    }

    public int appendRead(BinaryInput is, long length) {
        TempBuffer tBuf = TempBuffer.allocate();
        try {
            int readLength = 0;
            byte[] buffer = tBuf.getBuffer();
            while (length > 0L) {
                int sublen = Math.min((int)length, buffer.length);
                if (readLength > 0 && is.getAvailable() <= 0) {
                    int n = readLength;
                    return n;
                }
                if ((sublen = is.read(buffer, 0, sublen)) > 0) {
                    this.append(buffer, 0, sublen);
                    readLength += sublen;
                    length -= (long)sublen;
                    continue;
                }
                int n = readLength > 0 ? readLength : sublen;
                return n;
            }
            int n = readLength;
            return n;
        }
        catch (IOException e) {
            throw new QuercusModuleException(e);
        }
        finally {
            TempBuffer.free(tBuf);
        }
    }

    public int appendReadAll(BinaryInput is, long length) {
        TempBuffer tBuf = TempBuffer.allocate();
        try {
            byte[] buffer = tBuf.getBuffer();
            int readLength = 0;
            while (length > 0L) {
                int sublen = buffer.length;
                if (length < (long)sublen) {
                    sublen = (int)length;
                }
                if ((sublen = is.read(buffer, 0, sublen)) > 0) {
                    this.append(buffer, 0, sublen);
                    length -= (long)sublen;
                    readLength += sublen;
                    continue;
                }
                int n = readLength > 0 ? readLength : -1;
                return n;
            }
            int n = readLength;
            return n;
        }
        catch (IOException e) {
            throw new QuercusModuleException(e);
        }
        finally {
            TempBuffer.free(tBuf);
        }
    }

    @Override
    protected void varExportImpl(StringValue sb, int level) {
        sb.append("'");
        int len = this.length();
        block4: for (int i = 0; i < len; ++i) {
            char ch = this.charAt(i);
            switch (ch) {
                case '\'': {
                    sb.append("\\'");
                    continue block4;
                }
                case '\\': {
                    sb.append("\\\\");
                    continue block4;
                }
                default: {
                    sb.append(ch);
                }
            }
        }
        sb.append("'");
    }

    @Override
    public int length() {
        return this.toString().length();
    }

    @Override
    public char charAt(int index) {
        return this.toString().charAt(index);
    }

    @Override
    public CharSequence subSequence(int start, int end) {
        return new StringBuilderValue(this.toString().substring(start, end));
    }

    public void setLength(int length) {
        throw new UnsupportedOperationException();
    }

    public final int indexOf(CharSequence match) {
        return this.indexOf(match, 0);
    }

    public int indexOf(CharSequence match, int head) {
        int length = this.length();
        int matchLength = match.length();
        if (matchLength <= 0) {
            return -1;
        }
        if (head < 0) {
            return -1;
        }
        int end = length - matchLength;
        char first = match.charAt(0);
        while (head <= end) {
            block6: {
                if (this.charAt(head) == first) {
                    for (int i = 1; i < matchLength; ++i) {
                        if (this.charAt(head + i) == match.charAt(i)) {
                            continue;
                        }
                        break block6;
                    }
                    return head;
                }
            }
            ++head;
        }
        return -1;
    }

    public int indexOf(char match) {
        return this.indexOf(match, 0);
    }

    public int indexOf(char match, int head) {
        int length = this.length();
        while (head < length) {
            if (this.charAt(head) == match) {
                return head;
            }
            ++head;
        }
        return -1;
    }

    public final int lastIndexOf(char match) {
        return this.lastIndexOf(match, Integer.MAX_VALUE);
    }

    public int lastIndexOf(char match, int tail) {
        int length = this.length();
        if (tail >= length) {
            tail = length - 1;
        }
        while (tail >= 0) {
            if (this.charAt(tail) == match) {
                return tail;
            }
            --tail;
        }
        return -1;
    }

    public int lastIndexOf(CharSequence match) {
        return this.lastIndexOf(match, Integer.MAX_VALUE);
    }

    public int lastIndexOf(CharSequence match, int tail) {
        int length = this.length();
        int matchLength = match.length();
        if (matchLength <= 0) {
            return -1;
        }
        if (tail < 0) {
            return -1;
        }
        if (tail > length - matchLength) {
            tail = length - matchLength;
        }
        char first = match.charAt(0);
        while (tail >= 0) {
            block7: {
                if (this.charAt(tail) == first) {
                    for (int i = 1; i < matchLength; ++i) {
                        if (this.charAt(tail + i) == match.charAt(i)) {
                            continue;
                        }
                        break block7;
                    }
                    return tail;
                }
            }
            --tail;
        }
        return -1;
    }

    public boolean regionMatches(int offset, char[] mBuffer, int mOffset, int mLength) {
        int length = this.length();
        if (length < offset + mLength) {
            return false;
        }
        for (int i = 0; i < mLength; ++i) {
            if (this.charAt(offset + i) == mBuffer[mOffset + i]) continue;
            return false;
        }
        return true;
    }

    public boolean regionMatches(int offset, StringValue match, int mOffset, int mLength) {
        int length = this.length();
        if (length < offset + mLength) {
            return false;
        }
        for (int i = 0; i < mLength; ++i) {
            if (this.charAt(offset + i) == match.charAt(mOffset + i)) continue;
            return false;
        }
        return true;
    }

    public boolean regionMatchesIgnoreCase(int offset, char[] match, int mOffset, int mLength) {
        int length = this.length();
        if (length < offset + mLength) {
            return false;
        }
        for (int i = 0; i < mLength; ++i) {
            char b;
            char a = Character.toLowerCase(this.charAt(offset + i));
            if (a == (b = Character.toLowerCase(match[mOffset + i]))) continue;
            return false;
        }
        return true;
    }

    public boolean startsWith(CharSequence head) {
        int headLen;
        int len = this.length();
        if (len < (headLen = head.length())) {
            return false;
        }
        for (int i = 0; i < headLen; ++i) {
            if (this.charAt(i) == head.charAt(i)) continue;
            return false;
        }
        return true;
    }

    public boolean endsWith(CharSequence tail) {
        int tailLen;
        int len = this.length();
        int offset = len - (tailLen = tail.length());
        if (offset < 0) {
            return false;
        }
        for (int i = 0; i < tailLen; ++i) {
            if (this.charAt(offset + i) == tail.charAt(i)) continue;
            return false;
        }
        return true;
    }

    public StringValue substring(int head) {
        return (StringValue)this.subSequence(head, this.length());
    }

    public StringValue substring(int begin, int end) {
        return (StringValue)this.subSequence(begin, end);
    }

    public String stringSubstring(int begin, int end) {
        return this.substring(begin, end).toString();
    }

    public char[] toCharArray() {
        int length = this.length();
        char[] array = new char[this.length()];
        this.getChars(0, array, 0, length);
        return array;
    }

    public char[] getRawCharArray() {
        return this.toCharArray();
    }

    public void getChars(int stringOffset, char[] buffer, int offset, int length) {
        for (int i = 0; i < length; ++i) {
            buffer[offset + i] = this.charAt(stringOffset + i);
        }
    }

    public final StringValue toLowerCase() {
        return this.toLowerCase(Locale.ENGLISH);
    }

    public StringValue toLowerCase(Locale locale) {
        int length = this.length();
        boolean isUpperCase = false;
        for (int i = 0; i < length; ++i) {
            char ch = this.charAt(i);
            if ('a' <= ch && ch <= 'z') continue;
            if ('A' <= ch && ch <= 'Z') {
                isUpperCase = true;
                break;
            }
            if (!this.isUnicode() || !Character.isUpperCase(ch)) continue;
            isUpperCase = true;
            break;
        }
        if (!isUpperCase) {
            return this;
        }
        StringValue sb = this.createStringBuilder(length);
        for (int i = 0; i < length; ++i) {
            char ch = this.charAt(i);
            if ('a' <= ch && ch <= 'z') {
                sb.append(ch);
                continue;
            }
            if ('A' <= ch && ch <= 'Z') {
                sb.append((char)(ch + 97 - 65));
                continue;
            }
            if (!this.isUnicode() || !Character.isUpperCase(ch)) continue;
            sb.append(Character.toLowerCase(ch));
        }
        return sb;
    }

    public StringValue toUpperCase() {
        return this.toUpperCase(Locale.ENGLISH);
    }

    public StringValue toUpperCase(Locale locale) {
        int length = this.length();
        UnicodeBuilderValue string = new UnicodeBuilderValue(length);
        char[] buffer = string.getBuffer();
        this.getChars(0, buffer, 0, length);
        for (int i = 0; i < length; ++i) {
            char ch = buffer[i];
            if ('a' <= ch && ch <= 'z') {
                buffer[i] = (char)(ch + 65 - 97);
                continue;
            }
            if (ch < '\u0080' || !Character.isLowerCase(ch)) continue;
            buffer[i] = Character.toUpperCase(ch);
        }
        string.setLength(length);
        return string;
    }

    @Override
    public InputStream toInputStream() {
        return new ByteArrayInputStream(this.toBytes());
    }

    public Reader toSimpleReader() {
        return new SimpleStringValueReader(this);
    }

    public Reader toReader(String charset) throws UnsupportedEncodingException {
        byte[] bytes = this.toBytes();
        return new InputStreamReader((InputStream)new ByteArrayInputStream(bytes), charset);
    }

    public String toString(String charset) throws UnsupportedEncodingException {
        byte[] bytes = this.toBytes();
        return new String(bytes, charset);
    }

    public byte[] toBytes() {
        throw new UnsupportedOperationException();
    }

    @Override
    public StringValue toUnicode(Env env) {
        return this;
    }

    public StringValue toUnicodeValue(Env env, String charset) {
        UnicodeBuilderValue sb = new UnicodeBuilderValue();
        Decoder decoder = Decoder.create(charset);
        sb.append(decoder.decode(env, this));
        return sb;
    }

    public StringValue convertToUnicode(Env env, String charset) {
        Decoder decoder = Decoder.create(charset);
        decoder.setAllowMalformedOut(true);
        StringValue result = decoder.decodeUnicode(this);
        return result;
    }

    @Override
    public StringValue toStringBuilder(Env env) {
        return this.createStringBuilder().append(this);
    }

    @Override
    public boolean isset(Value indexV) {
        int index = indexV.toInt();
        int len = this.length();
        return 0 <= index && index < len;
    }

    public void writeTo(OutputStream os) {
        try {
            int len = this.length();
            for (int i = 0; i < len; ++i) {
                os.write(this.charAt(i));
            }
        }
        catch (IOException e) {
            throw new QuercusModuleException(e);
        }
    }

    public OutputStream getOutputStream() {
        throw new UnsupportedOperationException();
    }

    public long getCrc32Value() {
        CRC32 crc = new CRC32();
        int length = this.length();
        for (int i = 0; i < length; ++i) {
            crc.update((byte)this.charAt(i));
        }
        return crc.getValue() & 0xFFFFFFFFFFFFFFFFL;
    }

    @Override
    public void write(int value) {
        throw new UnsupportedOperationException(this.getClass().getName());
    }

    @Override
    public void write(byte[] buffer, int offset, int len) {
        throw new UnsupportedOperationException(this.getClass().getName());
    }

    @Override
    public int hashCode() {
        int hash = 37;
        int length = this.length();
        for (int i = 0; i < length; ++i) {
            hash = 65521 * hash + this.charAt(i);
        }
        return hash;
    }

    public int hashCodeCaseInsensitive() {
        int hash = 37;
        int length = this.length();
        for (int i = length - 1; i >= 0; --i) {
            int ch = this.charAt(i);
            if (65 <= ch && ch <= 90) {
                ch = ch + 97 - 65;
            }
            hash = 65521 * hash + ch;
        }
        return hash;
    }

    public boolean equals(Object o) {
        int bLength;
        if (this == o) {
            return true;
        }
        if (!(o instanceof StringValue)) {
            return false;
        }
        StringValue s = (StringValue)o;
        int aLength = this.length();
        if (aLength != (bLength = s.length())) {
            return false;
        }
        for (int i = aLength - 1; i >= 0; --i) {
            if (this.charAt(i) == s.charAt(i)) continue;
            return false;
        }
        return true;
    }

    public boolean equalsIgnoreCase(Object o) {
        int bLength;
        if (this == o) {
            return true;
        }
        if (!(o instanceof StringValue)) {
            return false;
        }
        StringValue s = (StringValue)o;
        if (s.isUnicode() != this.isUnicode()) {
            return false;
        }
        int aLength = this.length();
        if (aLength != (bLength = s.length())) {
            return false;
        }
        for (int i = aLength - 1; i >= 0; --i) {
            char chA = this.charAt(i);
            char chB = s.charAt(i);
            if ((chA = Character.toLowerCase(chA)) == (chB = Character.toLowerCase(chB))) continue;
            return false;
        }
        return true;
    }

    public boolean equalsString(CharSequence s) {
        int lenB;
        if (this == s) {
            return true;
        }
        int lenA = this.length();
        if (lenA != (lenB = s.length())) {
            return false;
        }
        for (int i = 0; i < lenA; ++i) {
            char chB;
            char chA = this.charAt(i);
            if (chA == (chB = s.charAt(i))) continue;
            return false;
        }
        return true;
    }

    public boolean equalsStringIgnoreCase(CharSequence s) {
        int lenB;
        if (this == s) {
            return true;
        }
        int lenA = this.length();
        if (lenA != (lenB = s.length())) {
            return false;
        }
        for (int i = 0; i < lenA; ++i) {
            char chB;
            char chA = this.charAt(i);
            if (chA == (chB = s.charAt(i))) continue;
            if ('A' <= chA && chA <= 'Z') {
                chA = (char)(chA + 32);
            }
            if ('A' <= chB && chB <= 'Z') {
                chB = (char)(chB + 32);
            }
            if (chA == chB) continue;
            return false;
        }
        return true;
    }

    @Override
    public void generate(PrintWriter out) throws IOException {
        int maxSublen = 65534;
        int len = this.length();
        String className = this.getClass().getSimpleName();
        if (len == 1) {
            out.print(className + ".create('");
            StringValue.printJavaChar(out, this.charAt(0));
            out.print("')");
        } else if (len < maxSublen) {
            out.print("new " + className + "(\"");
            StringValue.printJavaString(out, this);
            out.print("\")");
        } else {
            out.print("((" + className + ") (new " + className + "(\"");
            for (int i = 0; i < len; i += maxSublen) {
                if (i != 0) {
                    out.print("\").append(\"");
                }
                StringValue.printJavaString(out, this.substring(i, Math.min(i + maxSublen, len)));
            }
            out.print("\")))");
        }
    }

    @Override
    public abstract String toDebugString();

    @Override
    public abstract void varDumpImpl(Env var1, WriteStream var2, int var3, IdentityHashMap<Value, String> var4) throws IOException;

    public StringValue intern() {
        StringValue value = _internMap.get(this);
        if (value == null) {
            _internMap.put(this, this);
            value = this;
        }
        return value;
    }

    static class SimpleStringValueReader
    extends Reader {
        StringValue _str;
        int _index;
        int _length;

        SimpleStringValueReader(StringValue s) {
            this._str = s;
            this._length = s.length();
        }

        @Override
        public int read() {
            if (this._index >= this._length) {
                return -1;
            }
            return this._str.charAt(this._index++);
        }

        @Override
        public int read(char[] buf, int off, int len) {
            int i;
            if (this._index >= this._length) {
                return -1;
            }
            len = Math.min(this._length - this._index, len);
            for (i = 0; i < len; ++i) {
                buf[off + i] = this._str.charAt(i + this._index++);
            }
            return i;
        }

        @Override
        public void close() throws IOException {
        }
    }

    class StringValueInputStream
    extends InputStream {
        private final int _length;
        private int _index;

        StringValueInputStream() {
            this._length = StringValue.this.length();
        }

        @Override
        public int read() {
            if (this._index < this._length) {
                return StringValue.this.charAt(this._index++);
            }
            return -1;
        }

        @Override
        public int read(byte[] buffer, int offset, int length) {
            int sublen = this._length - this._index;
            if (length < sublen) {
                sublen = length;
            }
            if (sublen <= 0) {
                return -1;
            }
            int index = this._index;
            for (int i = 0; i < sublen; ++i) {
                buffer[offset + i] = (byte)StringValue.this.charAt(index + i);
            }
            this._index += sublen;
            return sublen;
        }
    }
}

