/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.quercus.expr;

import com.caucho.quercus.Location;
import com.caucho.quercus.env.Env;
import com.caucho.quercus.env.ObjectValue;
import com.caucho.quercus.env.Value;
import com.caucho.quercus.env.Var;
import com.caucho.quercus.expr.AbstractVarExpr;
import com.caucho.quercus.expr.Expr;

public class ArrayTailExpr
extends AbstractVarExpr {
    protected final Expr _expr;

    public ArrayTailExpr(Location location, Expr expr) {
        super(location);
        this._expr = expr;
    }

    public ArrayTailExpr(Expr expr) {
        this._expr = expr;
    }

    @Override
    public boolean canRead() {
        return false;
    }

    public Expr getExpr() {
        return this._expr;
    }

    @Override
    public Value eval(Env env) {
        return env.error("Cannot use [] as a read-value.", this.getLocation());
    }

    @Override
    public Value evalArg(Env env, boolean isTop) {
        if (isTop) {
            Value obj = this._expr.evalArray(env);
            return obj.putVar();
        }
        Value obj = this._expr.evalArray(env).toValue();
        return obj.getArgTail(env, isTop);
    }

    @Override
    public Var evalVar(Env env) {
        Var obj = this._expr.evalVar(env);
        return ((Value)obj).putVar();
    }

    @Override
    public Value evalArray(Env env) {
        Value obj = this._expr.evalArray(env);
        return obj.putArray(env);
    }

    @Override
    public Value evalObject(Env env) {
        Value array = this._expr.evalArray(env);
        ObjectValue value = env.createObject();
        array.put(value);
        return value;
    }

    @Override
    public Value evalAssignValue(Env env, Value value) {
        Value array = this._expr.evalArrayAssignTail(env, value);
        return array;
    }

    @Override
    public Value evalAssignRef(Env env, Value value) {
        Value array = this._expr.evalArray(env);
        array.put(value);
        return value;
    }

    @Override
    public void evalUnset(Env env) {
        throw new UnsupportedOperationException();
    }

    @Override
    public String toString() {
        return this._expr + "[]";
    }
}

