/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.quercus.expr;

import com.caucho.quercus.Location;
import com.caucho.quercus.env.Env;
import com.caucho.quercus.env.StringValue;
import com.caucho.quercus.env.Value;
import com.caucho.quercus.expr.AbstractMethodExpr;
import com.caucho.quercus.expr.Expr;
import java.util.ArrayList;

public class ObjectMethodExpr
extends AbstractMethodExpr {
    protected final Expr _objExpr;
    protected final StringValue _methodName;
    protected final Expr[] _args;

    public ObjectMethodExpr(Location location, Expr objExpr, StringValue name, ArrayList<Expr> args) {
        super(location);
        this._objExpr = objExpr;
        this._methodName = name;
        this._args = new Expr[args.size()];
        args.toArray(this._args);
    }

    public String getName() {
        return this._methodName.toString();
    }

    @Override
    public Value eval(Env env) {
        Value obj = this._objExpr.eval(env);
        StringValue methodName = this._methodName;
        int hash = methodName.hashCodeCaseInsensitive();
        return this.eval(env, obj, methodName, hash, this._args);
    }

    @Override
    public String toString() {
        return this._objExpr + "->" + this._methodName + "()";
    }
}

