/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.quercus.expr;

import com.caucho.quercus.Location;
import com.caucho.quercus.env.Env;
import com.caucho.quercus.env.StringValue;
import com.caucho.quercus.env.Value;
import com.caucho.quercus.env.Var;
import com.caucho.quercus.expr.AbstractVarExpr;
import com.caucho.quercus.expr.Expr;
import com.caucho.quercus.expr.ExprFactory;
import com.caucho.quercus.expr.ThisExpr;
import com.caucho.quercus.parser.QuercusParser;
import com.caucho.quercus.program.ClassField;
import java.io.IOException;
import java.util.ArrayList;

public class ThisFieldExpr
extends AbstractVarExpr {
    protected final ThisExpr _qThis;
    protected StringValue _name;
    protected boolean _isInit;

    public ThisFieldExpr(Location location, ThisExpr qThis, StringValue name) {
        super(location);
        this._qThis = qThis;
        this._name = name;
    }

    @Override
    public Expr createCall(QuercusParser parser, Location location, ArrayList<Expr> args) throws IOException {
        ExprFactory factory = parser.getExprFactory();
        return factory.createThisMethod(location, this._qThis, this._name, args);
    }

    public void init() {
        if (!this._isInit) {
            this._isInit = true;
            ClassField entry = this._qThis.getClassDef().getField(this._name);
            if (entry != null) {
                this._name = entry.getCanonicalName();
            }
        }
    }

    @Override
    public Value eval(Env env) {
        this.init();
        Value obj = env.getThis();
        if (obj.isNull()) {
            return env.thisError(this.getLocation());
        }
        return obj.getThisField(env, this._name);
    }

    @Override
    public Value evalCopy(Env env) {
        this.init();
        Value obj = env.getThis();
        if (obj.isNull()) {
            return env.thisError(this.getLocation());
        }
        return obj.getThisField(env, this._name).copy();
    }

    @Override
    public Var evalVar(Env env) {
        this.init();
        Value obj = env.getThis();
        if (obj.isNull()) {
            env.thisError(this.getLocation());
            return new Var();
        }
        return obj.getThisFieldVar(env, this._name);
    }

    @Override
    public Value evalArg(Env env, boolean isTop) {
        this.init();
        Value obj = env.getThis();
        if (obj.isNull()) {
            return env.thisError(this.getLocation());
        }
        return obj.getThisFieldArg(env, this._name);
    }

    @Override
    public Value evalAssignValue(Env env, Value value) {
        this.init();
        Value obj = env.getThis();
        if (obj.isNull()) {
            return env.thisError(this.getLocation());
        }
        obj.putThisField(env, this._name, value);
        return value;
    }

    @Override
    public Value evalAssignRef(Env env, Value value) {
        this.init();
        Value obj = env.getThis();
        if (obj.isNull()) {
            return env.thisError(this.getLocation());
        }
        obj.putThisField(env, this._name, value);
        return value;
    }

    @Override
    public Value evalArrayAssign(Env env, Expr indexExpr, Expr valueExpr) {
        this.init();
        Value obj = env.getThis();
        if (obj.isNull()) {
            return env.thisError(this.getLocation());
        }
        Value fieldVar = obj.getThisFieldArray(env, this._name);
        Value index = indexExpr.eval(env);
        Value value = valueExpr.evalCopy(env);
        return fieldVar.putThisFieldArray(env, obj, this._name, index, value);
    }

    @Override
    public Value evalArrayAssignRef(Env env, Expr indexExpr, Expr valueExpr) {
        this.init();
        Value obj = env.getThis();
        if (obj.isNull()) {
            return env.thisError(this.getLocation());
        }
        Value fieldVar = obj.getThisFieldArray(env, this._name);
        Value index = indexExpr.eval(env);
        Value value = valueExpr.evalRef(env);
        return fieldVar.putThisFieldArray(env, obj, this._name, index, value);
    }

    @Override
    public Value evalArray(Env env) {
        this.init();
        Value obj = env.getThis();
        if (obj.isNull()) {
            return env.thisError(this.getLocation());
        }
        return obj.getThisFieldArray(env, this._name);
    }

    @Override
    public Value evalObject(Env env) {
        this.init();
        Value obj = env.getThis();
        if (obj.isNull()) {
            return env.thisError(this.getLocation());
        }
        return obj.getThisFieldObject(env, this._name);
    }

    @Override
    public void evalUnset(Env env) {
        this.init();
        Value obj = env.getThis();
        if (obj.isNull()) {
            env.thisError(this.getLocation());
        }
        obj.unsetThisField(this._name);
    }

    @Override
    public String toString() {
        return "$this->" + this._name;
    }
}

