/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.quercus.expr;

import com.caucho.quercus.Location;
import com.caucho.quercus.env.Env;
import com.caucho.quercus.env.StringValue;
import com.caucho.quercus.env.Value;
import com.caucho.quercus.expr.Expr;
import com.caucho.quercus.expr.ObjectMethodExpr;
import com.caucho.quercus.expr.ThisExpr;
import com.caucho.quercus.function.AbstractFunction;
import com.caucho.quercus.program.InterpretedClassDef;
import java.util.ArrayList;

public class ThisMethodExpr
extends ObjectMethodExpr {
    protected final InterpretedClassDef _classDef;
    protected final int _hashCodeInsensitive;
    protected boolean _isInit;
    protected AbstractFunction _fun;

    public ThisMethodExpr(Location location, ThisExpr qThis, StringValue methodName, ArrayList<Expr> args) {
        super(location, qThis, methodName, args);
        this._classDef = qThis.getClassDef();
        this._hashCodeInsensitive = methodName.hashCodeCaseInsensitive();
    }

    @Override
    public Value eval(Env env) {
        if (!this._isInit) {
            this.init();
        }
        Value qThis = this._objExpr.eval(env);
        if (this._fun != null) {
            return this.evalPrivate(env, this._fun, qThis, this._args);
        }
        return this.evalImpl(env, qThis, this._methodName, this._hashCodeInsensitive, this._args);
    }

    protected void init() {
        this._isInit = true;
        AbstractFunction fun = this._classDef.getFunction(this._methodName);
        if (fun != null && fun.isPrivate()) {
            this._fun = fun;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Value evalPrivate(Env env, AbstractFunction fun, Value qThis, Expr[] argExprs) {
        Value[] args = ThisMethodExpr.evalArgs(env, argExprs);
        env.pushCall(this, qThis, args);
        try {
            env.checkTimeout();
            Value value = fun.callMethod(env, qThis.getQuercusClass(), qThis, args);
            return value;
        }
        finally {
            env.popCall();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Value evalImpl(Env env, Value qThis, StringValue methodName, int hashCode, Expr[] argExprs) {
        Value[] args = ThisMethodExpr.evalArgs(env, argExprs);
        env.pushCall(this, qThis, args);
        try {
            env.checkTimeout();
            Value value = qThis.callMethod(env, methodName, hashCode, args);
            return value;
        }
        finally {
            env.popCall();
        }
    }

    @Override
    public String toString() {
        return "$this->$" + this._methodName + "()";
    }
}

