/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.quercus.expr;

import com.caucho.quercus.Location;
import com.caucho.quercus.env.Env;
import com.caucho.quercus.env.StringValue;
import com.caucho.quercus.env.Value;
import com.caucho.quercus.env.Var;
import com.caucho.quercus.expr.AbstractVarExpr;
import com.caucho.quercus.expr.Expr;
import com.caucho.quercus.expr.VarInfo;
import com.caucho.quercus.expr.VarState;
import com.caucho.quercus.parser.QuercusParser;

public class VarExpr
extends AbstractVarExpr {
    private final VarInfo _var;
    protected final StringValue _name;
    private VarState _varState = VarState.INIT;

    protected VarExpr(Location location, VarInfo var) {
        super(location);
        this._var = var;
        this._name = var.getName();
    }

    protected VarExpr(VarInfo var) {
        this._var = var;
        this._name = var.getName();
    }

    public VarInfo getVarInfo() {
        return this._var;
    }

    public StringValue getName() {
        return this._name;
    }

    public String getJavaVar() {
        return "v_" + this._name;
    }

    public Expr copy(Location location) {
        return new VarExpr(location, this._var);
    }

    @Override
    public Expr createAssign(QuercusParser parser, Expr value) {
        return super.createAssign(parser, value);
    }

    @Override
    public void assign(QuercusParser parser) {
    }

    @Override
    public Expr createAssignRef(QuercusParser parser, Expr value) {
        return super.createAssignRef(parser, value);
    }

    @Override
    public Value eval(Env env) {
        return env.getValue(this._name, false, true);
    }

    @Override
    public Value evalTop(Env env) {
        return env.getValue(this._name, false, false);
    }

    @Override
    public boolean evalIsset(Env env) {
        return env.getValue(this._name, false, false).isset();
    }

    @Override
    public Value evalIssetValue(Env env) {
        return env.getValue(this._name, false, false);
    }

    @Override
    public Value evalCopy(Env env) {
        return this.eval(env).copy();
    }

    @Override
    public Value evalArray(Env env) {
        Value value = env.getVar(this._name);
        value = ((Value)value).toAutoArray();
        return value;
    }

    @Override
    public Value evalObject(Env env) {
        Value value = env.getValue(this._name);
        if (value == null || value.isString() || value.isNull()) {
            value = env.createObject();
            env.setValue(this._name, value);
        }
        return value;
    }

    @Override
    public Var evalVar(Env env) {
        return env.getVar(this._name);
    }

    @Override
    public Value evalArg(Env env, boolean isTop) {
        return env.getVar(this._name);
    }

    @Override
    public Value evalAssignValue(Env env, Value value) {
        env.setValue(this._name, value);
        return value;
    }

    @Override
    public Value evalAssignRef(Env env, Value value) {
        env.setRef(this._name, value);
        return value;
    }

    @Override
    public void evalUnset(Env env) {
        env.unsetLocalVar(this._name);
    }

    public int hashCode() {
        return this._name.hashCode();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (this.getClass() != o.getClass()) {
            return false;
        }
        VarExpr var = (VarExpr)o;
        return this._var == var._var;
    }

    @Override
    public String toString() {
        return "$" + this._name;
    }
}

