/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.quercus.lib;

import com.caucho.quercus.annotation.Optional;
import com.caucho.quercus.env.ArrayValue;
import com.caucho.quercus.env.ArrayValueImpl;
import com.caucho.quercus.env.BooleanValue;
import com.caucho.quercus.env.Env;
import com.caucho.quercus.env.StringValue;
import com.caucho.quercus.env.Value;
import com.caucho.quercus.module.AbstractQuercusModule;
import com.caucho.util.L10N;
import com.caucho.vfs.Path;
import com.caucho.vfs.ReadStream;
import com.caucho.vfs.TempBuffer;
import java.io.IOException;
import java.io.InputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.Security;
import java.util.Collection;
import java.util.HashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.zip.Adler32;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;

public class HashModule
extends AbstractQuercusModule {
    private static final L10N L = new L10N(HashModule.class);
    private static final Logger log = Logger.getLogger(HashModule.class.getName());
    public static final int HASH_HMAC = 1;
    private static HashMap<String, String> _algorithmMap = new HashMap();
    private static HashMap<String, String> _hmacAlgorithmMap = new HashMap();

    @Override
    public String[] getLoadedExtensions() {
        return new String[]{"hash"};
    }

    public Value hash(Env env, String algorithm, StringValue string, @Optional boolean isBinary) {
        try {
            algorithm = HashModule.getAlgorithm(algorithm);
            MessageDigest digest = "ADLER32".equals(algorithm) ? new Adler32MessageDigest() : MessageDigest.getInstance(algorithm);
            int len = string.length();
            for (int i = 0; i < len; ++i) {
                digest.update((byte)string.charAt(i));
            }
            byte[] bytes = digest.digest();
            return HashModule.hashToValue(env, bytes, isBinary);
        }
        catch (NoSuchAlgorithmException e) {
            env.error(L.l("'{0}' is an unknown algorithm", (Object)algorithm), e);
            return BooleanValue.FALSE;
        }
    }

    public static Value hash_algos(Env env) {
        ArrayValueImpl array = new ArrayValueImpl();
        for (String name : _algorithmMap.keySet()) {
            ((ArrayValue)array).put(env.createString(name));
        }
        Collection<String> values = _algorithmMap.values();
        for (String name : Security.getAlgorithms("MessageDigest")) {
            if (values.contains(name)) continue;
            ((ArrayValue)array).put(env.createString(name));
        }
        return array;
    }

    public HashContext hash_copy(HashContext context) {
        if (context != null) {
            return context.copy();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Value hash_file(Env env, String algorithm, Path path, @Optional boolean isBinary) {
        Value value;
        algorithm = HashModule.getAlgorithm(algorithm);
        MessageDigest digest = MessageDigest.getInstance(algorithm);
        TempBuffer tempBuffer = TempBuffer.allocate();
        byte[] buffer = tempBuffer.getBuffer();
        ReadStream is = path.openRead();
        try {
            int len;
            while ((len = is.read(buffer, 0, buffer.length)) > 0) {
                digest.update(buffer, 0, len);
            }
            byte[] bytes = digest.digest();
            value = HashModule.hashToValue(env, bytes, isBinary);
        }
        catch (Throwable throwable) {
            try {
                TempBuffer.free(tempBuffer);
                is.close();
                throw throwable;
            }
            catch (NoSuchAlgorithmException e) {
                env.error(L.l("'{0}' is an unknown algorithm", (Object)algorithm), e);
                return BooleanValue.FALSE;
            }
            catch (IOException e) {
                env.error(L.l("'{0}' is an unknown file", (Object)path), e);
                return BooleanValue.FALSE;
            }
        }
        TempBuffer.free(tempBuffer);
        is.close();
        return value;
    }

    public Value hash_final(Env env, HashContext context, @Optional boolean isBinary) {
        if (context == null) {
            return BooleanValue.FALSE;
        }
        return HashModule.hashToValue(env, context.digest(), isBinary);
    }

    public Value hash_hmac(Env env, String algorithm, StringValue data, StringValue key, @Optional boolean isBinary) {
        HashContext context = this.hash_init(env, algorithm, 1, key);
        this.hash_update(env, context, data);
        return this.hash_final(env, context, isBinary);
    }

    public Value hash_hmac_file(Env env, String algorithm, Path path, StringValue key, @Optional boolean isBinary) {
        HashContext context = this.hash_init(env, algorithm, 1, key);
        this.hash_update_file(env, context, path);
        return this.hash_final(env, context, isBinary);
    }

    public HashContext hash_init(Env env, String algorithm, @Optional int options, @Optional StringValue keyString) {
        try {
            if (options == 1) {
                algorithm = HashModule.getHmacAlgorithm(algorithm);
                Mac mac = Mac.getInstance(algorithm);
                int keySize = 64;
                if (keyString != null) {
                    keySize = keyString.length();
                }
                byte[] keyBytes = new byte[keySize];
                for (int i = 0; i < keyString.length(); ++i) {
                    keyBytes[i] = (byte)keyString.charAt(i);
                }
                SecretKeySpec key = new SecretKeySpec(keyBytes, "dsa");
                mac.init(key);
                return new HashMacContext(mac);
            }
            algorithm = HashModule.getAlgorithm(algorithm);
            MessageDigest md = MessageDigest.getInstance(algorithm);
            return new HashDigestContext(md);
        }
        catch (Exception e) {
            env.error(L.l("hash_init: '{0}' is an unknown algorithm", (Object)algorithm));
            return null;
        }
    }

    public Value hash_update(Env env, HashContext context, StringValue value) {
        if (context == null) {
            return BooleanValue.FALSE;
        }
        context.update(value);
        return BooleanValue.TRUE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Value hash_update_file(Env env, HashContext context, Path path) {
        if (context == null) {
            return BooleanValue.FALSE;
        }
        TempBuffer tempBuffer = TempBuffer.allocate();
        byte[] buffer = tempBuffer.getBuffer();
        ReadStream is = null;
        try {
            int len;
            is = path.openRead();
            while ((len = is.read(buffer, 0, buffer.length)) > 0) {
                context.update(buffer, 0, len);
            }
        }
        catch (IOException e) {
            log.log(Level.WARNING, e.toString(), e);
        }
        finally {
            TempBuffer.free(tempBuffer);
            if (is != null) {
                is.close();
            }
        }
        return BooleanValue.TRUE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int hash_update_stream(Env env, HashContext context, InputStream is, @Optional(value="-1") int length) {
        if (context == null) {
            return -1;
        }
        if (length < 0) {
            length = 0x7FFFFFFE;
        }
        TempBuffer tempBuffer = TempBuffer.allocate();
        byte[] buffer = tempBuffer.getBuffer();
        int readLength = 0;
        try {
            while (length > 0) {
                int len;
                int sublen = buffer.length;
                if (length < sublen) {
                    sublen = length;
                }
                if ((len = is.read(buffer, 0, sublen)) < 0) {
                    int n = readLength;
                    return n;
                }
                context.update(buffer, 0, len);
                readLength += len;
                length -= len;
            }
        }
        catch (IOException e) {
            log.log(Level.WARNING, e.toString(), e);
        }
        finally {
            TempBuffer.free(tempBuffer);
        }
        return readLength;
    }

    private static Value hashToValue(Env env, byte[] bytes, boolean isBinary) {
        if (isBinary) {
            StringValue v = env.createBinaryBuilder();
            v.append(bytes, 0, bytes.length);
            return v;
        }
        StringValue v = env.createUnicodeBuilder();
        for (int i = 0; i < bytes.length; ++i) {
            byte ch = bytes[i];
            int d1 = ch >> 4 & 0xF;
            int d2 = ch & 0xF;
            if (d1 < 10) {
                v.append((char)(48 + d1));
            } else {
                v.append((char)(97 + d1 - 10));
            }
            if (d2 < 10) {
                v.append((char)(48 + d2));
                continue;
            }
            v.append((char)(97 + d2 - 10));
        }
        return v;
    }

    private static String getAlgorithm(String algorithm) {
        String name = _algorithmMap.get(algorithm);
        if (name != null) {
            return name;
        }
        return algorithm;
    }

    private static String getHmacAlgorithm(String algorithm) {
        String name = _hmacAlgorithmMap.get(algorithm);
        if (name != null) {
            return name;
        }
        return algorithm;
    }

    static {
        _algorithmMap.put("md2", "MD2");
        _algorithmMap.put("md5", "MD5");
        _algorithmMap.put("sha1", "SHA");
        _algorithmMap.put("sha256", "SHA-256");
        _algorithmMap.put("sha384", "SHA-384");
        _algorithmMap.put("sha512", "SHA-512");
        _algorithmMap.put("adler32", "ADLER32");
        _hmacAlgorithmMap.put("md5", "HmacMD5");
        _hmacAlgorithmMap.put("sha1", "HmacSHA1");
        _hmacAlgorithmMap.put("sha256", "HmacSHA256");
        _hmacAlgorithmMap.put("sha384", "HmacSHA384");
        _hmacAlgorithmMap.put("sha512", "HmacSHA512");
    }

    static class Adler32MessageDigest
    extends MessageDigest {
        private Adler32 _adler = new Adler32();

        public Adler32MessageDigest() {
            super("ADLER32");
        }

        @Override
        public void engineUpdate(byte b) {
            this._adler.update(b);
        }

        @Override
        public void engineUpdate(byte[] bytes, int offset, int length) {
            this._adler.update(bytes, offset, length);
        }

        @Override
        protected byte[] engineDigest() {
            long value = this._adler.getValue();
            byte[] bytes = new byte[]{(byte)(value >>> 24), (byte)(value >>> 16), (byte)(value >>> 8), (byte)value};
            return bytes;
        }

        @Override
        protected void engineReset() {
            this._adler.reset();
        }
    }

    public static class HashMacContext
    extends HashContext {
        private Mac _digest;

        HashMacContext(Mac digest) {
            this._digest = digest;
        }

        void update(byte value) {
            this._digest.update(value);
        }

        @Override
        void update(StringValue value) {
            int sublen;
            int len = value.length();
            Mac digest = this._digest;
            TempBuffer tBuf = TempBuffer.allocate();
            byte[] buffer = tBuf.getBuffer();
            for (int offset = 0; offset < len; offset += sublen) {
                sublen = len - offset;
                if (buffer.length < sublen) {
                    sublen = buffer.length;
                }
                for (int i = 0; i < sublen; ++i) {
                    buffer[i] = (byte)value.charAt(offset + i);
                }
                digest.update(buffer, 0, sublen);
            }
            TempBuffer.free(tBuf);
        }

        @Override
        void update(byte[] buffer, int offset, int length) {
            this._digest.update(buffer, offset, length);
        }

        @Override
        byte[] digest() {
            return this._digest.doFinal();
        }

        @Override
        HashContext copy() {
            try {
                return new HashDigestContext((MessageDigest)this._digest.clone());
            }
            catch (Exception e) {
                log.log(Level.FINE, e.toString(), e);
                return null;
            }
        }

        public String toString() {
            return this.getClass().getSimpleName() + "[" + this._digest + "]";
        }
    }

    public static class HashDigestContext
    extends HashContext {
        private MessageDigest _digest;

        HashDigestContext(MessageDigest digest) {
            this._digest = digest;
        }

        MessageDigest getDigest() {
            return this._digest;
        }

        void update(byte value) {
            this._digest.update(value);
        }

        @Override
        void update(StringValue value) {
            int len = value.length();
            MessageDigest digest = this._digest;
            for (int i = 0; i < len; ++i) {
                digest.update((byte)value.charAt(i));
            }
        }

        @Override
        void update(byte[] buffer, int offset, int length) {
            this._digest.update(buffer, offset, length);
        }

        @Override
        byte[] digest() {
            return this._digest.digest();
        }

        @Override
        HashContext copy() {
            try {
                return new HashDigestContext((MessageDigest)this._digest.clone());
            }
            catch (Exception e) {
                log.log(Level.FINE, e.toString(), e);
                return null;
            }
        }

        public String toString() {
            return this.getClass().getSimpleName() + "[" + this._digest + "]";
        }
    }

    public static abstract class HashContext {
        abstract void update(StringValue var1);

        abstract void update(byte[] var1, int var2, int var3);

        abstract byte[] digest();

        abstract HashContext copy();
    }
}

