/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.quercus.lib.curl;

import com.caucho.quercus.env.Callable;
import com.caucho.quercus.env.Env;
import com.caucho.quercus.env.Value;
import com.caucho.quercus.lib.curl.CurlResource;
import com.caucho.quercus.lib.curl.MultipartBody;
import com.caucho.quercus.lib.curl.UrlEncodedBody;
import com.caucho.quercus.lib.curl.UserBody;
import com.caucho.quercus.lib.file.BinaryInput;
import java.io.IOException;
import java.io.OutputStream;

public abstract class PostBody {
    private boolean _isValid = true;

    static PostBody create(Env env, CurlResource curl) {
        PostBody post;
        Value data = curl.getPostBody();
        Callable bodyFun = curl.getReadCallback();
        BinaryInput file = curl.getUploadFile();
        long length = curl.getUploadFileSize();
        if (data == null && bodyFun == null) {
            return null;
        }
        if (bodyFun != null) {
            post = new UserBody(env, curl, bodyFun, file, length);
        } else if (data.isArray()) {
            post = new MultipartBody(env, data);
        } else {
            UrlEncodedBody body = new UrlEncodedBody(env, data);
            post = body;
            String contentType = curl.getContentType();
            if (contentType != null) {
                body.setContentType(contentType);
            }
        }
        if (post.isValid()) {
            return post;
        }
        return null;
    }

    public boolean isChunked() {
        return false;
    }

    public void setValid(boolean isValid) {
        this._isValid = isValid;
    }

    public boolean isValid() {
        return true;
    }

    public abstract long getContentLength();

    public abstract String getContentType();

    public abstract void writeTo(Env var1, OutputStream var2) throws IOException;
}

