/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.quercus.lib.db;

import com.caucho.quercus.lib.db.JdbcTableMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Locale;

public class JdbcColumnMetaData {
    private final JdbcTableMetaData _table;
    private final String _name;
    private final int _jdbcType;
    private final int _length;
    private final boolean _isNotNull;
    private final boolean _isUnsigned;
    private final boolean _isZeroFill;
    private boolean _isPrimaryKey;
    private boolean _isIndex;
    private boolean _isUnique;

    public JdbcColumnMetaData(JdbcTableMetaData table, ResultSet rs) throws SQLException {
        this._table = table;
        this._name = rs.getString(4);
        this._jdbcType = rs.getInt(5);
        this._length = rs.getInt(7);
        this._isNotNull = rs.getInt(11) == 0;
        String type = rs.getString(6).toLowerCase(Locale.ENGLISH);
        this._isUnsigned = type.indexOf("unsigned") >= 0;
        this._isZeroFill = type.indexOf("zerofill") >= 0;
    }

    public String getName() {
        return this._name;
    }

    public JdbcTableMetaData getTable() {
        return this._table;
    }

    public int getLength() {
        return this._length;
    }

    public boolean isNotNull() {
        return this._isNotNull;
    }

    public boolean isPrimaryKey() {
        return this._isPrimaryKey;
    }

    void setPrimaryKey(boolean isPrimaryKey) {
        this._isPrimaryKey = isPrimaryKey;
    }

    public boolean isIndex() {
        return this._isIndex;
    }

    void setIndex(boolean isIndex) {
        this._isIndex = isIndex;
    }

    public boolean isUnique() {
        return this._isUnique;
    }

    void setUnique(boolean isUnique) {
        this._isUnique = isUnique;
    }

    public int getJdbcType() {
        return this._jdbcType;
    }

    public static boolean isNumeric(int jdbcType) {
        switch (jdbcType) {
            case -7: 
            case -6: 
            case -5: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                return true;
            }
        }
        return false;
    }

    public boolean isNumeric() {
        return JdbcColumnMetaData.isNumeric(this._jdbcType);
    }

    public boolean isFloat() {
        switch (this._jdbcType) {
            case 6: 
            case 7: 
            case 8: {
                return true;
            }
        }
        return false;
    }

    public boolean isUnsigned() {
        return this._isUnsigned;
    }

    public boolean isZeroFill() {
        return this._isZeroFill;
    }

    public static boolean isBlob(int jdbcType) {
        switch (jdbcType) {
            case -4: 
            case -1: 
            case 2004: 
            case 2005: {
                return true;
            }
        }
        return false;
    }

    public boolean isBlob() {
        return JdbcColumnMetaData.isBlob(this._jdbcType);
    }

    public String toString() {
        return "JdbcColumnMetaData[" + this.getName() + "]";
    }
}

