/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.quercus.lib.db;

import com.caucho.quercus.Location;
import com.caucho.quercus.env.Env;
import com.caucho.quercus.env.QuercusLanguageException;
import com.caucho.quercus.env.Value;

public class PDOException
extends QuercusLanguageException {
    private final String _code;
    private final String _message;
    private Location _location;

    public PDOException(Env env, String code, String message) {
        super(env);
        this._code = code;
        this._message = "SQLSTATE[" + code + "]: " + message;
        this._location = env.getLocation();
    }

    public String getCode() {
        return this._code;
    }

    @Override
    public Location getLocation(Env env) {
        return this._location;
    }

    @Override
    public String getMessage() {
        return this._message;
    }

    @Override
    public String getMessage(Env env) {
        return this.getMessage();
    }

    @Override
    public Value toValue(Env env) {
        Value e = env.createException("PDOException", this._code, this._message);
        return e;
    }
}

