/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.quercus.lib.db;

import com.caucho.quercus.UnimplementedException;
import com.caucho.quercus.annotation.NotNull;
import com.caucho.quercus.annotation.Optional;
import com.caucho.quercus.annotation.ReturnNullAsFalse;
import com.caucho.quercus.env.ArrayValue;
import com.caucho.quercus.env.ArrayValueImpl;
import com.caucho.quercus.env.BooleanValue;
import com.caucho.quercus.env.DoubleValue;
import com.caucho.quercus.env.Env;
import com.caucho.quercus.env.LongValue;
import com.caucho.quercus.env.NullValue;
import com.caucho.quercus.env.StringValue;
import com.caucho.quercus.env.UnsetValue;
import com.caucho.quercus.env.Value;
import com.caucho.quercus.lib.db.ColumnType;
import com.caucho.quercus.lib.db.JdbcResultResource;
import com.caucho.quercus.lib.db.Postgres;
import com.caucho.quercus.lib.db.PostgresResult;
import com.caucho.quercus.lib.db.PostgresStatement;
import com.caucho.quercus.module.AbstractQuercusModule;
import com.caucho.util.CharBuffer;
import com.caucho.util.L10N;
import com.caucho.util.Log;
import com.caucho.vfs.Path;
import com.caucho.vfs.ReadStream;
import com.caucho.vfs.WriteStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLWarning;
import java.sql.Statement;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;

public class PostgresModule
extends AbstractQuercusModule {
    private static final Logger log = Log.open(PostgresModule.class);
    private static final L10N L = new L10N(PostgresModule.class);
    public static final int PGSQL_ASSOC = 1;
    public static final int PGSQL_NUM = 2;
    public static final int PGSQL_BOTH = 3;
    public static final int PGSQL_CONNECT_FORCE_NEW = 4;
    public static final int PGSQL_CONNECTION_BAD = 5;
    public static final int PGSQL_CONNECTION_OK = 6;
    public static final int PGSQL_SEEK_SET = 7;
    public static final int PGSQL_SEEK_CUR = 8;
    public static final int PGSQL_SEEK_END = 9;
    public static final int PGSQL_EMPTY_QUERY = 10;
    public static final int PGSQL_COMMAND_OK = 11;
    public static final int PGSQL_TUPLES_OK = 12;
    public static final int PGSQL_COPY_OUT = 13;
    public static final int PGSQL_COPY_IN = 14;
    public static final int PGSQL_BAD_RESPONSE = 15;
    public static final int PGSQL_NONFATAL_ERROR = 16;
    public static final int PGSQL_FATAL_ERROR = 17;
    public static final int PGSQL_TRANSACTION_IDLE = 18;
    public static final int PGSQL_TRANSACTION_ACTIVE = 19;
    public static final int PGSQL_TRANSACTION_INTRANS = 20;
    public static final int PGSQL_TRANSACTION_INERROR = 21;
    public static final int PGSQL_TRANSACTION_UNKNOWN = 22;
    public static final int PGSQL_DIAG_SEVERITY = 23;
    public static final int PGSQL_DIAG_SQLSTATE = 24;
    public static final int PGSQL_DIAG_MESSAGE_PRIMARY = 25;
    public static final int PGSQL_DIAG_MESSAGE_DETAIL = 32;
    public static final int PGSQL_DIAG_MESSAGE_HINT = 33;
    public static final int PGSQL_DIAG_STATEMENT_POSITION = 34;
    public static final int PGSQL_DIAG_INTERNAL_POSITION = 35;
    public static final int PGSQL_DIAG_INTERNAL_QUERY = 36;
    public static final int PGSQL_DIAG_CONTEXT = 37;
    public static final int PGSQL_DIAG_SOURCE_FILE = 38;
    public static final int PGSQL_DIAG_SOURCE_LINE = 39;
    public static final int PGSQL_DIAG_SOURCE_FUNCTION = 40;
    public static final int PGSQL_ERRORS_TERSE = 41;
    public static final int PGSQL_ERRORS_DEFAULT = 42;
    public static final int PGSQL_ERRORS_VERBOSE = 43;
    public static final int PGSQL_STATUS_LONG = 44;
    public static final int PGSQL_STATUS_STRING = 45;
    public static final int PGSQL_CONV_IGNORE_DEFAULT = 46;
    public static final int PGSQL_CONV_FORCE_NULL = 47;

    @Override
    public String[] getLoadedExtensions() {
        return new String[]{"postgres", "pgsql"};
    }

    public static int pg_affected_rows(Env env, @NotNull PostgresResult result) {
        try {
            if (result == null) {
                return -1;
            }
            return result.getAffectedRows();
        }
        catch (Exception ex) {
            log.log(Level.FINE, ex.toString(), ex);
            return 0;
        }
    }

    public static int pg_cmdtuples(Env env, @NotNull PostgresResult result) {
        if (result == null) {
            return -1;
        }
        return PostgresModule.pg_affected_rows(env, result);
    }

    public static boolean pg_cancel_query(Env env, @NotNull Postgres conn) {
        try {
            if (conn == null) {
                return false;
            }
            conn.setAsynchronousStatement(null);
            conn.setAsynchronousResult(null);
            return true;
        }
        catch (Exception ex) {
            log.log(Level.FINE, ex.toString(), ex);
            return false;
        }
    }

    @ReturnNullAsFalse
    public static String pg_client_encoding(Env env, @Optional Postgres conn) {
        try {
            if (conn == null) {
                conn = PostgresModule.getConnection(env);
            }
            return conn.getClientEncoding();
        }
        catch (Exception ex) {
            log.log(Level.FINE, ex.toString(), ex);
            return null;
        }
    }

    public static boolean pg_close(Env env, @Optional Postgres conn) {
        try {
            if (conn == null) {
                return false;
            }
            if (conn == env.getSpecialValue("caucho.postgres")) {
                env.removeSpecialValue("caucho.postgres");
            }
            conn.close();
            return true;
        }
        catch (Exception ex) {
            log.log(Level.FINE, ex.toString(), ex);
            return false;
        }
    }

    @ReturnNullAsFalse
    public static Postgres pg_connect(Env env, String connectionString, @Optional int connectionType) {
        try {
            String url;
            String driver;
            Postgres postgres;
            String host = "localhost";
            int port = 5432;
            String dbName = "";
            String userName = "";
            String password = "";
            HashMap<String, String> nameValueMap = PostgresModule.parseConnectionString(connectionString);
            String value = nameValueMap.get("host");
            if (value != null) {
                host = nameValueMap.get("host");
            }
            if ((value = nameValueMap.get("port")) != null) {
                char ch;
                port = 0;
                int len = value.length();
                for (int i = 0; i < len && '0' <= (ch = value.charAt(i)) && ch <= '9'; ++i) {
                    port = port * 10 + value.charAt(i) - 48;
                }
            }
            if ((value = nameValueMap.get("dbname")) != null) {
                dbName = value;
            }
            if ((value = nameValueMap.get("user")) != null) {
                userName = value;
            }
            if ((value = nameValueMap.get("password")) != null) {
                password = value;
            }
            if (!(postgres = new Postgres(env, host, userName, password, dbName, port, driver = "org.postgresql.Driver", url = "jdbc:postgresql://" + host + ":" + port + "/" + dbName)).isConnected()) {
                return null;
            }
            env.setSpecialValue("caucho.postgres", postgres);
            return postgres;
        }
        catch (Exception ex) {
            log.log(Level.FINE, ex.toString(), ex);
            return null;
        }
    }

    private static HashMap<String, String> parseConnectionString(String s) {
        HashMap<String, String> map = new HashMap<String, String>();
        int len = s.length();
        int i = 0;
        CharBuffer buffer = new CharBuffer();
        while (i < len) {
            char ch;
            buffer.clear();
            while (i < len && Character.isWhitespace(ch = s.charAt(i))) {
                ++i;
            }
            while (i < len && !Character.isWhitespace(ch = s.charAt(i)) && ch != '=') {
                buffer.append(ch);
                ++i;
            }
            String name = buffer.toString();
            buffer.clear();
            while (i < len && (ch = s.charAt(i++)) != '=') {
            }
            while (i < len && Character.isWhitespace(ch = s.charAt(i))) {
                ++i;
            }
            boolean isQuoted = false;
            if (i < len) {
                if ((ch = s.charAt(i++)) == '\'') {
                    isQuoted = true;
                } else {
                    buffer.append(ch);
                }
            }
            boolean isEscaped = false;
            block10: while (i < len) {
                ch = s.charAt(i++);
                switch (ch) {
                    case '\\': {
                        if (isEscaped) {
                            buffer.append(ch);
                        }
                        isEscaped = !isEscaped;
                        continue block10;
                    }
                    case '\'': {
                        if (isEscaped) {
                            buffer.append(ch);
                            isEscaped = false;
                            continue block10;
                        }
                        if (isQuoted) break block10;
                    }
                    case '\t': 
                    case '\n': 
                    case '\f': 
                    case '\r': 
                    case ' ': {
                        if (isQuoted) {
                            buffer.append(ch);
                            continue block10;
                        }
                        if (!isEscaped) break block10;
                        buffer.append('\\');
                        break block10;
                    }
                    default: {
                        if (isEscaped) {
                            buffer.append('\\');
                            isEscaped = false;
                        }
                        buffer.append(ch);
                        continue block10;
                    }
                }
            }
            String value = buffer.toString();
            if (name.length() <= 0) continue;
            map.put(name, value);
        }
        return map;
    }

    public static boolean pg_connection_busy(Env env, @NotNull Postgres conn) {
        return false;
    }

    public static boolean pg_connection_reset(Env env, @NotNull Postgres conn) {
        try {
            if (conn == null) {
                return false;
            }
            String dbname = conn.getDbName();
            conn.close();
            conn = new Postgres(env, conn.getHost(), conn.getUserName(), conn.getPassword(), dbname, conn.getPort(), conn.getDriver(), conn.getUrl());
            env.setSpecialValue("caucho.postgres", conn);
            return true;
        }
        catch (Exception ex) {
            log.log(Level.FINE, ex.toString(), ex);
            return false;
        }
    }

    public static int pg_connection_status(Env env, @NotNull Postgres conn) {
        try {
            if (conn == null) {
                return 5;
            }
            boolean ping = PostgresModule.pg_ping(env, conn);
            return ping ? 6 : 5;
        }
        catch (Exception ex) {
            log.log(Level.FINE, ex.toString(), ex);
            return 5;
        }
    }

    @ReturnNullAsFalse
    public static ArrayValue pg_convert(Env env, @NotNull Postgres conn, String tableName, ArrayValue assocArray, @Optional(value="0") int options) {
        try {
            if (conn == null) {
                return null;
            }
            if (options > 0) {
                throw new UnimplementedException("pg_convert with options");
            }
            Connection jdbcConn = conn.getJavaConnection(env);
            DatabaseMetaData dbMetaData = jdbcConn.getMetaData();
            ResultSet rs = dbMetaData.getColumns("", "", tableName, "");
            ResultSetMetaData rsMetaData = rs.getMetaData();
            int n = rsMetaData.getColumnCount();
            if (n < assocArray.getSize()) {
                return null;
            }
            ArrayValueImpl newArray = new ArrayValueImpl();
            int matches = 0;
            while (rs.next()) {
                String columnName = rs.getString("COLUMN_NAME");
                Value columnNameV = StringValue.create(columnName);
                Value value = assocArray.get(columnNameV);
                if (value == UnsetValue.UNSET) continue;
                ++matches;
                if (value.isNull()) {
                    value = StringValue.create("NULL");
                    newArray.put(columnNameV, value);
                    continue;
                }
                int dataType = rs.getInt("DATA_TYPE");
                switch (dataType) {
                    case -7: 
                    case -6: 
                    case -5: 
                    case 4: 
                    case 5: {
                        if (value.isLongConvertible()) {
                            value = LongValue.create(value.toLong());
                            break;
                        }
                        StringValue sb = env.createUnicodeBuilder();
                        value = sb.append("'").append(value).append("'");
                        break;
                    }
                    case 2: 
                    case 3: 
                    case 6: 
                    case 7: 
                    case 8: {
                        if (value.isDoubleConvertible()) {
                            value = DoubleValue.create(value.toDouble());
                            break;
                        }
                        StringValue sb = env.createUnicodeBuilder();
                        value = sb.append("'").append(value).append("'");
                        break;
                    }
                    default: {
                        StringValue sb = env.createUnicodeBuilder();
                        value = value.isNumberConvertible() ? sb.append(value) : sb.append("'").append(value).append("'");
                    }
                }
                newArray.put(columnNameV, value);
            }
            rs.close();
            if (matches < assocArray.getSize()) {
                return null;
            }
            return newArray;
        }
        catch (Exception ex) {
            log.log(Level.FINE, ex.toString(), ex);
            return null;
        }
    }

    public static boolean pg_copy_from(Env env, @NotNull Postgres conn, String tableName, ArrayValue rows, @Optional(value="") String delimiter, @Optional(value="") String nullAs) {
        try {
            if (conn == null) {
                return false;
            }
            if (!delimiter.equals("")) {
                throw new UnimplementedException("pg_copy_from with non-default delimiter");
            }
            delimiter = "\t";
            String delimiterRegex = "\\t";
            if (!nullAs.equals("")) {
                throw new UnimplementedException("pg_copy_from with non-default nullAs");
            }
            nullAs = "\\N";
            ArrayValueImpl array = (ArrayValueImpl)rows;
            int size = array.size();
            String baseInsert = "INSERT INTO " + tableName + " VALUES(";
            StringBuilder sb = new StringBuilder(baseInsert);
            int lenBaseInsert = sb.length();
            for (int i = 0; i < size; ++i) {
                String line = array.get(LongValue.create(i)).toString();
                line = line.substring(0, line.length() - 1);
                sb.setLength(lenBaseInsert);
                String[] cols = line.split(delimiterRegex);
                int len = cols.length;
                if (len <= 0) continue;
                --len;
                for (int j = 0; j < len; ++j) {
                    if (cols[j].equals(nullAs)) {
                        sb.append("NULL, ");
                        continue;
                    }
                    sb.append("'");
                    sb.append(cols[j]);
                    sb.append("', ");
                }
                if (cols[len].equals(nullAs)) {
                    sb.append("NULL)");
                } else {
                    sb.append("'");
                    sb.append(cols[len]);
                    sb.append("')");
                }
                PostgresModule.pg_query(env, conn, sb.toString());
            }
            return true;
        }
        catch (Exception ex) {
            log.log(Level.FINE, ex.toString(), ex);
            return false;
        }
    }

    @ReturnNullAsFalse
    public static ArrayValue pg_copy_to(Env env, @NotNull Postgres conn, String tableName, @Optional(value="") String delimiter, @Optional(value="") String nullAs) {
        try {
            Value value;
            if (conn == null) {
                return null;
            }
            if (delimiter.equals("")) {
                delimiter = "\t";
            }
            if (nullAs.equals("")) {
                nullAs = "\\N";
            }
            PostgresResult result = PostgresModule.pg_query(env, conn, "SELECT * FROM " + tableName);
            ArrayValueImpl newArray = new ArrayValueImpl();
            int curr = 0;
            while ((value = result.fetchArray(env, 2)).isArray()) {
                ArrayValue arr = value.toArrayValue(env);
                int count = arr.getSize();
                StringValue sb = env.createUnicodeBuilder();
                LongValue currValue = LongValue.create(curr);
                for (int i = 0; i < count; ++i) {
                    Value fieldValue;
                    if (sb.length() > 0) {
                        sb.append(delimiter);
                    }
                    if ((fieldValue = arr.get(LongValue.create(i))) instanceof NullValue) {
                        sb.append(nullAs);
                        continue;
                    }
                    sb.append(fieldValue.toString());
                }
                sb.append("\n");
                newArray.put(currValue, sb);
                ++curr;
            }
            return newArray;
        }
        catch (Exception e) {
            log.log(Level.FINE, e.toString(), e);
            return null;
        }
    }

    @ReturnNullAsFalse
    public static String pg_dbname(Env env, @Optional Postgres conn) {
        try {
            if (conn == null) {
                conn = PostgresModule.getConnection(env);
            }
            return conn.getDbName();
        }
        catch (Exception e) {
            log.log(Level.FINE, e.toString(), e);
            return null;
        }
    }

    public static boolean pg_delete(Env env, @NotNull Postgres conn, String tableName, ArrayValue assocArray, @Optional(value="-1") int options) {
        try {
            if (conn == null) {
                return false;
            }
            if (options > 0) {
                throw new UnimplementedException("pg_delete with options");
            }
            StringBuilder condition = new StringBuilder();
            boolean isFirst = true;
            for (Map.Entry<Value, Value> entry : assocArray.entrySet()) {
                Value k = entry.getKey();
                Value v = entry.getValue();
                if (isFirst) {
                    isFirst = false;
                } else {
                    condition.append(" AND ");
                }
                condition.append(k.toString());
                condition.append("='");
                condition.append(v.toString());
                condition.append("'");
            }
            StringBuilder query = new StringBuilder();
            query.append("DELETE FROM ");
            query.append(tableName);
            query.append(" WHERE ");
            query.append((CharSequence)condition);
            PostgresModule.pg_query(env, conn, query.toString());
            return true;
        }
        catch (Exception ex) {
            log.log(Level.FINE, ex.toString(), ex);
            return false;
        }
    }

    public static boolean pg_end_copy(Env env, @Optional Postgres conn) {
        env.stub("pg_end_copy");
        return false;
    }

    @ReturnNullAsFalse
    public static StringValue pg_escape_bytea(Env env, StringValue data) {
        if (data.length() == 0) {
            return data;
        }
        try {
            Class<?> cl = Class.forName("org.postgresql.util.PGbytea");
            Method method = cl.getDeclaredMethod("toPGString", byte[].class);
            String s = (String)method.invoke(cl, new Object[]{data.toBytes()});
            return Postgres.pgRealEscapeString(env.createString(s));
        }
        catch (Exception ex) {
            log.log(Level.FINE, ex.toString(), ex);
            return null;
        }
    }

    @ReturnNullAsFalse
    public static StringValue pg_escape_bytea(Env env, @NotNull Postgres conn, StringValue data) {
        return PostgresModule.pg_escape_bytea(env, data);
    }

    @ReturnNullAsFalse
    public static StringValue pg_escape_string(Env env, StringValue data) {
        try {
            Postgres conn = PostgresModule.getConnection(env);
            if (conn == null) {
                return null;
            }
            return conn.realEscapeString(data);
        }
        catch (Exception ex) {
            log.log(Level.FINE, ex.toString(), ex);
            return null;
        }
    }

    @ReturnNullAsFalse
    public static PostgresResult pg_execute(Env env, @NotNull Postgres conn, String stmtName, ArrayValue params) {
        try {
            if (conn == null) {
                return null;
            }
            PostgresStatement pstmt = conn.getStatement(stmtName);
            return PostgresModule.executeInternal(env, conn, pstmt, params);
        }
        catch (Exception ex) {
            log.log(Level.FINE, ex.toString(), ex);
            conn.setResultResource(null);
            return null;
        }
    }

    @ReturnNullAsFalse
    public static ArrayValue pg_fetch_all_columns(Env env, @NotNull PostgresResult result, @Optional(value="0") LongValue column) {
        try {
            if (result == null) {
                return null;
            }
            ArrayValueImpl newArray = new ArrayValueImpl();
            int curr = 0;
            Value row = result.fetchRow(env);
            while (row != NullValue.NULL) {
                newArray.put(LongValue.create(curr++), row.get(column));
                row = result.fetchRow(env);
            }
            if (newArray.getSize() > 0) {
                return newArray;
            }
        }
        catch (Exception ex) {
            log.log(Level.FINE, ex.toString(), ex);
        }
        return null;
    }

    @ReturnNullAsFalse
    public static ArrayValue pg_fetch_all(Env env, @NotNull PostgresResult result) {
        try {
            if (result == null) {
                return null;
            }
            ArrayValueImpl newArray = new ArrayValueImpl();
            int curr = 0;
            Value row = result.fetchAssoc(env);
            while (row != NullValue.NULL) {
                newArray.put(LongValue.create(curr++), row);
                row = result.fetchAssoc(env);
            }
            if (newArray.getSize() > 0) {
                return newArray;
            }
        }
        catch (Exception ex) {
            log.log(Level.FINE, ex.toString(), ex);
        }
        return null;
    }

    public static Value pg_fetch_array(Env env, @NotNull PostgresResult result, @Optional(value="-1") Value row, @Optional(value="PGSQL_BOTH") int resultType) {
        try {
            if (result == null) {
                return BooleanValue.FALSE;
            }
            if (row.isNull()) {
                if (result.getPassedNullRow()) {
                    result.setPassedNullRow();
                } else {
                    ResultSet rs = result.getResultSet();
                    rs.previous();
                }
            }
            if (row.isLongConvertible() && row.toInt() >= 0 && !result.seek(env, row.toInt())) {
                env.warning(L.l("Unable to jump to row {0} on PostgreSQL result", row.toInt()));
                return BooleanValue.FALSE;
            }
            return result.fetchArray(env, resultType);
        }
        catch (Exception e) {
            log.log(Level.FINE, e.toString(), e);
            return BooleanValue.FALSE;
        }
    }

    public static Value pg_fetch_assoc(Env env, @NotNull PostgresResult result, @Optional(value="-1") Value row) {
        try {
            if (result == null) {
                return BooleanValue.FALSE;
            }
            if (!row.isNull() && row.toInt() >= 0) {
                result.seek(env, row.toInt());
            }
            return result.fetchAssoc(env);
        }
        catch (Exception e) {
            log.log(Level.FINE, e.toString(), e);
            return null;
        }
    }

    public static Value pg_fetch_object(Env env, @NotNull PostgresResult result, @Optional(value="-1") Value row, @Optional int resultType) {
        try {
            Value resultValue;
            if (result == null) {
                return null;
            }
            if (row != null && !row.equals(NullValue.NULL) && row.toInt() >= 0) {
                result.seek(env, row.toInt());
            }
            if ((resultValue = result.fetchObject(env, null, null)).isNull()) {
                return BooleanValue.FALSE;
            }
            return resultValue;
        }
        catch (Exception ex) {
            log.log(Level.FINE, ex.toString(), ex);
            return BooleanValue.FALSE;
        }
    }

    public static Value pg_fetch_result(Env env, @NotNull PostgresResult result, Value row, @Optional(value="-1") Value fieldNameOrNumber) {
        try {
            if (result == null) {
                return BooleanValue.FALSE;
            }
            int rowNumber = -1;
            if (fieldNameOrNumber.isLongConvertible() && fieldNameOrNumber.toInt() < 0) {
                fieldNameOrNumber = row;
                rowNumber = -1;
            } else {
                rowNumber = row.toInt();
            }
            if (rowNumber >= 0) {
                result.seek(env, rowNumber);
            }
            Value fetchRow = result.fetchRow(env);
            int fieldNumber = result.getColumnNumber(fieldNameOrNumber, 0);
            return fetchRow.get(LongValue.create(fieldNumber));
        }
        catch (Exception ex) {
            log.log(Level.FINE, ex.toString(), ex);
            return BooleanValue.FALSE;
        }
    }

    public static Value pg_result(Env env, @NotNull PostgresResult result, Value row, @Optional(value="-1") Value fieldNameOrNumber) {
        return PostgresModule.pg_fetch_result(env, result, row, fieldNameOrNumber);
    }

    public static Value pg_fetch_row(Env env, @NotNull PostgresResult result, @Optional(value="-1") Value row) {
        try {
            if (result == null) {
                return BooleanValue.FALSE;
            }
            if (row != null && !row.equals(NullValue.NULL) && row.toInt() >= 0) {
                result.seek(env, row.toInt());
            }
            return result.fetchRow(env);
        }
        catch (Exception e) {
            log.log(Level.FINE, e.toString(), e);
            return null;
        }
    }

    @ReturnNullAsFalse
    public static LongValue pg_field_is_null(Env env, @NotNull PostgresResult result, Value row, @Optional(value="-1") Value fieldNameOrNumber) {
        try {
            if (result == null) {
                return null;
            }
            int rowNumber = -1;
            if (fieldNameOrNumber.isLongConvertible() && fieldNameOrNumber.toInt() == -1) {
                fieldNameOrNumber = row;
                rowNumber = -1;
            } else {
                rowNumber = row.toInt();
            }
            if (rowNumber >= 0 && !result.seek(env, rowNumber)) {
                env.warning(L.l("Unable to jump to row {0} on PostgreSQL result", rowNumber));
                return null;
            }
            int fieldNumber = result.getColumnNumber(fieldNameOrNumber, 0);
            Value field = PostgresModule.pg_fetch_result(env, result, LongValue.MINUS_ONE, LongValue.create(fieldNumber));
            if (field == null || field.isNull()) {
                return LongValue.ONE;
            }
            return LongValue.ZERO;
        }
        catch (Exception ex) {
            log.log(Level.FINE, ex.toString(), ex);
            return null;
        }
    }

    @ReturnNullAsFalse
    public static LongValue pg_fieldisnull(Env env, @NotNull PostgresResult result, Value row, @Optional(value="-1") Value fieldNameOrNumber) {
        return PostgresModule.pg_field_is_null(env, result, row, fieldNameOrNumber);
    }

    public static Value pg_field_name(Env env, @NotNull PostgresResult result, int fieldNumber) {
        try {
            if (result == null) {
                return BooleanValue.FALSE;
            }
            return result.getFieldName(env, fieldNumber);
        }
        catch (Exception ex) {
            log.log(Level.FINE, ex.toString(), ex);
            return BooleanValue.FALSE;
        }
    }

    public static Value pg_fieldname(Env env, @NotNull PostgresResult result, int fieldNumber) {
        return PostgresModule.pg_field_name(env, result, fieldNumber);
    }

    public static int pg_field_num(Env env, @NotNull PostgresResult result, String fieldName) {
        try {
            if (result == null) {
                return -1;
            }
            return result.getColumnNumber(fieldName);
        }
        catch (Exception ex) {
            log.log(Level.FINE, ex.toString(), ex);
            return -1;
        }
    }

    public static int pg_fieldnum(Env env, @NotNull PostgresResult result, String fieldName) {
        return PostgresModule.pg_field_num(env, result, fieldName);
    }

    public static int pg_field_prtlen(Env env, @NotNull PostgresResult result, Value rowNumber, @Optional(value="-1") Value fieldNameOrNumber) {
        try {
            if (result == null) {
                return -1;
            }
            int row = rowNumber.toInt();
            if (fieldNameOrNumber.toString().equals("-1")) {
                fieldNameOrNumber = rowNumber;
                row = -1;
            }
            int fieldNumber = result.getColumnNumber(fieldNameOrNumber, 0);
            ResultSetMetaData metaData = result.getMetaData();
            String typeName = metaData.getColumnTypeName(fieldNumber + 1);
            if (typeName.equals("bool")) {
                return 1;
            }
            Value value = PostgresModule.pg_fetch_result(env, result, LongValue.create(row), LongValue.create(fieldNumber));
            result.getResultSet().previous();
            int len = value.toString().length();
            return len;
        }
        catch (Exception ex) {
            log.log(Level.FINE, ex.toString(), ex);
            return -1;
        }
    }

    public static int pg_fieldprtlen(Env env, @NotNull PostgresResult result, Value rowNumber, @Optional(value="-1") Value fieldNameOrNumber) {
        return PostgresModule.pg_field_prtlen(env, result, rowNumber, fieldNameOrNumber);
    }

    @ReturnNullAsFalse
    public static LongValue pg_field_size(Env env, @NotNull PostgresResult result, int fieldNumber) {
        try {
            if (result == null) {
                return LongValue.create(-1L);
            }
            ResultSetMetaData metaData = result.getMetaData();
            int dataType = metaData.getColumnType(++fieldNumber);
            int size = -1;
            switch (dataType) {
                case -7: {
                    String typeName = metaData.getColumnTypeName(fieldNumber);
                    if (!typeName.equals("bool")) break;
                    size = 1;
                    break;
                }
                case -6: {
                    size = 1;
                    break;
                }
                case 5: {
                    size = 2;
                    break;
                }
                case 4: 
                case 6: 
                case 7: 
                case 91: {
                    size = 4;
                    break;
                }
                case -5: 
                case 8: {
                    size = 8;
                    String typeName = metaData.getColumnTypeName(fieldNumber);
                    if (!typeName.equals("money")) break;
                    size = 4;
                    break;
                }
                case 92: 
                case 93: {
                    size = 8;
                }
                default: {
                    String typeName = metaData.getColumnTypeName(fieldNumber);
                    if (typeName.equals("timetz") || typeName.equals("interval")) {
                        size = 12;
                        break;
                    }
                    if (typeName.equals("macaddr")) {
                        size = 6;
                        break;
                    }
                    if (typeName.equals("point")) {
                        size = 16;
                        break;
                    }
                    if (typeName.equals("circle")) {
                        size = 24;
                        break;
                    }
                    if (!typeName.equals("box") && !typeName.equals("lseg")) break;
                    size = 32;
                }
            }
            return LongValue.create(size);
        }
        catch (Exception ex) {
            log.log(Level.FINE, ex.toString(), ex);
            return null;
        }
    }

    @ReturnNullAsFalse
    public static LongValue pg_fieldsize(Env env, @NotNull PostgresResult result, int fieldNumber) {
        return PostgresModule.pg_field_size(env, result, fieldNumber);
    }

    @ReturnNullAsFalse
    public static String pg_field_table(Env env, @NotNull PostgresResult result, int fieldNumber, @Optional(value="false") boolean oidOnly) {
        env.stub("pg_field_table");
        return "";
    }

    @ReturnNullAsFalse
    public static LongValue pg_field_type_oid(Env env, @NotNull PostgresResult result, int fieldNumber) {
        try {
            if (result == null) {
                return null;
            }
            ResultSetMetaData metaData = result.getMetaData();
            String columnTypeName = metaData.getColumnTypeName(fieldNumber + 1);
            String metaQuery = "SELECT oid FROM pg_type WHERE typname='" + columnTypeName + "'";
            Value value = PostgresModule.pg_fetch_result(env, result = PostgresModule.pg_query(env, result.getConnection(), metaQuery), LongValue.MINUS_ONE, LongValue.ZERO);
            if (value.isLongConvertible()) {
                return LongValue.create(value.toLong());
            }
        }
        catch (Exception ex) {
            log.log(Level.FINE, ex.toString(), ex);
        }
        return null;
    }

    @ReturnNullAsFalse
    public static StringValue pg_field_type(Env env, @NotNull PostgresResult result, int fieldNumber) {
        try {
            if (result == null) {
                return null;
            }
            ResultSetMetaData metaData = result.getMetaData();
            String typeName = metaData.getColumnTypeName(++fieldNumber);
            return (StringValue)StringValue.create(typeName);
        }
        catch (Exception ex) {
            log.log(Level.FINE, ex.toString(), ex);
            return null;
        }
    }

    @ReturnNullAsFalse
    public static StringValue pg_fieldtype(Env env, @NotNull PostgresResult result, int fieldNumber) {
        return PostgresModule.pg_field_type(env, result, fieldNumber);
    }

    public static boolean pg_free_result(Env env, PostgresResult result) {
        try {
            if (result == null) {
                return true;
            }
            result.close();
            return true;
        }
        catch (Exception ex) {
            log.log(Level.FINE, ex.toString(), ex);
            return true;
        }
    }

    public static boolean pg_freeresult(Env env, PostgresResult result) {
        if (result == null) {
            return true;
        }
        return PostgresModule.pg_free_result(env, result);
    }

    @ReturnNullAsFalse
    public static ArrayValue pg_get_notify(Env env, @NotNull Postgres conn, @Optional(value="-1") int resultType) {
        try {
            if (conn == null) {
                return null;
            }
            if (resultType > 0) {
                throw new UnimplementedException("pg_get_notify with result type");
            }
            Class<?> cl = Class.forName("org.postgresql.PGConnection");
            Method method = cl.getDeclaredMethod("getNotifications", null);
            Connection pgconn = conn.getJavaConnection(env);
            Object[] notifications = (Object[])method.invoke((Object)pgconn, new Object[0]);
            cl = Class.forName("org.postgresql.PGNotification");
            Method methodGetName = cl.getDeclaredMethod("getName", null);
            Method methodGetPID = cl.getDeclaredMethod("getPID", null);
            ArrayValueImpl arrayValue = new ArrayValueImpl();
            int n = notifications.length;
            for (int i = 0; i < n; ++i) {
                StringValue k = (StringValue)StringValue.create(methodGetName.invoke(notifications[i], new Object[0]));
                LongValue v = LongValue.create((Integer)methodGetPID.invoke(notifications[i], new Object[0]));
                arrayValue.put(k, v);
            }
            return arrayValue;
        }
        catch (Exception ex) {
            log.log(Level.FINE, ex.toString(), ex);
            return null;
        }
    }

    public static int pg_get_pid(Env env, @NotNull Postgres conn) {
        try {
            if (conn == null) {
                return -1;
            }
            String randomLabel = "caucho_pg_get_pid_random_label";
            PostgresModule.pg_query(env, conn, "LISTEN " + randomLabel);
            PostgresModule.pg_query(env, conn, "NOTIFY " + randomLabel);
            ArrayValue arrayValue = PostgresModule.pg_get_notify(env, conn, -1);
            LongValue pid = (LongValue)arrayValue.get(StringValue.create(randomLabel));
            return pid.toInt();
        }
        catch (Exception ex) {
            log.log(Level.FINE, ex.toString(), ex);
            return -1;
        }
    }

    @ReturnNullAsFalse
    public static PostgresResult pg_get_result(Env env, @Optional Postgres conn) {
        try {
            if (conn == null) {
                conn = PostgresModule.getConnection(env);
            }
            PostgresResult result = (PostgresResult)conn.getResultResource();
            if (conn.getAsynchronousStatement() != null) {
                if (conn.getAsynchronousResult() != null) {
                    conn.setAsynchronousResult(null);
                    return result;
                }
                return null;
            }
            if (conn.getAsynchronousResult() != null) {
                Statement stmt = result.getJavaStatement(env);
                if (stmt.getMoreResults()) {
                    result = (PostgresResult)conn.createResult(stmt, stmt.getResultSet());
                } else {
                    conn.setResultResource(null);
                }
            }
            conn.setAsynchronousResult(result);
            return result;
        }
        catch (Exception ex) {
            log.log(Level.FINE, ex.toString(), ex);
            return null;
        }
    }

    @ReturnNullAsFalse
    public static String pg_host(Env env, @Optional Postgres conn) {
        try {
            if (conn == null) {
                conn = PostgresModule.getConnection(env);
            }
            return conn.getHost();
        }
        catch (Exception ex) {
            log.log(Level.FINE, ex.toString(), ex);
            return null;
        }
    }

    public static boolean pg_insert(Env env, @NotNull Postgres conn, String tableName, ArrayValue assocArray, @Optional(value="-1") int options) {
        try {
            if (conn == null) {
                return false;
            }
            if (options > 0) {
                throw new UnimplementedException("pg_insert with options");
            }
            StringBuilder names = new StringBuilder();
            StringBuilder values = new StringBuilder();
            boolean isFirst = true;
            for (Map.Entry<Value, Value> entry : assocArray.entrySet()) {
                Value k = entry.getKey();
                Value v = entry.getValue();
                if (isFirst) {
                    isFirst = false;
                } else {
                    values.append("','");
                    names.append(",");
                }
                values.append(v.toString());
                names.append(k.toString());
            }
            StringBuilder query = new StringBuilder();
            query.append("INSERT INTO ");
            query.append(tableName);
            query.append("(");
            query.append((CharSequence)names);
            query.append(") VALUES('");
            query.append((CharSequence)values);
            query.append("')");
            PostgresModule.pg_query(env, conn, query.toString());
            return true;
        }
        catch (Exception ex) {
            log.log(Level.FINE, ex.toString(), ex);
            return false;
        }
    }

    @ReturnNullAsFalse
    public static StringValue pg_last_error(Env env, @Optional Postgres conn) {
        try {
            if (conn == null) {
                conn = PostgresModule.getConnection(env);
            }
            return conn.error(env);
        }
        catch (Exception ex) {
            log.log(Level.FINE, ex.toString(), ex);
            return null;
        }
    }

    @ReturnNullAsFalse
    public static StringValue pg_errormessage(Env env, @Optional Postgres conn) {
        return PostgresModule.pg_last_error(env, conn);
    }

    @ReturnNullAsFalse
    public static String pg_last_notice(Env env, @NotNull Postgres conn) {
        try {
            if (conn == null) {
                return null;
            }
            SQLWarning warning = conn.getWarnings();
            if (warning != null) {
                return warning.toString();
            }
            return null;
        }
        catch (Exception ex) {
            log.log(Level.FINE, ex.toString(), ex);
            return null;
        }
    }

    @ReturnNullAsFalse
    public static String pg_last_oid(Env env, PostgresResult result) {
        try {
            Statement stmt = result.getJavaStatement(env);
            Class<?> cl = Class.forName("org.postgresql.jdbc2.AbstractJdbc2Statement");
            Method method = cl.getDeclaredMethod("getLastOID", null);
            int oid = Integer.parseInt(method.invoke((Object)stmt, new Object[0]).toString());
            if (oid > 0) {
                return "" + oid;
            }
        }
        catch (Exception ex) {
            log.log(Level.FINE, ex.toString(), ex);
        }
        return null;
    }

    @ReturnNullAsFalse
    public static String pg_getlastoid(Env env, PostgresResult result) {
        return PostgresModule.pg_last_oid(env, result);
    }

    public static boolean pg_lo_close(Env env, Object largeObject) {
        try {
            Class<?> cl = Class.forName("org.postgresql.largeobject.LargeObject");
            Method method = cl.getDeclaredMethod("close", null);
            method.invoke(largeObject, new Object[0]);
            return true;
        }
        catch (Exception ex) {
            log.log(Level.FINE, ex.toString(), ex);
            return false;
        }
    }

    public static boolean pg_loclose(Env env, Object largeObject) {
        return PostgresModule.pg_lo_close(env, largeObject);
    }

    @ReturnNullAsFalse
    public static LongValue pg_lo_create(Env env, @Optional Postgres conn) {
        try {
            int oid = -1;
            if (conn == null) {
                conn = PostgresModule.getConnection(env);
            }
            Class<?> cl = Class.forName("org.postgresql.PGConnection");
            Method method = cl.getDeclaredMethod("getLargeObjectAPI", null);
            Connection pgconn = conn.getJavaConnection(env);
            pgconn.setAutoCommit(false);
            Object lobManager = method.invoke((Object)pgconn, new Object[0]);
            cl = Class.forName("org.postgresql.largeobject.LargeObjectManager");
            method = cl.getDeclaredMethod("create", null);
            Object oidObj = method.invoke(lobManager, new Object[0]);
            oid = Integer.parseInt(oidObj.toString());
            return LongValue.create(oid);
        }
        catch (Exception ex) {
            log.log(Level.FINE, ex.toString(), ex);
            return null;
        }
    }

    @ReturnNullAsFalse
    public static LongValue pg_locreate(Env env, @Optional Postgres conn) {
        return PostgresModule.pg_lo_create(env, conn);
    }

    public static boolean pg_lo_export(Env env, @NotNull Postgres conn, int oid, Path path) {
        try {
            if (conn == null) {
                return false;
            }
            Class<?> cl = Class.forName("org.postgresql.PGConnection");
            Method method = cl.getDeclaredMethod("getLargeObjectAPI", null);
            Connection pgconn = conn.getJavaConnection(env);
            Object lobManager = method.invoke((Object)pgconn, new Object[0]);
            cl = Class.forName("org.postgresql.largeobject.LargeObjectManager");
            method = cl.getDeclaredMethod("open", Integer.TYPE);
            Object lobj = method.invoke(lobManager, oid);
            cl = Class.forName("org.postgresql.largeobject.LargeObject");
            method = cl.getDeclaredMethod("getInputStream", null);
            Object isObj = method.invoke(lobj, new Object[0]);
            InputStream is = (InputStream)isObj;
            WriteStream os = path.openWrite();
            os.writeStream(is);
            os.close();
            is.close();
            method = cl.getDeclaredMethod("close", null);
            method.invoke(lobj, new Object[0]);
            return true;
        }
        catch (Exception ex) {
            log.log(Level.FINE, ex.toString(), ex);
            return false;
        }
    }

    public static boolean pg_loexport(Env env, @NotNull Postgres conn, int oid, Path path) {
        return PostgresModule.pg_lo_export(env, conn, oid, path);
    }

    @ReturnNullAsFalse
    public static LongValue pg_lo_import(Env env, @NotNull Postgres conn, Path path) {
        try {
            if (conn == null) {
                return null;
            }
            LongValue value = PostgresModule.pg_lo_create(env, conn);
            if (value != null) {
                int oid = value.toInt();
                Object largeObject = PostgresModule.pg_lo_open(env, conn, oid, "w");
                ReadStream is = path.openRead();
                PostgresModule.writeLobInternal(largeObject, is, Integer.MAX_VALUE);
                PostgresModule.pg_lo_close(env, largeObject);
                is.close();
                return LongValue.create(oid);
            }
        }
        catch (Exception ex) {
            log.log(Level.FINE, ex.toString(), ex);
        }
        return null;
    }

    @ReturnNullAsFalse
    public static LongValue pg_loimport(Env env, @NotNull Postgres conn, Path path) {
        return PostgresModule.pg_lo_import(env, conn, path);
    }

    @ReturnNullAsFalse
    public static Object pg_lo_open(Env env, @NotNull Postgres conn, int oid, String mode) {
        try {
            if (conn == null) {
                return null;
            }
            Object largeObject = null;
            Class<?> cl = Class.forName("org.postgresql.PGConnection");
            Method method = cl.getDeclaredMethod("getLargeObjectAPI", null);
            Connection pgconn = conn.getJavaConnection(env);
            Object lobManager = method.invoke((Object)pgconn, new Object[0]);
            cl = Class.forName("org.postgresql.largeobject.LargeObjectManager");
            method = cl.getDeclaredMethod("open", Integer.TYPE, Integer.TYPE);
            boolean write = mode.indexOf("w") >= 0;
            boolean read = mode.indexOf("r") >= 0;
            int modeREAD = cl.getDeclaredField("READ").getInt(null);
            int modeREADWRITE = cl.getDeclaredField("READWRITE").getInt(null);
            int modeWRITE = cl.getDeclaredField("WRITE").getInt(null);
            int intMode = modeREAD;
            if (read) {
                if (write) {
                    intMode = modeREADWRITE;
                }
            } else if (write) {
                intMode = modeWRITE;
            }
            largeObject = method.invoke(lobManager, oid, intMode);
            return largeObject;
        }
        catch (Exception ex) {
            env.warning(L.l("Unable to open PostgreSQL large object"));
            log.log(Level.FINE, ex.toString(), ex);
            return null;
        }
    }

    @ReturnNullAsFalse
    public static Object pg_loopen(Env env, @NotNull Postgres conn, int oid, String mode) {
        return PostgresModule.pg_lo_open(env, conn, oid, mode);
    }

    @ReturnNullAsFalse
    public static LongValue pg_lo_read_all(Env env, Object largeObject) {
        try {
            StringValue contents = PostgresModule.pg_lo_read(env, largeObject, -1);
            if (contents != null) {
                env.getOut().print(contents);
            }
        }
        catch (Exception ex) {
            log.log(Level.FINE, ex.toString(), ex);
        }
        return null;
    }

    @ReturnNullAsFalse
    public static LongValue pg_loreadall(Env env, Object largeObject) {
        return PostgresModule.pg_lo_read_all(env, largeObject);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ReturnNullAsFalse
    public static StringValue pg_lo_read(Env env, Object largeObject, @Optional(value="-1") int len) {
        StringValue stringValue;
        if (len < 0) {
            len = Integer.MAX_VALUE;
        }
        Class<?> cl = Class.forName("org.postgresql.largeobject.LargeObject");
        Method method = cl.getDeclaredMethod("getInputStream", null);
        InputStream is = (InputStream)method.invoke(largeObject, new Object[0]);
        try {
            StringValue bb = env.createBinaryBuilder();
            bb.appendReadAll(is, (long)len);
            stringValue = bb;
        }
        catch (Throwable throwable) {
            try {
                is.close();
                throw throwable;
            }
            catch (Exception ex) {
                log.log(Level.FINE, ex.toString(), ex);
                return null;
            }
        }
        is.close();
        return stringValue;
    }

    @ReturnNullAsFalse
    public static StringValue pg_loread(Env env, Object largeObject, @Optional(value="-1") int len) {
        return PostgresModule.pg_lo_read(env, largeObject, len);
    }

    public static boolean pg_lo_seek(Env env, Object largeObject, int offset, @Optional int whence) {
        try {
            Class<?> cl = Class.forName("org.postgresql.largeobject.LargeObject");
            int seekSET = cl.getDeclaredField("SEEK_SET").getInt(null);
            int seekEND = cl.getDeclaredField("SEEK_END").getInt(null);
            int seekCUR = cl.getDeclaredField("SEEK_CUR").getInt(null);
            switch (whence) {
                case 7: {
                    whence = seekSET;
                    break;
                }
                case 9: {
                    whence = seekEND;
                    break;
                }
                default: {
                    whence = seekCUR;
                }
            }
            Method method = cl.getDeclaredMethod("seek", Integer.TYPE, Integer.TYPE);
            method.invoke(largeObject, offset, whence);
            return true;
        }
        catch (Exception ex) {
            log.log(Level.FINE, ex.toString(), ex);
            return false;
        }
    }

    public static int pg_lo_tell(Env env, Object largeObject) {
        try {
            Class<?> cl = Class.forName("org.postgresql.largeobject.LargeObject");
            Method method = cl.getDeclaredMethod("tell", null);
            Object obj = method.invoke(largeObject, new Object[0]);
            return Integer.parseInt(obj.toString());
        }
        catch (Exception ex) {
            log.log(Level.FINE, ex.toString(), ex);
            return -1;
        }
    }

    public static boolean pg_lo_unlink(Env env, @NotNull Postgres conn, int oid) {
        try {
            if (conn == null) {
                return false;
            }
            Class<?> cl = Class.forName("org.postgresql.PGConnection");
            Method method = cl.getDeclaredMethod("getLargeObjectAPI", null);
            Connection pgconn = conn.getJavaConnection(env);
            Object lobManager = method.invoke((Object)pgconn, new Object[0]);
            cl = Class.forName("org.postgresql.largeobject.LargeObjectManager");
            method = cl.getDeclaredMethod("unlink", Integer.TYPE);
            method.invoke(lobManager, oid);
            return true;
        }
        catch (Exception ex) {
            log.log(Level.FINE, ex.toString(), ex);
            return false;
        }
    }

    public static boolean pg_lounlink(Env env, @NotNull Postgres conn, int oid) {
        return PostgresModule.pg_lo_unlink(env, conn, oid);
    }

    @ReturnNullAsFalse
    public static LongValue pg_lo_write(Env env, @NotNull Object largeObject, String data, @Optional int len) {
        try {
            if (largeObject == null) {
                return null;
            }
            if (len <= 0) {
                len = data.length();
            }
            int written = len;
            Class<?> cl = Class.forName("org.postgresql.largeobject.LargeObject");
            Method method = cl.getDeclaredMethod("write", byte[].class, Integer.TYPE, Integer.TYPE);
            method.invoke(largeObject, data.getBytes(), 0, len);
            return LongValue.create(written);
        }
        catch (Exception ex) {
            log.log(Level.FINE, ex.toString(), ex);
            return null;
        }
    }

    @ReturnNullAsFalse
    public static LongValue pg_lowrite(Env env, @NotNull Object largeObject, String data, @Optional int len) {
        return PostgresModule.pg_lo_write(env, largeObject, data, len);
    }

    @ReturnNullAsFalse
    public static ArrayValue pg_meta_data(Env env, @NotNull Postgres conn, String tableName) {
        env.stub("pg_meta_data");
        return null;
    }

    public static int pg_num_fields(Env env, @NotNull PostgresResult result) {
        try {
            return result.getFieldCount();
        }
        catch (Exception ex) {
            log.log(Level.FINE, ex.toString(), ex);
            return -1;
        }
    }

    public static int pg_numfields(Env env, @NotNull PostgresResult result) {
        return PostgresModule.pg_num_fields(env, result);
    }

    public static LongValue pg_num_rows(Env env, @NotNull PostgresResult result) {
        int numRows = -1;
        try {
            if (result == null) {
                return LongValue.create(-1L);
            }
            if (result != null && result.getResultSet() != null) {
                numRows = result.getNumRows();
            }
            if (numRows < 0) {
                env.warning(L.l("supplied argument is not a valid PostgreSQL result resource"));
            }
        }
        catch (Exception ex) {
            log.log(Level.FINE, ex.toString(), ex);
        }
        return LongValue.create(numRows);
    }

    public static LongValue pg_numrows(Env env, @NotNull PostgresResult result) {
        return PostgresModule.pg_num_rows(env, result);
    }

    public static String pg_options(Env env, @Optional Postgres conn) {
        throw new UnimplementedException("pg_options");
    }

    public static Value pg_parameter_status(Env env, @NotNull Postgres conn, @NotNull StringValue paramName) {
        try {
            if (conn == null || paramName == null) {
                return BooleanValue.FALSE;
            }
            PostgresResult result = PostgresModule.pg_query(env, conn, "SHOW " + paramName);
            Value value = PostgresModule.pg_fetch_result(env, result, LongValue.ZERO, LongValue.ZERO);
            if (value == null || value.isNull()) {
                return BooleanValue.FALSE;
            }
            if (paramName.toString().equals("server_encoding") && value.equals(env.createString("UNICODE"))) {
                value = env.createString("UTF8");
            }
            return value;
        }
        catch (Exception ex) {
            log.log(Level.FINE, ex.toString(), ex);
            return BooleanValue.FALSE;
        }
    }

    public static Value pg_parameter_status(Env env, @NotNull StringValue paramName) {
        Postgres conn = PostgresModule.getConnection(env);
        return PostgresModule.pg_parameter_status(env, conn, paramName);
    }

    @ReturnNullAsFalse
    public static Postgres pg_pconnect(Env env, String connectionString, @Optional int connectType) {
        return PostgresModule.pg_connect(env, connectionString, connectType);
    }

    public static boolean pg_ping(Env env, @Optional Postgres conn) {
        try {
            if (conn == null) {
                conn = PostgresModule.getConnection(env);
            }
            return PostgresModule.pg_query(env, conn, "SELECT 1") != null;
        }
        catch (Exception ex) {
            log.log(Level.FINE, ex.toString(), ex);
            return false;
        }
    }

    @ReturnNullAsFalse
    public static StringValue pg_port(Env env, @Optional Postgres conn) {
        try {
            if (conn == null) {
                conn = PostgresModule.getConnection(env);
            }
            return (StringValue)StringValue.create(conn.getPort());
        }
        catch (Exception ex) {
            log.log(Level.FINE, ex.toString(), ex);
            return null;
        }
    }

    @ReturnNullAsFalse
    public static PostgresStatement pg_prepare(Env env, @NotNull Postgres conn, String stmtName, String query) {
        try {
            if (conn == null) {
                return null;
            }
            PostgresStatement pstmt = conn.prepare(env, query);
            conn.putStatement(stmtName, pstmt);
            return pstmt;
        }
        catch (Exception ex) {
            log.log(Level.FINE, ex.toString(), ex);
            return null;
        }
    }

    public static boolean pg_put_line(Env env, @NotNull Postgres conn, String data) {
        try {
            if (conn == null) {
                return false;
            }
            Class<?> cl = Class.forName("org.postgresql.core.PGStream");
            Constructor<?> constructor = cl.getDeclaredConstructor(String.class, Integer.TYPE);
            Object object = constructor.newInstance(conn.getHost(), conn.getPort());
            byte[] dataArray = data.getBytes();
            Method method = cl.getDeclaredMethod("Send", byte[].class);
            method.invoke(object, new Object[]{dataArray});
            return true;
        }
        catch (Exception ex) {
            log.log(Level.FINE, ex.toString(), ex);
            return false;
        }
    }

    @ReturnNullAsFalse
    public static PostgresResult pg_query_params(Env env, @NotNull Postgres conn, String query, ArrayValue params) {
        try {
            if (conn == null) {
                return null;
            }
            if (PostgresModule.pg_send_query_params(env, conn, query, params)) {
                return (PostgresResult)conn.getResultResource();
            }
            return null;
        }
        catch (Exception ex) {
            log.log(Level.FINE, ex.toString(), ex);
            return null;
        }
    }

    @ReturnNullAsFalse
    public static PostgresResult pg_query(Env env, @NotNull String query) {
        if (query == null) {
            return null;
        }
        return PostgresModule.pg_query_impl(env, PostgresModule.getConnection(env), query, true);
    }

    @ReturnNullAsFalse
    public static PostgresResult pg_query(Env env, @NotNull Postgres conn, @NotNull String query) {
        if (conn == null || query == null) {
            return null;
        }
        return PostgresModule.pg_query_impl(env, conn, query, true);
    }

    @ReturnNullAsFalse
    public static PostgresResult pg_exec(Env env, @NotNull Postgres conn, String query) {
        if (conn == null) {
            return null;
        }
        return PostgresModule.pg_query(env, conn, query);
    }

    private static PostgresResult pg_query_impl(Env env, Postgres conn, String query, boolean reportError) {
        try {
            if (conn == null) {
                conn = PostgresModule.getConnection(env);
            }
            PostgresResult result = conn.query(env, query);
            StringValue error = conn.error(env);
            if (error.length() != 0) {
                if (reportError) {
                    env.warning(L.l("Query failed: {0}", (Object)error));
                }
                return null;
            }
            return result;
        }
        catch (Exception ex) {
            log.log(Level.FINE, ex.toString(), ex);
            return null;
        }
    }

    public static Value pg_result_error_field(Env env, @NotNull PostgresResult result, int fieldCode) {
        try {
            Integer position;
            if (result == null) {
                return BooleanValue.FALSE;
            }
            Object errorField = null;
            Object serverError = result.getConnection().getServerErrorMessage();
            if (serverError != null) {
                String methodName;
                Class<?> cl = Class.forName("org.postgresql.util.ServerErrorMessage");
                switch (fieldCode) {
                    case 23: {
                        methodName = "getSeverity";
                        break;
                    }
                    case 24: {
                        methodName = "getSQLState";
                        break;
                    }
                    case 25: {
                        methodName = "getMessage";
                        break;
                    }
                    case 32: {
                        methodName = "getDetail";
                        break;
                    }
                    case 33: {
                        methodName = "getHint";
                        break;
                    }
                    case 34: {
                        methodName = "getPosition";
                        break;
                    }
                    case 35: {
                        methodName = "getInternalPosition";
                        break;
                    }
                    case 36: {
                        methodName = "getInternalQuery";
                        break;
                    }
                    case 37: {
                        methodName = "getWhere";
                        break;
                    }
                    case 38: {
                        methodName = "getFile";
                        break;
                    }
                    case 39: {
                        methodName = "getLine";
                        break;
                    }
                    case 40: {
                        methodName = "getRoutine";
                        break;
                    }
                    default: {
                        return null;
                    }
                }
                Method method = cl.getDeclaredMethod(methodName, null);
                errorField = method.invoke(serverError, new Object[0]);
            }
            if (errorField == null) {
                return NullValue.NULL;
            }
            if (fieldCode == 34 && (position = (Integer)errorField) == 0) {
                return NullValue.NULL;
            }
            if (fieldCode == 35 && (position = (Integer)errorField) == 0) {
                return NullValue.NULL;
            }
            return StringValue.create(errorField.toString());
        }
        catch (Exception ex) {
            log.log(Level.FINE, ex.toString(), ex);
            return NullValue.NULL;
        }
    }

    @ReturnNullAsFalse
    public static String pg_result_error(Env env, @Optional PostgresResult result) {
        try {
            if (result != null) {
                return result.getConnection().getErrorMessage();
            }
            return null;
        }
        catch (Exception ex) {
            log.log(Level.FINE, ex.toString(), ex);
            return null;
        }
    }

    public static boolean pg_result_seek(Env env, @NotNull PostgresResult result, int offset) {
        try {
            if (result == null) {
                return false;
            }
            return result.seek(env, offset);
        }
        catch (Exception ex) {
            log.log(Level.FINE, ex.toString(), ex);
            return false;
        }
    }

    public static int pg_result_status(Env env, @NotNull PostgresResult result, @Optional(value="PGSQL_STATUS_LONG") int type) {
        try {
            if (result == null) {
                return -1;
            }
            if (type == 45) {
                throw new UnimplementedException("pg_result_status with PGSQL_STATUS_STRING");
            }
            if (result != null) {
                Statement stmt = result.getJavaStatement(env);
                if (stmt.getUpdateCount() >= 0) {
                    return 11;
                }
                ResultSet rs = result.getResultSet();
                if (rs == null) {
                    return 10;
                }
                return 12;
            }
        }
        catch (Exception ex) {
            log.log(Level.FINE, ex.toString(), ex);
        }
        return -1;
    }

    @ReturnNullAsFalse
    public static ArrayValue pg_select(Env env, @NotNull Postgres conn, String tableName, ArrayValue assocArray, @Optional(value="-1") int options) {
        try {
            if (conn == null) {
                return null;
            }
            StringValue whereClause = env.createUnicodeBuilder();
            boolean isFirst = true;
            for (Map.Entry<Value, Value> entry : assocArray.entrySet()) {
                Value k = entry.getKey();
                Value v = entry.getValue();
                if (isFirst) {
                    isFirst = false;
                } else {
                    whereClause.append(" AND ");
                }
                whereClause.append(k.toString()).append("='").append(v.toString()).append("'");
            }
            StringValue query = env.createUnicodeBuilder();
            query.append("SELECT * FROM ").append(tableName).append(" WHERE ").append(whereClause);
            PostgresResult result = PostgresModule.pg_query(env, conn, query.toString());
            return PostgresModule.pg_fetch_all(env, result);
        }
        catch (Exception ex) {
            log.log(Level.FINE, ex.toString(), ex);
            return null;
        }
    }

    public static boolean pg_send_execute(Env env, @NotNull Postgres conn, String stmtName, ArrayValue params) {
        try {
            PostgresResult result = PostgresModule.pg_execute(env, conn, stmtName, params);
            conn.setAsynchronousResult(result);
            if (result != null) {
                return true;
            }
        }
        catch (Exception ex) {
            log.log(Level.FINE, ex.toString(), ex);
        }
        return false;
    }

    public static boolean pg_send_prepare(Env env, @NotNull Postgres conn, String stmtName, String query) {
        try {
            PostgresStatement stmt = PostgresModule.pg_prepare(env, conn, stmtName, query);
            conn.setAsynchronousStatement(stmt);
            if (stmt != null) {
                return true;
            }
        }
        catch (Exception ex) {
            log.log(Level.FINE, ex.toString(), ex);
        }
        return false;
    }

    public static boolean pg_send_query_params(Env env, @NotNull Postgres conn, String query, ArrayValue params) {
        try {
            PostgresStatement pstmt = conn.prepare(env, query);
            return PostgresModule.executeInternal(env, conn, pstmt, params) != null;
        }
        catch (Exception ex) {
            log.log(Level.FINE, ex.toString(), ex);
            return false;
        }
    }

    public static boolean pg_send_query(Env env, @NotNull Postgres conn, String query) {
        if (conn == null) {
            return false;
        }
        try {
            PostgresResult result = PostgresModule.pg_query_impl(env, conn, query, false);
            return true;
        }
        catch (Exception ex) {
            log.log(Level.FINE, ex.toString(), ex);
            return false;
        }
    }

    public static int pg_set_client_encoding(Env env, @NotNull Postgres conn, String encoding) {
        if (conn == null) {
            conn = PostgresModule.getConnection(env);
        }
        if (conn.setClientEncoding(encoding)) {
            return 0;
        }
        return -1;
    }

    public static int pg_set_error_verbosity(Env env, @NotNull Postgres conn, int intVerbosity) {
        try {
            String verbosity;
            PostgresResult result = PostgresModule.pg_query(env, conn, "SHOW log_error_verbosity");
            Value arr = PostgresModule.pg_fetch_row(env, result, LongValue.ZERO);
            String prevVerbosity = arr.get(LongValue.ZERO).toString();
            switch (intVerbosity) {
                case 41: {
                    verbosity = "TERSE";
                    break;
                }
                case 43: {
                    verbosity = "VERBOSE";
                    break;
                }
                default: {
                    verbosity = "DEFAULT";
                }
            }
            PostgresModule.pg_query(env, conn, "SET log_error_verbosity TO '" + verbosity + "'");
            if (prevVerbosity.equals("TERSE")) {
                return 41;
            }
            if (prevVerbosity.equals("VERBOSE")) {
                return 43;
            }
            return 42;
        }
        catch (Exception ex) {
            log.log(Level.FINE, ex.toString(), ex);
            return -1;
        }
    }

    public static boolean pg_trace(Env env, Path path, @Optional String mode, @Optional Postgres conn) {
        env.stub("pg_trace");
        return false;
    }

    public static int pg_transaction_status(Env env, @Optional Postgres conn) {
        return 18;
    }

    public static String pg_tty(Env env, @Optional Postgres conn) {
        env.stub("pg_tty");
        return "";
    }

    @ReturnNullAsFalse
    public static String pg_unescape_bytea(Env env, String data) {
        try {
            byte[] dataBytes = data.getBytes();
            Class<?> cl = Class.forName("org.postgresql.util.PGbytea");
            Method method = cl.getDeclaredMethod("toBytes", byte[].class);
            return new String((byte[])method.invoke(cl, new Object[]{dataBytes}));
        }
        catch (Exception ex) {
            log.log(Level.FINE, ex.toString(), ex);
            return null;
        }
    }

    public static boolean pg_untrace(Env env, @Optional Postgres conn) {
        env.stub("pg_untrace");
        return true;
    }

    public static boolean pg_update(Env env, @NotNull Postgres conn, String tableName, ArrayValue data, ArrayValue condition, @Optional int options) {
        try {
            if (options > 0) {
                throw new UnimplementedException("pg_update with options");
            }
            StringBuilder values = new StringBuilder();
            boolean isFirst = true;
            for (Map.Entry<Value, Value> entry : data.entrySet()) {
                Value value = entry.getKey();
                Value v = entry.getValue();
                if (isFirst) {
                    isFirst = false;
                } else {
                    values.append(", ");
                }
                values.append(value.toString());
                values.append("='");
                values.append(v.toString());
                values.append("'");
            }
            StringBuilder whereClause = new StringBuilder();
            isFirst = true;
            for (Map.Entry<Value, Value> entry : condition.entrySet()) {
                Value k = entry.getKey();
                Value v = entry.getValue();
                if (isFirst) {
                    isFirst = false;
                } else {
                    whereClause.append(" AND ");
                }
                whereClause.append(k.toString());
                whereClause.append("='");
                whereClause.append(v.toString());
                whereClause.append("'");
            }
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("UPDATE ");
            stringBuilder.append(tableName);
            stringBuilder.append(" SET ");
            stringBuilder.append((CharSequence)values);
            stringBuilder.append(" WHERE ");
            stringBuilder.append((CharSequence)whereClause);
            PostgresModule.pg_query(env, conn, stringBuilder.toString());
            return true;
        }
        catch (Exception ex) {
            log.log(Level.FINE, ex.toString(), ex);
            return false;
        }
    }

    @ReturnNullAsFalse
    public static ArrayValue pg_version(Env env, @Optional Postgres conn) {
        try {
            if (conn == null) {
                conn = (Postgres)env.getSpecialValue("caucho.postgres");
            }
            ArrayValueImpl result = new ArrayValueImpl();
            ((ArrayValue)result).append(env.createString("client"), env.createString(conn.getClientInfo()));
            ((ArrayValue)result).append(env.createString("server_version"), env.createString(conn.getServerInfo()));
            return result;
        }
        catch (Exception ex) {
            log.log(Level.FINE, ex.toString(), ex);
            return null;
        }
    }

    private static Postgres getConnection(Env env) {
        Postgres conn = (Postgres)env.getSpecialValue("caucho.postgres");
        if (conn != null) {
            return conn;
        }
        String driver = "org.postgresql.Driver";
        String url = "jdbc:postgresql://localhost:5432/";
        conn = new Postgres(env, "localhost", "", "", "", 5432, driver, url);
        env.setSpecialValue("caucho.postgres", conn);
        return conn;
    }

    private static PostgresResult executeInternal(Env env, @NotNull Postgres conn, PostgresStatement pstmt, ArrayValue params) {
        try {
            int size = params.getSize();
            ColumnType[] types = new ColumnType[size];
            for (int i = 0; i < size; ++i) {
                types[i] = ColumnType.STRING;
            }
            Value[] value = params.valuesToArray();
            pstmt.bindParams(env, types, value);
            if (!pstmt.execute(env)) {
                return null;
            }
            if (pstmt.getStatementType().equals("SELECT")) {
                JdbcResultResource rs = pstmt.getResultSet();
                conn.setResultResource(rs);
                return (PostgresResult)rs;
            }
            return null;
        }
        catch (Exception ex) {
            log.log(Level.FINE, ex.toString(), ex);
            return null;
        }
    }

    private static int writeLobInternal(Object largeObject, InputStream is, int len) {
        try {
            int b;
            Class<?> cl = Class.forName("org.postgresql.largeobject.LargeObject");
            Method method = cl.getDeclaredMethod("getOutputStream", null);
            OutputStream os = (OutputStream)method.invoke(largeObject, new Object[0]);
            int written = 0;
            while ((b = is.read()) >= 0 && written++ < len) {
                os.write(b);
            }
            os.close();
            return written;
        }
        catch (Exception ex) {
            log.log(Level.FINE, ex.toString(), ex);
            return -1;
        }
    }
}

