/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.quercus.lib.file;

import com.caucho.quercus.env.BooleanValue;
import com.caucho.quercus.env.Env;
import com.caucho.quercus.env.LongValue;
import com.caucho.quercus.env.StringValue;
import com.caucho.quercus.env.Value;
import com.caucho.quercus.lib.file.BinaryStream;
import com.caucho.quercus.lib.file.ByteArrayBinaryStream;
import com.caucho.quercus.lib.file.FileModule;
import com.caucho.quercus.lib.file.PhpBinaryInput;
import com.caucho.quercus.lib.file.PhpBinaryOutput;
import com.caucho.quercus.lib.file.PhpStderr;
import com.caucho.quercus.lib.file.PhpStdin;
import com.caucho.quercus.lib.file.PhpStdout;
import com.caucho.quercus.lib.file.ProtocolWrapper;
import com.caucho.util.L10N;

public class PhpProtocolWrapper
extends ProtocolWrapper {
    private static final L10N L = new L10N(PhpProtocolWrapper.class);

    @Override
    public BinaryStream fopen(Env env, StringValue pathV, StringValue mode, LongValue options) {
        String path = pathV.toString();
        if (path.equals("php://output")) {
            return new PhpBinaryOutput(env);
        }
        if (path.equals("php://input")) {
            return new PhpBinaryInput(env);
        }
        if (path.equals("php://stdout")) {
            return new PhpStdout();
        }
        if (path.equals("php://stderr")) {
            return new PhpStderr();
        }
        if (path.equals("php://stdin")) {
            return new PhpStdin(env);
        }
        if (path.equals("php://memory")) {
            return new ByteArrayBinaryStream(env);
        }
        if (path.equals("php://temp")) {
            return FileModule.tmpfile(env);
        }
        env.warning(L.l("{0} is an unsupported or unknown path for this protocol", (Object)path));
        return null;
    }

    @Override
    public Value opendir(Env env, StringValue path, LongValue flags) {
        env.warning(L.l("opendir not supported by protocol"));
        return BooleanValue.FALSE;
    }

    @Override
    public boolean unlink(Env env, StringValue path) {
        env.warning(L.l("unlink not supported by protocol"));
        return false;
    }

    @Override
    public boolean rename(Env env, StringValue path_from, StringValue path_to) {
        env.warning(L.l("rename not supported by protocol"));
        return false;
    }

    @Override
    public boolean mkdir(Env env, StringValue path, LongValue mode, LongValue options) {
        env.warning(L.l("mkdir not supported by protocol"));
        return false;
    }

    @Override
    public boolean rmdir(Env env, StringValue path, LongValue options) {
        env.warning(L.l("rmdir not supported by protocol"));
        return false;
    }

    @Override
    public Value url_stat(Env env, StringValue path, LongValue flags) {
        env.warning(L.l("stat not supported by protocol"));
        return BooleanValue.FALSE;
    }
}

