/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.quercus.lib.file;

import com.caucho.quercus.env.Env;
import com.caucho.quercus.env.EnvCleanup;
import com.caucho.quercus.lib.file.AbstractBinaryOutput;
import com.caucho.vfs.VfsStream;
import com.caucho.vfs.WriteStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.logging.Level;
import java.util.logging.Logger;

public class PopenOutput
extends AbstractBinaryOutput
implements EnvCleanup {
    private static final Logger log = Logger.getLogger(PopenOutput.class.getName());
    private Env _env;
    private Process _process;
    private WriteStream _os;

    public PopenOutput(Env env, Process process) throws IOException {
        this._env = env;
        this._env.addCleanup(this);
        this._process = process;
        this._os = new WriteStream(new VfsStream(null, this._process.getOutputStream()));
        this._process.getInputStream().close();
    }

    @Override
    public OutputStream getOutputStream() {
        return this._os;
    }

    @Override
    public void print(char v) throws IOException {
        if (this._os != null) {
            this._os.print(v);
        }
    }

    @Override
    public void print(String v) throws IOException {
        if (this._os != null) {
            this._os.print(v);
        }
    }

    @Override
    public void write(int ch) throws IOException {
        if (this._os != null) {
            this._os.write(ch);
        }
    }

    @Override
    public void write(byte[] buffer, int offset, int length) throws IOException {
        if (this._os != null) {
            this._os.write(buffer, offset, length);
        }
    }

    @Override
    public void flush() {
        try {
            if (this._os != null) {
                this._os.flush();
            }
        }
        catch (IOException e) {
            log.log(Level.FINE, e.toString(), e);
        }
    }

    @Override
    public void closeWrite() {
        this.close();
    }

    public int pclose() {
        try {
            WriteStream os = this._os;
            this._os = null;
            if (os != null) {
                os.close();
            }
            int n = this._process.waitFor();
            return n;
        }
        catch (Exception e) {
            log.log(Level.FINE, e.toString(), e);
            int n = -1;
            return n;
        }
        finally {
            this._env.removeCleanup(this);
        }
    }

    @Override
    public void close() {
        this.pclose();
    }

    @Override
    public void cleanup() {
        this.pclose();
    }

    public String toString() {
        return "PopenOutput[" + this._process + "]";
    }
}

