/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.quercus.lib.file;

import com.caucho.quercus.annotation.NotNull;
import com.caucho.quercus.annotation.Optional;
import com.caucho.quercus.annotation.ReadOnly;
import com.caucho.quercus.annotation.Reference;
import com.caucho.quercus.annotation.ReturnNullAsFalse;
import com.caucho.quercus.env.ArrayValue;
import com.caucho.quercus.env.ArrayValueImpl;
import com.caucho.quercus.env.BooleanValue;
import com.caucho.quercus.env.Env;
import com.caucho.quercus.env.LongValue;
import com.caucho.quercus.env.QuercusClass;
import com.caucho.quercus.env.StringValue;
import com.caucho.quercus.env.Value;
import com.caucho.quercus.lib.file.AbstractBinaryInputOutput;
import com.caucho.quercus.lib.file.BinaryInput;
import com.caucho.quercus.lib.file.BinaryOutput;
import com.caucho.quercus.lib.file.BinaryStream;
import com.caucho.quercus.lib.file.FileInputOutput;
import com.caucho.quercus.lib.file.ProtocolWrapper;
import com.caucho.quercus.lib.file.SocketInputOutput;
import com.caucho.quercus.lib.file.TcpInputOutput;
import com.caucho.quercus.lib.file.UdpInputOutput;
import com.caucho.quercus.module.AbstractQuercusModule;
import com.caucho.quercus.resources.StreamContextResource;
import com.caucho.util.L10N;
import com.caucho.vfs.FilePath;
import com.caucho.vfs.MemoryPath;
import com.caucho.vfs.Path;
import com.caucho.vfs.TempBuffer;
import java.io.IOException;
import java.net.UnknownHostException;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Logger;

public class StreamModule
extends AbstractQuercusModule {
    private static final L10N L = new L10N(StreamModule.class);
    private static final Logger log = Logger.getLogger(StreamModule.class.getName());
    public static final int STREAM_FILTER_READ = 1;
    public static final int STREAM_FILTER_WRITE = 2;
    public static final int STREAM_FILTER_ALL = 3;
    public static final int PSFS_PASS_ON = 2;
    public static final int PSFS_FEED_ME = 1;
    public static final int PSFS_ERR_FATAL = 0;
    public static final int STREAM_USE_PATH = 1;
    public static final int STREAM_REPORT_ERRORS = 8;
    public static final int STREAM_CLIENT_ASYNC_CONNECT = 2;
    public static final int STREAM_CLIENT_CONNECT = 4;
    public static final int STREAM_CLIENT_PERSISTENT = 1;
    public static final int STREAM_SERVER_BIND = 4;
    public static final int STREAM_SERVER_LISTEN = 8;
    public static final int STREAM_URL_STAT_LINK = 1;
    public static final int STREAM_URL_STAT_QUIET = 2;
    public static final int PHP_STREAM_META_TOUCH = 1;
    private static final HashMap<StringValue, Value> _constMap = new HashMap();

    @Override
    public Map<StringValue, Value> getConstMap() {
        return _constMap;
    }

    public static Value stream_context_create(Env env, @Optional ArrayValue options) {
        return new StreamContextResource(options);
    }

    public static Value stream_context_get_options(Env env, Value resource) {
        if (resource instanceof StreamContextResource) {
            return ((StreamContextResource)resource).getOptions();
        }
        env.warning(L.l("expected resource at '{0}'", (Object)resource));
        return BooleanValue.FALSE;
    }

    public static Value stream_context_get_default(Env env, @Optional ArrayValue options) {
        StreamContextResource context = env.getDefaultStreamContext();
        if (options != null) {
            context.setOptions(options);
        }
        return context;
    }

    public static boolean stream_context_set_option(Env env, Value resource, StringValue wrapper, StringValue option, Value value) {
        if (resource instanceof StreamContextResource) {
            StreamContextResource context = (StreamContextResource)resource;
            context.setOption(env, wrapper, option, value);
            return true;
        }
        env.warning(L.l("expected resource at '{0}'", (Object)resource));
        return false;
    }

    public static boolean stream_context_set_params(Env env, Value resource, ArrayValue value) {
        if (resource instanceof StreamContextResource) {
            StreamContextResource context = (StreamContextResource)resource;
            context.setParameters(value);
            return true;
        }
        env.warning(L.l("expected resource at '{0}'", (Object)resource));
        return false;
    }

    public static long stream_copy_to_stream(Env env, @NotNull BinaryInput in, @NotNull BinaryOutput out, @Optional(value="-1") int length, @Optional int offset) {
        long bytesWritten = 0L;
        try {
            if (in == null) {
                return -1L;
            }
            if (out == null) {
                return -1L;
            }
            TempBuffer temp = TempBuffer.allocate();
            byte[] buffer = temp.getBuffer();
            while (offset-- > 0) {
                in.read();
            }
            if (length < 0) {
                length = Integer.MAX_VALUE;
            }
            while (length > 0) {
                int sublen = buffer.length;
                if (length < sublen) {
                    sublen = length;
                }
                if ((sublen = in.read(buffer, 0, sublen)) < 0) {
                    return bytesWritten;
                }
                out.write(buffer, 0, sublen);
                bytesWritten += (long)sublen;
                length -= sublen;
            }
            TempBuffer.free(temp);
            return bytesWritten;
        }
        catch (IOException e) {
            env.warning(e);
            return bytesWritten;
        }
    }

    public static Value stream_get_contents(Env env, @NotNull BinaryInput in, @Optional(value="-1") long maxLen, @Optional(value="-1") long offset) {
        try {
            int ch;
            if (in == null) {
                return BooleanValue.FALSE;
            }
            StringValue sb = env.createStringBuilder();
            if (maxLen < 0L) {
                maxLen = Integer.MAX_VALUE;
            }
            if (offset >= 0L) {
                in.setPosition(offset);
            }
            while (maxLen-- > 0L && (ch = in.read()) >= 0) {
                sb.append((char)ch);
            }
            return sb;
        }
        catch (IOException e) {
            env.warning(e);
            return BooleanValue.FALSE;
        }
    }

    public static Value stream_get_line(Env env, @NotNull BinaryInput file, @Optional(value="-1") long length) {
        try {
            StringValue line;
            if (file == null) {
                return BooleanValue.FALSE;
            }
            if (length < 0L) {
                length = Integer.MAX_VALUE;
            }
            if ((line = file.readLine(length)) == null) {
                return BooleanValue.FALSE;
            }
            int lineLength = line.length();
            if (lineLength == 0) {
                return line;
            }
            char tail = line.charAt(lineLength - 1);
            if (tail == '\n') {
                return line.substring(0, line.length() - 1);
            }
            if (tail == '\r') {
                return line.substring(0, line.length() - 1);
            }
            return line;
        }
        catch (IOException e) {
            env.warning(e);
            return BooleanValue.FALSE;
        }
    }

    public static Value stream_get_meta_data(Env env, BinaryStream stream) {
        if (stream == null) {
            return BooleanValue.FALSE;
        }
        ArrayValueImpl array = new ArrayValueImpl();
        boolean isTimeout = false;
        boolean isSeekable = false;
        StringValue mode = env.getEmptyString();
        if (stream instanceof AbstractBinaryInputOutput) {
            isTimeout = ((AbstractBinaryInputOutput)stream).isTimeout();
        }
        if (stream instanceof FileInputOutput) {
            isSeekable = true;
            mode = env.createString("w+b");
        }
        array.put(env.createString("timed_out"), BooleanValue.create(isTimeout));
        array.put(env.createString("seekable"), BooleanValue.create(isSeekable));
        array.put(env.createString("mode"), mode);
        return array;
    }

    public static Value stream_get_transports(Env env) {
        ArrayValueImpl value = new ArrayValueImpl();
        value.append(env.createString("tcp"));
        value.append(env.createString("udp"));
        return value;
    }

    public static Value stream_get_wrappers(Env env) {
        ArrayValueImpl array = new ArrayValueImpl();
        HashMap<StringValue, ProtocolWrapper> streamMap = env.getStreamWrappers();
        for (StringValue name : streamMap.keySet()) {
            array.append(name);
        }
        array.append(env.createString("quercus"));
        array.append(env.createString("file"));
        array.append(env.createString("http"));
        array.append(env.createString("ftp"));
        return array;
    }

    public static boolean stream_is_local(Env env, Value stream) {
        if (stream.isString()) {
            Path path = env.lookupPwd(stream);
            return path instanceof FilePath || path instanceof MemoryPath;
        }
        return false;
    }

    public static boolean stream_register_wrapper(Env env, StringValue protocol, String className, @Optional int flags) {
        return StreamModule.stream_wrapper_register(env, protocol, className, flags);
    }

    public static Value stream_resolve_include_path(Env env, StringValue relPath) {
        Path path = env.lookupInclude(relPath);
        if (path != null && path.exists()) {
            return env.createString(path.getNativePath());
        }
        return BooleanValue.FALSE;
    }

    public static boolean stream_set_blocking(Env env, @NotNull Value stream, int mode) {
        env.stub("stream_set_blocking()");
        return stream != null;
    }

    public static boolean stream_set_timeout(Env env, @NotNull Value stream, int seconds, @Optional(value="-1") int microseconds) {
        if (stream == null) {
            return false;
        }
        Object obj = stream.toJavaObject();
        long timeout = 1000L * (long)seconds;
        if (microseconds > 0) {
            timeout += (long)(microseconds / 1000);
        }
        if (obj instanceof AbstractBinaryInputOutput) {
            ((AbstractBinaryInputOutput)obj).setTimeout(timeout);
        }
        return true;
    }

    public static int stream_set_write_buffer(Env env, BinaryOutput stream, int bufferSize) {
        return 0;
    }

    @ReturnNullAsFalse
    public static SocketInputOutput stream_socket_client(Env env, @NotNull String remoteSocket, @Optional @Reference Value errorInt, @Optional @Reference Value errorStr, @Optional(value="120.0") double timeout, @Optional(value="STREAM_CLIENT_CONNECT") int flags, @Optional StreamContextResource context) {
        try {
            if (remoteSocket == null) {
                env.warning("socket to connect to must not be null");
                return null;
            }
            if (flags != 4) {
                env.stub("unsupported stream_socket_client flag");
            }
            boolean isTcp = true;
            boolean isSecure = false;
            int typeIndex = (remoteSocket = remoteSocket.trim()).indexOf("://");
            if (typeIndex > 0) {
                String type = remoteSocket.substring(0, typeIndex);
                remoteSocket = remoteSocket.substring(typeIndex + 3);
                if (!type.equals("tcp")) {
                    if (type.equals("ssl")) {
                        isSecure = true;
                    } else if (type.equals("udp")) {
                        isTcp = false;
                    } else {
                        env.warning(L.l("unrecognized socket transport: {0}", (Object)type));
                        return null;
                    }
                }
            }
            int colonIndex = remoteSocket.lastIndexOf(58);
            String host = remoteSocket;
            int port = 80;
            if (colonIndex > 0) {
                char ch;
                host = remoteSocket.substring(0, colonIndex);
                port = 0;
                for (int i = colonIndex + 1; i < remoteSocket.length() && '0' <= (ch = remoteSocket.charAt(i)) && ch <= '9'; ++i) {
                    port = port * 10 + ch - 48;
                }
            }
            AbstractBinaryInputOutput stream = isTcp ? new TcpInputOutput(env, host, port, isSecure, SocketInputOutput.Domain.AF_INET) : new UdpInputOutput(env, host, port, SocketInputOutput.Domain.AF_INET);
            stream.setTimeout((int)(timeout * 1000.0));
            stream.init();
            return stream;
        }
        catch (UnknownHostException e) {
            errorStr.set(env.createString(e.getMessage()));
            return null;
        }
        catch (IOException e) {
            errorStr.set(env.createString(e.getMessage()));
            return null;
        }
        catch (SecurityException e) {
            errorStr.set(env.createString(e.getMessage()));
            return null;
        }
        catch (NoClassDefFoundError e) {
            errorStr.set(env.createString(e.getMessage()));
            return null;
        }
    }

    public static Value stream_select(Env env, @ReadOnly Value read, @ReadOnly Value write, @ReadOnly Value except, int timeoutSeconds, @Optional int timeoutMicroseconds) {
        Object obj;
        ArrayValue array;
        int count = 0;
        if (read.isArray()) {
            array = read.toArrayValue(env);
            for (Map.Entry<Value, Value> entry : array.entrySet()) {
                obj = entry.getValue().toJavaObject();
                if (!(obj instanceof SocketInputOutput) || !((SocketInputOutput)obj).isConnected()) continue;
                ++count;
            }
        }
        if (write.isArray()) {
            array = write.toArrayValue(env);
            for (Map.Entry<Value, Value> entry : array.entrySet()) {
                obj = entry.getValue().toJavaObject();
                if (!(obj instanceof SocketInputOutput) || !((SocketInputOutput)obj).isConnected()) continue;
                ++count;
            }
        }
        if (except.isArray()) {
            array = except.toArrayValue(env);
            for (Map.Entry<Value, Value> entry : array.entrySet()) {
                obj = entry.getValue().toJavaObject();
                if (!(obj instanceof SocketInputOutput) || !((SocketInputOutput)obj).isConnected()) continue;
                ++count;
            }
        }
        return LongValue.create(count);
    }

    public static boolean stream_wrapper_register(Env env, StringValue protocol, String className, @Optional int flags) {
        HashMap<StringValue, ProtocolWrapper> wrapperMap = env.getStreamWrappers();
        if (wrapperMap.containsKey(protocol)) {
            return false;
        }
        QuercusClass qClass = env.getClass(className);
        env.addStreamWrapper(protocol, new ProtocolWrapper(qClass));
        return true;
    }

    public static boolean stream_wrapper_restore(Env env, StringValue name) {
        return env.restoreStreamWrapper(name);
    }

    public static boolean stream_wrapper_unregister(Env env, StringValue name) {
        return env.unregisterStreamWrapper(name);
    }

    static {
        StreamModule.addConstant(_constMap, "STREAM_URL_STAT_LINK", 1L);
        StreamModule.addConstant(_constMap, "STREAM_URL_STAT_QUIET", 2L);
        StreamModule.addConstant(_constMap, "STREAM_FILTER_READ", 1L);
        StreamModule.addConstant(_constMap, "STREAM_FILTER_WRITE", 2L);
        StreamModule.addConstant(_constMap, "STREAM_FILTER_ALL", 3L);
        StreamModule.addConstant(_constMap, "PSFS_PASS_ON", 2L);
        StreamModule.addConstant(_constMap, "PSFS_FEED_ME", 1L);
        StreamModule.addConstant(_constMap, "PSFS_ERR_FATAL", 0L);
        StreamModule.addConstant(_constMap, "STREAM_USE_PATH", 1L);
        StreamModule.addConstant(_constMap, "STREAM_REPORT_ERRORS", 8L);
        StreamModule.addConstant(_constMap, "STREAM_CLIENT_ASYNC_CONNECT", 2L);
        StreamModule.addConstant(_constMap, "STREAM_CLIENT_CONNECT", 4L);
        StreamModule.addConstant(_constMap, "STREAM_CLIENT_PERSISTENT", 1L);
        StreamModule.addConstant(_constMap, "STREAM_SERVER_BIND", 4L);
        StreamModule.addConstant(_constMap, "STREAM_SERVER_LISTEN", 8L);
    }
}

