/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.quercus.lib.file;

import com.caucho.quercus.env.Env;
import com.caucho.quercus.lib.file.AbstractBinaryInputOutput;
import com.caucho.quercus.lib.file.SocketInputOutput;
import com.caucho.vfs.DatagramStream;
import java.io.IOException;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.SocketAddress;
import java.util.logging.Level;
import java.util.logging.Logger;

public class UdpInputOutput
extends AbstractBinaryInputOutput
implements SocketInputOutput {
    private static final Logger log = Logger.getLogger(UdpInputOutput.class.getName());
    private DatagramSocket _socket;
    private SocketInputOutput.Domain _domain;
    private DatagramStream _stream;
    private int _error;
    private byte _unread;

    public UdpInputOutput(Env env, String host, int port, SocketInputOutput.Domain domain) throws IOException {
        super(env);
        env.addCleanup(this);
        this._socket = new DatagramSocket();
        this._socket.connect(InetAddress.getByName(host), port);
        this._domain = domain;
    }

    public UdpInputOutput(Env env, DatagramSocket socket, SocketInputOutput.Domain domain) {
        super(env);
        this._socket = socket;
        this._domain = domain;
    }

    @Override
    public void bind(SocketAddress address) throws IOException {
        this._socket.bind(address);
    }

    @Override
    public void connect(SocketAddress address) throws IOException {
        this._socket.connect(address);
        this.init();
    }

    @Override
    public void init() {
        DatagramStream sock = new DatagramStream(this._socket);
        sock.setThrowReadInterrupts(true);
        this.init(sock.getInputStream(), sock.getOutputStream());
    }

    @Override
    public void setTimeout(long timeout) {
        try {
            if (this._socket != null) {
                this._socket.setSoTimeout((int)timeout);
            }
        }
        catch (Exception e) {
            log.log(Level.FINER, e.toString(), e);
        }
    }

    @Override
    public void setError(int error) {
        this._error = error;
    }

    @Override
    public boolean isConnected() {
        return this._socket.isConnected();
    }

    @Override
    public long getPosition() {
        if (this._stream != null) {
            return this._stream.getPosition();
        }
        return -1L;
    }

    @Override
    public boolean setPosition(long offset) {
        if (this._stream == null) {
            return false;
        }
        boolean result = this._stream.setPosition(offset);
        if (result) {
            this._isEOF = false;
        }
        return result;
    }

    @Override
    public void unread() throws IOException {
        if (this._stream != null) {
            this._stream.unread();
            this._isEOF = false;
        }
    }

    @Override
    public void cleanup() {
        DatagramSocket s = this._socket;
        this._socket = null;
        if (s != null) {
            s.close();
        }
    }

    @Override
    public String toString() {
        if (this._socket != null) {
            return "UdpInputOutput[" + this._socket.getInetAddress() + "," + this._socket.getPort() + "]";
        }
        return "UdpInputOutput[closed]";
    }
}

