/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.quercus.lib.file;

import com.caucho.quercus.env.Value;
import com.caucho.quercus.lib.file.BinaryOutput;
import com.caucho.vfs.TempBuffer;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.logging.Level;
import java.util.logging.Logger;

public class WriteStreamOutput
extends OutputStream
implements BinaryOutput {
    private static final Logger log = Logger.getLogger(WriteStreamOutput.class.getName());
    private OutputStream _os;

    public WriteStreamOutput(OutputStream os) {
        this._os = os;
    }

    @Override
    public OutputStream getOutputStream() {
        return this._os;
    }

    public Object toJavaObject() {
        return this;
    }

    public String getResourceType() {
        return "stream";
    }

    @Override
    public void write(int ch) throws IOException {
        this._os.write(ch);
    }

    @Override
    public void write(byte[] buffer, int offset, int length) throws IOException {
        this._os.write(buffer, offset, length);
    }

    @Override
    public void closeWrite() {
        this.close();
    }

    @Override
    public void print(char ch) throws IOException {
        this._os.write(ch);
    }

    @Override
    public void print(String s) throws IOException {
        int len = s.length();
        for (int i = 0; i < len; ++i) {
            this._os.write(s.charAt(i));
        }
    }

    @Override
    public int write(InputStream is, int length) throws IOException {
        TempBuffer tempBuffer = TempBuffer.allocate();
        byte[] buffer = tempBuffer.getBuffer();
        int writeLength = length;
        while (length > 0) {
            int sublen = buffer.length;
            if (length < sublen) {
                sublen = length;
            }
            if ((sublen = is.read(buffer, 0, sublen)) <= 0) break;
            this._os.write(buffer, 0, sublen);
            length -= sublen;
        }
        TempBuffer.free(tempBuffer);
        return writeLength;
    }

    @Override
    public long getPosition() {
        return 0L;
    }

    @Override
    public boolean isEOF() {
        return false;
    }

    @Override
    public long seek(long offset, int whence) {
        return 0L;
    }

    @Override
    public boolean setPosition(long offset) {
        return false;
    }

    @Override
    public Value stat() {
        return null;
    }

    @Override
    public void flush() {
        OutputStream os = this._os;
        this._os = null;
        if (os != null) {
            try {
                os.flush();
            }
            catch (Exception e) {
                log.log(Level.FINE, e.toString(), e);
            }
        }
    }

    @Override
    public void close() {
        OutputStream os = this._os;
        this._os = null;
        if (os != null) {
            try {
                os.close();
            }
            catch (Exception e) {
                log.log(Level.FINE, e.toString(), e);
            }
        }
    }

    public String toString() {
        return "WriteStreamOutput[" + this._os + "]";
    }
}

