/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.quercus.lib.filter;

import com.caucho.quercus.UnimplementedException;
import com.caucho.quercus.annotation.Optional;
import com.caucho.quercus.annotation.ReadOnly;
import com.caucho.quercus.env.ArrayValue;
import com.caucho.quercus.env.ArrayValueImpl;
import com.caucho.quercus.env.BooleanValue;
import com.caucho.quercus.env.Env;
import com.caucho.quercus.env.NullValue;
import com.caucho.quercus.env.StringValue;
import com.caucho.quercus.env.UnsetValue;
import com.caucho.quercus.env.Value;
import com.caucho.quercus.lib.filter.AbstractFilter;
import com.caucho.quercus.lib.filter.BooleanValidateFilter;
import com.caucho.quercus.lib.filter.EmailSanitizeFilter;
import com.caucho.quercus.lib.filter.EmailValidateFilter;
import com.caucho.quercus.lib.filter.Filter;
import com.caucho.quercus.lib.filter.FloatValidateFilter;
import com.caucho.quercus.lib.filter.IntValidateFilter;
import com.caucho.quercus.lib.filter.IpValidateFilter;
import com.caucho.quercus.lib.filter.SpecialCharsSanitizeFilter;
import com.caucho.quercus.lib.filter.StringSanitizeFilter;
import com.caucho.quercus.lib.filter.UnsafeRawSanitizeFilter;
import com.caucho.quercus.module.AbstractQuercusModule;
import com.caucho.util.L10N;
import java.util.HashMap;
import java.util.Map;

public class FilterModule
extends AbstractQuercusModule {
    private static final L10N L = new L10N(FilterModule.class);
    public static final int INPUT_POST = 0;
    public static final int INPUT_GET = 1;
    public static final int INPUT_COOKIE = 2;
    public static final int INPUT_ENV = 4;
    public static final int INPUT_SERVER = 5;
    public static final int FILTER_VALIDATE_INT = 257;
    public static final int FILTER_VALIDATE_BOOLEAN = 258;
    public static final int FILTER_VALIDATE_FLOAT = 259;
    public static final int FILTER_VALIDATE_URL = 273;
    public static final int FILTER_VALIDATE_EMAIL = 274;
    public static final int FILTER_VALIDATE_IP = 275;
    public static final int FILTER_SANITIZE_STRING = 513;
    public static final int FILTER_SANITIZE_STRIPPED = 513;
    public static final int FILTER_SANITIZE_SPECIAL_CHARS = 515;
    public static final int FILTER_UNSAFE_RAW = 516;
    public static final int FILTER_DEFAULT = 516;
    public static final int FILTER_SANITIZE_EMAIL = 517;
    public static final int FILTER_FLAG_NONE = 0;
    public static final int FILTER_FLAG_ALLOW_OCTAL = 1;
    public static final int FILTER_FLAG_STRIP_LOW = 4;
    public static final int FILTER_FLAG_STRIP_HIGH = 8;
    public static final int FILTER_FLAG_ENCODE_LOW = 16;
    public static final int FILTER_FLAG_ENCODE_HIGH = 32;
    public static final int FILTER_FLAG_ENCODE_AMP = 64;
    public static final int FILTER_FLAG_NO_ENCODE_QUOTES = 128;
    public static final int FILTER_FLAG_ALLOW_THOUSAND = 8192;
    public static final int FILTER_NULL_ON_FAILURE = 0x8000000;
    public static final int FILTER_FLAG_IPV4 = 0x100000;
    public static final int FILTER_FLAG_IPV6 = 0x200000;
    public static final int FILTER_FLAG_NO_RES_RANGE = 0x400000;
    public static final int FILTER_FLAG_NO_PRIV_RANGE = 0x800000;
    public static HashMap<Integer, Filter> _filterMap = new HashMap();

    @Override
    public String[] getLoadedExtensions() {
        return new String[]{"filter"};
    }

    public static Value filter_var(Env env, @ReadOnly Value value, @Optional Value filterIdV, @Optional Value flagV) {
        if (value.isArray()) {
            return BooleanValue.FALSE;
        }
        Filter filter = FilterModule.getFilter(env, filterIdV);
        if (filter == null) {
            return BooleanValue.FALSE;
        }
        return filter.filter(env, value, flagV);
    }

    public static Value filter_input(Env env, int type, StringValue name, @Optional Value filterIdV, @Optional Value flagV) {
        ArrayValue array;
        switch (type) {
            case 0: {
                array = env.getInputPostArray();
                break;
            }
            case 1: {
                array = env.getInputGetArray();
                break;
            }
            case 2: {
                array = env.getInputCookieArray();
                break;
            }
            case 4: {
                array = env.getInputEnvArray();
                break;
            }
            default: {
                return env.warning(L.l("filter input type is unknown: {0}", type));
            }
        }
        Filter filter = FilterModule.getFilter(env, filterIdV);
        Value value = array.get(name);
        if (value == UnsetValue.UNSET) {
            int flags = AbstractFilter.getFlags(env, flagV);
            if ((flags & 0x8000000) > 0) {
                return BooleanValue.FALSE;
            }
            return NullValue.NULL;
        }
        return filter.filter(env, value, flagV);
    }

    public Value filter_input_array(Env env, int type, @Optional Value definition, @Optional(value="true") boolean isAddEmpty) {
        ArrayValue inputArray;
        switch (type) {
            case 0: {
                inputArray = env.getInputPostArray();
                break;
            }
            case 1: {
                inputArray = env.getInputGetArray();
                break;
            }
            case 2: {
                inputArray = env.getInputCookieArray();
                break;
            }
            case 4: {
                inputArray = env.getInputEnvArray();
                break;
            }
            default: {
                return env.warning(L.l("filter input type is unknown: {0}", type));
            }
        }
        Filter filter = FilterModule.getFilter(env, definition);
        ArrayValueImpl array = new ArrayValueImpl();
        for (Map.Entry<Value, Value> entry : inputArray.entrySet()) {
            Value key = entry.getKey();
            Value value = entry.getValue();
            Value newKey = filter.filter(env, key, definition);
            Value newValue = filter.filter(env, value, definition);
            array.put(newKey, newValue);
        }
        return array;
    }

    public static Filter getFilter(Env env, Value filterIdV) {
        Value value;
        int defaultFilterId = 516;
        int filterId = filterIdV.isDefault() ? defaultFilterId : (filterIdV.isArray() ? ((value = filterIdV.get(env.createString("filter"))).isNull() ? defaultFilterId : value.toInt()) : filterIdV.toInt());
        Filter filter = _filterMap.get(filterId);
        if (filter == null) {
            throw new UnimplementedException(L.l("filter not implemented: {0} ({1})", (Object)filterIdV, filterId));
        }
        return filter;
    }

    static {
        _filterMap.put(516, new UnsafeRawSanitizeFilter());
        _filterMap.put(257, new IntValidateFilter());
        _filterMap.put(258, new BooleanValidateFilter());
        _filterMap.put(259, new FloatValidateFilter());
        _filterMap.put(274, new EmailValidateFilter());
        _filterMap.put(275, new IpValidateFilter());
        _filterMap.put(513, new StringSanitizeFilter());
        _filterMap.put(517, new EmailSanitizeFilter());
        _filterMap.put(515, new SpecialCharsSanitizeFilter());
    }
}

