/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.quercus.lib.filter;

import com.caucho.quercus.env.ArrayValue;
import com.caucho.quercus.env.BooleanValue;
import com.caucho.quercus.env.DoubleValue;
import com.caucho.quercus.env.Env;
import com.caucho.quercus.env.Value;
import com.caucho.quercus.lib.filter.AbstractFilter;
import com.caucho.quercus.lib.filter.ValidateFilter;
import com.caucho.util.L10N;

public class FloatValidateFilter
extends AbstractFilter
implements ValidateFilter {
    private static final L10N L = new L10N(FloatValidateFilter.class);

    @Override
    protected Value filterImpl(Env env, Value value, int flags, ArrayValue options) {
        Value decimalSeparator;
        String originalStr;
        if (value == BooleanValue.TRUE) {
            return DoubleValue.create(1.0);
        }
        if (value.isLong()) {
            return value.toDoubleValue();
        }
        if (value.isDoubleConvertible()) {
            return value.toDoubleValue();
        }
        String str = originalStr = value.toStringValue(env).toString();
        if ((flags & 0x2000) > 0) {
            str = str.replace(",", "");
        }
        if (options != null && (decimalSeparator = options.get(env.createString("decimal"))).isString()) {
            if (decimalSeparator.length() > 1) {
                env.warning(L.l("decimal separator must be one char: {0}", (Object)decimalSeparator));
                return BooleanValue.FALSE;
            }
            str = str.replace(decimalSeparator.toString(), ".");
        }
        if (str != originalStr && (value = env.createString(str)).isDoubleConvertible()) {
            return value.toDoubleValue();
        }
        return BooleanValue.FALSE;
    }
}

