/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.quercus.lib.filter;

import com.caucho.quercus.env.ArrayValue;
import com.caucho.quercus.env.Env;
import com.caucho.quercus.env.StringValue;
import com.caucho.quercus.env.Value;
import com.caucho.quercus.lib.filter.AbstractFilter;
import com.caucho.quercus.lib.filter.SanitizeFilter;

public class SpecialCharsSanitizeFilter
extends AbstractFilter
implements SanitizeFilter {
    @Override
    protected Value filterImpl(Env env, Value value, int flags, ArrayValue options) {
        StringValue str = value.toStringValue(env);
        StringValue sb = str.createStringBuilder();
        int len = str.length();
        boolean isEncodeHigh = (flags & 0x20) > 0;
        boolean isStripLow = (flags & 4) > 0;
        boolean isStripHigh = (flags & 8) > 0;
        for (int i = 0; i < len; ++i) {
            char ch = str.charAt(i);
            if ('\u0000' <= ch && ch <= '\u001f') {
                if (isStripLow) continue;
                SpecialCharsSanitizeFilter.appendEncoded(sb, ch);
                continue;
            }
            if ('\u0080' <= ch) {
                if (isStripHigh) continue;
                if (isEncodeHigh) {
                    SpecialCharsSanitizeFilter.appendEncoded(sb, ch);
                    continue;
                }
                sb.append(ch);
                continue;
            }
            if (ch == '&') {
                SpecialCharsSanitizeFilter.appendEncoded(sb, ch);
                continue;
            }
            if (ch == '\"' || ch == '\'') {
                SpecialCharsSanitizeFilter.appendEncoded(sb, ch);
                continue;
            }
            if (ch == '<' || ch == '>') {
                SpecialCharsSanitizeFilter.appendEncoded(sb, ch);
                continue;
            }
            sb.append(ch);
        }
        return sb;
    }
}

