/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.quercus.lib.json;

import com.caucho.quercus.annotation.Optional;
import com.caucho.quercus.env.ArrayValueImpl;
import com.caucho.quercus.env.Env;
import com.caucho.quercus.env.JsonEncodeContext;
import com.caucho.quercus.env.StringValue;
import com.caucho.quercus.env.Value;
import com.caucho.quercus.lib.json.JsonDecoder;
import com.caucho.quercus.module.AbstractQuercusModule;

public class JsonModule
extends AbstractQuercusModule {
    public static final int JSON_ERROR_NONE = 0;
    public static final int JSON_ERROR_DEPTH = 1;
    public static final int JSON_ERROR_STATE_MISMATCH = 2;
    public static final int JSON_ERROR_CTRL_CHAR = 3;
    public static final int JSON_ERROR_SYNTAX = 4;
    public static final int JSON_ERROR_UTF8 = 5;
    public static final int JSON_HEX_TAG = 1;
    public static final int JSON_HEX_AMP = 2;
    public static final int JSON_HEX_APOS = 4;
    public static final int JSON_HEX_QUOT = 8;
    public static final int JSON_FORCE_OBJECT = 16;
    public static final int JSON_NUMERIC_CHECK = 32;
    public static final int JSON_BIGINT_AS_STRING = 64;
    public static final int JSON_PRETTY_PRINT = 128;
    public static final int JSON_UNESCAPED_SLASHES = 256;
    public static final int JSON_UNESCAPED_UNICODE = 512;

    @Override
    public String[] getLoadedExtensions() {
        return new String[]{"json"};
    }

    public static StringValue json_encode(Env env, Value val, @Optional int options) {
        boolean isEscapeTag = (options & 1) > 0;
        boolean isEscapeAmp = (options & 2) > 0;
        boolean isEscapeApos = (options & 4) > 0;
        boolean isEscapeQuote = (options & 8) > 0;
        boolean isNumericCheck = (options & 0x20) > 0;
        boolean isBigIntAsString = (options & 0x40) > 0;
        JsonEncodeContext context = new JsonEncodeContext(isEscapeTag, isEscapeAmp, isEscapeApos, isEscapeQuote, isNumericCheck, isBigIntAsString);
        StringValue sb = env.createStringBuilder();
        val.jsonEncode(env, context, sb);
        return sb;
    }

    public static Value json_decode(Env env, StringValue s, @Optional(value="false") boolean assoc) {
        env.removeSpecialValue("json.last_error");
        if (s.length() == 0) {
            return new ArrayValueImpl();
        }
        return new JsonDecoder().jsonDecode(env, s, assoc);
    }

    public static int json_last_error(Env env) {
        Object obj = env.getSpecialValue("json.last_error");
        if (obj == null) {
            return 0;
        }
        return (Integer)obj;
    }

    protected static void setErrorLast(Env env, int code) {
        env.setSpecialValue("json.last_error", new Integer(code));
    }
}

