/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.quercus.lib.regexp;

import com.caucho.quercus.env.StringValue;
import com.caucho.quercus.lib.regexp.Regcomp;
import com.caucho.quercus.lib.regexp.RegexpSet;
import com.caucho.quercus.lib.regexp.RegexpState;
import com.caucho.util.CharBuffer;
import com.caucho.util.IntSet;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.Map;

class RegexpNode {
    static final int RC_END = 0;
    static final int RC_NULL = 1;
    static final int RC_STRING = 2;
    static final int RC_SET = 3;
    static final int RC_NSET = 4;
    static final int RC_BEG_GROUP = 5;
    static final int RC_END_GROUP = 6;
    static final int RC_GROUP_REF = 7;
    static final int RC_LOOP = 8;
    static final int RC_LOOP_INIT = 9;
    static final int RC_LOOP_SHORT = 10;
    static final int RC_LOOP_UNIQUE = 11;
    static final int RC_LOOP_SHORT_UNIQUE = 12;
    static final int RC_LOOP_LONG = 13;
    static final int RC_OR = 64;
    static final int RC_OR_UNIQUE = 65;
    static final int RC_POS_LOOKAHEAD = 66;
    static final int RC_NEG_LOOKAHEAD = 67;
    static final int RC_POS_LOOKBEHIND = 68;
    static final int RC_NEG_LOOKBEHIND = 69;
    static final int RC_LOOKBEHIND_OR = 70;
    static final int RC_WORD = 73;
    static final int RC_NWORD = 74;
    static final int RC_BLINE = 75;
    static final int RC_ELINE = 76;
    static final int RC_BSTRING = 77;
    static final int RC_ESTRING = 78;
    static final int RC_ENSTRING = 79;
    static final int RC_GSTRING = 80;
    static final int RC_COND = 81;
    static final int RC_STRING_I = 128;
    static final int RC_SET_I = 129;
    static final int RC_NSET_I = 130;
    static final int RC_GROUP_REF_I = 131;
    static final int RC_LEXEME = 256;
    static final int RC_UNICODE = 512;
    static final int RC_NUNICODE = 513;
    static final int RC_C = 1024;
    static final int RC_L = 1025;
    static final int RC_M = 1026;
    static final int RC_N = 1027;
    static final int RC_P = 1028;
    static final int RC_S = 1029;
    static final int RC_Z = 1030;
    static final int RC_NC = 1031;
    static final int RC_NL = 1032;
    static final int RC_NM = 1033;
    static final int RC_NN = 1034;
    static final int RC_NP = 1035;
    static final int RC_CHAR_CLASS = 2048;
    static final int RC_ALNUM = 1;
    static final int RC_ALPHA = 2;
    static final int RC_BLANK = 3;
    static final int RC_CNTRL = 4;
    static final int RC_DIGIT = 5;
    static final int RC_GRAPH = 6;
    static final int RC_LOWER = 7;
    static final int RC_PRINT = 8;
    static final int RC_PUNCT = 9;
    static final int RC_SPACE = 10;
    static final int RC_UPPER = 11;
    static final int RC_XDIGIT = 12;
    private static final int INTEGER_MAX = 0x7FFFFFFE;
    public static final int FAIL = -1;
    public static final int SUCCESS = 0;
    static final RegexpNode N_END = new End();
    static final RegexpNode ANY_CHAR;
    static final AnchorBegin ANCHOR_BEGIN;
    static final AnchorBeginOrNewline ANCHOR_BEGIN_OR_NEWLINE;
    static final AnchorBeginRelative ANCHOR_BEGIN_RELATIVE;
    static final AnchorEnd ANCHOR_END;
    static final AnchorEndOnly ANCHOR_END_ONLY;
    static final AnchorEndOrNewline ANCHOR_END_OR_NEWLINE;
    static final RegexpNode DIGIT;
    static final RegexpNode NOT_DIGIT;
    static final RegexpNode DOT;
    static final RegexpNode NOT_DOT;
    static final RegexpNode SPACE;
    static final RegexpNode NOT_SPACE;
    static final RegexpNode S_WORD;
    static final RegexpNode NOT_S_WORD;
    static final EmptyNode EMPTY;
    static final PropC PROP_C;
    static final PropNotC PROP_NOT_C;
    static final Prop PROP_Cc;
    static final PropNot PROP_NOT_Cc;
    static final Prop PROP_Cf;
    static final PropNot PROP_NOT_Cf;
    static final Prop PROP_Cn;
    static final PropNot PROP_NOT_Cn;
    static final Prop PROP_Co;
    static final PropNot PROP_NOT_Co;
    static final Prop PROP_Cs;
    static final PropNot PROP_NOT_Cs;
    static final PropL PROP_L;
    static final PropNotL PROP_NOT_L;
    static final Prop PROP_Ll;
    static final PropNot PROP_NOT_Ll;
    static final Prop PROP_Lm;
    static final PropNot PROP_NOT_Lm;
    static final Prop PROP_Lo;
    static final PropNot PROP_NOT_Lo;
    static final Prop PROP_Lt;
    static final PropNot PROP_NOT_Lt;
    static final Prop PROP_Lu;
    static final PropNot PROP_NOT_Lu;
    static final PropM PROP_M;
    static final PropNotM PROP_NOT_M;
    static final Prop PROP_Mc;
    static final PropNot PROP_NOT_Mc;
    static final Prop PROP_Me;
    static final PropNot PROP_NOT_Me;
    static final Prop PROP_Mn;
    static final PropNot PROP_NOT_Mn;
    static final PropN PROP_N;
    static final PropNotN PROP_NOT_N;
    static final Prop PROP_Nd;
    static final PropNot PROP_NOT_Nd;
    static final Prop PROP_Nl;
    static final PropNot PROP_NOT_Nl;
    static final Prop PROP_No;
    static final PropNot PROP_NOT_No;
    static final PropP PROP_P;
    static final PropNotP PROP_NOT_P;
    static final Prop PROP_Pc;
    static final PropNot PROP_NOT_Pc;
    static final Prop PROP_Pd;
    static final PropNot PROP_NOT_Pd;
    static final Prop PROP_Pe;
    static final PropNot PROP_NOT_Pe;
    static final Prop PROP_Pf;
    static final PropNot PROP_NOT_Pf;
    static final Prop PROP_Pi;
    static final PropNot PROP_NOT_Pi;
    static final Prop PROP_Po;
    static final PropNot PROP_NOT_Po;
    static final Prop PROP_Ps;
    static final PropNot PROP_NOT_Ps;
    static final PropS PROP_S;
    static final PropNotS PROP_NOT_S;
    static final Prop PROP_Sc;
    static final PropNot PROP_NOT_Sc;
    static final Prop PROP_Sk;
    static final PropNot PROP_NOT_Sk;
    static final Prop PROP_Sm;
    static final PropNot PROP_NOT_Sm;
    static final Prop PROP_So;
    static final PropNot PROP_NOT_So;
    static final PropZ PROP_Z;
    static final PropNotZ PROP_NOT_Z;
    static final Prop PROP_Zl;
    static final PropNot PROP_NOT_Zl;
    static final Prop PROP_Zp;
    static final PropNot PROP_NOT_Zp;
    static final Prop PROP_Zs;
    static final PropNot PROP_NOT_Zs;
    static final StringBegin STRING_BEGIN;
    static final StringEnd STRING_END;
    static final StringFirst STRING_FIRST;
    static final StringNewline STRING_NEWLINE;
    static final Word WORD;
    static final NotWord NOT_WORD;

    protected RegexpNode() {
    }

    final RegexpNode copy() {
        return this.copy(new HashMap<RegexpNode, RegexpNode>());
    }

    final RegexpNode copy(HashMap<RegexpNode, RegexpNode> state) {
        RegexpNode copy = state.get(this);
        if (copy != null) {
            return copy;
        }
        copy = this.copyImpl(state);
        return copy;
    }

    RegexpNode copyImpl(HashMap<RegexpNode, RegexpNode> state) {
        return this;
    }

    RegexpNode concat(RegexpNode next) {
        return new Concat(this, next);
    }

    RegexpNode createOptional(Regcomp parser) {
        return this.createLoop(parser, 0, 1);
    }

    RegexpNode createStar(Regcomp parser) {
        return this.createLoop(parser, 0, 0x7FFFFFFE);
    }

    RegexpNode createPlus(Regcomp parser) {
        return this.createLoop(parser, 1, 0x7FFFFFFE);
    }

    RegexpNode createLoop(Regcomp parser, int min, int max) {
        return new LoopHead(parser, this, min, max);
    }

    RegexpNode createLoopUngreedy(Regcomp parser, int min, int max) {
        return new LoopHeadUngreedy(parser, this, min, max);
    }

    RegexpNode createPossessiveLoop(int min, int max) {
        return new PossessiveLoop(this.getHead(), min, max);
    }

    RegexpNode createOr(RegexpNode node) {
        return Or.create(this, node);
    }

    RegexpNode createNot() {
        return Not.create(this);
    }

    int minLength() {
        return 0;
    }

    String prefix() {
        return "";
    }

    int firstChar() {
        return -1;
    }

    boolean isNullable() {
        return false;
    }

    boolean[] firstSet(boolean[] firstSet) {
        return null;
    }

    boolean isAnchorBegin() {
        return false;
    }

    RegexpNode getTail() {
        return this;
    }

    RegexpNode getHead() {
        return this;
    }

    int match(StringValue string, int length, int offset, RegexpState state) {
        throw new UnsupportedOperationException(this.getClass().getName());
    }

    public String toString() {
        IdentityHashMap<RegexpNode, Integer> map = new IdentityHashMap<RegexpNode, Integer>();
        StringBuilder sb = new StringBuilder();
        this.toString(sb, map);
        return sb.toString();
    }

    protected void toString(StringBuilder sb, Map<RegexpNode, Integer> map) {
        if (this.toStringAdd(sb, map)) {
            return;
        }
        sb.append(this.toStringName()).append("[]");
    }

    protected boolean toStringAdd(StringBuilder sb, Map<RegexpNode, Integer> map) {
        Integer v = map.get(this);
        if (v != null) {
            sb.append("#").append(v);
            return true;
        }
        map.put(this, map.size());
        return false;
    }

    protected String toStringName() {
        String name = this.getClass().getName();
        int p = name.lastIndexOf(36);
        if (p < 0) {
            p = name.lastIndexOf(46);
        }
        return name.substring(p + 1);
    }

    static {
        ANCHOR_BEGIN = new AnchorBegin();
        ANCHOR_BEGIN_OR_NEWLINE = new AnchorBeginOrNewline();
        ANCHOR_BEGIN_RELATIVE = new AnchorBeginRelative();
        ANCHOR_END = new AnchorEnd();
        ANCHOR_END_ONLY = new AnchorEndOnly();
        ANCHOR_END_OR_NEWLINE = new AnchorEndOrNewline();
        DIGIT = RegexpSet.DIGIT.createNode();
        NOT_DIGIT = RegexpSet.DIGIT.createNotNode();
        DOT = RegexpSet.DOT.createNotNode();
        NOT_DOT = RegexpSet.DOT.createNode();
        SPACE = RegexpSet.SPACE.createNode();
        NOT_SPACE = RegexpSet.SPACE.createNotNode();
        S_WORD = RegexpSet.WORD.createNode();
        NOT_S_WORD = RegexpSet.WORD.createNotNode();
        EMPTY = new EmptyNode();
        PROP_C = new PropC();
        PROP_NOT_C = new PropNotC();
        PROP_Cc = new Prop(15);
        PROP_NOT_Cc = new PropNot(15);
        PROP_Cf = new Prop(16);
        PROP_NOT_Cf = new PropNot(16);
        PROP_Cn = new Prop(0);
        PROP_NOT_Cn = new PropNot(0);
        PROP_Co = new Prop(18);
        PROP_NOT_Co = new PropNot(18);
        PROP_Cs = new Prop(19);
        PROP_NOT_Cs = new PropNot(19);
        PROP_L = new PropL();
        PROP_NOT_L = new PropNotL();
        PROP_Ll = new Prop(2);
        PROP_NOT_Ll = new PropNot(2);
        PROP_Lm = new Prop(4);
        PROP_NOT_Lm = new PropNot(4);
        PROP_Lo = new Prop(5);
        PROP_NOT_Lo = new PropNot(5);
        PROP_Lt = new Prop(3);
        PROP_NOT_Lt = new PropNot(3);
        PROP_Lu = new Prop(1);
        PROP_NOT_Lu = new PropNot(1);
        PROP_M = new PropM();
        PROP_NOT_M = new PropNotM();
        PROP_Mc = new Prop(8);
        PROP_NOT_Mc = new PropNot(8);
        PROP_Me = new Prop(7);
        PROP_NOT_Me = new PropNot(7);
        PROP_Mn = new Prop(6);
        PROP_NOT_Mn = new PropNot(6);
        PROP_N = new PropN();
        PROP_NOT_N = new PropNotN();
        PROP_Nd = new Prop(9);
        PROP_NOT_Nd = new PropNot(9);
        PROP_Nl = new Prop(10);
        PROP_NOT_Nl = new PropNot(10);
        PROP_No = new Prop(11);
        PROP_NOT_No = new PropNot(11);
        PROP_P = new PropP();
        PROP_NOT_P = new PropNotP();
        PROP_Pc = new Prop(23);
        PROP_NOT_Pc = new PropNot(23);
        PROP_Pd = new Prop(20);
        PROP_NOT_Pd = new PropNot(20);
        PROP_Pe = new Prop(22);
        PROP_NOT_Pe = new PropNot(22);
        PROP_Pf = new Prop(30);
        PROP_NOT_Pf = new PropNot(30);
        PROP_Pi = new Prop(29);
        PROP_NOT_Pi = new PropNot(29);
        PROP_Po = new Prop(24);
        PROP_NOT_Po = new PropNot(24);
        PROP_Ps = new Prop(21);
        PROP_NOT_Ps = new PropNot(21);
        PROP_S = new PropS();
        PROP_NOT_S = new PropNotS();
        PROP_Sc = new Prop(26);
        PROP_NOT_Sc = new PropNot(26);
        PROP_Sk = new Prop(27);
        PROP_NOT_Sk = new PropNot(27);
        PROP_Sm = new Prop(25);
        PROP_NOT_Sm = new PropNot(25);
        PROP_So = new Prop(28);
        PROP_NOT_So = new PropNot(28);
        PROP_Z = new PropZ();
        PROP_NOT_Z = new PropNotZ();
        PROP_Zl = new Prop(13);
        PROP_NOT_Zl = new PropNot(13);
        PROP_Zp = new Prop(14);
        PROP_NOT_Zp = new PropNot(14);
        PROP_Zs = new Prop(12);
        PROP_NOT_Zs = new PropNot(12);
        STRING_BEGIN = new StringBegin();
        STRING_END = new StringEnd();
        STRING_FIRST = new StringFirst();
        STRING_NEWLINE = new StringNewline();
        WORD = new Word();
        NOT_WORD = new NotWord();
        ANY_CHAR = new AsciiNotSet();
    }

    private static class NotWord
    extends RegexpNode {
        private NotWord() {
        }

        @Override
        int match(StringValue string, int strlen, int offset, RegexpState state) {
            if ((state._start < offset && RegexpSet.WORD.match(string.charAt(offset - 1))) == (offset < strlen && RegexpSet.WORD.match(string.charAt(offset)))) {
                return offset;
            }
            return -1;
        }
    }

    private static class Word
    extends RegexpNode {
        private Word() {
        }

        @Override
        int match(StringValue string, int strlen, int offset, RegexpState state) {
            if ((state._start < offset && RegexpSet.WORD.match(string.charAt(offset - 1))) != (offset < strlen && RegexpSet.WORD.match(string.charAt(offset)))) {
                return offset;
            }
            return -1;
        }
    }

    private static class StringNewline
    extends RegexpNode {
        private StringNewline() {
        }

        @Override
        int match(StringValue string, int strlen, int offset, RegexpState state) {
            if (offset == strlen || string.charAt(offset) == '\n' && offset + 1 == string.length()) {
                return offset;
            }
            return -1;
        }
    }

    private static class StringFirst
    extends RegexpNode {
        private StringFirst() {
        }

        @Override
        int match(StringValue string, int strlen, int offset, RegexpState state) {
            if (offset == state._first) {
                return offset;
            }
            return -1;
        }
    }

    private static class StringEnd
    extends RegexpNode {
        private StringEnd() {
        }

        @Override
        int match(StringValue string, int strlen, int offset, RegexpState state) {
            if (offset == strlen) {
                return offset;
            }
            return -1;
        }
    }

    private static class StringBegin
    extends RegexpNode {
        private StringBegin() {
        }

        @Override
        int match(StringValue string, int strlen, int offset, RegexpState state) {
            if (offset == state._start) {
                return offset;
            }
            return -1;
        }
    }

    static class StringIgnoreCase
    extends RegexpNode {
        private final char[] _buffer;
        private final int _length;

        StringIgnoreCase(CharBuffer value) {
            this._length = value.length();
            this._buffer = new char[this._length];
            if (this._length == 0) {
                throw new IllegalStateException("empty string");
            }
            System.arraycopy(value.getBuffer(), 0, this._buffer, 0, this._buffer.length);
        }

        StringIgnoreCase(char[] buffer, int length) {
            this._length = length;
            this._buffer = buffer;
            if (this._length == 0) {
                throw new IllegalStateException("empty string");
            }
        }

        StringIgnoreCase(char ch) {
            this._length = 1;
            this._buffer = new char[1];
            this._buffer[0] = ch;
        }

        @Override
        RegexpNode createLoop(Regcomp parser, int min, int max) {
            if (this._length == 1) {
                return new CharLoop(this, min, max);
            }
            char ch = this._buffer[this._length - 1];
            StringIgnoreCase head = new StringIgnoreCase(this._buffer, this._length - 1);
            StringIgnoreCase tail = new StringIgnoreCase(new char[]{ch}, 1);
            return head.concat(((RegexpNode)tail).createLoop(parser, min, max));
        }

        @Override
        RegexpNode createLoopUngreedy(Regcomp parser, int min, int max) {
            if (this._length == 1) {
                return new CharUngreedyLoop(this, min, max);
            }
            char ch = this._buffer[this._length - 1];
            StringIgnoreCase head = new StringIgnoreCase(this._buffer, this._length - 1);
            StringIgnoreCase tail = new StringIgnoreCase(new char[]{ch}, 1);
            return head.concat(((RegexpNode)tail).createLoopUngreedy(parser, min, max));
        }

        @Override
        RegexpNode createPossessiveLoop(int min, int max) {
            if (this._length == 1) {
                return super.createPossessiveLoop(min, max);
            }
            char ch = this._buffer[this._length - 1];
            StringIgnoreCase head = new StringIgnoreCase(this._buffer, this._length - 1);
            StringIgnoreCase tail = new StringIgnoreCase(new char[]{ch}, 1);
            return head.concat(((RegexpNode)tail).createPossessiveLoop(min, max));
        }

        @Override
        int minLength() {
            return this._length;
        }

        @Override
        int firstChar() {
            if (this._length > 0 && Character.toLowerCase(this._buffer[0]) == Character.toUpperCase(this._buffer[0])) {
                return this._buffer[0];
            }
            return -1;
        }

        @Override
        boolean[] firstSet(boolean[] firstSet) {
            if (this._length > 0 && firstSet != null) {
                char lower = Character.toLowerCase(this._buffer[0]);
                char upper = Character.toUpperCase(this._buffer[0]);
                if (lower < firstSet.length && upper < firstSet.length) {
                    firstSet[lower] = true;
                    firstSet[upper] = true;
                    return firstSet;
                }
            }
            return null;
        }

        @Override
        String prefix() {
            return new String(this._buffer, 0, this._length);
        }

        @Override
        int match(StringValue string, int strlen, int offset, RegexpState state) {
            if (string.regionMatchesIgnoreCase(offset, this._buffer, 0, this._length)) {
                return offset + this._length;
            }
            return -1;
        }
    }

    static final class StringNode
    extends RegexpNode {
        private final char[] _buffer;
        private final int _length;

        StringNode(CharBuffer value) {
            this._length = value.length();
            this._buffer = new char[this._length];
            if (this._length == 0) {
                throw new IllegalStateException("empty string");
            }
            System.arraycopy(value.getBuffer(), 0, this._buffer, 0, this._buffer.length);
        }

        StringNode(char[] buffer, int length) {
            this._length = length;
            this._buffer = buffer;
            if (this._length == 0) {
                throw new IllegalStateException("empty string");
            }
        }

        StringNode(char ch) {
            this._length = 1;
            this._buffer = new char[1];
            this._buffer[0] = ch;
        }

        @Override
        RegexpNode createLoop(Regcomp parser, int min, int max) {
            if (this._length == 1) {
                return new CharLoop(this, min, max);
            }
            char ch = this._buffer[this._length - 1];
            StringNode head = new StringNode(this._buffer, this._length - 1);
            return head.concat(new CharNode(ch).createLoop(parser, min, max));
        }

        @Override
        RegexpNode createLoopUngreedy(Regcomp parser, int min, int max) {
            if (this._length == 1) {
                return new CharUngreedyLoop(this, min, max);
            }
            char ch = this._buffer[this._length - 1];
            StringNode head = new StringNode(this._buffer, this._length - 1);
            return head.concat(new CharNode(ch).createLoopUngreedy(parser, min, max));
        }

        @Override
        RegexpNode createPossessiveLoop(int min, int max) {
            if (this._length == 1) {
                return super.createPossessiveLoop(min, max);
            }
            char ch = this._buffer[this._length - 1];
            StringNode head = new StringNode(this._buffer, this._length - 1);
            return head.concat(new CharNode(ch).createPossessiveLoop(min, max));
        }

        @Override
        int minLength() {
            return this._length;
        }

        @Override
        int firstChar() {
            if (this._length > 0) {
                return this._buffer[0];
            }
            return -1;
        }

        @Override
        boolean[] firstSet(boolean[] firstSet) {
            if (firstSet != null && this._length > 0 && this._buffer[0] < firstSet.length) {
                firstSet[this._buffer[0]] = true;
                return firstSet;
            }
            return null;
        }

        @Override
        String prefix() {
            return new String(this._buffer, 0, this._length);
        }

        @Override
        final int match(StringValue string, int strlen, int offset, RegexpState state) {
            if (string.regionMatches(offset, this._buffer, 0, this._length)) {
                return offset + this._length;
            }
            return -1;
        }

        @Override
        protected void toString(StringBuilder sb, Map<RegexpNode, Integer> map) {
            sb.append(this.toStringName());
            sb.append("[");
            sb.append(this._buffer, 0, this._length);
            sb.append("]");
        }
    }

    static class NotSet
    extends AbstractCharNode {
        private final boolean[] _asciiSet;
        private final IntSet _range;

        NotSet(boolean[] set, IntSet range) {
            this._asciiSet = set;
            this._range = range;
        }

        @Override
        int match(StringValue string, int strlen, int offset, RegexpState state) {
            if (strlen <= offset) {
                return -1;
            }
            char ch = string.charAt(offset);
            if (ch < '\u0080') {
                return this._asciiSet[ch] ? -1 : offset + 1;
            }
            return this._range.contains(ch) ? -1 : offset + 1;
        }
    }

    static class Set
    extends AbstractCharNode {
        private final boolean[] _asciiSet;
        private final IntSet _range;

        Set(boolean[] set, IntSet range) {
            this._asciiSet = set;
            this._range = range;
        }

        @Override
        int match(StringValue string, int strlen, int offset, RegexpState state) {
            char low;
            int ch;
            if (strlen <= offset) {
                return -1;
            }
            if ((ch = string.charAt(offset++)) < 128) {
                return this._asciiSet[ch] ? offset : -1;
            }
            int codePoint = ch;
            if (55296 <= ch && ch <= 56319 && offset < strlen && '\udc00' <= (low = string.charAt(offset++)) && ch <= 57343) {
                codePoint = Character.toCodePoint((char)ch, low);
            }
            return this._range.contains(codePoint) ? offset : -1;
        }
    }

    static class Subroutine
    extends RegexpNode {
        private final int _group;
        private final RegexpNode _node;

        Subroutine(int group, RegexpNode node) {
            this._group = group;
            this._node = node;
        }

        @Override
        int match(StringValue string, int length, int offset, RegexpState state) {
            state.setFinalized(this._group, true);
            int match = this._node.match(string, length, offset, state);
            return match;
        }
    }

    static class GroupNameRecursive
    extends RegexpNode {
        private final StringValue _name;
        private RegexpNode _top;

        GroupNameRecursive(StringValue name) {
            this._name = name;
        }

        StringValue getGroup() {
            return this._name;
        }

        void setTop(RegexpNode top) {
            this._top = top;
        }

        @Override
        int match(StringValue string, int length, int offset, RegexpState state) {
            int match = this._top.match(string, length, offset, state);
            return match;
        }
    }

    static class GroupNumberRecursive
    extends RegexpNode {
        private final int _group;
        private RegexpNode _top;

        GroupNumberRecursive(int group) {
            this._group = group;
        }

        int getGroup() {
            return this._group;
        }

        void setTop(RegexpNode top) {
            this._top = top;
        }

        @Override
        int match(StringValue string, int length, int offset, RegexpState state) {
            int match = this._top.match(string, length, offset, state);
            return match;
        }
    }

    static class Recursive
    extends RegexpNode {
        private final int _group;
        private RegexpNode _top;

        Recursive(int group) {
            this._group = group;
        }

        void setTop(RegexpNode top) {
            this._top = top;
        }

        @Override
        int match(StringValue string, int length, int offset, RegexpState state) {
            int oldBegin = state.getBegin(this._group);
            int match = this._top.match(string, length, offset, state);
            if (match >= 0) {
                if (oldBegin >= 0) {
                    state.setBegin(this._group, oldBegin);
                } else {
                    state.setBegin(this._group, offset);
                }
            }
            return match;
        }
    }

    static class PropNotZ
    extends AbstractCharNode {
        PropNotZ() {
        }

        @Override
        int match(StringValue string, int strlen, int offset, RegexpState state) {
            char ch;
            int value;
            if (offset < strlen && (value = Character.getType(ch = string.charAt(offset))) != 13 && value != 14 && value != 12) {
                return offset + 1;
            }
            return -1;
        }
    }

    static class PropZ
    extends AbstractCharNode {
        PropZ() {
        }

        @Override
        int match(StringValue string, int strlen, int offset, RegexpState state) {
            char ch;
            int value;
            if (offset < strlen && ((value = Character.getType(ch = string.charAt(offset))) == 13 || value == 14 || value == 12)) {
                return offset + 1;
            }
            return -1;
        }
    }

    static class PropNotS
    extends AbstractCharNode {
        PropNotS() {
        }

        @Override
        int match(StringValue string, int strlen, int offset, RegexpState state) {
            char ch;
            int value;
            if (offset < strlen && (value = Character.getType(ch = string.charAt(offset))) != 26 && value != 27 && value != 25 && value != 28) {
                return offset + 1;
            }
            return -1;
        }
    }

    static class PropS
    extends AbstractCharNode {
        PropS() {
        }

        @Override
        int match(StringValue string, int strlen, int offset, RegexpState state) {
            char ch;
            int value;
            if (offset < strlen && ((value = Character.getType(ch = string.charAt(offset))) == 26 || value == 27 || value == 25 || value == 28)) {
                return offset + 1;
            }
            return -1;
        }
    }

    static class PropNotP
    extends AbstractCharNode {
        PropNotP() {
        }

        @Override
        int match(StringValue string, int strlen, int offset, RegexpState state) {
            char ch;
            int value;
            if (offset < strlen && (value = Character.getType(ch = string.charAt(offset))) != 23 && value != 20 && value != 22 && value != 30 && value != 29 && value != 24 && value != 21) {
                return offset + 1;
            }
            return -1;
        }
    }

    static class PropP
    extends AbstractCharNode {
        PropP() {
        }

        @Override
        int match(StringValue string, int strlen, int offset, RegexpState state) {
            char ch;
            int value;
            if (offset < strlen && ((value = Character.getType(ch = string.charAt(offset))) == 23 || value == 20 || value == 22 || value == 30 || value == 29 || value == 24 || value == 21)) {
                return offset + 1;
            }
            return -1;
        }
    }

    static class PropNotN
    extends AbstractCharNode {
        PropNotN() {
        }

        @Override
        int match(StringValue string, int strlen, int offset, RegexpState state) {
            char ch;
            int value;
            if (offset < strlen && (value = Character.getType(ch = string.charAt(offset))) != 9 && value != 10 && value != 11) {
                return offset + 1;
            }
            return -1;
        }
    }

    static class PropN
    extends AbstractCharNode {
        PropN() {
        }

        @Override
        int match(StringValue string, int strlen, int offset, RegexpState state) {
            char ch;
            int value;
            if (offset < strlen && ((value = Character.getType(ch = string.charAt(offset))) == 9 || value == 10 || value == 11)) {
                return offset + 1;
            }
            return -1;
        }
    }

    static class PropNotM
    extends AbstractCharNode {
        PropNotM() {
        }

        @Override
        int match(StringValue string, int strlen, int offset, RegexpState state) {
            char ch;
            int value;
            if (offset < strlen && (value = Character.getType(ch = string.charAt(offset))) != 8 && value != 7 && value != 6) {
                return offset + 1;
            }
            return -1;
        }
    }

    static class PropM
    extends AbstractCharNode {
        PropM() {
        }

        @Override
        int match(StringValue string, int strlen, int offset, RegexpState state) {
            char ch;
            int value;
            if (offset < strlen && ((value = Character.getType(ch = string.charAt(offset))) == 8 || value == 7 || value == 6)) {
                return offset + 1;
            }
            return -1;
        }
    }

    static class PropNotL
    extends AbstractCharNode {
        PropNotL() {
        }

        @Override
        int match(StringValue string, int strlen, int offset, RegexpState state) {
            char ch;
            int value;
            if (offset < strlen && (value = Character.getType(ch = string.charAt(offset))) != 2 && value != 4 && value != 5 && value != 3 && value != 1) {
                return offset + 1;
            }
            return -1;
        }
    }

    static class PropL
    extends AbstractCharNode {
        PropL() {
        }

        @Override
        int match(StringValue string, int strlen, int offset, RegexpState state) {
            char ch;
            int value;
            if (offset < strlen && ((value = Character.getType(ch = string.charAt(offset))) == 2 || value == 4 || value == 5 || value == 3 || value == 1)) {
                return offset + 1;
            }
            return -1;
        }
    }

    static class PropNotC
    extends AbstractCharNode {
        PropNotC() {
        }

        @Override
        int match(StringValue string, int strlen, int offset, RegexpState state) {
            char ch;
            int value;
            if (offset < strlen && (value = Character.getType(ch = string.charAt(offset))) != 15 && value != 16 && value != 0 && value != 18 && value != 19) {
                return offset + 1;
            }
            return -1;
        }
    }

    static class PropC
    extends AbstractCharNode {
        PropC() {
        }

        @Override
        int match(StringValue string, int strlen, int offset, RegexpState state) {
            char ch;
            int value;
            if (offset < strlen && ((value = Character.getType(ch = string.charAt(offset))) == 15 || value == 16 || value == 0 || value == 18 || value == 19)) {
                return offset + 1;
            }
            return -1;
        }
    }

    private static class PropNot
    extends AbstractCharNode {
        private final int _category;

        PropNot(int category) {
            this._category = category;
        }

        @Override
        int match(StringValue string, int strlen, int offset, RegexpState state) {
            char ch;
            if (offset < strlen && Character.getType(ch = string.charAt(offset)) != this._category) {
                return offset + 1;
            }
            return -1;
        }
    }

    private static class Prop
    extends AbstractCharNode {
        private final int _category;

        Prop(int category) {
            this._category = category;
        }

        @Override
        int match(StringValue string, int strlen, int offset, RegexpState state) {
            char ch;
            if (offset < strlen && Character.getType(ch = string.charAt(offset)) == this._category) {
                return offset + 1;
            }
            return -1;
        }
    }

    static class PossessiveLoop
    extends RegexpNode {
        private RegexpNode _node;
        private RegexpNode _next = N_END;
        private int _min;
        private int _max;

        private PossessiveLoop(int min, int max) {
            this._min = min;
            this._max = max;
        }

        PossessiveLoop(RegexpNode node, int min, int max) {
            this._node = node.getHead();
            this._min = min;
            this._max = max;
        }

        @Override
        RegexpNode copyImpl(HashMap<RegexpNode, RegexpNode> state) {
            PossessiveLoop copy = new PossessiveLoop(this._min, this._max);
            state.put(this, copy);
            RegexpNode node = this._node.copy(state);
            RegexpNode next = this._next.copy(state);
            copy._node = node;
            copy._next = next;
            return copy;
        }

        @Override
        RegexpNode concat(RegexpNode next) {
            if (next == null) {
                throw new NullPointerException();
            }
            this._next = this._next != null ? this._next.concat(next) : next;
            return this;
        }

        @Override
        RegexpNode createLoop(Regcomp parser, int min, int max) {
            if (min == 0 && max == 1) {
                this._min = 0;
                return this;
            }
            return new LoopHead(parser, this, min, max);
        }

        @Override
        int match(StringValue string, int strlen, int offset, RegexpState state) {
            int i;
            RegexpNode node = this._node;
            int min = this._min;
            int max = this._max;
            for (i = 0; i < min; ++i) {
                if ((offset = node.match(string, strlen, offset, state)) >= 0) continue;
                return -1;
            }
            while (i < max) {
                int tail = node.match(string, strlen, offset, state);
                if (tail < 0 || tail == offset) {
                    return this._next.match(string, strlen, offset, state);
                }
                offset = tail;
                ++i;
            }
            return this._next.match(string, strlen, offset, state);
        }

        @Override
        public String toString() {
            return "PossessiveLoop[" + this._min + ", " + this._max + ", " + this._node + ", " + this._next + "]";
        }
    }

    static final class Or
    extends RegexpNode {
        private final RegexpNode _left;
        private Or _right;

        private Or(RegexpNode left, Or right) {
            this._left = left;
            this._right = right;
        }

        static Or create(RegexpNode left, RegexpNode right) {
            if (left instanceof Or) {
                return ((Or)left).append(right);
            }
            if (right instanceof Or) {
                return new Or(left, (Or)right);
            }
            return new Or(left, new Or(right, null));
        }

        private Or append(RegexpNode right) {
            this._right = this._right != null ? this._right.append(right) : (right instanceof Or ? (Or)right : new Or(right, null));
            return this;
        }

        @Override
        RegexpNode copyImpl(HashMap<RegexpNode, RegexpNode> state) {
            RegexpNode left = this._left.copy(state);
            RegexpNode right = null;
            if (this._right != null) {
                right = this._right.copy(state);
            }
            Or copy = new Or(left, (Or)right);
            return copy;
        }

        @Override
        int minLength() {
            if (this._right != null) {
                return Math.min(this._left.minLength(), this._right.minLength());
            }
            return this._left.minLength();
        }

        @Override
        int firstChar() {
            int rightChar;
            if (this._right == null) {
                return this._left.firstChar();
            }
            int leftChar = this._left.firstChar();
            if (leftChar == (rightChar = this._right.firstChar())) {
                return leftChar;
            }
            return -1;
        }

        @Override
        boolean[] firstSet(boolean[] firstSet) {
            if (this._right == null) {
                return this._left.firstSet(firstSet);
            }
            firstSet = this._left.firstSet(firstSet);
            firstSet = this._right.firstSet(firstSet);
            return firstSet;
        }

        @Override
        boolean isAnchorBegin() {
            return this._left.isAnchorBegin() && this._right != null && this._right.isAnchorBegin();
        }

        @Override
        int match(StringValue string, int strlen, int offset, RegexpState state) {
            Or ptr = this;
            while (ptr != null) {
                int value = ptr._left.match(string, strlen, offset, state);
                if (value >= 0) {
                    return value;
                }
                ptr = ptr._right;
            }
            return -1;
        }

        @Override
        protected void toString(StringBuilder sb, Map<RegexpNode, Integer> map) {
            if (this.toStringAdd(sb, map)) {
                return;
            }
            sb.append(this.toStringName());
            sb.append("[");
            this._left.toString(sb, map);
            Or ptr = this._right;
            while (ptr != null) {
                sb.append(",");
                ptr._left.toString(sb, map);
                ptr = ptr._right;
            }
            sb.append("]");
        }

        @Override
        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append("Or[");
            sb.append(this._left);
            Or ptr = this._right;
            while (ptr != null) {
                sb.append(",");
                sb.append(ptr._left);
                ptr = ptr._right;
            }
            sb.append("]");
            return sb.toString();
        }
    }

    static class Not
    extends RegexpNode {
        private RegexpNode _node;

        private Not(RegexpNode node) {
            this._node = node;
        }

        static Not create(RegexpNode node) {
            return new Not(node);
        }

        @Override
        int match(StringValue string, int strlen, int offset, RegexpState state) {
            int result = this._node.match(string, strlen, offset, state);
            if (result >= 0) {
                return -1;
            }
            return offset + 1;
        }
    }

    static class LoopTailUngreedy
    extends RegexpNode {
        private final int _index;
        private LoopHeadUngreedy _head;
        private RegexpNode _next;

        private LoopTailUngreedy(int index) {
            this._index = index;
        }

        LoopTailUngreedy(int index, LoopHeadUngreedy head) {
            this._index = index;
            this._head = head;
            this._next = N_END;
        }

        @Override
        RegexpNode getHead() {
            return this._head;
        }

        @Override
        RegexpNode copyImpl(HashMap<RegexpNode, RegexpNode> state) {
            LoopTailUngreedy copy = new LoopTailUngreedy(this._index);
            state.put(this, copy);
            RegexpNode head = this._head.copy(state);
            RegexpNode next = this._next.copy(state);
            copy._head = (LoopHeadUngreedy)head;
            copy._next = next;
            return copy;
        }

        @Override
        RegexpNode concat(RegexpNode next) {
            this._next = this._next != null ? this._next.concat(next) : next;
            if (this._next == this) {
                throw new IllegalStateException();
            }
            return this;
        }

        @Override
        int match(StringValue string, int strlen, int offset, RegexpState state) {
            int i = state._loopCount[this._index];
            int oldOffset = state._loopOffset[this._index];
            if (i < this._head._min) {
                return offset;
            }
            if (offset == oldOffset) {
                return -1;
            }
            int tail = this._next.match(string, strlen, offset, state);
            if (tail >= 0) {
                return tail;
            }
            if (i + 1 < this._head._max) {
                state._loopCount[this._index] = i + 1;
                state._loopOffset[this._index] = offset;
                tail = this._head._node.match(string, strlen, offset, state);
                state._loopCount[this._index] = i;
                state._loopOffset[this._index] = oldOffset;
                return tail;
            }
            return -1;
        }

        @Override
        public String toString() {
            return "LoopTailUngreedy[" + this._next + "]";
        }
    }

    static class LoopHeadUngreedy
    extends RegexpNode {
        private final int _index;
        RegexpNode _node;
        private LoopTailUngreedy _tail;
        private int _min;
        private int _max;

        private LoopHeadUngreedy(int index, int min, int max) {
            this._index = index;
            this._min = min;
            this._max = max;
        }

        LoopHeadUngreedy(Regcomp parser, RegexpNode node, int min, int max) {
            this._index = parser.nextLoopIndex();
            this._min = min;
            this._max = max;
            this._tail = new LoopTailUngreedy(this._index, this);
            this._node = node.getTail().concat(this._tail).getHead();
        }

        @Override
        RegexpNode getTail() {
            return this._tail;
        }

        @Override
        RegexpNode copyImpl(HashMap<RegexpNode, RegexpNode> state) {
            LoopHeadUngreedy copy = new LoopHeadUngreedy(this._index, this._min, this._max);
            state.put(this, copy);
            RegexpNode tail = this._tail.copy(state);
            RegexpNode node = this._node.copy(state);
            copy._tail = (LoopTailUngreedy)tail;
            copy._node = node;
            return copy;
        }

        @Override
        RegexpNode concat(RegexpNode next) {
            this._tail.concat(next);
            return this;
        }

        @Override
        RegexpNode createLoop(Regcomp parser, int min, int max) {
            if (min == 0 && max == 1) {
                this._min = 0;
                return this;
            }
            return new LoopHead(parser, this, min, max);
        }

        @Override
        int minLength() {
            return this._min * this._node.minLength() + this._tail.minLength();
        }

        @Override
        int match(StringValue string, int strlen, int offset, RegexpState state) {
            state._loopCount[this._index] = 0;
            RegexpNode node = this._node;
            int min = this._min;
            int i = 0;
            while (i < min) {
                state._loopCount[this._index] = i++;
                state._loopOffset[this._index] = offset;
                if ((offset = node.match(string, strlen, offset, state)) >= 0) continue;
                return -1;
            }
            int tail = this._tail._next.match(string, strlen, offset, state);
            if (tail >= 0) {
                return tail;
            }
            if (min < this._max) {
                state._loopCount[this._index] = min;
                state._loopOffset[this._index] = offset;
                return node.match(string, strlen, offset, state);
            }
            return -1;
        }

        @Override
        public String toString() {
            return "LoopHeadUngreedy[" + this._min + ", " + this._max + ", " + this._node + "]";
        }
    }

    static class LoopTail
    extends RegexpNode {
        private final int _index;
        private LoopHead _head;
        private RegexpNode _next;

        private LoopTail(int index) {
            this._index = index;
        }

        LoopTail(int index, LoopHead head) {
            this._index = index;
            this._head = head;
            this._next = N_END;
        }

        @Override
        RegexpNode getHead() {
            return this._head;
        }

        @Override
        RegexpNode copyImpl(HashMap<RegexpNode, RegexpNode> state) {
            LoopTail tail = new LoopTail(this._index);
            state.put(this, tail);
            LoopHead head = (LoopHead)this._head.copy(state);
            RegexpNode next = this._next.copy(state);
            tail._head = head;
            tail._next = next;
            return tail;
        }

        @Override
        RegexpNode concat(RegexpNode next) {
            this._next = this._next != null ? this._next.concat(next) : next;
            if (this._next == this) {
                throw new IllegalStateException();
            }
            return this;
        }

        @Override
        int match(StringValue string, int strlen, int offset, RegexpState state) {
            int oldOffset;
            int oldCount = state._loopCount[this._index];
            if (oldCount + 1 < this._head._min) {
                return offset;
            }
            if (oldCount + 1 < this._head._max && (oldOffset = state._loopOffset[this._index]) != offset) {
                state._loopCount[this._index] = oldCount + 1;
                state._loopOffset[this._index] = offset;
                int tail = this._head._node.match(string, strlen, offset, state);
                if (tail >= 0) {
                    return tail;
                }
                state._loopCount[this._index] = oldCount;
                state._loopOffset[this._index] = oldOffset;
            }
            int match = this._next.match(string, strlen, offset, state);
            return match;
        }

        @Override
        public String toString() {
            return "LoopTail[" + this._next + "]";
        }
    }

    static class LoopHead
    extends RegexpNode {
        private final int _index;
        RegexpNode _node;
        private RegexpNode _tail;
        private int _min;
        private int _max;

        private LoopHead(int index, int min, int max) {
            this._index = index;
            this._min = min;
            this._max = max;
        }

        LoopHead(Regcomp parser, RegexpNode node, int min, int max) {
            this._index = parser.nextLoopIndex();
            this._tail = new LoopTail(this._index, this);
            this._node = node.concat(this._tail).getHead();
            this._min = min;
            this._max = max;
        }

        @Override
        RegexpNode getTail() {
            return this._tail;
        }

        @Override
        RegexpNode copyImpl(HashMap<RegexpNode, RegexpNode> state) {
            LoopHead head = new LoopHead(this._index, this._min, this._max);
            state.put(this, head);
            RegexpNode node = this._node.copy(state);
            RegexpNode tail = this._tail.copy(state);
            head._node = node;
            head._tail = tail;
            return head;
        }

        @Override
        RegexpNode concat(RegexpNode next) {
            this._tail.concat(next);
            return this;
        }

        @Override
        RegexpNode createLoop(Regcomp parser, int min, int max) {
            if (min == 0 && max == 1) {
                this._min = 0;
                return this;
            }
            return new LoopHead(parser, this, min, max);
        }

        @Override
        int minLength() {
            return this._min * this._node.minLength() + this._tail.minLength();
        }

        @Override
        boolean[] firstSet(boolean[] firstSet) {
            firstSet = this._node.firstSet(firstSet);
            if (this._min > 0 && !this._node.isNullable()) {
                return firstSet;
            }
            firstSet = this._tail.firstSet(firstSet);
            return firstSet;
        }

        @Override
        int match(StringValue string, int strlen, int offset, RegexpState state) {
            state._loopCount[this._index] = 0;
            RegexpNode node = this._node;
            int min = this._min;
            int i = 0;
            while (i < min - 1) {
                state._loopCount[this._index] = i++;
                if ((offset = node.match(string, strlen, offset, state)) >= 0) continue;
                return offset;
            }
            state._loopCount[this._index] = i;
            state._loopOffset[this._index] = offset;
            int tail = node.match(string, strlen, offset, state);
            if (tail >= 0) {
                return tail;
            }
            if (state._loopCount[this._index] < this._min) {
                return tail;
            }
            return this._tail.match(string, strlen, offset, state);
        }

        @Override
        public String toString() {
            return "LoopHead[" + this._min + ", " + this._max + ", " + this._node + "]";
        }
    }

    static abstract class NullableNode
    extends RegexpNode {
        NullableNode() {
        }

        @Override
        boolean isNullable() {
            return true;
        }
    }

    static class NotLookbehind
    extends RegexpNode {
        private final RegexpNode _head;

        NotLookbehind(RegexpNode head) {
            this._head = head;
        }

        @Override
        int match(StringValue string, int strlen, int offset, RegexpState state) {
            int length = this._head.minLength();
            if (offset < length) {
                return offset;
            }
            if (this._head.match(string, strlen, offset - length, state) < 0) {
                return offset;
            }
            return -1;
        }
    }

    static class Lookbehind
    extends RegexpNode {
        private final RegexpNode _head;

        Lookbehind(RegexpNode head) {
            this._head = head.getHead();
        }

        @Override
        int match(StringValue string, int strlen, int offset, RegexpState state) {
            int length = this._head.minLength();
            if (offset < length) {
                return -1;
            }
            if (this._head.match(string, strlen, offset - length, state) >= 0) {
                return offset;
            }
            return -1;
        }
    }

    static class NotLookahead
    extends RegexpNode {
        private final RegexpNode _head;

        NotLookahead(RegexpNode head) {
            this._head = head;
        }

        @Override
        int match(StringValue string, int length, int offset, RegexpState state) {
            if (this._head.match(string, length, offset, state) < 0) {
                return offset;
            }
            return -1;
        }
    }

    static class Lookahead
    extends RegexpNode {
        private final RegexpNode _head;

        Lookahead(RegexpNode head) {
            this._head = head;
        }

        @Override
        int match(StringValue string, int length, int offset, RegexpState state) {
            if (this._head.match(string, length, offset, state) >= 0) {
                return offset;
            }
            return -1;
        }
    }

    static class GroupRef
    extends RegexpNode {
        private final int _group;

        GroupRef(int group) {
            this._group = group;
        }

        @Override
        int match(StringValue string, int length, int offset, RegexpState state) {
            int groupLength;
            if (state.getLength() < this._group) {
                return -1;
            }
            int groupBegin = state.getBegin(this._group);
            if (string.regionMatches(offset, string, groupBegin, groupLength = state.getEnd(this._group) - groupBegin)) {
                return offset + groupLength;
            }
            return -1;
        }
    }

    static class GroupTail
    extends RegexpNode {
        private GroupHead _head;
        private RegexpNode _next;
        private final int _group;

        private GroupTail(int group) {
            this._group = group;
        }

        private GroupTail(int group, GroupHead head) {
            this._next = N_END;
            this._head = head;
            this._group = group;
        }

        @Override
        RegexpNode getHead() {
            return this._head;
        }

        @Override
        RegexpNode copyImpl(HashMap<RegexpNode, RegexpNode> state) {
            GroupHead head;
            GroupTail tail = new GroupTail(this._group);
            state.put(this, tail);
            tail._head = head = (GroupHead)this._head.copy(state);
            tail._next = this._next.copy(state);
            return tail;
        }

        @Override
        RegexpNode concat(RegexpNode next) {
            this._next = this._next != null ? this._next.concat(next) : next;
            return this._head;
        }

        @Override
        RegexpNode createLoop(Regcomp parser, int min, int max) {
            LoopHead head = new LoopHead(parser, this._head, min, max);
            this._next = head.getTail();
            return head;
        }

        @Override
        RegexpNode createLoopUngreedy(Regcomp parser, int min, int max) {
            LoopHeadUngreedy head = new LoopHeadUngreedy(parser, this._head, min, max);
            this._next = head.getTail();
            return head;
        }

        @Override
        int minLength() {
            return this._next.minLength();
        }

        @Override
        int match(StringValue string, int length, int offset, RegexpState state) {
            int tail;
            if (state.isFinalized(this._group)) {
                return this._next.match(string, length, offset, state);
            }
            int oldEnd = state.getEnd(this._group);
            int oldLength = state.getLength();
            if (this._group > 0) {
                state.setEnd(this._group, offset);
                if (oldLength < this._group) {
                    state.setLength(this._group);
                }
            }
            if ((tail = this._next.match(string, length, offset, state)) < 0) {
                state.setEnd(this._group, oldEnd);
                state.setLength(oldLength);
                return -1;
            }
            return tail;
        }

        @Override
        protected void toString(StringBuilder sb, Map<RegexpNode, Integer> map) {
            if (this.toStringAdd(sb, map)) {
                return;
            }
            sb.append(this.toStringName());
            sb.append("[");
            sb.append(this._group);
            sb.append(", ");
            this._next.toString(sb, map);
            sb.append("]");
        }
    }

    static class GroupHead
    extends RegexpNode {
        private RegexpNode _node;
        private GroupTail _tail;
        private int _group;

        private GroupHead() {
        }

        GroupHead(int group) {
            this._group = group;
            this._tail = new GroupTail(group, this);
        }

        void setNode(RegexpNode node) {
            this._node = node.getHead();
            if (this._node == this) {
                this._node = this._tail;
            }
        }

        @Override
        RegexpNode getTail() {
            return this._tail;
        }

        RegexpNode getNode() {
            return this._node;
        }

        @Override
        RegexpNode copyImpl(HashMap<RegexpNode, RegexpNode> state) {
            GroupHead copy = new GroupHead();
            state.put(this, copy);
            copy._group = this._group;
            if (this._node == this) {
                copy._node = copy;
            } else if (this._node != null) {
                copy._node = this._node.copy(state);
            }
            copy._tail = (GroupTail)this._tail.copy(state);
            return copy;
        }

        @Override
        RegexpNode concat(RegexpNode next) {
            this._tail.concat(next);
            return this;
        }

        @Override
        RegexpNode createLoop(Regcomp parser, int min, int max) {
            return this._tail.createLoop(parser, min, max);
        }

        @Override
        RegexpNode createLoopUngreedy(Regcomp parser, int min, int max) {
            return this._tail.createLoopUngreedy(parser, min, max);
        }

        @Override
        int minLength() {
            return this._node.minLength();
        }

        @Override
        int firstChar() {
            return this._node.firstChar();
        }

        @Override
        boolean[] firstSet(boolean[] firstSet) {
            return this._node.firstSet(firstSet);
        }

        @Override
        String prefix() {
            return this._node.prefix();
        }

        @Override
        boolean isAnchorBegin() {
            return this._node.isAnchorBegin();
        }

        @Override
        int match(StringValue string, int length, int offset, RegexpState state) {
            int oldBegin = state.getBegin(this._group);
            state.setBegin(this._group, offset);
            int tail = this._node.match(string, length, offset, state);
            if (tail >= 0) {
                return tail;
            }
            state.setBegin(this._group, oldBegin);
            return tail;
        }

        @Override
        protected void toString(StringBuilder sb, Map<RegexpNode, Integer> map) {
            if (this.toStringAdd(sb, map)) {
                return;
            }
            sb.append(this.toStringName());
            sb.append("[");
            sb.append(this._group);
            sb.append(", ");
            this._node.toString(sb, map);
            sb.append("]");
        }
    }

    static class Group
    extends RegexpNode {
        private final RegexpNode _node;
        private final int _group;

        Group(RegexpNode node, int group) {
            this._node = node.getHead();
            this._group = group;
        }

        @Override
        int match(StringValue string, int length, int offset, RegexpState state) {
            int oldBegin = state.getBegin(this._group);
            state.setBegin(this._group, offset);
            int tail = this._node.match(string, length, offset, state);
            if (tail >= 0) {
                state.setEnd(this._group, tail);
                return tail;
            }
            state.setBegin(this._group, oldBegin);
            return -1;
        }
    }

    static class End
    extends RegexpNode {
        End() {
        }

        @Override
        RegexpNode concat(RegexpNode next) {
            return next;
        }

        @Override
        int match(StringValue string, int length, int offset, RegexpState state) {
            return offset;
        }
    }

    static class EmptyNode
    extends RegexpNode {
        EmptyNode() {
        }

        @Override
        int match(StringValue string, int length, int offset, RegexpState state) {
            return offset;
        }
    }

    static class ConditionalTail
    extends RegexpNode {
        private RegexpNode _head;
        private RegexpNode _next;

        private ConditionalTail() {
        }

        ConditionalTail(ConditionalHead head) {
            this._next = N_END;
            this._head = head;
            head.setTail(this);
        }

        @Override
        RegexpNode getHead() {
            return this._head;
        }

        @Override
        RegexpNode copyImpl(HashMap<RegexpNode, RegexpNode> state) {
            ConditionalTail copy = new ConditionalTail();
            state.put(this, copy);
            copy._head = this._head.copy(state);
            copy._next = this._next.copy(state);
            return copy;
        }

        @Override
        RegexpNode concat(RegexpNode next) {
            this._next = this._next != null ? this._next.concat(next) : next;
            return this._head;
        }

        @Override
        RegexpNode createLoop(Regcomp parser, int min, int max) {
            LoopHead head = new LoopHead(parser, this._head, min, max);
            this._next = this._next.concat(head.getTail());
            return head;
        }

        @Override
        RegexpNode createLoopUngreedy(Regcomp parser, int min, int max) {
            LoopHeadUngreedy head = new LoopHeadUngreedy(parser, this._head, min, max);
            this._next = this._next.concat(head.getTail());
            return head;
        }

        @Override
        RegexpNode createOr(RegexpNode node) {
            this._next = this._next.createOr(node);
            return this.getHead();
        }

        @Override
        int match(StringValue string, int length, int offset, RegexpState state) {
            return this._next.match(string, length, offset, state);
        }
    }

    static class GroupConditionalHead
    extends ConditionalHead {
        private final int _group;

        GroupConditionalHead(int group) {
            this._group = group;
        }

        @Override
        RegexpNode copyImpl(HashMap<RegexpNode, RegexpNode> state) {
            GroupConditionalHead copy = new GroupConditionalHead(this._group);
            state.put(this, copy);
            copy._first = this._first.copy(state);
            copy._second = this._second.copy(state);
            copy._tail = this._tail.copy(state);
            return copy;
        }

        @Override
        int match(StringValue string, int length, int offset, RegexpState state) {
            int begin = state.getBegin(this._group);
            int end = state.getEnd(this._group);
            if (this._group <= state.getLength() && begin >= 0 && begin <= end) {
                int match = this._first.match(string, length, offset, state);
                return match;
            }
            if (this._second != null) {
                return this._second.match(string, length, offset, state);
            }
            return this._tail.match(string, length, offset, state);
        }

        @Override
        public String toString() {
            return this.getClass().getSimpleName() + "[" + this._group + "," + this._first + "," + this._tail + "]";
        }
    }

    static class GenericConditionalHead
    extends ConditionalHead {
        private final RegexpNode _conditional;

        GenericConditionalHead(RegexpNode conditional) {
            this._conditional = conditional;
        }

        @Override
        RegexpNode copyImpl(HashMap<RegexpNode, RegexpNode> state) {
            RegexpNode conditional = this._conditional.copy(state);
            GenericConditionalHead copy = new GenericConditionalHead(conditional);
            state.put(this, copy);
            copy._first = this._first.copy(state);
            copy._second = this._second.copy(state);
            copy._tail = this._tail.copy(state);
            return copy;
        }

        @Override
        int match(StringValue string, int length, int offset, RegexpState state) {
            if (this._conditional.match(string, length, offset, state) >= 0) {
                int match = this._first.match(string, length, offset, state);
                return match;
            }
            if (this._second != null) {
                return this._second.match(string, length, offset, state);
            }
            return this._tail.match(string, length, offset, state);
        }

        @Override
        public String toString() {
            return this.getClass().getSimpleName() + "[" + this._conditional + "," + this._first + "," + this._tail + "]";
        }
    }

    static abstract class ConditionalHead
    extends RegexpNode {
        protected RegexpNode _first;
        protected RegexpNode _second;
        protected RegexpNode _tail = new ConditionalTail(this);

        ConditionalHead() {
        }

        void setFirst(RegexpNode first) {
            this._first = first;
        }

        void setSecond(RegexpNode second) {
            this._second = second;
        }

        void setTail(RegexpNode tail) {
            this._tail = tail;
        }

        @Override
        RegexpNode getTail() {
            return this._tail;
        }

        @Override
        RegexpNode concat(RegexpNode next) {
            this._tail.concat(next);
            return this;
        }

        @Override
        RegexpNode createLoop(Regcomp parser, int min, int max) {
            return this._tail.createLoop(parser, min, max);
        }

        @Override
        RegexpNode createOr(RegexpNode node) {
            return this._tail.createOr(node);
        }
    }

    static final class Concat
    extends RegexpNode {
        private final RegexpNode _head;
        private RegexpNode _next;

        Concat(RegexpNode head, RegexpNode next) {
            if (head == null || next == null) {
                throw new NullPointerException();
            }
            this._head = head;
            this._next = next;
        }

        @Override
        RegexpNode copyImpl(HashMap<RegexpNode, RegexpNode> state) {
            RegexpNode head = this._head.copy(state);
            RegexpNode next = this._next.copy(state);
            return new Concat(head, next);
        }

        @Override
        RegexpNode concat(RegexpNode next) {
            this._next = this._next.concat(next);
            return this;
        }

        @Override
        int minLength() {
            return this._head.minLength() + this._next.minLength();
        }

        @Override
        int firstChar() {
            return this._head.firstChar();
        }

        @Override
        boolean[] firstSet(boolean[] firstSet) {
            firstSet = this._head.firstSet(firstSet);
            if (this._head.isNullable()) {
                firstSet = this._next.firstSet(firstSet);
            }
            return firstSet;
        }

        @Override
        String prefix() {
            return this._head.prefix();
        }

        @Override
        boolean isAnchorBegin() {
            return this._head.isAnchorBegin();
        }

        RegexpNode getConcatHead() {
            return this._head;
        }

        RegexpNode getConcatNext() {
            return this._next;
        }

        @Override
        int match(StringValue string, int length, int offset, RegexpState state) {
            if ((offset = this._head.match(string, length, offset, state)) < 0) {
                return -1;
            }
            return this._next.match(string, length, offset, state);
        }

        @Override
        protected void toString(StringBuilder sb, Map<RegexpNode, Integer> map) {
            if (this.toStringAdd(sb, map)) {
                return;
            }
            sb.append(this.toStringName());
            sb.append("[");
            this._head.toString(sb, map);
            sb.append(", ");
            this._next.toString(sb, map);
            sb.append("]");
        }
    }

    static class CharUngreedyLoop
    extends RegexpNode {
        private final RegexpNode _node;
        private RegexpNode _next = N_END;
        private int _min;
        private int _max;

        CharUngreedyLoop(RegexpNode node, int min, int max) {
            this._node = node.getHead();
            this._min = min;
            this._max = max;
            if (this._min < 0) {
                throw new IllegalStateException();
            }
        }

        @Override
        RegexpNode copyImpl(HashMap<RegexpNode, RegexpNode> state) {
            RegexpNode next = this._next.copy(state);
            RegexpNode node = this._node.copy(state);
            CharUngreedyLoop copy = new CharUngreedyLoop(node, this._min, this._max);
            copy._next = next;
            return copy;
        }

        @Override
        RegexpNode concat(RegexpNode next) {
            if (next == null) {
                throw new NullPointerException();
            }
            this._next = this._next != null ? this._next.concat(next) : next.getHead();
            return this;
        }

        @Override
        RegexpNode createLoop(Regcomp parser, int min, int max) {
            if (min == 0 && max == 1) {
                this._min = 0;
                return this;
            }
            return new LoopHead(parser, this, min, max);
        }

        @Override
        int minLength() {
            return this._min;
        }

        @Override
        boolean[] firstSet(boolean[] firstSet) {
            firstSet = this._node.firstSet(firstSet);
            if (this._min > 0 && !this._node.isNullable()) {
                return firstSet;
            }
            firstSet = this._next.firstSet(firstSet);
            return firstSet;
        }

        @Override
        int match(StringValue string, int length, int offset, RegexpState state) {
            int tail;
            int i;
            RegexpNode next = this._next;
            RegexpNode node = this._node;
            int min = this._min;
            int max = this._max;
            for (i = 0; i < min; ++i) {
                tail = node.match(string, length, offset + i, state);
                if (tail >= 0) continue;
                return tail;
            }
            while (i <= max) {
                tail = next.match(string, length, offset + i, state);
                if (tail >= 0) {
                    return tail;
                }
                if (node.match(string, length, offset + i, state) < 0) {
                    return -1;
                }
                ++i;
            }
            return -1;
        }

        @Override
        public String toString() {
            return "CharUngreedyLoop[" + this._min + ", " + this._max + ", " + this._node + ", " + this._next + "]";
        }
    }

    static class CharLoop
    extends RegexpNode {
        private final RegexpNode _node;
        private RegexpNode _next = N_END;
        private int _min;
        private int _max;

        CharLoop(RegexpNode node, int min, int max) {
            this._node = node.getHead();
            this._min = min;
            this._max = max;
            if (this._min < 0) {
                throw new IllegalStateException();
            }
        }

        @Override
        RegexpNode copyImpl(HashMap<RegexpNode, RegexpNode> state) {
            RegexpNode next = this._next.copy(state);
            RegexpNode node = this._node.copy(state);
            CharLoop copy = new CharLoop(node, this._min, this._max);
            copy._next = next;
            return copy;
        }

        @Override
        RegexpNode concat(RegexpNode next) {
            if (next == null) {
                throw new NullPointerException();
            }
            this._next = this._next != null ? this._next.concat(next) : next.getHead();
            return this;
        }

        @Override
        RegexpNode createLoop(Regcomp parser, int min, int max) {
            if (min == 0 && max == 1) {
                this._min = 0;
                return this;
            }
            return new LoopHead(parser, this, min, max);
        }

        @Override
        int minLength() {
            return this._min;
        }

        @Override
        boolean[] firstSet(boolean[] firstSet) {
            firstSet = this._node.firstSet(firstSet);
            if (this._min > 0 && !this._node.isNullable()) {
                return firstSet;
            }
            firstSet = this._next.firstSet(firstSet);
            return firstSet;
        }

        @Override
        int match(StringValue string, int length, int offset, RegexpState state) {
            int tail;
            int i;
            RegexpNode next = this._next;
            RegexpNode node = this._node;
            int min = this._min;
            int max = this._max;
            for (i = 0; i < min; ++i) {
                tail = node.match(string, length, offset + i, state);
                if (tail >= 0) continue;
                return tail;
            }
            while (i < max && node.match(string, length, offset + i, state) >= 0) {
                ++i;
            }
            while (min <= i) {
                tail = next.match(string, length, offset + i, state);
                if (tail >= 0) {
                    return tail;
                }
                --i;
            }
            return -1;
        }

        @Override
        protected void toString(StringBuilder sb, Map<RegexpNode, Integer> map) {
            if (this.toStringAdd(sb, map)) {
                return;
            }
            sb.append(this.toStringName());
            sb.append("[").append(this._min).append(", ").append(this._max).append(", ");
            this._node.toString(sb, map);
            sb.append(", ");
            this._next.toString(sb, map);
            sb.append("]");
        }
    }

    static class AsciiNotSet
    extends AbstractCharNode {
        private final boolean[] _set;

        AsciiNotSet() {
            this._set = new boolean[128];
        }

        AsciiNotSet(boolean[] set) {
            this._set = set;
        }

        void setChar(char ch) {
            this._set[ch] = true;
        }

        void clearChar(char ch) {
            this._set[ch] = false;
        }

        @Override
        int match(StringValue string, int length, int offset, RegexpState state) {
            if (length <= offset) {
                return -1;
            }
            char ch = string.charAt(offset);
            if (ch < '\u0080' && this._set[ch]) {
                return -1;
            }
            if (Character.isHighSurrogate(ch) && offset + 1 < length && Character.isLowSurrogate(string.charAt(offset + 1))) {
                return offset + 2;
            }
            return offset + 1;
        }
    }

    static class AsciiSet
    extends AbstractCharNode {
        private final boolean[] _set;

        AsciiSet() {
            this._set = new boolean[128];
        }

        AsciiSet(boolean[] set) {
            this._set = set;
        }

        @Override
        boolean[] firstSet(boolean[] firstSet) {
            if (firstSet == null) {
                return null;
            }
            for (int i = 0; i < this._set.length; ++i) {
                if (!this._set[i]) continue;
                firstSet[i] = true;
            }
            return firstSet;
        }

        void setChar(char ch) {
            this._set[ch] = true;
        }

        void clearChar(char ch) {
            this._set[ch] = false;
        }

        @Override
        int match(StringValue string, int length, int offset, RegexpState state) {
            if (length <= offset) {
                return -1;
            }
            char ch = string.charAt(offset);
            if (ch < '\u0080' && this._set[ch]) {
                return offset + 1;
            }
            return -1;
        }
    }

    private static class AnchorEndOrNewline
    extends NullableNode {
        private AnchorEndOrNewline() {
        }

        @Override
        int match(StringValue string, int length, int offset, RegexpState state) {
            if (offset == length || string.charAt(offset) == '\n') {
                return offset;
            }
            return -1;
        }
    }

    private static class AnchorEndOnly
    extends NullableNode {
        private AnchorEndOnly() {
        }

        @Override
        int match(StringValue string, int length, int offset, RegexpState state) {
            if (offset == length) {
                return offset;
            }
            return -1;
        }
    }

    private static class AnchorEnd
    extends NullableNode {
        private AnchorEnd() {
        }

        @Override
        int match(StringValue string, int strlen, int offset, RegexpState state) {
            if (offset == strlen || offset + 1 == strlen && string.charAt(offset) == '\n') {
                return offset;
            }
            return -1;
        }
    }

    static class AnchorBeginRelative
    extends NullableNode {
        AnchorBeginRelative() {
        }

        @Override
        int match(StringValue string, int strlen, int offset, RegexpState state) {
            if (offset == state._start) {
                return offset;
            }
            return -1;
        }
    }

    private static class AnchorBeginOrNewline
    extends NullableNode {
        private AnchorBeginOrNewline() {
        }

        @Override
        int match(StringValue string, int strlen, int offset, RegexpState state) {
            if (offset == 0 || string.charAt(offset - 1) == '\n') {
                return offset;
            }
            return -1;
        }
    }

    static class AnchorBegin
    extends NullableNode {
        AnchorBegin() {
        }

        @Override
        boolean isAnchorBegin() {
            return true;
        }

        @Override
        int match(StringValue string, int length, int offset, RegexpState state) {
            if (offset == 0) {
                return offset;
            }
            return -1;
        }
    }

    static class CharNode
    extends AbstractCharNode {
        private char _ch;

        CharNode(char ch) {
            this._ch = ch;
        }

        @Override
        int firstChar() {
            return this._ch;
        }

        @Override
        boolean[] firstSet(boolean[] firstSet) {
            if (firstSet != null && this._ch < firstSet.length) {
                firstSet[this._ch] = true;
                return firstSet;
            }
            return null;
        }

        @Override
        int match(StringValue string, int length, int offset, RegexpState state) {
            if (offset < length && string.charAt(offset) == this._ch) {
                return offset + 1;
            }
            return -1;
        }
    }

    static class AbstractCharNode
    extends RegexpNode {
        AbstractCharNode() {
        }

        @Override
        RegexpNode createLoop(Regcomp parser, int min, int max) {
            return new CharLoop(this, min, max);
        }

        @Override
        RegexpNode createLoopUngreedy(Regcomp parser, int min, int max) {
            return new CharUngreedyLoop(this, min, max);
        }

        @Override
        int minLength() {
            return 1;
        }
    }
}

