/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.quercus.lib.simplexml;

import com.caucho.quercus.env.ArrayValue;
import com.caucho.quercus.env.ArrayValueImpl;
import com.caucho.quercus.env.Env;
import com.caucho.quercus.env.ObjectValue;
import com.caucho.quercus.env.QuercusClass;
import com.caucho.quercus.env.StringValue;
import com.caucho.quercus.env.Value;
import com.caucho.quercus.lib.simplexml.AttributeListView;
import com.caucho.quercus.lib.simplexml.AttributeView;
import com.caucho.quercus.lib.simplexml.IteratorIndex;
import com.caucho.quercus.lib.simplexml.SelectedView;
import com.caucho.quercus.lib.simplexml.SimpleNamespaceContext;
import com.caucho.quercus.lib.simplexml.SimpleView;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class ChildrenView
extends SimpleView {
    private final SimpleView _parent;
    private final ArrayList<SimpleView> _childList;
    private final ArrayList<AttributeView> _attrList;

    public ChildrenView(SimpleView parent, ArrayList<SimpleView> childList, ArrayList<AttributeView> attrList) {
        super(parent.getOwnerDocument());
        this._parent = parent;
        this._childList = childList;
        this._attrList = attrList;
    }

    @Override
    public String getNodeName() {
        if (this._childList.size() > 0) {
            return this._childList.get(0).getNodeName();
        }
        return null;
    }

    @Override
    public ChildrenView getChildren(String namespace, String prefix) {
        if (this._childList.size() > 0) {
            return this._childList.get(0).getChildren(namespace, prefix);
        }
        return null;
    }

    @Override
    public AttributeListView getAttributes(String namespace) {
        if (this._childList.size() > 0) {
            return this._childList.get(0).getAttributes(namespace);
        }
        return null;
    }

    @Override
    public SimpleView addChild(Env env, String name, String value, String namespace) {
        if (this._childList.size() > 0) {
            return this._childList.get(0).addChild(env, name, value, namespace);
        }
        return null;
    }

    @Override
    public HashMap<String, String> getNamespaces(boolean isRecursive, boolean isFromRoot, boolean isCheckUsage) {
        if (this._childList.size() > 0) {
            return this._childList.get(0).getNamespaces(isRecursive, isFromRoot, isCheckUsage);
        }
        return null;
    }

    @Override
    public SimpleView getIndex(Env env, Value indexV) {
        if (indexV.isString()) {
            if (this._childList.size() > 0) {
                return this._childList.get(0).getIndex(env, indexV);
            }
            return null;
        }
        int index = indexV.toInt();
        if (index < this._childList.size()) {
            return this._childList.get(index);
        }
        return null;
    }

    @Override
    public SimpleView setIndex(Env env, Value indexV, Value value) {
        throw new UnsupportedOperationException();
    }

    @Override
    public SimpleView getField(Env env, Value indexV) {
        SimpleView view2;
        String nodeName = indexV.toStringValue(env).toString();
        ArrayList<SimpleView> childList = new ArrayList<SimpleView>();
        for (SimpleView view2 : this._childList) {
            String childName = view2.getNodeName();
            if (!nodeName.equals(childName)) continue;
            childList.add(view2);
        }
        ArrayList<AttributeView> attrList = new ArrayList<AttributeView>();
        view2 = new SelectedView(this, nodeName, childList, attrList);
        return view2;
    }

    @Override
    public SimpleView setField(Env env, Value indexV, Value value) {
        if (this._childList.size() > 0) {
            SimpleView firstChild = this._childList.get(0);
            return firstChild.setField(env, indexV, value);
        }
        return null;
    }

    @Override
    public int getCount() {
        return this._childList.size();
    }

    @Override
    public boolean issetField(Env env, String name) {
        for (SimpleView child : this._childList) {
            if (!child.getNodeName().equals(name)) continue;
            return true;
        }
        return false;
    }

    @Override
    public List<SimpleView> xpath(Env env, SimpleNamespaceContext context, String expression) {
        if (this._childList.size() > 0) {
            SimpleView firstChild = this._childList.get(0);
            return firstChild.xpath(env, context, expression);
        }
        return null;
    }

    @Override
    public String toString(Env env) {
        if (this._childList.size() > 0) {
            SimpleView firstChild = this._childList.get(0);
            return firstChild.toString(env);
        }
        return "";
    }

    @Override
    public Iterator<Map.Entry<IteratorIndex, SimpleView>> getIterator() {
        LinkedHashMap<IteratorIndex, SimpleView> map = new LinkedHashMap<IteratorIndex, SimpleView>();
        for (int i = 0; i < this._childList.size(); ++i) {
            SimpleView view = this._childList.get(i);
            map.put(IteratorIndex.create(view.getNodeName()), view);
        }
        return map.entrySet().iterator();
    }

    @Override
    public Set<Map.Entry<Value, Value>> getEntrySet(Env env, QuercusClass cls) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean toXml(Env env, StringBuilder sb) {
        if (this._childList.size() > 0) {
            SimpleView firstChild = this._childList.get(0);
            firstChild.toXml(env, sb);
            return true;
        }
        return false;
    }

    @Override
    public Value toDumpValue(Env env, QuercusClass cls, boolean isChildren) {
        int childSize = this._childList.size();
        ObjectValue obj = env.createObject();
        obj.setClassName(cls.getName());
        if (childSize > 0) {
            for (int i = 0; i < childSize; ++i) {
                SimpleView child = this._childList.get(i);
                Value childValue = child.toDumpValue(env, cls, false);
                StringValue nodeName = env.createString(child.getNodeName());
                obj.putField(env, nodeName, childValue);
            }
        } else if (this._attrList.size() > 0) {
            ArrayValueImpl array = new ArrayValueImpl();
            for (AttributeView view : this._attrList) {
                StringValue attrName = env.createString(view.getNodeName());
                StringValue attrValue = env.createString(view.getNodeValue());
                ((ArrayValue)array).append(attrName, attrValue);
            }
            obj.putField(env, env.createString("@attributes"), (Value)array);
        }
        return obj;
    }

    public String toString() {
        int size = this._childList.size();
        SimpleView firstChild = null;
        if (size > 0) {
            firstChild = this._childList.get(0);
        }
        return this.getClass().getSimpleName() + "[size=" + size + ",first=" + firstChild + ",parent=" + this._parent + "]";
    }
}

