/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.quercus.lib.spl;

import com.caucho.quercus.env.ArrayDelegate;
import com.caucho.quercus.env.ConstStringValue;
import com.caucho.quercus.env.Env;
import com.caucho.quercus.env.ObjectValue;
import com.caucho.quercus.env.StringValue;
import com.caucho.quercus.env.UnsetValue;
import com.caucho.quercus.env.Value;

public class ArrayAccessDelegate
implements ArrayDelegate {
    private static final StringValue OFFSET_GET = new ConstStringValue("offsetGet");
    private static final StringValue OFFSET_SET = new ConstStringValue("offsetSet");
    private static final StringValue OFFSET_UNSET = new ConstStringValue("offsetUnset");
    private static final StringValue OFFSET_EXISTS = new ConstStringValue("offsetExists");

    @Override
    public Value get(Env env, ObjectValue qThis, Value index) {
        return qThis.callMethod(env, OFFSET_GET, index);
    }

    @Override
    public Value put(Env env, ObjectValue qThis, Value index, Value value) {
        return qThis.callMethod(env, OFFSET_SET, index, value);
    }

    @Override
    public Value put(Env env, ObjectValue qThis, Value index) {
        return qThis.callMethod(env, OFFSET_SET, UnsetValue.UNSET, index);
    }

    @Override
    public boolean isset(Env env, ObjectValue qThis, Value index) {
        return qThis.callMethod(env, OFFSET_EXISTS, index).toBoolean();
    }

    @Override
    public boolean isEmpty(Env env, ObjectValue qThis, Value index) {
        boolean isExists = qThis.callMethod(env, OFFSET_EXISTS, index).toBoolean();
        if (!isExists) {
            return true;
        }
        Value value = this.get(env, qThis, index);
        return value.isEmpty();
    }

    @Override
    public Value unset(Env env, ObjectValue qThis, Value index) {
        return qThis.callMethod(env, OFFSET_UNSET, index);
    }

    @Override
    public long count(Env env, ObjectValue qThis) {
        return 1L;
    }
}

