/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.quercus.lib.spl;

import com.caucho.quercus.QuercusRuntimeException;
import com.caucho.quercus.env.Env;
import com.caucho.quercus.env.LongValue;
import com.caucho.quercus.env.StringValue;
import com.caucho.quercus.env.UnsetValue;
import com.caucho.quercus.env.Value;
import com.caucho.quercus.lib.spl.Iterator;
import com.caucho.quercus.lib.spl.SeekableIterator;
import com.caucho.quercus.lib.spl.SplFileInfo;
import com.caucho.quercus.lib.spl.Traversable;
import com.caucho.vfs.Path;
import java.io.IOException;

public class DirectoryIterator
extends SplFileInfo
implements Iterator,
Traversable,
SeekableIterator {
    private String[] _list;
    private int _index;
    private SplFileInfo _current;

    public DirectoryIterator(Env env, StringValue fileName) {
        super(env, fileName);
        try {
            this._list = DirectoryIterator.getPathList(this._path);
        }
        catch (IOException e) {
            throw new QuercusRuntimeException(e);
        }
    }

    protected DirectoryIterator(Path parent, Path path, String fileName) {
        super(parent, path, fileName);
        try {
            this._list = DirectoryIterator.getPathList(path);
        }
        catch (IOException e) {
            throw new QuercusRuntimeException(e);
        }
    }

    private static String[] getPathList(Path path) throws IOException {
        String[] list = path.list();
        String[] newList = new String[list.length + 2];
        newList[0] = ".";
        newList[1] = "..";
        System.arraycopy(list, 0, newList, 2, list.length);
        return newList;
    }

    @Override
    public Value current(Env env) {
        SplFileInfo current = this.getCurrent(env);
        return current != null ? env.wrapJava(current) : UnsetValue.UNSET;
    }

    protected SplFileInfo getCurrent(Env env) {
        if (this._current == null && this._index < this._list.length) {
            String name = this._list[this._index];
            Path child = this._path.lookup(name);
            this._current = this.createCurrent(env, this._path, child, name);
        }
        return this._current;
    }

    protected SplFileInfo createCurrent(Env env, Path parent, Path path, String fileName) {
        return new SplFileInfo(parent, path, fileName);
    }

    protected int getKey() {
        return this._index;
    }

    public boolean isDot(Env env) {
        SplFileInfo current = this.getCurrent(env);
        String fileName = current.getFilename(env);
        return ".".equals(fileName) || "..".equals(fileName);
    }

    @Override
    public Value key(Env env) {
        return LongValue.create(this._index);
    }

    @Override
    public void next(Env env) {
        ++this._index;
        this._current = null;
    }

    @Override
    public void rewind(Env env) {
        this._index = 0;
    }

    @Override
    public boolean valid(Env env) {
        return this._index < this._list.length;
    }

    @Override
    public void seek(Env env, int index) {
        this._index = index;
    }
}

