/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.quercus.lib.zlib;

import java.io.IOException;
import java.io.OutputStream;
import java.util.zip.CRC32;
import java.util.zip.Deflater;
import java.util.zip.DeflaterOutputStream;

public class GZIPOutputStream
extends DeflaterOutputStream {
    private CRC32 _crc32;
    private byte[] _header = new byte[]{31, -117, 8, 0, 0, 0, 0, 0, 0, 0};
    private int _encodingMode;
    private boolean _isGzip;

    private GZIPOutputStream(OutputStream out, Deflater def) throws IOException {
        super(out, def);
        out.write(this._header, 0, this._header.length);
    }

    public GZIPOutputStream(OutputStream out, int compressionLevel, int strategy, int encodingMode) throws IOException {
        this(out, GZIPOutputStream.createDeflater(compressionLevel, strategy, encodingMode));
        boolean bl = this._isGzip = encodingMode == 1;
        if (this._isGzip) {
            this._crc32 = new CRC32();
        }
        this._encodingMode = encodingMode;
    }

    private static Deflater createDeflater(int compressionLevel, int strategy, int encodingMode) {
        Deflater defl = encodingMode == 1 ? new Deflater(compressionLevel, true) : new Deflater(compressionLevel, false);
        defl.setStrategy(strategy);
        return defl;
    }

    public GZIPOutputStream(OutputStream out, int compressionLevel, int strategy) throws IOException {
        this(out, compressionLevel, strategy, 1);
    }

    public GZIPOutputStream(OutputStream out) throws IOException {
        this(out, -1, 0);
    }

    @Override
    public void write(int v) throws IOException {
        super.write(v);
        if (this._isGzip) {
            this._crc32.update(v);
        }
    }

    @Override
    public void write(byte[] buffer, int offset, int length) throws IOException {
        super.write(buffer, offset, length);
        if (this._isGzip) {
            this._crc32.update(buffer, offset, length);
        }
    }

    @Override
    public void finish() throws IOException {
        super.finish();
        if (this._isGzip) {
            long crcValue = this._crc32.getValue();
            byte[] trailerCRC = new byte[]{(byte)crcValue, (byte)(crcValue >> 8), (byte)(crcValue >> 16), (byte)(crcValue >> 24)};
            this.out.write(trailerCRC, 0, trailerCRC.length);
        }
        long inputSize = this.def.getBytesRead();
        byte[] trailerInputSize = new byte[]{(byte)inputSize, (byte)(inputSize >> 8), (byte)(inputSize >> 16), (byte)(inputSize >> 24)};
        this.out.write(trailerInputSize, 0, trailerInputSize.length);
        this.out.flush();
    }

    @Override
    public void close() throws IOException {
        if (!this.def.finished()) {
            this.finish();
        }
        super.close();
    }
}

