/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.quercus.marshal;

import com.caucho.quercus.env.Env;
import com.caucho.quercus.env.JavaValue;
import com.caucho.quercus.env.Value;
import com.caucho.quercus.expr.Expr;
import com.caucho.quercus.lib.file.BinaryInput;
import com.caucho.quercus.lib.file.ReadStreamInput;
import com.caucho.quercus.marshal.Marshal;
import java.io.InputStream;

public class BinaryInputMarshal
extends Marshal {
    public static final Marshal MARSHAL = new BinaryInputMarshal();

    @Override
    public boolean isReadOnly() {
        return true;
    }

    @Override
    public Object marshal(Env env, Expr expr, Class expectedClass) {
        return this.marshal(env, expr.eval(env), expectedClass);
    }

    @Override
    public Object marshal(Env env, Value value, Class expectedClass) {
        if (value == null) {
            return null;
        }
        if (value instanceof BinaryInput) {
            return (BinaryInput)((Object)value);
        }
        Object javaObj = value.toJavaObject();
        if (javaObj instanceof BinaryInput) {
            return (BinaryInput)javaObj;
        }
        if (javaObj instanceof InputStream) {
            return new ReadStreamInput(env, (InputStream)javaObj);
        }
        return new ReadStreamInput(env, value.toInputStream());
    }

    public static BinaryInput marshal(Env env, Value value) {
        if (value == null) {
            return null;
        }
        if (value instanceof BinaryInput) {
            return (BinaryInput)((Object)value);
        }
        Object javaObj = value.toJavaObject();
        if (javaObj instanceof BinaryInput) {
            return (BinaryInput)javaObj;
        }
        if (javaObj instanceof InputStream) {
            return new ReadStreamInput(env, (InputStream)javaObj);
        }
        return new ReadStreamInput(env, value.toInputStream());
    }

    @Override
    public Value unmarshal(Env env, Object value) {
        return (Value)value;
    }

    @Override
    protected int getMarshalingCostImpl(Value argValue) {
        if (argValue instanceof JavaValue && InputStream.class.isAssignableFrom(argValue.toJavaObject().getClass())) {
            return 0;
        }
        return 400;
    }

    @Override
    public Class getExpectedClass() {
        return BinaryInput.class;
    }
}

