/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.quercus.marshal;

import com.caucho.quercus.env.Env;
import com.caucho.quercus.env.Value;
import com.caucho.quercus.expr.Expr;
import com.caucho.quercus.marshal.Marshal;

public class ExtValueMarshal
extends Marshal {
    private Class<?> _expectedClass;

    public ExtValueMarshal(Class<?> expectedClass) {
        this._expectedClass = expectedClass;
    }

    @Override
    public boolean isReadOnly() {
        return false;
    }

    @Override
    public boolean isValue() {
        return true;
    }

    @Override
    public Object marshal(Env env, Expr expr, Class expectedClass) {
        return this.marshal(env, expr.eval(env), expectedClass);
    }

    @Override
    public Object marshal(Env env, Value value, Class expectedClass) {
        if (value == null || !value.isset()) {
            return null;
        }
        if (expectedClass.isAssignableFrom((value = value.toValue()).getClass())) {
            return value;
        }
        this.unexpectedType(env, value, value.getClass(), expectedClass);
        return null;
    }

    @Override
    public Value unmarshal(Env env, Object value) {
        return (Value)value;
    }

    @Override
    protected int getMarshalingCostImpl(Value argValue) {
        if (this._expectedClass.isAssignableFrom(argValue.getClass())) {
            return 100;
        }
        return 400;
    }

    @Override
    public Class getExpectedClass() {
        return this._expectedClass;
    }
}

