/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.quercus.marshal;

import com.caucho.quercus.env.Env;
import com.caucho.quercus.env.JavaValue;
import com.caucho.quercus.env.Value;
import com.caucho.quercus.expr.Expr;
import com.caucho.quercus.marshal.Marshal;
import java.io.InputStream;

public class InputStreamMarshal
extends Marshal {
    public static final Marshal MARSHAL = new InputStreamMarshal();

    @Override
    public boolean isReadOnly() {
        return true;
    }

    @Override
    public Object marshal(Env env, Expr expr, Class expectedClass) {
        return this.marshal(env, expr.eval(env), expectedClass);
    }

    @Override
    public Object marshal(Env env, Value value, Class expectedClass) {
        return value.toInputStream();
    }

    @Override
    public Value unmarshal(Env env, Object value) {
        return env.wrapJava((InputStream)value);
    }

    @Override
    protected int getMarshalingCostImpl(Value argValue) {
        if (argValue instanceof JavaValue && InputStream.class.isAssignableFrom(argValue.toJavaObject().getClass())) {
            return 0;
        }
        return 400;
    }

    @Override
    public Class getExpectedClass() {
        return InputStream.class;
    }
}

