/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.quercus.marshal;

import com.caucho.quercus.env.Env;
import com.caucho.quercus.env.JavaValue;
import com.caucho.quercus.env.Value;
import com.caucho.quercus.expr.Expr;
import com.caucho.quercus.marshal.Marshal;
import com.caucho.quercus.program.JavaClassDef;
import com.caucho.util.L10N;

public class JavaMarshal
extends Marshal {
    private static final L10N L = new L10N(JavaMarshal.class);
    protected final JavaClassDef _def;
    protected final boolean _isNotNull;
    protected final boolean _isUnmarshalNullAsFalse;

    public JavaMarshal(JavaClassDef def, boolean isNotNull) {
        this(def, isNotNull, false);
    }

    public JavaMarshal(JavaClassDef def, boolean isNotNull, boolean isUnmarshalNullAsFalse) {
        this._def = def;
        this._isNotNull = isNotNull;
        this._isUnmarshalNullAsFalse = isUnmarshalNullAsFalse;
    }

    @Override
    public Object marshal(Env env, Expr expr, Class argClass) {
        Value value = expr.eval(env);
        return this.marshal(env, value, argClass);
    }

    @Override
    public Object marshal(Env env, Value value, Class argClass) {
        if (!value.isset()) {
            if (this._isNotNull) {
                this.unexpectedNull(env, argClass);
            }
            return null;
        }
        Object obj = value.toJavaObject();
        if (obj == null) {
            if (this._isNotNull) {
                this.unexpectedNull(env, argClass);
            }
            return null;
        }
        if (!argClass.isAssignableFrom(obj.getClass())) {
            this.unexpectedType(env, value, obj.getClass(), argClass);
            return null;
        }
        return obj;
    }

    @Override
    public Value unmarshal(Env env, Object value) {
        return env.wrapJava(value, this._def, this._isUnmarshalNullAsFalse);
    }

    @Override
    protected int getMarshalingCostImpl(Value argValue) {
        Class<?> type = this._def.getType();
        if (argValue instanceof JavaValue && type.isAssignableFrom(argValue.toJavaObject().getClass())) {
            return 0;
        }
        return 400;
    }

    @Override
    public final Class getExpectedClass() {
        return this._def.getType();
    }
}

