/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.quercus.marshal;

import com.caucho.quercus.env.ArrayValue;
import com.caucho.quercus.env.BinaryBuilderValue;
import com.caucho.quercus.env.BinaryValue;
import com.caucho.quercus.env.Callable;
import com.caucho.quercus.env.DoubleValue;
import com.caucho.quercus.env.LongValue;
import com.caucho.quercus.env.StringValue;
import com.caucho.quercus.env.UnicodeValue;
import com.caucho.quercus.env.Value;
import com.caucho.quercus.lib.file.BinaryInput;
import com.caucho.quercus.lib.file.BinaryOutput;
import com.caucho.quercus.lib.regexp.Ereg;
import com.caucho.quercus.lib.regexp.Eregi;
import com.caucho.quercus.lib.regexp.Regexp;
import com.caucho.quercus.lib.regexp.UnicodeEreg;
import com.caucho.quercus.lib.regexp.UnicodeEregi;
import com.caucho.quercus.marshal.ArrayValueMarshal;
import com.caucho.quercus.marshal.BigDecimalMarshal;
import com.caucho.quercus.marshal.BigIntegerMarshal;
import com.caucho.quercus.marshal.BinaryInputMarshal;
import com.caucho.quercus.marshal.BinaryOutputMarshal;
import com.caucho.quercus.marshal.BinaryValueMarshal;
import com.caucho.quercus.marshal.BooleanMarshal;
import com.caucho.quercus.marshal.BooleanObjectMarshal;
import com.caucho.quercus.marshal.ByteMarshal;
import com.caucho.quercus.marshal.ByteObjectMarshal;
import com.caucho.quercus.marshal.CalendarMarshal;
import com.caucho.quercus.marshal.CallableMarshal;
import com.caucho.quercus.marshal.CharacterMarshal;
import com.caucho.quercus.marshal.CharacterObjectMarshal;
import com.caucho.quercus.marshal.ClassMarshal;
import com.caucho.quercus.marshal.DateMarshal;
import com.caucho.quercus.marshal.DoubleMarshal;
import com.caucho.quercus.marshal.DoubleObjectMarshal;
import com.caucho.quercus.marshal.DoubleValueMarshal;
import com.caucho.quercus.marshal.EnumMarshal;
import com.caucho.quercus.marshal.EregMarshal;
import com.caucho.quercus.marshal.EregiMarshal;
import com.caucho.quercus.marshal.ExpectMarshal;
import com.caucho.quercus.marshal.ExtValueMarshal;
import com.caucho.quercus.marshal.FloatMarshal;
import com.caucho.quercus.marshal.FloatObjectMarshal;
import com.caucho.quercus.marshal.InputStreamMarshal;
import com.caucho.quercus.marshal.IntegerMarshal;
import com.caucho.quercus.marshal.IntegerObjectMarshal;
import com.caucho.quercus.marshal.JavaArrayMarshal;
import com.caucho.quercus.marshal.JavaByteArrayMarshal;
import com.caucho.quercus.marshal.JavaCharacterArrayMarshal;
import com.caucho.quercus.marshal.JavaCollectionMarshal;
import com.caucho.quercus.marshal.JavaListMarshal;
import com.caucho.quercus.marshal.JavaMapMarshal;
import com.caucho.quercus.marshal.JavaMarshal;
import com.caucho.quercus.marshal.LongMarshal;
import com.caucho.quercus.marshal.LongObjectMarshal;
import com.caucho.quercus.marshal.LongValueMarshal;
import com.caucho.quercus.marshal.Marshal;
import com.caucho.quercus.marshal.NullAsFalseMarshal;
import com.caucho.quercus.marshal.PathMarshal;
import com.caucho.quercus.marshal.ReferenceMarshal;
import com.caucho.quercus.marshal.RegexpArrayMarshal;
import com.caucho.quercus.marshal.RegexpMarshal;
import com.caucho.quercus.marshal.ShortMarshal;
import com.caucho.quercus.marshal.ShortObjectMarshal;
import com.caucho.quercus.marshal.StringMarshal;
import com.caucho.quercus.marshal.StringValueMarshal;
import com.caucho.quercus.marshal.URLMarshal;
import com.caucho.quercus.marshal.UnicodeEregMarshal;
import com.caucho.quercus.marshal.UnicodeEregiMarshal;
import com.caucho.quercus.marshal.UnicodeValueMarshal;
import com.caucho.quercus.marshal.ValueMarshal;
import com.caucho.quercus.marshal.VoidMarshal;
import com.caucho.quercus.module.ModuleContext;
import com.caucho.quercus.program.JavaClassDef;
import com.caucho.vfs.Path;
import java.io.InputStream;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.net.URL;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class MarshalFactory {
    private static final HashMap<Class<?>, Marshal> _marshalMap = new HashMap();
    protected ModuleContext _moduleContext;

    public MarshalFactory(ModuleContext moduleContext) {
        this._moduleContext = moduleContext;
    }

    public Marshal create(Class<?> argType) {
        return this.create(argType, false);
    }

    public Marshal create(Class<?> argType, boolean isNotNull) {
        return this.create(argType, isNotNull, false, false);
    }

    public Marshal create(Class<?> argType, boolean isNotNull, boolean isNullAsFalse, boolean isOptional) {
        Marshal marshal = _marshalMap.get(argType);
        if (marshal == null) {
            String typeName;
            if (Boolean.TYPE.equals(argType)) {
                marshal = BooleanMarshal.MARSHAL;
            } else if (Boolean.class.equals(argType)) {
                marshal = BooleanObjectMarshal.MARSHAL;
            } else if (Byte.TYPE.equals(argType)) {
                marshal = ByteMarshal.MARSHAL;
            } else if (Byte.class.equals(argType)) {
                marshal = ByteObjectMarshal.MARSHAL;
            } else if (Short.TYPE.equals(argType)) {
                marshal = ShortMarshal.MARSHAL;
            } else if (Short.class.equals(argType)) {
                marshal = ShortObjectMarshal.MARSHAL;
            } else if (Integer.TYPE.equals(argType)) {
                marshal = IntegerMarshal.MARSHAL;
            } else if (Integer.class.equals(argType)) {
                marshal = IntegerObjectMarshal.MARSHAL;
            } else if (Long.TYPE.equals(argType)) {
                marshal = LongMarshal.MARSHAL;
            } else if (Long.class.equals(argType)) {
                marshal = LongObjectMarshal.MARSHAL;
            } else if (LongValue.class.equals(argType)) {
                marshal = LongValueMarshal.MARSHAL;
            } else if (Float.TYPE.equals(argType)) {
                marshal = FloatMarshal.MARSHAL;
            } else if (Float.class.equals(argType)) {
                marshal = FloatObjectMarshal.MARSHAL;
            } else if (Double.TYPE.equals(argType)) {
                marshal = DoubleMarshal.MARSHAL;
            } else if (Double.class.equals(argType)) {
                marshal = DoubleObjectMarshal.MARSHAL;
            } else if (DoubleValue.class.equals(argType)) {
                marshal = DoubleValueMarshal.MARSHAL;
            } else if (BigDecimal.class.equals(argType)) {
                marshal = BigDecimalMarshal.MARSHAL;
            } else if (BigInteger.class.equals(argType)) {
                marshal = BigIntegerMarshal.MARSHAL;
            } else if (Character.TYPE.equals(argType)) {
                marshal = CharacterMarshal.MARSHAL;
            } else if (Character.class.equals(argType)) {
                marshal = CharacterObjectMarshal.MARSHAL;
            } else if (Path.class.equals(argType)) {
                marshal = PathMarshal.MARSHAL;
            } else if (StringValue.class.equals(argType)) {
                marshal = StringValueMarshal.MARSHAL;
            } else if (UnicodeValue.class.equals(argType)) {
                marshal = UnicodeValueMarshal.MARSHAL;
            } else if (BinaryValue.class.equals(argType)) {
                marshal = BinaryValueMarshal.MARSHAL;
            } else if (BinaryBuilderValue.class.equals(argType)) {
                marshal = BinaryValueMarshal.MARSHAL;
            } else if (InputStream.class.equals(argType)) {
                marshal = InputStreamMarshal.MARSHAL;
            } else if (BinaryInput.class.equals(argType)) {
                marshal = BinaryInputMarshal.MARSHAL;
            } else if (BinaryOutput.class.equals(argType)) {
                marshal = BinaryOutputMarshal.MARSHAL;
            } else if (ArrayValue.class.equals(argType)) {
                marshal = ArrayValueMarshal.MARSHAL;
            } else if (Value.class.equals(argType)) {
                marshal = ValueMarshal.MARSHAL;
            } else if (Value.class.isAssignableFrom(argType)) {
                marshal = new ExtValueMarshal(argType);
            } else if (Void.TYPE.equals(argType)) {
                marshal = VoidMarshal.MARSHAL;
            } else if (Calendar.class.equals(argType)) {
                marshal = CalendarMarshal.MARSHAL;
            } else if (Date.class.equals(argType)) {
                marshal = DateMarshal.MARSHAL;
            } else if (Regexp.class.equals(argType)) {
                marshal = RegexpMarshal.MARSHAL;
            } else if (Regexp[].class.equals(argType)) {
                marshal = RegexpArrayMarshal.MARSHAL;
            } else if (Ereg.class.equals(argType)) {
                marshal = EregMarshal.MARSHAL;
            } else if (Eregi.class.equals(argType)) {
                marshal = EregiMarshal.MARSHAL;
            } else if (UnicodeEreg.class.equals(argType)) {
                marshal = UnicodeEregMarshal.MARSHAL;
            } else if (UnicodeEregi.class.equals(argType)) {
                marshal = UnicodeEregiMarshal.MARSHAL;
            } else if (URL.class.equals(argType)) {
                marshal = URLMarshal.MARSHAL;
            } else if (byte[].class.equals(argType)) {
                marshal = JavaByteArrayMarshal.MARSHAL;
            } else if (char[].class.equals(argType)) {
                marshal = JavaCharacterArrayMarshal.MARSHAL;
            } else if (argType.isArray()) {
                marshal = new JavaArrayMarshal(argType);
            } else if (Callable.class.equals(argType)) {
                marshal = isOptional ? CallableMarshal.MARSHAL_OPTIONAL : CallableMarshal.MARSHAL;
            } else if (Map.class.isAssignableFrom(argType)) {
                typeName = argType.getName();
                JavaClassDef javaDef = this._moduleContext.getJavaClassDefinition(typeName);
                marshal = new JavaMapMarshal(javaDef, isNotNull, isNullAsFalse);
            } else if (List.class.isAssignableFrom(argType)) {
                typeName = argType.getName();
                JavaClassDef javaDef = this._moduleContext.getJavaClassDefinition(typeName);
                marshal = new JavaListMarshal(javaDef, isNotNull, isNullAsFalse);
            } else if (Collection.class.isAssignableFrom(argType)) {
                typeName = argType.getName();
                JavaClassDef javaDef = this._moduleContext.getJavaClassDefinition(typeName);
                marshal = new JavaCollectionMarshal(javaDef, isNotNull, isNullAsFalse);
            } else if (Enum.class.isAssignableFrom(argType)) {
                marshal = new EnumMarshal(argType);
            } else {
                typeName = argType.getName();
                JavaClassDef javaDef = this._moduleContext.getJavaClassDefinition(typeName);
                marshal = new JavaMarshal(javaDef, isNotNull, isNullAsFalse);
            }
        }
        if (!isNullAsFalse) {
            return marshal;
        }
        if (Value.class.equals(argType) || Boolean.class.equals(argType) || Byte.class.equals(argType) || Short.class.equals(argType) || Integer.class.equals(argType) || Long.class.equals(argType) || Float.class.equals(argType) || Double.class.equals(argType) || Character.class.equals(argType)) {
            String shortName = argType.getSimpleName();
            throw new UnsupportedOperationException("@ReturnNullAsFalse cannot be used with return type `" + shortName + "'");
        }
        return new NullAsFalseMarshal(marshal);
    }

    public Marshal createReference() {
        return ReferenceMarshal.MARSHAL;
    }

    public Marshal createValuePassThru() {
        return ValueMarshal.MARSHAL_PASS_THRU;
    }

    public Marshal createExpectString() {
        return ExpectMarshal.MARSHAL_EXPECT_STRING;
    }

    public Marshal createExpectNumeric() {
        return ExpectMarshal.MARSHAL_EXPECT_NUMERIC;
    }

    public Marshal createExpectBoolean() {
        return ExpectMarshal.MARSHAL_EXPECT_BOOLEAN;
    }

    static {
        _marshalMap.put(String.class, StringMarshal.MARSHAL);
        _marshalMap.put(Class.class, ClassMarshal.MARSHAL);
    }
}

