/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.quercus.marshal;

import com.caucho.quercus.env.Env;
import com.caucho.quercus.env.Value;
import com.caucho.quercus.expr.Expr;
import com.caucho.quercus.lib.regexp.Regexp;
import com.caucho.quercus.lib.regexp.RegexpModule;
import com.caucho.quercus.marshal.StringMarshal;

public class RegexpMarshal
extends StringMarshal {
    public static final RegexpMarshal MARSHAL = new RegexpMarshal();

    @Override
    public Object marshal(Env env, Expr expr, Class expectedClass) {
        return RegexpModule.createRegexp(expr.evalStringValue(env));
    }

    @Override
    public Object marshal(Env env, Value value, Class expectedClass) {
        return RegexpModule.createRegexp(value.toStringValue(env));
    }

    @Override
    public Value unmarshal(Env env, Object value) {
        throw new UnsupportedOperationException(this.getClass().getName());
    }

    @Override
    protected int getMarshalingCostImpl(Value argValue) {
        if (argValue.isString()) {
            return 0;
        }
        return 0x3FFFFFF;
    }

    @Override
    public int getMarshalingCost(Expr expr) {
        if (expr.isString()) {
            return 0;
        }
        return 0x3FFFFFF;
    }

    @Override
    public Class getExpectedClass() {
        return Regexp.class;
    }
}

