/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.quercus.marshal;

import com.caucho.quercus.env.Env;
import com.caucho.quercus.env.LongValue;
import com.caucho.quercus.env.Value;
import com.caucho.quercus.expr.Expr;
import com.caucho.quercus.marshal.Marshal;

public class ShortObjectMarshal
extends Marshal {
    public static final Marshal MARSHAL = new ShortObjectMarshal();

    @Override
    public boolean isReadOnly() {
        return true;
    }

    @Override
    public Object marshal(Env env, Expr expr, Class expectedClass) {
        return new Short((short)expr.evalLong(env));
    }

    @Override
    public Object marshal(Env env, Value value, Class expectedClass) {
        return value.toJavaShort();
    }

    @Override
    public Value unmarshal(Env env, Object value) {
        if (value == null) {
            return LongValue.ZERO;
        }
        return LongValue.create(((Number)value).longValue());
    }

    @Override
    protected int getMarshalingCostImpl(Value argValue) {
        if (argValue instanceof LongValue) {
            return 100;
        }
        if (argValue.isLongConvertible()) {
            return 300;
        }
        if (argValue.isNumeric()) {
            return 300;
        }
        return 400;
    }

    @Override
    public Class getExpectedClass() {
        return Short.class;
    }
}

