/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.quercus.marshal;

import com.caucho.quercus.env.Env;
import com.caucho.quercus.env.NullValue;
import com.caucho.quercus.env.Value;
import com.caucho.quercus.expr.Expr;
import com.caucho.quercus.marshal.Marshal;

public class StringMarshal
extends Marshal {
    public static final StringMarshal MARSHAL = new StringMarshal();

    @Override
    public boolean isString() {
        return true;
    }

    @Override
    public boolean isReadOnly() {
        return true;
    }

    @Override
    public Object marshal(Env env, Expr expr, Class expectedClass) {
        return expr.evalString(env);
    }

    @Override
    public Object marshal(Env env, Value value, Class expectedClass) {
        return value.toJavaString();
    }

    @Override
    public Value unmarshal(Env env, Object value) {
        if (value == null) {
            return NullValue.NULL;
        }
        return env.createString((String)value);
    }

    @Override
    protected int getMarshalingCostImpl(Value argValue) {
        return argValue.toStringMarshalCost();
    }

    @Override
    public int getMarshalingCost(Expr expr) {
        if (expr.isString()) {
            return 0;
        }
        return 400;
    }

    @Override
    public Class getExpectedClass() {
        return String.class;
    }
}

