/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.quercus.page;

import com.caucho.quercus.QuercusContext;
import com.caucho.quercus.page.InterpretedPage;
import com.caucho.quercus.page.QuercusPage;
import com.caucho.quercus.parser.QuercusParser;
import com.caucho.quercus.program.QuercusProgram;
import com.caucho.util.CurrentTime;
import com.caucho.util.L10N;
import com.caucho.util.LruCache;
import com.caucho.vfs.IOExceptionWrapper;
import com.caucho.vfs.Path;
import java.io.IOException;
import java.lang.ref.SoftReference;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;

public class PageManager {
    private static final Logger log = Logger.getLogger(PageManager.class.getName());
    protected static final L10N L = new L10N(PageManager.class);
    private final QuercusContext _quercus;
    private boolean _isLazyCompile;
    private boolean _isCompile;
    private boolean _isCompileFailover = CurrentTime.isActive();
    private boolean _isRequireSource = true;
    private Map<String, Object> _programLockMap = new ConcurrentHashMap<String, Object>();
    protected LruCache<Path, SoftReference<QuercusProgram>> _programCache = new LruCache(1024);
    private boolean _isClosed;

    public PageManager(QuercusContext quercus) {
        this._quercus = quercus;
    }

    public QuercusContext getQuercus() {
        return this._quercus;
    }

    public Path getPwd() {
        return this._quercus.getPwd();
    }

    public boolean isCompile() {
        return this._isCompile;
    }

    public void setCompile(boolean isCompile) {
        this._isCompile = isCompile;
    }

    public boolean isLazyCompile() {
        return this._isLazyCompile;
    }

    public void setLazyCompile(boolean isCompile) {
        this._isLazyCompile = isCompile;
    }

    public boolean isCompileFailover() {
        return this._isCompileFailover;
    }

    public void setCompileFailover(boolean isCompileFailover) {
        this._isCompileFailover = isCompileFailover;
    }

    public void setRequireSource(boolean isRequireSource) {
        this._isRequireSource = isRequireSource;
    }

    public boolean isRequireSource() {
        return this._isRequireSource;
    }

    public int getPageCacheSize() {
        return this._programCache.getCapacity();
    }

    public void setPageCacheSize(int size) {
        if (size >= 0 && size != this._programCache.getCapacity()) {
            this._programCache = new LruCache(size);
        }
    }

    public boolean isActive() {
        return !this._isClosed;
    }

    public QuercusPage parse(Path path) throws IOException {
        return this.parse(path, null, -1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public QuercusPage parse(Path path, String fileName, int line) throws IOException {
        String fullName = path.getFullPath();
        try {
            Object lock = this._programLockMap.get(fullName);
            while (lock == null) {
                lock = new Object();
                this._programLockMap.putIfAbsent(fullName, lock);
                lock = this._programLockMap.get(fullName);
            }
            Object object = lock;
            synchronized (object) {
                QuercusPage quercusPage = this.parseImpl(path, fileName, line);
                return quercusPage;
            }
        }
        finally {
            this._programLockMap.remove(fullName);
        }
    }

    public QuercusPage parseImpl(Path path, String fileName, int line) throws IOException {
        try {
            SoftReference<QuercusProgram> programRef = this._programCache.get(path);
            QuercusProgram program = programRef != null ? programRef.get() : null;
            boolean isModified = false;
            if (program != null) {
                isModified = program.isModified();
                if (!program.isCompilable()) {
                    if (isModified) {
                        program.setCompilable(true);
                    } else {
                        if (log.isLoggable(Level.FINE)) {
                            log.fine(L.l("Quercus[{0}] loading interpreted page", (Object)path));
                        }
                        return new InterpretedPage(program);
                    }
                }
            }
            if (program == null || isModified) {
                this.clearProgram(path, program);
                program = this.preloadProgram(path, fileName);
                if (program == null || program.isModified()) {
                    if (log.isLoggable(Level.FINE)) {
                        log.fine(L.l("Quercus[{0}] parsing page", (Object)path));
                    }
                    program = QuercusParser.parse(this._quercus, path, this._quercus.getScriptEncoding(), fileName, line);
                }
                this._programCache.put(path, new SoftReference<QuercusProgram>(program));
            }
            if (program.getCompiledPage() != null) {
                return program.getCompiledPage();
            }
            return this.compilePage(program, path);
        }
        catch (IOException e) {
            throw e;
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Throwable e) {
            throw new IOExceptionWrapper(e);
        }
    }

    public boolean precompileExists(Path path) {
        return false;
    }

    protected QuercusProgram preloadProgram(Path path, String fileName) {
        return null;
    }

    protected void clearProgram(Path path, QuercusProgram program) {
        this._programCache.remove(path);
        if (program != null) {
            this._quercus.clearDefinitionCache();
        }
    }

    protected QuercusPage compilePage(QuercusProgram program, Path path) {
        if (log.isLoggable(Level.FINE)) {
            log.fine(L.l("Quercus[{0}] loading interpreted page", (Object)path));
        }
        return new InterpretedPage(program);
    }

    public void close() {
        this._isClosed = true;
    }
}

