/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.quercus.parser;

import com.caucho.quercus.Location;
import com.caucho.quercus.env.StringValue;
import com.caucho.quercus.expr.ExprFactory;
import com.caucho.quercus.parser.Scope;
import com.caucho.quercus.program.Function;
import com.caucho.quercus.program.InterpretedClassDef;
import com.caucho.util.L10N;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Locale;

public class GlobalScope
extends Scope {
    private static final L10N L = new L10N(GlobalScope.class);
    private ExprFactory _exprFactory;
    private HashMap<StringValue, Function> _functionMap = new HashMap();
    private ArrayList<Function> _functionList = new ArrayList();
    private HashMap<StringValue, Function> _conditionalFunctionMap = new HashMap();
    private HashMap<String, InterpretedClassDef> _classMap = new HashMap();
    private ArrayList<InterpretedClassDef> _classList = new ArrayList();
    private HashMap<String, InterpretedClassDef> _conditionalClassMap = new HashMap();

    GlobalScope(ExprFactory exprFactory) {
        this._exprFactory = exprFactory;
    }

    @Override
    public boolean isGlobal() {
        return true;
    }

    @Override
    public void addFunction(StringValue name, Function function, boolean isTop) {
        if (isTop) {
            this._functionMap.put(name.toLowerCase(Locale.ENGLISH), function);
        }
        this._functionList.add(function);
    }

    @Override
    protected void addConditionalFunction(StringValue name, Function function) {
        this._conditionalFunctionMap.put(name, function);
    }

    @Override
    public InterpretedClassDef addClass(Location location, String name, String parentName, ArrayList<String> ifaceList, int index, boolean isTop) {
        InterpretedClassDef cl = null;
        if (isTop) {
            cl = this._classMap.get(name);
        }
        if (cl == null) {
            String[] ifaces = new String[ifaceList.size()];
            ifaceList.toArray(ifaces);
            cl = this._exprFactory.createClassDef(location, name, parentName, ifaces, index);
            if (isTop) {
                cl.setTopScope(true);
                this._classMap.put(name, cl);
            }
        } else {
            cl = this._exprFactory.createClassDef(location, name, parentName, new String[0], index);
        }
        this._classList.add(cl);
        return cl;
    }

    @Override
    protected void addConditionalClass(InterpretedClassDef def) {
        this._classList.add(def);
    }

    public HashMap<StringValue, Function> getFunctionMap() {
        return this._functionMap;
    }

    public ArrayList<Function> getFunctionList() {
        return this._functionList;
    }

    public HashMap<StringValue, Function> getConditionalFunctionMap() {
        return this._conditionalFunctionMap;
    }

    public HashMap<String, InterpretedClassDef> getClassMap() {
        return this._classMap;
    }

    public ArrayList<InterpretedClassDef> getClassList() {
        return this._classList;
    }

    public HashMap<String, InterpretedClassDef> getConditionalClassMap() {
        return this._conditionalClassMap;
    }
}

