/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.quercus.parser;

import com.caucho.quercus.Location;
import com.caucho.quercus.QuercusContext;
import com.caucho.quercus.QuercusRuntimeException;
import com.caucho.quercus.env.BinaryBuilderValue;
import com.caucho.quercus.env.BinaryValue;
import com.caucho.quercus.env.BooleanValue;
import com.caucho.quercus.env.ConstStringValue;
import com.caucho.quercus.env.DoubleValue;
import com.caucho.quercus.env.Env;
import com.caucho.quercus.env.FieldVisibility;
import com.caucho.quercus.env.LongValue;
import com.caucho.quercus.env.StringBuilderValue;
import com.caucho.quercus.env.StringValue;
import com.caucho.quercus.env.UnicodeBuilderValue;
import com.caucho.quercus.env.UnicodeValue;
import com.caucho.quercus.expr.AbstractVarExpr;
import com.caucho.quercus.expr.BinaryAppendExpr;
import com.caucho.quercus.expr.ClosureExpr;
import com.caucho.quercus.expr.ConstExpr;
import com.caucho.quercus.expr.Expr;
import com.caucho.quercus.expr.ExprFactory;
import com.caucho.quercus.expr.ListHeadExpr;
import com.caucho.quercus.expr.LiteralStringExpr;
import com.caucho.quercus.expr.VarExpr;
import com.caucho.quercus.expr.VarInfo;
import com.caucho.quercus.expr.VarVarExpr;
import com.caucho.quercus.function.AbstractFunction;
import com.caucho.quercus.parser.ClassScope;
import com.caucho.quercus.parser.FunctionScope;
import com.caucho.quercus.parser.GlobalScope;
import com.caucho.quercus.parser.QuercusParseException;
import com.caucho.quercus.parser.Scope;
import com.caucho.quercus.program.Arg;
import com.caucho.quercus.program.ClassDef;
import com.caucho.quercus.program.Function;
import com.caucho.quercus.program.FunctionInfo;
import com.caucho.quercus.program.InterpretedClassDef;
import com.caucho.quercus.program.QuercusProgram;
import com.caucho.quercus.program.Visibility;
import com.caucho.quercus.statement.BlockStatement;
import com.caucho.quercus.statement.Statement;
import com.caucho.quercus.statement.TryStatement;
import com.caucho.util.IntMap;
import com.caucho.util.L10N;
import com.caucho.vfs.IOExceptionWrapper;
import com.caucho.vfs.NullPath;
import com.caucho.vfs.Path;
import com.caucho.vfs.ReadStream;
import com.caucho.vfs.StringPath;
import com.caucho.vfs.Vfs;
import com.caucho.vfs.VfsStream;
import java.io.CharConversionException;
import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Locale;

public class QuercusParser {
    private static final L10N L = new L10N(QuercusParser.class);
    private static final int M_STATIC = 1;
    private static final int M_PUBLIC = 2;
    private static final int M_PROTECTED = 4;
    private static final int M_PRIVATE = 8;
    private static final int M_FINAL = 16;
    private static final int M_ABSTRACT = 32;
    private static final int M_INTERFACE = 64;
    private static final int M_TRAIT = 128;
    private static final int IDENTIFIER = 256;
    private static final int STRING = 257;
    private static final int LONG = 258;
    private static final int DOUBLE = 259;
    private static final int LSHIFT = 260;
    private static final int RSHIFT = 261;
    private static final int PHP_END = 262;
    private static final int EQ = 263;
    private static final int DEREF = 264;
    private static final int LEQ = 268;
    private static final int GEQ = 269;
    private static final int NEQ = 270;
    private static final int EQUALS = 271;
    private static final int NEQUALS = 272;
    private static final int C_AND = 273;
    private static final int C_OR = 274;
    private static final int PLUS_ASSIGN = 278;
    private static final int MINUS_ASSIGN = 279;
    private static final int APPEND_ASSIGN = 280;
    private static final int MUL_ASSIGN = 281;
    private static final int DIV_ASSIGN = 282;
    private static final int MOD_ASSIGN = 283;
    private static final int AND_ASSIGN = 284;
    private static final int OR_ASSIGN = 285;
    private static final int XOR_ASSIGN = 286;
    private static final int LSHIFT_ASSIGN = 287;
    private static final int RSHIFT_ASSIGN = 288;
    private static final int INCR = 289;
    private static final int DECR = 290;
    private static final int SCOPE = 291;
    private static final int ESCAPED_STRING = 292;
    private static final int HEREDOC = 293;
    private static final int ARRAY_RIGHT = 294;
    private static final int SIMPLE_STRING_ESCAPE = 295;
    private static final int COMPLEX_STRING_ESCAPE = 296;
    private static final int BINARY = 297;
    private static final int SIMPLE_BINARY_ESCAPE = 298;
    private static final int COMPLEX_BINARY_ESCAPE = 299;
    private static final int FIRST_IDENTIFIER_LEXEME = 512;
    private static final int ECHO = 512;
    private static final int NULL = 513;
    private static final int IF = 514;
    private static final int WHILE = 515;
    private static final int FUNCTION = 516;
    private static final int CLASS = 517;
    private static final int NEW = 518;
    private static final int RETURN = 519;
    private static final int VAR = 520;
    private static final int PRIVATE = 521;
    private static final int PROTECTED = 522;
    private static final int PUBLIC = 523;
    private static final int FOR = 524;
    private static final int DO = 525;
    private static final int BREAK = 526;
    private static final int CONTINUE = 527;
    private static final int ELSE = 528;
    private static final int EXTENDS = 529;
    private static final int STATIC = 530;
    private static final int INCLUDE = 531;
    private static final int REQUIRE = 532;
    private static final int INCLUDE_ONCE = 533;
    private static final int REQUIRE_ONCE = 534;
    private static final int UNSET = 535;
    private static final int FOREACH = 536;
    private static final int AS = 537;
    private static final int TEXT = 538;
    private static final int ISSET = 539;
    private static final int SWITCH = 540;
    private static final int CASE = 541;
    private static final int DEFAULT = 542;
    private static final int EXIT = 543;
    private static final int GLOBAL = 544;
    private static final int ELSEIF = 545;
    private static final int PRINT = 546;
    private static final int SYSTEM_STRING = 547;
    private static final int SIMPLE_SYSTEM_STRING = 548;
    private static final int COMPLEX_SYSTEM_STRING = 549;
    private static final int TEXT_ECHO = 550;
    private static final int ENDIF = 551;
    private static final int ENDWHILE = 552;
    private static final int ENDFOR = 553;
    private static final int ENDFOREACH = 554;
    private static final int ENDSWITCH = 555;
    private static final int XOR_RES = 556;
    private static final int AND_RES = 557;
    private static final int OR_RES = 558;
    private static final int LIST = 559;
    private static final int THIS = 560;
    private static final int TRUE = 561;
    private static final int FALSE = 562;
    private static final int CLONE = 563;
    private static final int INSTANCEOF = 564;
    private static final int CONST = 565;
    private static final int ABSTRACT = 566;
    private static final int FINAL = 567;
    private static final int DIE = 568;
    private static final int THROW = 569;
    private static final int TRY = 570;
    private static final int CATCH = 571;
    private static final int INTERFACE = 572;
    private static final int TRAIT = 573;
    private static final int IMPLEMENTS = 574;
    private static final int IMPORT = 575;
    private static final int TEXT_PHP = 576;
    private static final int NAMESPACE = 577;
    private static final int USE = 578;
    private static final int INSTEADOF = 579;
    private static final int EMPTY = 580;
    private static final int LAST_IDENTIFIER_LEXEME = 1024;
    private static final IntMap _insensitiveReserved = new IntMap();
    private static final IntMap _reserved = new IntMap();
    private QuercusContext _quercus;
    private Path _sourceFile;
    private int _sourceOffset;
    private ParserLocation _parserLocation = new ParserLocation();
    private ExprFactory _factory;
    private boolean _hasCr;
    private int _peek = -1;
    private ReadStream _is;
    private Reader _reader;
    private String _scriptEncoding = "utf-8";
    private StringValue _sb;
    private StringValue _namespace;
    private HashMap<StringValue, StringValue> _namespaceUseMap = new HashMap();
    private int _peekToken = -1;
    private StringValue _lexeme;
    private String _heredocEnd = null;
    private GlobalScope _globalScope;
    private boolean _returnsReference = false;
    private Scope _scope;
    private InterpretedClassDef _classDef;
    private FunctionInfo _function;
    private boolean _isTop;
    private boolean _isNewExpr;
    private boolean _isIfTest;
    private int _classesParsed;
    private int _functionsParsed;
    private ArrayList<String> _loopLabelList = new ArrayList();
    private int _labelsCreated;
    private String _comment;

    public QuercusParser(QuercusContext quercus) {
        this(quercus, quercus != null ? quercus.getScriptEncoding() : "utf-8");
    }

    public QuercusParser(QuercusContext quercus, String scriptEncoding) {
        this._quercus = quercus;
        this._factory = quercus == null ? ExprFactory.create() : quercus.createExprFactory();
        this._globalScope = new GlobalScope(this._factory);
        this._scope = this._globalScope;
        this._scriptEncoding = scriptEncoding;
        if (this.isUnicodeSemantics()) {
            this._namespace = UnicodeBuilderValue.EMPTY;
            this._lexeme = UnicodeBuilderValue.EMPTY;
            this._sb = new UnicodeBuilderValue();
        } else {
            this._namespace = ConstStringValue.EMPTY;
            this._lexeme = ConstStringValue.EMPTY;
            this._sb = new StringBuilderValue();
        }
    }

    public QuercusParser(QuercusContext quercus, Path sourceFile, ReadStream is) {
        this(quercus);
        this.init(sourceFile, is, null);
    }

    public QuercusParser(QuercusContext quercus, Path sourceFile, Reader reader) {
        this(quercus);
        this.init(sourceFile, null, reader);
    }

    private void init(Path sourceFile) throws IOException {
        this.init(sourceFile, sourceFile.openRead(), null);
    }

    private void init(Path sourceFile, ReadStream is, Reader reader) {
        this._is = is;
        this._reader = reader;
        if (sourceFile != null) {
            this._parserLocation.setFileName(sourceFile);
            this._sourceFile = sourceFile;
        } else {
            this._parserLocation.setFileName("eval:");
            this._sourceFile = new NullPath("eval:");
        }
        this._parserLocation.setLineNumber(1);
        this._peek = -1;
        this._peekToken = -1;
    }

    public void setLocation(String fileName, int line) {
        this._parserLocation.setFileName(fileName);
        this._parserLocation.setLineNumber(line);
        if (line > 0) {
            this._sourceOffset = 1 - line;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static QuercusProgram parse(QuercusContext quercus, Path path, String encoding) throws IOException {
        ReadStream is = path.openRead();
        try {
            if (quercus != null && quercus.isUnicodeSemantics()) {
                is.setEncoding(encoding);
            }
            QuercusParser parser = new QuercusParser(quercus, path, is);
            QuercusProgram quercusProgram = parser.parse();
            return quercusProgram;
        }
        finally {
            is.close();
        }
    }

    public static QuercusProgram parse(QuercusContext quercus, Path path, String encoding, String fileName, int line) throws IOException {
        ReadStream is = path.openRead();
        try {
            if (quercus != null && quercus.isUnicodeSemantics()) {
                is.setEncoding(encoding);
            }
            QuercusParser parser = new QuercusParser(quercus, path, is);
            if (fileName != null && line >= 0) {
                parser.setLocation(fileName, line);
            }
            QuercusProgram quercusProgram = parser.parse();
            return quercusProgram;
        }
        catch (RuntimeException e) {
            throw e;
        }
        finally {
            is.close();
        }
    }

    public static QuercusProgram parse(QuercusContext quercus, ReadStream is) throws IOException {
        QuercusParser parser = new QuercusParser(quercus, is.getPath(), is);
        return parser.parse();
    }

    public static QuercusProgram parse(QuercusContext quercus, Path path, Reader reader) throws IOException {
        QuercusParser parser = new QuercusParser(quercus, path, reader);
        return parser.parse();
    }

    public static QuercusProgram parse(QuercusContext quercus, Path path, ReadStream is) throws IOException {
        return new QuercusParser(quercus, path, is).parse();
    }

    public static QuercusProgram parseEval(QuercusContext quercus, StringValue str) throws IOException {
        QuercusParser parser;
        if (str.isUnicode()) {
            parser = new QuercusParser(quercus, null, str.toSimpleReader());
        } else {
            ReadStream is = new ReadStream(new VfsStream(str.toInputStream(), null));
            parser = new QuercusParser(quercus, null, is);
        }
        return parser.parseCode();
    }

    public static QuercusProgram parseEvalExpr(QuercusContext quercus, StringValue str) throws IOException {
        QuercusParser parser;
        if (str.isUnicode()) {
            parser = new QuercusParser(quercus, null, str.toSimpleReader());
        } else {
            ReadStream is = new ReadStream(new VfsStream(str.toInputStream(), null));
            parser = new QuercusParser(quercus, null, is);
        }
        return parser.parseCode().createExprReturn();
    }

    public static AbstractFunction parseFunction(QuercusContext quercus, String name, String args, String code) throws IOException {
        StringPath argPath = new StringPath(args);
        StringPath codePath = new StringPath(code);
        QuercusParser parser = new QuercusParser(quercus);
        Function fun = parser.parseFunction(name, argPath, codePath);
        parser.close();
        return fun;
    }

    public boolean isUnicodeSemantics() {
        return this._quercus != null && this._quercus.isUnicodeSemantics();
    }

    public boolean isShortOpenTag() {
        return this._quercus != null && this._quercus.getIniBoolean("short_open_tag");
    }

    public static Expr parse(QuercusContext quercus, String str) throws IOException {
        StringPath path = new StringPath(str);
        return new QuercusParser(quercus, (Path)path, path.openRead()).parseExpr();
    }

    public static Expr parseDefault(String str) {
        try {
            StringPath path = new StringPath(str);
            return new QuercusParser(null, (Path)path, path.openRead()).parseExpr();
        }
        catch (IOException e) {
            throw new QuercusRuntimeException(e);
        }
    }

    public static Expr parseDefault(ExprFactory factory, String str) {
        try {
            StringPath path = new StringPath(str);
            QuercusParser parser = new QuercusParser(null, (Path)path, path.openRead());
            parser._factory = factory;
            return parser.parseExpr();
        }
        catch (IOException e) {
            throw new QuercusRuntimeException(e);
        }
    }

    public String getFileName() {
        if (this._sourceFile == null) {
            return null;
        }
        return this._sourceFile.getPath();
    }

    public String getClassName() {
        if (this._classDef != null) {
            return this._classDef.getName();
        }
        return null;
    }

    public int getLine() {
        return this._parserLocation.getLineNumber();
    }

    public ExprFactory getExprFactory() {
        return this._factory;
    }

    public ExprFactory getFactory() {
        return this._factory;
    }

    public QuercusProgram parse() throws IOException {
        ClassDef globalClass = null;
        this._function = this.getFactory().createFunctionInfo(this._quercus, globalClass, "");
        this._function.setPageMain(true);
        this._function.setVariableVar(true);
        this._function.setUsesSymbolTable(true);
        Statement stmt = this.parseTop();
        QuercusProgram program = new QuercusProgram(this._quercus, this._sourceFile, this._globalScope.getFunctionMap(), this._globalScope.getFunctionList(), this._globalScope.getClassMap(), this._globalScope.getClassList(), this._function, stmt);
        return program;
    }

    QuercusProgram parseCode() throws IOException {
        ClassDef globalClass = null;
        this._function = this.getFactory().createFunctionInfo(this._quercus, globalClass, "eval");
        this._function.setGlobal(false);
        Location location = this.getLocation();
        ArrayList<Statement> stmtList = this.parseStatementList();
        return new QuercusProgram(this._quercus, this._sourceFile, this._globalScope.getFunctionMap(), this._globalScope.getFunctionList(), this._globalScope.getClassMap(), this._globalScope.getClassList(), this._function, this._factory.createBlock(location, stmtList));
    }

    public Function parseFunction(String name, Path argPath, Path codePath) throws IOException {
        ClassDef globalClass = null;
        this._function = this.getFactory().createFunctionInfo(this._quercus, globalClass, name);
        this._function.setGlobal(false);
        this._function.setPageMain(true);
        this.init(argPath);
        Arg[] args = this.parseFunctionArgDefinition();
        this.close();
        this.init(codePath);
        Statement[] statements = this.parseStatements();
        Function fun = this._factory.createFunction(Location.UNKNOWN, name, this._function, args, statements);
        this.close();
        return fun;
    }

    Statement parseTop() throws IOException {
        this._isTop = true;
        ArrayList<Statement> statements = new ArrayList<Statement>();
        Location location = this.getLocation();
        int token = this.parsePhpText();
        if (this._lexeme.length() > 0) {
            statements.add(this._factory.createText(location, this._lexeme));
        }
        if (token == 550) {
            this.parseEcho(statements);
        } else if (token == 576) {
            this._peekToken = this.parseToken();
            if (this._peekToken == 256 && this._lexeme.equalsStringIgnoreCase("php")) {
                this._peekToken = -1;
            }
        }
        statements.addAll(this.parseStatementList());
        return this._factory.createBlock(location, statements);
    }

    private Statement[] parseStatements() throws IOException {
        ArrayList<Statement> statementList = this.parseStatementList();
        Statement[] statements = new Statement[statementList.size()];
        statementList.toArray(statements);
        return statements;
    }

    private ArrayList<Statement> parseStatementList() throws IOException {
        ArrayList<Statement> statementList = new ArrayList<Statement>();
        block39: while (true) {
            Location location = this.getLocation();
            int token = this.parseToken();
            switch (token) {
                case -1: {
                    return statementList;
                }
                case 59: {
                    break;
                }
                case 512: {
                    this.parseEcho(statementList);
                    break;
                }
                case 546: {
                    statementList.add(this.parsePrint());
                    break;
                }
                case 535: {
                    this.parseUnset(statementList);
                    break;
                }
                case 566: 
                case 567: {
                    this._peekToken = token;
                    int modifiers = 0;
                    do {
                        token = this.parseToken();
                        switch (token) {
                            case 566: {
                                modifiers |= 0x20;
                                break;
                            }
                            case 567: {
                                modifiers |= 0x10;
                                break;
                            }
                            case 517: {
                                statementList.add(this.parseClassDefinition(modifiers));
                                break;
                            }
                            default: {
                                throw this.error(L.l("expected 'class' at {0}", (Object)this.tokenName(token)));
                            }
                        }
                    } while (token != 517);
                    break;
                }
                case 516: {
                    Location functionLocation = this.getLocation();
                    Function fun = this.parseFunctionDefinition(1);
                    if (this._isTop) continue block39;
                    statementList.add(this._factory.createFunctionDef(functionLocation, fun));
                    break;
                }
                case 517: {
                    statementList.add(this.parseClassDefinition(0));
                    break;
                }
                case 572: {
                    statementList.add(this.parseClassDefinition(64));
                    break;
                }
                case 573: {
                    statementList.add(this.parseClassDefinition(128));
                    break;
                }
                case 565: {
                    statementList.addAll(this.parseConstDefinition());
                    break;
                }
                case 514: {
                    statementList.add(this.parseIf());
                    break;
                }
                case 540: {
                    statementList.add(this.parseSwitch());
                    break;
                }
                case 515: {
                    statementList.add(this.parseWhile());
                    break;
                }
                case 525: {
                    statementList.add(this.parseDo());
                    break;
                }
                case 524: {
                    statementList.add(this.parseFor());
                    break;
                }
                case 536: {
                    statementList.add(this.parseForeach());
                    break;
                }
                case 262: {
                    return statementList;
                }
                case 519: {
                    statementList.add(this.parseReturn());
                    break;
                }
                case 569: {
                    statementList.add(this.parseThrow());
                    break;
                }
                case 526: {
                    statementList.add(this.parseBreak());
                    break;
                }
                case 527: {
                    statementList.add(this.parseContinue());
                    break;
                }
                case 544: {
                    statementList.add(this.parseGlobal());
                    break;
                }
                case 530: {
                    statementList.add(this.parseStatic());
                    break;
                }
                case 570: {
                    statementList.add(this.parseTry());
                    break;
                }
                case 577: {
                    statementList.addAll(this.parseNamespace());
                    break;
                }
                case 578: {
                    this.parseUse();
                    break;
                }
                case 123: {
                    ArrayList<Statement> enclosedStatementList = this.parseStatementList();
                    this.expect(125);
                    statementList.addAll(enclosedStatementList);
                    break;
                }
                case 125: 
                case 528: 
                case 541: 
                case 542: 
                case 545: 
                case 551: 
                case 552: 
                case 553: 
                case 554: 
                case 555: {
                    this._peekToken = token;
                    return statementList;
                }
                case 538: {
                    if (this._lexeme.length() <= 0) continue block39;
                    statementList.add(this._factory.createText(location, this._lexeme));
                    break;
                }
                case 576: {
                    if (this._lexeme.length() > 0) {
                        statementList.add(this._factory.createText(location, this._lexeme));
                    }
                    this._peekToken = this.parseToken();
                    if (this._peekToken != 256 || !this._lexeme.equalsStringIgnoreCase("php")) continue block39;
                    this._peekToken = -1;
                    break;
                }
                case 550: {
                    if (this._lexeme.length() > 0) {
                        statementList.add(this._factory.createText(location, this._lexeme));
                    }
                    this.parseEcho(statementList);
                    break;
                }
                default: {
                    this._peekToken = token;
                    statementList.add(this.parseExprStatement());
                }
            }
        }
    }

    private Statement parseStatement() throws IOException {
        Location location = this.getLocation();
        int token = this.parseToken();
        switch (token) {
            case 59: {
                return this._factory.createNullStatement();
            }
            case 123: {
                location = this.getLocation();
                ArrayList<Statement> statementList = this.parseStatementList();
                this.expect(125);
                return this._factory.createBlock(location, statementList);
            }
            case 514: {
                return this.parseIf();
            }
            case 540: {
                return this.parseSwitch();
            }
            case 515: {
                return this.parseWhile();
            }
            case 525: {
                return this.parseDo();
            }
            case 524: {
                return this.parseFor();
            }
            case 536: {
                return this.parseForeach();
            }
            case 570: {
                return this.parseTry();
            }
            case 538: {
                if (this._lexeme.length() > 0) {
                    return this._factory.createText(location, this._lexeme);
                }
                return this.parseStatement();
            }
            case 576: {
                Statement stmt = null;
                if (this._lexeme.length() > 0) {
                    stmt = this._factory.createText(location, this._lexeme);
                }
                this._peekToken = this.parseToken();
                if (this._peekToken == 256 && this._lexeme.equalsStringIgnoreCase("php")) {
                    this._peekToken = -1;
                }
                if (stmt == null) {
                    stmt = this.parseStatement();
                }
                return stmt;
            }
        }
        Statement stmt = this.parseStatementImpl(token);
        token = this.parseToken();
        if (token != 59) {
            this._peekToken = token;
        }
        return stmt;
    }

    private Statement parseStatementImpl(int token) throws IOException {
        switch (token) {
            case 512: {
                Location location = this.getLocation();
                ArrayList<Statement> statementList = new ArrayList<Statement>();
                this.parseEcho(statementList);
                return this._factory.createBlock(location, statementList);
            }
            case 546: {
                return this.parsePrint();
            }
            case 535: {
                return this.parseUnset();
            }
            case 544: {
                return this.parseGlobal();
            }
            case 530: {
                return this.parseStatic();
            }
            case 526: {
                return this.parseBreak();
            }
            case 527: {
                return this.parseContinue();
            }
            case 519: {
                return this.parseReturn();
            }
            case 569: {
                return this.parseThrow();
            }
            case 570: {
                return this.parseTry();
            }
        }
        this._peekToken = token;
        return this.parseExprStatement();
    }

    private void parseEcho(ArrayList<Statement> statements) throws IOException {
        int token;
        Location location = this.getLocation();
        do {
            Expr expr = this.parseTopExpr();
            this.createEchoStatements(location, statements, expr);
        } while ((token = this.parseToken()) == 44);
        this._peekToken = token;
    }

    private void createEchoStatements(Location location, ArrayList<Statement> statements, Expr expr) {
        if (expr != null) {
            if (expr instanceof BinaryAppendExpr) {
                BinaryAppendExpr append = (BinaryAppendExpr)expr;
                this.createEchoStatements(location, statements, append.getValue());
                this.createEchoStatements(location, statements, append.getNext());
            } else if (expr instanceof LiteralStringExpr) {
                LiteralStringExpr string = (LiteralStringExpr)expr;
                Statement statement = this._factory.createText(location, (StringValue)string.evalConstant());
                statements.add(statement);
            } else {
                Statement statement = this._factory.createEcho(location, expr);
                statements.add(statement);
            }
        }
    }

    private Statement parsePrint() throws IOException {
        return this._factory.createExpr(this.getLocation(), this.parsePrintExpr());
    }

    private Expr parsePrintExpr() throws IOException {
        ArrayList<Expr> args = new ArrayList<Expr>();
        args.add(this.parseTopExpr());
        return this._factory.createCall(this, this.createStringValue("print"), args);
    }

    private Statement parseGlobal() throws IOException {
        int token;
        ArrayList<Statement> statementList = new ArrayList<Statement>();
        Location location = this.getLocation();
        do {
            AbstractVarExpr var;
            Expr expr;
            if ((expr = this.parseTopExpr()) instanceof VarExpr) {
                var = (VarExpr)expr;
                this._function.setUsesGlobal(true);
                statementList.add(this._factory.createGlobal(location, (VarExpr)var));
                continue;
            }
            if (expr instanceof VarVarExpr) {
                var = (VarVarExpr)expr;
                statementList.add(this._factory.createVarGlobal(location, (VarVarExpr)var));
                continue;
            }
            throw this.error(L.l("unknown expr {0} to global", (Object)expr));
        } while ((token = this.parseToken()) == 44);
        this._peekToken = token;
        return this._factory.createBlock(location, statementList);
    }

    private Statement parseStatic() throws IOException {
        int token;
        ArrayList<Statement> statementList = new ArrayList<Statement>();
        Location location = this.getLocation();
        do {
            Statement statement;
            this.expect(36);
            StringValue name = this.parseIdentifier();
            VarExpr var = this._factory.createVar(this._function.createVar(name));
            Expr init = null;
            token = this.parseToken();
            if (token == 61) {
                init = this.parseExpr();
                token = this.parseToken();
            }
            if (this._function.isClosure()) {
                statement = this._factory.createClosureStatic(location, var, init);
            } else {
                StringValue sb = this.createStringBuilder();
                if (this._classDef != null) {
                    sb.append(this._classDef.getName());
                    sb.append("::");
                }
                sb.append(this._function.getName());
                sb.append("::");
                sb.append(name);
                statement = this._classDef != null ? this._factory.createClassStatic(location, sb, var, init) : this._factory.createStatic(location, sb, var, init);
            }
            statementList.add(statement);
        } while (token == 44);
        this._peekToken = token;
        return this._factory.createBlock(location, statementList);
    }

    private Statement parseUnset() throws IOException {
        Location location = this.getLocation();
        ArrayList<Statement> statementList = new ArrayList<Statement>();
        this.parseUnset(statementList);
        return this._factory.createBlock(location, statementList);
    }

    private void parseUnset(ArrayList<Statement> statementList) throws IOException {
        Location location = this.getLocation();
        int token = this.parseToken();
        if (token != 40) {
            this._peekToken = token;
            statementList.add(this.parseTopExpr().createUnset(this._factory, location));
            return;
        }
        do {
            Expr topExpr = this.parseTopExpr();
            statementList.add(topExpr.createUnset(this._factory, this.getLocation()));
        } while ((token = this.parseToken()) == 44);
        this._peekToken = token;
        this.expect(41);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Statement parseIf() throws IOException {
        boolean oldTop = this._isTop;
        this._isTop = false;
        try {
            Location location = this.getLocation();
            this.expect(40);
            this._isIfTest = true;
            Expr test = this.parseExpr();
            this._isIfTest = false;
            this.expect(41);
            int token = this.parseToken();
            if (token == 58) {
                Statement statement = this.parseAlternateIf(test, location);
                return statement;
            }
            this._peekToken = token;
            Statement trueBlock = null;
            trueBlock = this.parseStatement();
            Statement falseBlock = null;
            token = this.parseToken();
            if (token == 545) {
                falseBlock = this.parseIf();
            } else if (token == 528) {
                falseBlock = this.parseStatement();
            } else {
                this._peekToken = token;
            }
            Statement statement = this._factory.createIf(location, test, trueBlock, falseBlock);
            return statement;
        }
        finally {
            this._isTop = oldTop;
        }
    }

    private Statement parseAlternateIf(Expr test, Location location) throws IOException {
        Statement trueBlock = null;
        trueBlock = this._factory.createBlock(location, this.parseStatementList());
        Statement falseBlock = null;
        int token = this.parseToken();
        if (token == 545) {
            Location subLocation = this.getLocation();
            Expr subTest = this.parseExpr();
            this.expect(58);
            falseBlock = this.parseAlternateIf(subTest, subLocation);
        } else if (token == 528) {
            this.expect(58);
            falseBlock = this._factory.createBlock(this.getLocation(), this.parseStatementList());
            this.expect(551);
        } else {
            this._peekToken = token;
            this.expect(551);
        }
        return this._factory.createIf(location, test, trueBlock, falseBlock);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Statement parseSwitch() throws IOException {
        Location location = this.getLocation();
        boolean oldTop = this._isTop;
        this._isTop = false;
        String label = this.pushSwitchLabel();
        try {
            this.expect(40);
            Expr test = this.parseExpr();
            this.expect(41);
            boolean isAlternate = false;
            int token = this.parseToken();
            if (token == 58) {
                isAlternate = true;
            } else if (token == 123) {
                isAlternate = false;
            } else {
                this._peekToken = token;
                this.expect(123);
            }
            ArrayList<Expr[]> caseList = new ArrayList<Expr[]>();
            ArrayList<BlockStatement> blockList = new ArrayList<BlockStatement>();
            ArrayList<Integer> fallThroughList = new ArrayList<Integer>();
            BlockStatement defaultBlock = null;
            while ((token = this.parseToken()) == 541 || token == 542) {
                Location caseLocation = this.getLocation();
                ArrayList<Expr> valueList = new ArrayList<Expr>();
                boolean isDefault = false;
                while (token == 541 || token == 542) {
                    if (token == 541) {
                        Expr value = this.parseExpr();
                        valueList.add(value);
                    } else {
                        isDefault = true;
                    }
                    token = this.parseToken();
                    if (token != 58 && token != 59) {
                        throw this.error("expected ':' at " + this.tokenName(token));
                    }
                    token = this.parseToken();
                }
                this._peekToken = token;
                Expr[] values = new Expr[valueList.size()];
                valueList.toArray(values);
                ArrayList<Statement> newBlockList = this.parseStatementList();
                Iterator iterator = fallThroughList.iterator();
                while (iterator.hasNext()) {
                    int fallThrough = (Integer)iterator.next();
                    BlockStatement block = blockList.get(fallThrough);
                    boolean isDefaultBlock = block == defaultBlock;
                    block = block.append(newBlockList);
                    blockList.set(fallThrough, block);
                    if (!isDefaultBlock) continue;
                    defaultBlock = block;
                }
                BlockStatement block = this._factory.createBlockImpl(caseLocation, newBlockList);
                if (values.length > 0) {
                    caseList.add(values);
                    blockList.add(block);
                }
                if (isDefault) {
                    defaultBlock = block;
                }
                if (blockList.size() > 0 && !fallThroughList.contains(blockList.size() - 1)) {
                    fallThroughList.add(blockList.size() - 1);
                }
                if (block.fallThrough() == 0) continue;
                fallThroughList.clear();
            }
            this._peekToken = token;
            if (isAlternate) {
                this.expect(555);
            } else {
                this.expect(125);
            }
            Statement statement = this._factory.createSwitch(location, test, caseList, blockList, defaultBlock, label);
            return statement;
        }
        finally {
            this._isTop = oldTop;
            this.popLoopLabel();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Statement parseWhile() throws IOException {
        boolean oldTop = this._isTop;
        this._isTop = false;
        String label = this.pushWhileLabel();
        try {
            Statement block;
            Location location = this.getLocation();
            this.expect(40);
            this._isIfTest = true;
            Expr test = this.parseExpr();
            this._isIfTest = false;
            this.expect(41);
            int token = this.parseToken();
            if (token == 58) {
                block = this._factory.createBlock(this.getLocation(), this.parseStatementList());
                this.expect(552);
            } else {
                this._peekToken = token;
                block = this.parseStatement();
            }
            Statement statement = this._factory.createWhile(location, test, block, label);
            return statement;
        }
        finally {
            this._isTop = oldTop;
            this.popLoopLabel();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Statement parseDo() throws IOException {
        boolean oldTop = this._isTop;
        this._isTop = false;
        String label = this.pushDoLabel();
        try {
            Location location = this.getLocation();
            Statement block = this.parseStatement();
            this.expect(515);
            this.expect(40);
            this._isIfTest = true;
            Expr test = this.parseExpr();
            this._isIfTest = false;
            this.expect(41);
            Statement statement = this._factory.createDo(location, test, block, label);
            return statement;
        }
        finally {
            this._isTop = oldTop;
            this.popLoopLabel();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Statement parseFor() throws IOException {
        boolean oldTop = this._isTop;
        this._isTop = false;
        String label = this.pushForLabel();
        try {
            Statement block;
            Location location = this.getLocation();
            this.expect(40);
            Expr init = null;
            int token = this.parseToken();
            if (token != 59) {
                this._peekToken = token;
                init = this.parseTopCommaExpr();
                this.expect(59);
            }
            Expr test = null;
            token = this.parseToken();
            if (token != 59) {
                this._peekToken = token;
                this._isIfTest = true;
                test = this.parseTopCommaExpr();
                this._isIfTest = false;
                this.expect(59);
            }
            Expr incr = null;
            token = this.parseToken();
            if (token != 41) {
                this._peekToken = token;
                incr = this.parseTopCommaExpr();
                this.expect(41);
            }
            if ((token = this.parseToken()) == 58) {
                block = this._factory.createBlock(this.getLocation(), this.parseStatementList());
                this.expect(553);
            } else {
                this._peekToken = token;
                block = this.parseStatement();
            }
            Statement statement = this._factory.createFor(location, init, test, incr, block, label);
            return statement;
        }
        finally {
            this._isTop = oldTop;
            this.popLoopLabel();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Statement parseForeach() throws IOException {
        boolean oldTop = this._isTop;
        this._isTop = false;
        String label = this.pushForeachLabel();
        try {
            Statement block;
            AbstractVarExpr valueVar;
            Location location = this.getLocation();
            this.expect(40);
            Expr objExpr = this.parseTopExpr();
            this.expect(537);
            boolean isRef = false;
            int token = this.parseToken();
            if (token == 38) {
                isRef = true;
            } else {
                this._peekToken = token;
            }
            AbstractVarExpr valueExpr = this.parseLeftHandSide();
            AbstractVarExpr keyVar = null;
            token = this.parseToken();
            if (token == 294) {
                if (isRef) {
                    throw this.error(L.l("key reference is forbidden in foreach"));
                }
                keyVar = valueExpr;
                token = this.parseToken();
                if (token == 38) {
                    isRef = true;
                } else {
                    this._peekToken = token;
                }
                valueVar = this.parseLeftHandSide();
                token = this.parseToken();
            } else {
                valueVar = valueExpr;
            }
            if (token != 41) {
                throw this.error(L.l("expected ')' in foreach"));
            }
            token = this.parseToken();
            if (token == 58) {
                block = this._factory.createBlock(this.getLocation(), this.parseStatementList());
                this.expect(554);
            } else {
                this._peekToken = token;
                block = this.parseStatement();
            }
            Statement statement = this._factory.createForeach(location, objExpr, keyVar, valueVar, isRef, block, label);
            return statement;
        }
        finally {
            this._isTop = oldTop;
            this.popLoopLabel();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Statement parseTry() throws IOException {
        boolean oldTop = this._isTop;
        this._isTop = false;
        try {
            Location location = this.getLocation();
            Statement block = null;
            block = this.parseStatement();
            TryStatement stmt = this._factory.createTry(location, block);
            int token = this.parseToken();
            while (token == 571) {
                this.expect(40);
                StringValue id = this.parseNamespaceIdentifier();
                AbstractVarExpr lhs = this.parseLeftHandSide();
                this.expect(41);
                block = this.parseStatement();
                stmt.addCatch(id, lhs, block);
                token = this.parseToken();
            }
            this._peekToken = token;
            TryStatement tryStatement = stmt;
            return tryStatement;
        }
        finally {
            this._isTop = oldTop;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Function parseFunctionDefinition(int modifiers) throws IOException {
        boolean isTraitMethod;
        boolean oldTop = this._isTop;
        this._isTop = false;
        boolean oldReturnsReference = this._returnsReference;
        FunctionInfo oldFunction = this._function;
        boolean isAbstract = (modifiers & 0x20) != 0;
        boolean isStatic = (modifiers & 1) != 0;
        boolean bl = isTraitMethod = this._classDef != null && this._classDef.isTrait();
        if (this._classDef != null && this._classDef.isInterface()) {
            isAbstract = true;
        }
        try {
            Function function;
            this._returnsReference = false;
            int token = this.parseToken();
            String comment = this._comment;
            this._comment = null;
            if (token == 38) {
                this._returnsReference = true;
            } else {
                this._peekToken = token;
            }
            StringValue nameV = this.parseIdentifier();
            if (this._classDef == null) {
                nameV = this.resolveIdentifier(nameV);
            }
            if (isAbstract && !this._scope.isAbstract()) {
                if (this._classDef != null) {
                    throw this.error(L.l("'{0}' may not be abstract because class {1} is not abstract.", (Object)nameV, (Object)this._classDef.getName()));
                }
                throw this.error(L.l("'{0}' may not be abstract. Abstract functions are only allowed in abstract classes.", (Object)nameV));
            }
            boolean isConstructor = false;
            if (this._classDef != null && (nameV.equalsString(this._classDef.getName()) || nameV.equalsString("__constructor"))) {
                if (isStatic) {
                    throw this.error(L.l("'{0}:{1}' may not be static because class constructors may not be static", (Object)this._classDef.getName(), (Object)nameV));
                }
                isConstructor = true;
            }
            String name = nameV.toString();
            this._function = this.getFactory().createFunctionInfo(this._quercus, this._classDef, name);
            this._function.setPageStatic(oldTop);
            this._function.setConstructor(isConstructor);
            this._function.setReturnsReference(this._returnsReference);
            this._function.setStaticClassMethod(this._classDef != null && isStatic);
            Location location = this.getLocation();
            this.expect(40);
            Arg[] args = this.parseFunctionArgDefinition();
            this.expect(41);
            if (this._classDef != null && "__call".equals(name) && args.length != 2) {
                throw this.error(L.l("{0}::{1} must have exactly two arguments defined", (Object)this._classDef.getName(), (Object)name));
            }
            if (isAbstract) {
                this.expect(59);
                function = this._factory.createMethodDeclaration(location, this._classDef, name, this._function, args);
            } else {
                this.expect(123);
                Statement[] statements = null;
                Scope oldScope = this._scope;
                try {
                    this._scope = new FunctionScope(this._factory, oldScope);
                    statements = this.parseStatements();
                }
                finally {
                    this._scope = oldScope;
                }
                this.expect(125);
                function = this._classDef != null ? this._factory.createObjectMethod(location, this._classDef, name, this._function, args, statements) : this._factory.createFunction(location, name, this._function, args, statements);
            }
            function.setGlobal(oldTop);
            function.setStatic((modifiers & 1) != 0);
            function.setFinal((modifiers & 0x10) != 0);
            function.setTraitMethod(isTraitMethod);
            function.setParseIndex(this._functionsParsed++);
            function.setComment(comment);
            if ((modifiers & 4) != 0) {
                function.setVisibility(Visibility.PROTECTED);
            } else if ((modifiers & 8) != 0) {
                function.setVisibility(Visibility.PRIVATE);
            }
            this._scope.addFunction(this.createStringValue(name), function, oldTop);
            Function function2 = function;
            return function2;
        }
        finally {
            this._returnsReference = oldReturnsReference;
            this._function = oldFunction;
            this._isTop = oldTop;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Expr parseClosure() throws IOException {
        boolean oldTop = this._isTop;
        this._isTop = false;
        boolean oldReturnsReference = this._returnsReference;
        FunctionInfo oldFunction = this._function;
        try {
            Arg[] useArgs;
            this._returnsReference = false;
            int token = this.parseToken();
            String comment = null;
            if (token == 38) {
                this._returnsReference = true;
            } else {
                this._peekToken = token;
            }
            String name = "__quercus_closure_" + this._functionsParsed;
            InterpretedClassDef classDef = this._classDef;
            this._function = this.getFactory().createFunctionInfo(this._quercus, classDef, name);
            this._function.setReturnsReference(this._returnsReference);
            this._function.setClosure(true);
            this._function.setStaticClassMethod(this._classDef != null && oldFunction != null && oldFunction.isStaticClassMethod());
            Location location = this.getLocation();
            this.expect(40);
            Arg[] args = this.parseFunctionArgDefinition();
            this.expect(41);
            ArrayList<VarExpr> useVars = new ArrayList<VarExpr>();
            token = this.parseToken();
            if (token == 578) {
                this.expect(40);
                for (Arg arg : useArgs = this.parseFunctionArgDefinition()) {
                    VarExpr var = this._factory.createVar(oldFunction.createVar(arg.getName()));
                    useVars.add(var);
                }
                this.expect(41);
            } else {
                useArgs = new Arg[]{};
                this._peekToken = token;
            }
            this.expect(123);
            Statement[] statements = null;
            Scope oldScope = this._scope;
            try {
                this._scope = new FunctionScope(this._factory, oldScope);
                statements = this.parseStatements();
            }
            finally {
                this._scope = oldScope;
            }
            this.expect(125);
            Function function = this._factory.createFunction(location, name, this._function, args, statements);
            function.setParseIndex(this._functionsParsed++);
            function.setComment(comment);
            function.setClosure(true);
            function.setClosureUseArgs(useArgs);
            this._globalScope.addFunction(this.createStringValue(name), function, oldTop);
            boolean isInClassScope = this._classDef != null && !oldFunction.isStaticClassMethod();
            ClosureExpr closureExpr = this._factory.createClosure(location, function, useVars, isInClassScope);
            return closureExpr;
        }
        finally {
            this._returnsReference = oldReturnsReference;
            this._function = oldFunction;
            this._isTop = oldTop;
        }
    }

    private Arg[] parseFunctionArgDefinition() throws IOException {
        LinkedHashMap<StringValue, Arg> argMap;
        block6: {
            int token;
            argMap = new LinkedHashMap<StringValue, Arg>();
            do {
                token = this.parseToken();
                boolean isReference = false;
                String expectedClass = null;
                if (token != 41 && token != 38 && token != 36 && token != -1) {
                    this._peekToken = token;
                    expectedClass = this.parseNamespaceIdentifier().toString();
                    token = this.parseToken();
                }
                if (token == 38) {
                    isReference = true;
                    token = this.parseToken();
                }
                if (token != 36) {
                    this._peekToken = token;
                    break block6;
                }
                StringValue argName = this.parseIdentifier();
                Expr defaultExpr = this._factory.createRequired();
                token = this.parseToken();
                if (token == 61) {
                    defaultExpr = this.parseUnary();
                    token = this.parseToken();
                }
                Arg arg = new Arg(argName, defaultExpr, isReference, expectedClass);
                if (argMap.get(argName) != null && this._quercus.isStrict()) {
                    throw this.error(L.l("aliasing of function argument '{0}'", (Object)argName));
                }
                argMap.put(argName, arg);
                VarInfo var = this._function.createVar(argName);
            } while (token == 44);
            this._peekToken = token;
        }
        Arg[] args = new Arg[argMap.size()];
        argMap.values().toArray(args);
        return args;
    }

    private Statement parseBreak() throws IOException {
        if (!this._isTop && this._loopLabelList.size() == 0 && !this._quercus.isLooseParse()) {
            throw this.error(L.l("cannot 'break' inside a function"));
        }
        Location location = this.getLocation();
        int token = this.parseToken();
        switch (token) {
            case 59: {
                this._peekToken = token;
                return this._factory.createBreak(location, null, (ArrayList)this._loopLabelList.clone());
            }
        }
        this._peekToken = token;
        Expr expr = this.parseTopExpr();
        return this._factory.createBreak(location, expr, (ArrayList)this._loopLabelList.clone());
    }

    private Statement parseContinue() throws IOException {
        if (!this._isTop && this._loopLabelList.size() == 0 && !this._quercus.isLooseParse()) {
            throw this.error(L.l("cannot 'continue' inside a function"));
        }
        Location location = this.getLocation();
        int token = this.parseToken();
        switch (token) {
            case 59: 
            case 576: {
                this._peekToken = token;
                return this._factory.createContinue(location, null, (ArrayList)this._loopLabelList.clone());
            }
        }
        this._peekToken = token;
        Expr expr = this.parseTopExpr();
        return this._factory.createContinue(location, expr, (ArrayList)this._loopLabelList.clone());
    }

    private Statement parseReturn() throws IOException {
        Location location = this.getLocation();
        int token = this.parseToken();
        switch (token) {
            case 59: {
                this._peekToken = token;
                return this._factory.createReturn(location, this._factory.createNull());
            }
        }
        this._peekToken = token;
        Expr expr = this.parseTopExpr();
        if (this._returnsReference) {
            return this._factory.createReturnRef(location, expr);
        }
        return this._factory.createReturn(location, expr);
    }

    private Statement parseThrow() throws IOException {
        Location location = this.getLocation();
        Expr expr = this.parseExpr();
        return this._factory.createThrow(location, expr);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Statement parseClassDefinition(int modifiers) throws IOException {
        StringValue nameV = this.parseIdentifier();
        nameV = this.resolveIdentifier(nameV);
        String name = nameV.toString();
        String comment = this._comment;
        String parentName = null;
        ArrayList<String> ifaceList = new ArrayList<String>();
        int token = this.parseToken();
        if (token == 529 && (modifiers & 0x80) == 0) {
            if ((modifiers & 0x40) != 0) {
                do {
                    ifaceList.add(this.parseNamespaceIdentifier().toString());
                } while ((token = this.parseToken()) == 44);
            } else {
                parentName = this.parseNamespaceIdentifier().toString();
                token = this.parseToken();
            }
        }
        if (token == 574 && (modifiers & 0x40) == 0 && (modifiers & 0x80) == 0) {
            do {
                ifaceList.add(this.parseNamespaceIdentifier().toString());
            } while ((token = this.parseToken()) == 44);
        }
        this._peekToken = token;
        InterpretedClassDef oldClass = this._classDef;
        Scope oldScope = this._scope;
        try {
            this._classDef = oldScope.addClass(this.getLocation(), name, parentName, ifaceList, this._classesParsed++, this._isTop);
            this._classDef.setComment(comment);
            if ((modifiers & 0x20) != 0) {
                this._classDef.setAbstract(true);
            }
            if ((modifiers & 0x40) != 0) {
                this._classDef.setInterface(true);
            }
            if ((modifiers & 0x10) != 0) {
                this._classDef.setFinal(true);
            }
            if ((modifiers & 0x80) != 0) {
                this._classDef.setTrait(true);
            }
            this._scope = new ClassScope(this._classDef);
            this.expect(123);
            this.parseClassContents();
            this.expect(125);
            Statement statement = this._factory.createClassDef(this.getLocation(), this._classDef);
            return statement;
        }
        finally {
            this._classDef = oldClass;
            this._scope = oldScope;
        }
    }

    private void parseClassContents() throws IOException {
        while (true) {
            this._comment = null;
            int token = this.parseToken();
            switch (token) {
                case 59: {
                    break;
                }
                case 516: {
                    Function fun = this.parseFunctionDefinition(0);
                    fun.setStatic(false);
                    break;
                }
                case 517: {
                    this.parseClassDefinition(0);
                    break;
                }
                case 565: {
                    this.parseClassConstDefinition();
                    break;
                }
                case 521: 
                case 522: 
                case 523: 
                case 530: 
                case 566: 
                case 567: {
                    this._peekToken = token;
                    int modifiers = this.parseModifiers();
                    int token2 = this.parseToken();
                    if (token2 == 516) {
                        Function function = this.parseFunctionDefinition(modifiers);
                        break;
                    }
                    this._peekToken = token2;
                    this.parseClassVarDefinition(modifiers);
                    break;
                }
                case 578: {
                    this.parseUseTraitDefinition();
                    break;
                }
                case 256: {
                    if (this._lexeme.equalsString("var")) {
                        this.parseClassVarDefinition(0);
                        break;
                    }
                    this._peekToken = token;
                    return;
                }
                default: {
                    this._peekToken = token;
                    return;
                }
            }
        }
    }

    private void parseClassVarDefinition(int modifiers) throws IOException {
        int token;
        do {
            this.expect(36);
            String comment = this._comment;
            StringValue name = this.parseIdentifier();
            token = this.parseToken();
            Expr expr = null;
            if (token == 61) {
                expr = this.parseExpr();
            } else {
                this._peekToken = token;
                expr = this._factory.createNull();
            }
            if ((modifiers & 1) != 0) {
                ((ClassScope)this._scope).addStaticClassField(name, expr, this._comment);
                continue;
            }
            if ((modifiers & 8) != 0) {
                ((ClassScope)this._scope).addClassField(name, expr, FieldVisibility.PRIVATE, comment);
                continue;
            }
            if ((modifiers & 4) != 0) {
                ((ClassScope)this._scope).addClassField(name, expr, FieldVisibility.PROTECTED, comment);
                continue;
            }
            ((ClassScope)this._scope).addClassField(name, expr, FieldVisibility.PUBLIC, comment);
        } while ((token = this.parseToken()) == 44);
        this._peekToken = token;
    }

    private ArrayList<Statement> parseConstDefinition() throws IOException {
        int token;
        ArrayList<Statement> constList = new ArrayList<Statement>();
        do {
            StringValue name = this.parseNamespaceIdentifier();
            this.expect(61);
            Expr expr = this.parseExpr();
            ArrayList<Expr> args = new ArrayList<Expr>();
            args.add(this.createStringExpr(name));
            args.add(expr);
            Expr fun = this._factory.createCall(this, this.createStringValue("define"), args);
            constList.add(this._factory.createExpr(this.getLocation(), fun));
        } while ((token = this.parseToken()) == 44);
        this._peekToken = token;
        return constList;
    }

    private void parseClassConstDefinition() throws IOException {
        int token;
        do {
            StringValue name = this.parseIdentifier();
            this.expect(61);
            Expr expr = this.parseExpr();
            ((ClassScope)this._scope).addConstant(name, expr);
        } while ((token = this.parseToken()) == 44);
        this._peekToken = token;
    }

    private void parseUseTraitDefinition() throws IOException {
        int token;
        ArrayList<StringValue> traitList = new ArrayList<StringValue>();
        do {
            traitList.add(this.parseNamespaceIdentifier());
        } while ((token = this.parseToken()) == 44);
        for (StringValue traitName : traitList) {
            this._classDef.addTrait(traitName.toString());
        }
        if (token == 123) {
            while ((token = this.parseToken()) >= 0 && token != 125) {
                StringValue funName;
                this._peekToken = token;
                StringValue traitNameV = this.parseNamespaceIdentifier();
                token = this.parseToken();
                if (token == 291) {
                    funName = this.parseIdentifier();
                    token = this.parseToken();
                } else if (traitList.size() == 1) {
                    funName = traitNameV;
                    traitNameV = (StringValue)traitList.get(0);
                } else {
                    throw this.error(L.l("cannot resolve method because multiple traits are defined"));
                }
                if (token == 579) {
                    String insteadofTraitName = this.parseNamespaceIdentifier().toString();
                    this._classDef.addTraitInsteadOf(funName, traitNameV.toString(), insteadofTraitName);
                } else if (token == 537) {
                    StringValue funNameAlias = this.parseIdentifier();
                    this._classDef.addTraitAlias(funName, funNameAlias, traitNameV.toString());
                } else {
                    throw this.error(L.l("expected 'insteadof' or 'as' at {0}", (Object)this.tokenName(token)));
                }
                if ((token = this.parseToken()) == 59) continue;
                this._peekToken = token;
            }
            this._peekToken = token;
            this.expect(125);
        } else {
            this._peekToken = token;
        }
    }

    private int parseModifiers() throws IOException {
        int token;
        int modifiers = 0;
        block8: while (true) {
            token = this.parseToken();
            switch (token) {
                case 523: {
                    modifiers |= 2;
                    continue block8;
                }
                case 521: {
                    modifiers |= 8;
                    continue block8;
                }
                case 522: {
                    modifiers |= 4;
                    continue block8;
                }
                case 567: {
                    modifiers |= 0x10;
                    continue block8;
                }
                case 530: {
                    modifiers |= 1;
                    continue block8;
                }
                case 566: {
                    modifiers |= 0x20;
                    continue block8;
                }
            }
            break;
        }
        this._peekToken = token;
        return modifiers;
    }

    private ArrayList<Statement> parseNamespace() throws IOException {
        int token = this.parseToken();
        StringValue var = StringValue.EMPTY;
        if (token == 256) {
            var = this._lexeme;
            token = this.parseToken();
        }
        if (var.startsWith("\\")) {
            var = var.substring(1);
        }
        StringValue oldNamespace = this._namespace;
        this._namespace = var;
        if (token == 123) {
            ArrayList<Statement> statementList = this.parseStatementList();
            this.expect(125);
            this._namespace = oldNamespace;
            return statementList;
        }
        if (token == 59) {
            return new ArrayList<Statement>();
        }
        throw this.error(L.l("namespace must be followed by '{' or ';'"));
    }

    private void parseUse() throws IOException {
        int token = this.parseNamespaceIdentifier(this.read());
        StringValue name = this._lexeme;
        int ns = name.lastIndexOf('\\');
        StringValue tail = ns >= 0 ? name.substring(ns + 1) : name;
        if (name.startsWith("\\")) {
            name = name.substring(1);
        }
        if ((token = this.parseToken()) == 59) {
            this._namespaceUseMap.put(tail, name);
            this._namespaceUseMap.put(tail.toLowerCase(), name);
            return;
        }
        if (token == 537) {
            do {
                tail = this.parseIdentifier();
                this._namespaceUseMap.put(tail, name);
                this._namespaceUseMap.put(tail.toLowerCase(), name);
            } while ((token = this.parseToken()) == 44);
        }
        this._peekToken = token;
        this.expect(59);
    }

    private Statement parseExprStatement() throws IOException {
        int token;
        Location location = this.getLocation();
        Expr expr = this.parseTopExpr();
        Statement statement = this._factory.createExpr(location, expr);
        this._peekToken = token = this.parseToken();
        switch (token) {
            case -1: 
            case 59: 
            case 125: 
            case 262: 
            case 538: 
            case 550: 
            case 576: {
                break;
            }
            default: {
                this.expect(59);
            }
        }
        return statement;
    }

    private Expr parseTopExpr() throws IOException {
        return this.parseExpr();
    }

    private Expr parseTopCommaExpr() throws IOException {
        return this.parseCommaExpr();
    }

    private Expr parseCommaExpr() throws IOException {
        int token;
        Expr expr = this.parseExpr();
        block3: while (true) {
            token = this.parseToken();
            switch (token) {
                case 44: {
                    expr = this._factory.createComma(expr, this.parseExpr());
                    continue block3;
                }
            }
            break;
        }
        this._peekToken = token;
        return expr;
    }

    private Expr parseRefExpr() throws IOException {
        boolean isRef;
        int token = this.parseToken();
        boolean bl = isRef = token == 38;
        if (!isRef) {
            this._peekToken = token;
        }
        Expr expr = this.parseExpr();
        if (isRef) {
            expr = this._factory.createRef(expr);
        }
        return expr;
    }

    private Expr parseExpr() throws IOException {
        return this.parseWeakOrExpr();
    }

    private Expr parseWeakOrExpr() throws IOException {
        int token;
        Expr expr = this.parseWeakXorExpr();
        block3: while (true) {
            token = this.parseToken();
            switch (token) {
                case 558: {
                    expr = this._factory.createOr(expr, this.parseWeakXorExpr());
                    continue block3;
                }
            }
            break;
        }
        this._peekToken = token;
        return expr;
    }

    private Expr parseWeakXorExpr() throws IOException {
        int token;
        Expr expr = this.parseWeakAndExpr();
        block3: while (true) {
            token = this.parseToken();
            switch (token) {
                case 556: {
                    expr = this._factory.createXor(expr, this.parseWeakAndExpr());
                    continue block3;
                }
            }
            break;
        }
        this._peekToken = token;
        return expr;
    }

    private Expr parseWeakAndExpr() throws IOException {
        int token;
        Expr expr = this.parseConditionalExpr();
        block3: while (true) {
            token = this.parseToken();
            switch (token) {
                case 557: {
                    expr = this._factory.createAnd(expr, this.parseConditionalExpr());
                    continue block3;
                }
            }
            break;
        }
        this._peekToken = token;
        return expr;
    }

    private Expr parseConditionalExpr() throws IOException {
        int token;
        Expr expr = this.parseOrExpr();
        block3: while (true) {
            token = this.parseToken();
            switch (token) {
                case 63: {
                    token = this.parseToken();
                    if (token == 58) {
                        expr = this._factory.createShortConditional(expr, this.parseOrExpr());
                        continue block3;
                    }
                    this._peekToken = token;
                    Expr trueExpr = this.parseExpr();
                    this.expect(58);
                    expr = this._factory.createConditional(expr, trueExpr, this.parseOrExpr());
                    continue block3;
                }
            }
            break;
        }
        this._peekToken = token;
        return expr;
    }

    private Expr parseOrExpr() throws IOException {
        int token;
        Expr expr = this.parseAndExpr();
        block3: while (true) {
            token = this.parseToken();
            switch (token) {
                case 274: {
                    expr = this._factory.createOr(expr, this.parseAndExpr());
                    continue block3;
                }
            }
            break;
        }
        this._peekToken = token;
        return expr;
    }

    private Expr parseAndExpr() throws IOException {
        int token;
        Expr expr = this.parseBitOrExpr();
        block3: while (true) {
            token = this.parseToken();
            switch (token) {
                case 273: {
                    expr = this._factory.createAnd(expr, this.parseBitOrExpr());
                    continue block3;
                }
            }
            break;
        }
        this._peekToken = token;
        return expr;
    }

    private Expr parseBitOrExpr() throws IOException {
        int token;
        Expr expr = this.parseBitXorExpr();
        block3: while (true) {
            token = this.parseToken();
            switch (token) {
                case 124: {
                    expr = this._factory.createBitOr(expr, this.parseBitXorExpr());
                    continue block3;
                }
            }
            break;
        }
        this._peekToken = token;
        return expr;
    }

    private Expr parseBitXorExpr() throws IOException {
        int token;
        Expr expr = this.parseBitAndExpr();
        block3: while (true) {
            token = this.parseToken();
            switch (token) {
                case 94: {
                    expr = this._factory.createBitXor(expr, this.parseBitAndExpr());
                    continue block3;
                }
            }
            break;
        }
        this._peekToken = token;
        return expr;
    }

    private Expr parseBitAndExpr() throws IOException {
        int token;
        Expr expr = this.parseEqExpr();
        block3: while (true) {
            token = this.parseToken();
            switch (token) {
                case 38: {
                    expr = this._factory.createBitAnd(expr, this.parseEqExpr());
                    continue block3;
                }
            }
            break;
        }
        this._peekToken = token;
        return expr;
    }

    private Expr parseEqExpr() throws IOException {
        Expr expr = this.parseCmpExpr();
        int token = this.parseToken();
        switch (token) {
            case 263: {
                return this._factory.createEq(expr, this.parseCmpExpr());
            }
            case 270: {
                return this._factory.createNeq(expr, this.parseCmpExpr());
            }
            case 271: {
                return this._factory.createEquals(expr, this.parseCmpExpr());
            }
            case 272: {
                return this._factory.createNot(this._factory.createEquals(expr, this.parseCmpExpr()));
            }
        }
        this._peekToken = token;
        return expr;
    }

    private Expr parseCmpExpr() throws IOException {
        Expr expr = this.parseShiftExpr();
        int token = this.parseToken();
        switch (token) {
            case 60: {
                return this._factory.createLt(expr, this.parseShiftExpr());
            }
            case 62: {
                return this._factory.createGt(expr, this.parseShiftExpr());
            }
            case 268: {
                return this._factory.createLeq(expr, this.parseShiftExpr());
            }
            case 269: {
                return this._factory.createGeq(expr, this.parseShiftExpr());
            }
            case 564: {
                Location location = this.getLocation();
                Expr classNameExpr = this.parseShiftExpr();
                if (classNameExpr instanceof ConstExpr) {
                    String className = classNameExpr.evalConstant().toString();
                    if (className.equals("self")) {
                        className = this.getSelfClassName();
                    } else if (className.equals("parent")) {
                        className = this.getParentClassName();
                    }
                    return this._factory.createInstanceOf(expr, className);
                }
                return this._factory.createInstanceOfVar(expr, classNameExpr);
            }
        }
        this._peekToken = token;
        return expr;
    }

    private Expr parseShiftExpr() throws IOException {
        int token;
        Expr expr = this.parseAddExpr();
        block4: while (true) {
            token = this.parseToken();
            switch (token) {
                case 260: {
                    expr = this._factory.createLeftShift(expr, this.parseAddExpr());
                    continue block4;
                }
                case 261: {
                    expr = this._factory.createRightShift(expr, this.parseAddExpr());
                    continue block4;
                }
            }
            break;
        }
        this._peekToken = token;
        return expr;
    }

    private Expr parseAddExpr() throws IOException {
        int token;
        Expr expr = this.parseMulExpr();
        block5: while (true) {
            token = this.parseToken();
            switch (token) {
                case 43: {
                    expr = this._factory.createAdd(expr, this.parseMulExpr());
                    continue block5;
                }
                case 45: {
                    expr = this._factory.createSub(expr, this.parseMulExpr());
                    continue block5;
                }
                case 46: {
                    expr = this._factory.createAppend(expr, this.parseMulExpr());
                    continue block5;
                }
            }
            break;
        }
        this._peekToken = token;
        return expr;
    }

    private Expr parseMulExpr() throws IOException {
        int token;
        Expr expr = this.parseAssignExpr();
        block5: while (true) {
            token = this.parseToken();
            switch (token) {
                case 42: {
                    expr = this._factory.createMul(expr, this.parseAssignExpr());
                    continue block5;
                }
                case 47: {
                    expr = this._factory.createDiv(expr, this.parseAssignExpr());
                    continue block5;
                }
                case 37: {
                    expr = this._factory.createMod(expr, this.parseAssignExpr());
                    continue block5;
                }
            }
            break;
        }
        this._peekToken = token;
        return expr;
    }

    private Expr parseAssignExpr() throws IOException {
        Expr expr = this.parseUnary();
        while (true) {
            int token = this.parseToken();
            switch (token) {
                case 61: {
                    token = this.parseToken();
                    try {
                        if (token == 38) {
                            expr = expr.createAssignRef(this, this.parseBitOrExpr());
                            break;
                        }
                        this._peekToken = token;
                        if (this._isIfTest && this._quercus.isStrict()) {
                            throw this.error("assignment without parentheses inside If/While/For test statement; please make sure whether equality was intended instead");
                        }
                        expr = expr.createAssign(this, this.parseConditionalExpr());
                        break;
                    }
                    catch (QuercusParseException e) {
                        throw e;
                    }
                    catch (IOException e) {
                        throw this.error(e.getMessage());
                    }
                }
                case 278: {
                    if (expr.canRead()) {
                        expr = expr.createAssign(this, this._factory.createAdd(expr, this.parseConditionalExpr()));
                        break;
                    }
                    expr = expr.createAssign(this, this.parseConditionalExpr());
                    break;
                }
                case 279: {
                    if (expr.canRead()) {
                        expr = expr.createAssign(this, this._factory.createSub(expr, this.parseConditionalExpr()));
                        break;
                    }
                    expr = expr.createAssign(this, this.parseConditionalExpr());
                    break;
                }
                case 280: {
                    if (expr.canRead()) {
                        expr = expr.createAssign(this, this._factory.createAppend(expr, this.parseConditionalExpr()));
                        break;
                    }
                    expr = expr.createAssign(this, this.parseConditionalExpr());
                    break;
                }
                case 281: {
                    if (expr.canRead()) {
                        expr = expr.createAssign(this, this._factory.createMul(expr, this.parseConditionalExpr()));
                        break;
                    }
                    expr = expr.createAssign(this, this.parseConditionalExpr());
                    break;
                }
                case 282: {
                    if (expr.canRead()) {
                        expr = expr.createAssign(this, this._factory.createDiv(expr, this.parseConditionalExpr()));
                        break;
                    }
                    expr = expr.createAssign(this, this.parseConditionalExpr());
                    break;
                }
                case 283: {
                    if (expr.canRead()) {
                        expr = expr.createAssign(this, this._factory.createMod(expr, this.parseConditionalExpr()));
                        break;
                    }
                    expr = expr.createAssign(this, this.parseConditionalExpr());
                    break;
                }
                case 287: {
                    if (expr.canRead()) {
                        expr = expr.createAssign(this, this._factory.createLeftShift(expr, this.parseConditionalExpr()));
                        break;
                    }
                    expr = expr.createAssign(this, this.parseConditionalExpr());
                    break;
                }
                case 288: {
                    if (expr.canRead()) {
                        expr = expr.createAssign(this, this._factory.createRightShift(expr, this.parseConditionalExpr()));
                        break;
                    }
                    expr = expr.createAssign(this, this.parseConditionalExpr());
                    break;
                }
                case 284: {
                    if (expr.canRead()) {
                        expr = expr.createAssign(this, this._factory.createBitAnd(expr, this.parseConditionalExpr()));
                        break;
                    }
                    expr = expr.createAssign(this, this.parseConditionalExpr());
                    break;
                }
                case 285: {
                    if (expr.canRead()) {
                        expr = expr.createAssign(this, this._factory.createBitOr(expr, this.parseConditionalExpr()));
                        break;
                    }
                    expr = expr.createAssign(this, this.parseConditionalExpr());
                    break;
                }
                case 286: {
                    if (expr.canRead()) {
                        expr = expr.createAssign(this, this._factory.createBitXor(expr, this.parseConditionalExpr()));
                        break;
                    }
                    expr = expr.createAssign(this, this.parseConditionalExpr());
                    break;
                }
                case 564: {
                    Expr classNameExpr = this.parseShiftExpr();
                    if (classNameExpr instanceof ConstExpr) {
                        String className = classNameExpr.evalConstant().toString();
                        if (className.equals("self")) {
                            className = this.getSelfClassName();
                        } else if (className.equals("parent")) {
                            className = this.getParentClassName();
                        }
                        return this._factory.createInstanceOf(expr, className);
                    }
                    return this._factory.createInstanceOfVar(expr, classNameExpr);
                }
                default: {
                    this._peekToken = token;
                    return expr;
                }
            }
        }
    }

    private Expr parseUnary() throws IOException {
        int token = this.parseToken();
        switch (token) {
            case 43: {
                Expr expr = this.parseAssignExpr();
                return this._factory.createPlus(expr);
            }
            case 45: {
                Expr expr = this.parseAssignExpr();
                return this._factory.createMinus(expr);
            }
            case 33: {
                Expr expr = this.parseAssignExpr();
                return this._factory.createNot(expr);
            }
            case 126: {
                Expr expr = this.parseAssignExpr();
                return this._factory.createBitNot(expr);
            }
            case 64: {
                Expr expr = this.parseAssignExpr();
                return this._factory.createSuppress(expr);
            }
            case 563: {
                Expr expr = this.parseAssignExpr();
                return this._factory.createClone(expr);
            }
            case 289: {
                Expr expr = this.parseUnary();
                return this._factory.createPreIncrement(expr, 1);
            }
            case 290: {
                Expr expr = this.parseUnary();
                return this._factory.createPreIncrement(expr, -1);
            }
        }
        this._peekToken = token;
        return this.parseTerm(true);
    }

    private Expr parseTerm(boolean isParseCall) throws IOException {
        int token;
        Expr term = this.parseTermBase();
        block9: while (true) {
            token = this.parseToken();
            switch (token) {
                case 91: {
                    Expr index;
                    token = this.parseToken();
                    if (token == 93) {
                        term = this._factory.createArrayTail(this.getLocation(), term);
                    } else {
                        this._peekToken = token;
                        index = this.parseExpr();
                        token = this.parseToken();
                        term = this._factory.createArrayGet(this.getLocation(), term, index);
                    }
                    if (token == 93) continue block9;
                    throw this.expect("']'", token);
                }
                case 123: {
                    Expr index = this.parseExpr();
                    this.expect(125);
                    term = this._factory.createCharAt(term, index);
                    continue block9;
                }
                case 289: {
                    term = this._factory.createPostIncrement(term, 1);
                    continue block9;
                }
                case 290: {
                    term = this._factory.createPostIncrement(term, -1);
                    continue block9;
                }
                case 264: {
                    term = this.parseDeref(term);
                    continue block9;
                }
                case 291: {
                    term = this.parseScope(term);
                    continue block9;
                }
                case 40: {
                    this._peek = token;
                    if (isParseCall) {
                        term = this.parseCall(term);
                        continue block9;
                    }
                    return term;
                }
            }
            break;
        }
        this._peekToken = token;
        return term;
    }

    private Expr parseTermArray() throws IOException {
        int token;
        Expr term = this.parseTermBase();
        block6: while (true) {
            token = this.parseToken();
            switch (token) {
                case 91: {
                    Expr index;
                    token = this.parseToken();
                    if (token == 93) {
                        term = this._factory.createArrayTail(this.getLocation(), term);
                    } else {
                        this._peekToken = token;
                        index = this.parseExpr();
                        token = this.parseToken();
                        term = this._factory.createArrayGet(this.getLocation(), term, index);
                    }
                    if (token == 93) continue block6;
                    throw this.expect("']'", token);
                }
                case 123: {
                    Expr index = this.parseExpr();
                    this.expect(125);
                    term = this._factory.createCharAt(term, index);
                    continue block6;
                }
                case 289: {
                    term = this._factory.createPostIncrement(term, 1);
                    continue block6;
                }
                case 290: {
                    term = this._factory.createPostIncrement(term, -1);
                    continue block6;
                }
            }
            break;
        }
        this._peekToken = token;
        return term;
    }

    private Expr parseDeref(Expr term) throws IOException {
        Expr nameExpr = null;
        int token = this.parseToken();
        if (token == 36) {
            this._peekToken = token;
            nameExpr = this.parseTermArray();
            return term.createFieldGet(this._factory, this.getLocation(), nameExpr);
        }
        if (token == 123) {
            nameExpr = this.parseExpr();
            this.expect(125);
            return term.createFieldGet(this._factory, this.getLocation(), nameExpr);
        }
        this._peekToken = token;
        StringValue name = this.parseIdentifier();
        return term.createFieldGet(this._factory, this.getLocation(), name);
    }

    private Expr parseTermBase() throws IOException {
        int token = this.parseToken();
        switch (token) {
            case 257: {
                return this.createStringExpr(this._lexeme);
            }
            case 547: {
                ArrayList<Expr> args = new ArrayList<Expr>();
                args.add(this.createStringExpr(this._lexeme));
                return this._factory.createCall(this, this.createStringValue("shell_exec"), args);
            }
            case 548: {
                ArrayList<Expr> args = new ArrayList<Expr>();
                args.add(this.parseEscapedString(this._lexeme, 295, true));
                return this._factory.createCall(this, this.createStringValue("shell_exec"), args);
            }
            case 549: {
                ArrayList<Expr> args = new ArrayList<Expr>();
                args.add(this.parseEscapedString(this._lexeme, 296, true));
                return this._factory.createCall(this, this.createStringValue("shell_exec"), args);
            }
            case 295: 
            case 296: {
                return this.parseEscapedString(this._lexeme, token, false);
            }
            case 297: {
                try {
                    if (this.isUnicodeSemantics()) {
                        BinaryBuilderValue sb = new BinaryBuilderValue();
                        sb.append(this._lexeme);
                        return this._factory.createBinary(sb);
                    }
                    return this._factory.createString(this._lexeme);
                }
                catch (Exception e) {
                    throw new QuercusParseException(e);
                }
            }
            case 298: 
            case 299: {
                return this.parseEscapedString(this._lexeme, token, false, false);
            }
            case 258: {
                long value = 0L;
                double doubleValue = 0.0;
                long sign = 1L;
                boolean isOverflow = false;
                char ch = this._lexeme.charAt(0);
                int i = 0;
                if (ch == '+') {
                    ++i;
                } else if (ch == '-') {
                    sign = -1L;
                    ++i;
                }
                int len = this._lexeme.length();
                while (i < len) {
                    int digit = this._lexeme.charAt(i) - 48;
                    long oldValue = value;
                    value = value * 10L + (long)digit;
                    doubleValue = doubleValue * 10.0 + (double)digit;
                    if (value < oldValue) {
                        isOverflow = true;
                    }
                    ++i;
                }
                if (!isOverflow) {
                    return this._factory.createLiteral(LongValue.create(value * sign));
                }
                return this._factory.createLiteral(new DoubleValue(doubleValue * (double)sign));
            }
            case 259: {
                double d = Double.parseDouble(this._lexeme.toString());
                return this._factory.createLiteral(new DoubleValue(d));
            }
            case 513: {
                return this._factory.createNull();
            }
            case 561: {
                return this._factory.createLiteral(BooleanValue.TRUE);
            }
            case 562: {
                return this._factory.createLiteral(BooleanValue.FALSE);
            }
            case 36: {
                return this.parseVariable();
            }
            case 518: {
                return this.parseNew();
            }
            case 516: {
                return this.parseClosure();
            }
            case 531: {
                return this._factory.createInclude(this.getLocation(), this._sourceFile, this.parseExpr());
            }
            case 532: {
                return this._factory.createRequire(this.getLocation(), this._sourceFile, this.parseExpr());
            }
            case 533: {
                return this._factory.createIncludeOnce(this.getLocation(), this._sourceFile, this.parseExpr());
            }
            case 534: {
                return this._factory.createRequireOnce(this.getLocation(), this._sourceFile, this.parseExpr());
            }
            case 559: {
                return this.parseList();
            }
            case 546: {
                return this.parsePrintExpr();
            }
            case 543: {
                return this.parseExit();
            }
            case 568: {
                return this.parseDie();
            }
            case 580: {
                return this.parseEmpty();
            }
            case 256: 
            case 577: {
                if (this._lexeme.equalsString("new")) {
                    return this.parseNew();
                }
                StringValue name = this._lexeme;
                this._peekToken = token = this.parseToken();
                if (token == 40 && !this._isNewExpr) {
                    return this.parseCall(name);
                }
                return this.parseConstant(name);
            }
            case 530: {
                if (this._classDef == null) {
                    throw this.error(L.l("cannot use new {0}() outside of a class context.", (Object)this.tokenName(token)));
                }
                return this.parseConstant(this._lexeme);
            }
            case 40: {
                this._isIfTest = false;
                Expr expr = this.parseExpr();
                this.expect(41);
                if (expr instanceof ConstExpr) {
                    String type = ((ConstExpr)expr).getVar();
                    int ns = type.lastIndexOf(92);
                    if (ns >= 0) {
                        type = type.substring(ns + 1);
                    }
                    if ("bool".equalsIgnoreCase(type) || "boolean".equalsIgnoreCase(type)) {
                        return this._factory.createToBoolean(this.parseAssignExpr());
                    }
                    if ("int".equalsIgnoreCase(type) || "integer".equalsIgnoreCase(type)) {
                        return this._factory.createToLong(this.parseAssignExpr());
                    }
                    if ("float".equalsIgnoreCase(type) || "double".equalsIgnoreCase(type) || "real".equalsIgnoreCase(type)) {
                        return this._factory.createToDouble(this.parseAssignExpr());
                    }
                    if ("string".equalsIgnoreCase(type)) {
                        return this._factory.createToString(this.parseAssignExpr());
                    }
                    if ("binary".equalsIgnoreCase(type)) {
                        return this._factory.createToBinary(this.parseAssignExpr());
                    }
                    if ("unicode".equalsIgnoreCase(type)) {
                        return this._factory.createToUnicode(this.parseAssignExpr());
                    }
                    if ("object".equalsIgnoreCase(type)) {
                        return this._factory.createToObject(this.parseAssignExpr());
                    }
                    if ("array".equalsIgnoreCase(type)) {
                        return this._factory.createToArray(this.parseAssignExpr());
                    }
                }
                return expr;
            }
            case 91: {
                this._peekToken = token;
                return this.parseArrayFunction('[', ']');
            }
            case 575: {
                StringValue importTokenString = this._lexeme;
                token = this.parseToken();
                if (token == 40) {
                    this._peekToken = token;
                    return this.parseCall(importTokenString);
                }
                this._peekToken = token;
                return this.parseImport();
            }
        }
        throw this.error(L.l("{0} is an unexpected token, expected an expression.", (Object)this.tokenName(token)));
    }

    private AbstractVarExpr parseLeftHandSide() throws IOException {
        int token = this.parseToken();
        AbstractVarExpr lhs = null;
        if (token != 36) {
            throw this.error(L.l("expected variable at {0} as left-hand-side", (Object)this.tokenName(token)));
        }
        lhs = this.parseVariable();
        block5: while (true) {
            token = this.parseToken();
            switch (token) {
                case 91: {
                    Expr index;
                    token = this.parseToken();
                    if (token == 93) {
                        lhs = this._factory.createArrayTail(this.getLocation(), lhs);
                    } else {
                        this._peekToken = token;
                        index = this.parseExpr();
                        token = this.parseToken();
                        lhs = this._factory.createArrayGet(this.getLocation(), lhs, index);
                    }
                    if (token == 93) continue block5;
                    throw this.expect("']'", token);
                }
                case 123: {
                    Expr index = this.parseExpr();
                    this.expect(125);
                    lhs = this._factory.createCharAt(lhs, index);
                    continue block5;
                }
                case 264: {
                    lhs = (AbstractVarExpr)this.parseDeref(lhs);
                    continue block5;
                }
            }
            break;
        }
        this._peekToken = token;
        return lhs;
    }

    private Expr parseScope(Expr classNameExpr) throws IOException {
        int token = this.parseToken();
        if (this.isIdentifier(token)) {
            return classNameExpr.createClassConst(this, this._lexeme);
        }
        if (token == 36) {
            token = this.parseToken();
            if (this.isIdentifier(token)) {
                return classNameExpr.createClassField(this, this._lexeme);
            }
            if (token == 123) {
                Expr expr = this.parseExpr();
                this.expect(125);
                return classNameExpr.createClassField(this, expr);
            }
            this._peekToken = token;
            return classNameExpr.createClassField(this, this.parseTermBase());
        }
        if (token == 123) {
            Expr expr = this.parseExpr();
            this.expect(125);
            Expr name = classNameExpr.createClassConst(this, expr);
            return this.parseCall(name);
        }
        throw this.error(L.l("unexpected token '{0}' in class scope expression", (Object)this.tokenName(token)));
    }

    private boolean isIdentifier(int token) {
        return token == 256 || 512 <= token;
    }

    private AbstractVarExpr parseVariable() throws IOException {
        int token = this.parseToken();
        if (token == 560) {
            return this._factory.createThis(this._classDef);
        }
        if (token == 36) {
            this._peekToken = token;
            return this._factory.createVarVar(this.parseTermArray());
        }
        if (token == 123) {
            VarVarExpr expr = this._factory.createVarVar(this.parseExpr());
            this.expect(125);
            return expr;
        }
        if (this._lexeme.length() == 0) {
            throw this.error(L.l("Expected identifier at '{0}'", (Object)this.tokenName(token)));
        }
        if (this._lexeme.indexOf('\\') >= 0) {
            throw this.error(L.l("Namespace is not allowed for variable ${0}", (Object)this._lexeme));
        }
        return this._factory.createVar(this._function.createVar(this._lexeme));
    }

    public Expr createVar(StringValue name) {
        return this._factory.createVar(this._function.createVar(name));
    }

    private Expr parseCall(StringValue name) throws IOException {
        if (name.equalsStringIgnoreCase("array")) {
            return this.parseArrayFunction('(', ')');
        }
        ArrayList<Expr> args = this.parseArgs();
        name = this.resolveIdentifier(name);
        if (!this._quercus.isStrict()) {
            name = name.toLowerCase(Locale.ENGLISH);
        }
        return this._factory.createCall(this, name, args);
    }

    private Expr parseConstant(StringValue name) {
        if (name.equalsString("__FILE__")) {
            return this._factory.createFileNameExpr(this._parserLocation.getFileName());
        }
        if (name.equalsString("__DIR__")) {
            Path parent = Vfs.lookup(this._parserLocation.getFileName()).getParent();
            return this._factory.createDirExpr(parent.getNativePath());
        }
        if (name.equalsString("__LINE__")) {
            return this._factory.createLong(this._parserLocation.getLineNumber());
        }
        if (name.equalsString("__CLASS__") && this._classDef != null) {
            if (this._classDef.isTrait()) {
                StringValue funNameV = this.createStringValue(this._function.getName());
                return this._factory.createClassExpr(this.getLocation(), funNameV);
            }
            return this.createStringExpr(this._classDef.getName());
        }
        if (name.equalsString("__FUNCTION__")) {
            return this.createStringExpr(this._function.getName());
        }
        if (name.equalsString("__METHOD__")) {
            if (this._classDef != null) {
                if (this._function.getName().length() != 0) {
                    return this.createStringExpr(this._classDef.getName() + "::" + this._function.getName());
                }
                return this.createStringExpr(this._classDef.getName());
            }
            return this.createStringExpr(this._function.getName());
        }
        if (name.equalsString("__NAMESPACE__")) {
            return this.createStringExpr(this._namespace);
        }
        if (name.equalsString("self") && this._classDef != null) {
            return this._factory.createConst(this._classDef.getName());
        }
        if ((name = this.resolveIdentifier(name)).startsWith("\\")) {
            name = name.substring(1);
        }
        return this._factory.createConst(name.toString());
    }

    private Expr parseCall(Expr name) throws IOException {
        return name.createCall(this, this.getLocation(), this.parseArgs());
    }

    private ArrayList<Expr> parseArgs() throws IOException {
        int token;
        this.expect(40);
        ArrayList<Expr> args = new ArrayList<Expr>();
        while ((token = this.parseToken()) > 0 && token != 41) {
            boolean isRef = false;
            if (token == 38) {
                isRef = true;
            } else {
                this._peekToken = token;
            }
            Expr expr = this.parseExpr();
            if (isRef) {
                expr = expr.createRef(this);
            }
            args.add(expr);
            token = this.parseToken();
            if (token == 41) break;
            if (token == 44) continue;
            throw this.expect("','", token);
        }
        return args;
    }

    public String getSelfClassName() {
        if (this._classDef == null) {
            throw this.error(L.l("'self' is not valid because there is no active class."));
        }
        return this._classDef.getName();
    }

    public InterpretedClassDef getClassDef() {
        return this._classDef;
    }

    public String getParentClassName() {
        if (this._classDef == null) {
            throw this.error(L.l("'parent' is not valid because there is no active class."));
        }
        return this._classDef.getParentName();
    }

    private Expr parseNew() throws IOException {
        String name = null;
        Expr nameExpr = null;
        boolean isNewExpr = this._isNewExpr;
        this._isNewExpr = true;
        nameExpr = this.parseTerm(false);
        this._isNewExpr = isNewExpr;
        if (nameExpr.isLiteral() || nameExpr instanceof ConstExpr) {
            name = nameExpr.evalConstant().toString();
            if ("self".equals(name) && this._classDef != null) {
                name = this._classDef.getName();
            } else if ("parent".equals(name) && this.getParentClassName() != null) {
                name = this.getParentClassName().toString();
            }
        }
        int token = this.parseToken();
        ArrayList<Expr> args = new ArrayList<Expr>();
        if (token != 40) {
            this._peekToken = token;
        } else {
            while ((token = this.parseToken()) > 0 && token != 41) {
                this._peekToken = token;
                args.add(this.parseExpr());
                token = this.parseToken();
                if (token == 41) break;
                if (token == 44) continue;
                throw this.error(L.l("expected ','"));
            }
        }
        Expr expr = name != null ? (name.equals("static") || name.endsWith("\\static") ? this._factory.createNewStatic(this.getLocation(), args) : this._factory.createNew(this.getLocation(), name, args)) : this._factory.createVarNew(this.getLocation(), nameExpr, args);
        return expr;
    }

    private Expr parseInclude() throws IOException {
        Expr name = this.parseExpr();
        return this._factory.createInclude(this.getLocation(), this._sourceFile, name);
    }

    private Expr parseList() throws IOException {
        ListHeadExpr leftVars = this.parseListHead();
        this.expect(61);
        Expr value = this.parseConditionalExpr();
        return this._factory.createList(this, leftVars, value);
    }

    private ListHeadExpr parseListHead() throws IOException {
        this.expect(40);
        int peek = this.parseToken();
        ArrayList<Expr> leftVars = new ArrayList<Expr>();
        while (peek > 0 && peek != 41) {
            if (peek == 559) {
                leftVars.add(this.parseListHead());
                peek = this.parseToken();
            } else if (peek != 44) {
                this._peekToken = peek;
                Expr left = this.parseTerm(true);
                leftVars.add(left);
                left.assign(this);
                peek = this.parseToken();
            } else {
                leftVars.add(null);
            }
            if (peek != 44) break;
            peek = this.parseToken();
        }
        if (peek != 41) {
            throw this.error(L.l("expected ')'"));
        }
        return this._factory.createListHead(leftVars);
    }

    private Expr parseExit() throws IOException {
        int token;
        this._peekToken = token = this.parseToken();
        if (token == 40) {
            ArrayList<Expr> args = this.parseArgs();
            if (args.size() > 0) {
                return this._factory.createExit(args.get(0));
            }
            return this._factory.createExit(null);
        }
        return this._factory.createExit(null);
    }

    private Expr parseDie() throws IOException {
        int token;
        this._peekToken = token = this.parseToken();
        if (token == 40) {
            ArrayList<Expr> args = this.parseArgs();
            if (args.size() > 0) {
                return this._factory.createDie(args.get(0));
            }
            return this._factory.createDie(null);
        }
        return this._factory.createDie(null);
    }

    private Expr parseEmpty() throws IOException {
        int token;
        this._peekToken = token = this.parseToken();
        if (token == 40) {
            ArrayList<Expr> args = this.parseArgs();
            if (args.size() > 0) {
                return this._factory.createEmpty(this.getLocation(), args.get(0));
            }
            throw this.error(L.l("empty must have one arg"));
        }
        throw this.error(L.l("expected '('"));
    }

    private Expr parseArrayFunction(char beginChar, char endChar) throws IOException {
        int token = this.parseToken();
        if (token != beginChar) {
            throw this.error(L.l("Expected {0}", (Object)String.valueOf(beginChar)));
        }
        ArrayList<Expr> keys = new ArrayList<Expr>();
        ArrayList<Expr> values = new ArrayList<Expr>();
        while ((token = this.parseToken()) > 0 && token != endChar) {
            this._peekToken = token;
            Expr value = this.parseRefExpr();
            token = this.parseToken();
            if (token == 294) {
                Expr key = value;
                value = this.parseRefExpr();
                keys.add(key);
                values.add(value);
                token = this.parseToken();
            } else {
                keys.add(null);
                values.add(value);
            }
            if (token == endChar) break;
            if (token == 44) continue;
            throw this.error(L.l("expected ','"));
        }
        return this._factory.createArrayFun(keys, values);
    }

    private Expr parseImport() throws IOException {
        StringBuilder sb;
        boolean isWildcard;
        block5: {
            int token;
            isWildcard = false;
            boolean isIdentifierStart = true;
            sb = new StringBuilder();
            while ((token = this.parseToken()) == 256) {
                sb.append(this._lexeme);
                token = this.parseToken();
                if (token == 46) {
                    sb.append('.');
                    continue;
                }
                this._peekToken = token;
                break block5;
            }
            if (token == 42) {
                if (sb.length() > 0) {
                    sb.setLength(sb.length() - 1);
                }
                isWildcard = true;
            } else {
                throw this.error(L.l("'{0}' is an unexpected token in import", (Object)this.tokenName(token)));
            }
        }
        return this._factory.createImport(this.getLocation(), sb.toString(), isWildcard);
    }

    private int parseToken() throws IOException {
        int peekToken = this._peekToken;
        if (peekToken > 0) {
            this._peekToken = 0;
            return peekToken;
        }
        block35: while (true) {
            int ch = this.read();
            switch (ch) {
                case -1: {
                    return -1;
                }
                case 9: 
                case 10: 
                case 13: 
                case 32: {
                    break;
                }
                case 35: {
                    while (true) {
                        if ((ch = this.read()) == 10 || ch == 13 || ch < 0) continue block35;
                        if (ch != 63) continue;
                        ch = this.read();
                        if (ch == 62) break;
                        this._peek = ch;
                    }
                    ch = this.read();
                    if (ch == 13) {
                        ch = this.read();
                    }
                    if (ch != 10) {
                        this._peek = ch;
                    }
                    return this.parsePhpText();
                }
                case 34: {
                    String heredocEnd = this._heredocEnd;
                    this._heredocEnd = null;
                    int result = this.parseEscapedString('\"');
                    this._heredocEnd = heredocEnd;
                    return result;
                }
                case 96: {
                    int token = this.parseEscapedString('`');
                    switch (token) {
                        case 257: {
                            return 547;
                        }
                        case 295: {
                            return 548;
                        }
                        case 296: {
                            return 549;
                        }
                    }
                    throw new IllegalStateException();
                }
                case 39: {
                    this.parseStringToken(39);
                    return 257;
                }
                case 36: 
                case 40: 
                case 41: 
                case 44: 
                case 59: 
                case 64: 
                case 91: 
                case 93: 
                case 123: 
                case 125: 
                case 126: {
                    return ch;
                }
                case 43: {
                    ch = this.read();
                    if (ch == 61) {
                        return 278;
                    }
                    if (ch == 43) {
                        return 289;
                    }
                    this._peek = ch;
                    return 43;
                }
                case 45: {
                    ch = this.read();
                    if (ch == 62) {
                        return 264;
                    }
                    if (ch == 61) {
                        return 279;
                    }
                    if (ch == 45) {
                        return 290;
                    }
                    this._peek = ch;
                    return 45;
                }
                case 42: {
                    ch = this.read();
                    if (ch == 61) {
                        return 281;
                    }
                    this._peek = ch;
                    return 42;
                }
                case 47: {
                    ch = this.read();
                    if (ch == 61) {
                        return 282;
                    }
                    if (ch == 47) {
                        while (true) {
                            if (ch < 0 || ch == 10) continue block35;
                            if (ch == 13) continue block35;
                            if (ch == 63) {
                                ch = this.read();
                                if (ch != 62) continue;
                                ch = this.read();
                                if (ch == 13) {
                                    ch = this.read();
                                }
                                if (ch != 10) {
                                    this._peek = ch;
                                }
                                return this.parsePhpText();
                            }
                            ch = this.read();
                        }
                    }
                    if (ch == 42) {
                        this.parseMultilineComment();
                        break;
                    }
                    this._peek = ch;
                    return 47;
                }
                case 37: {
                    ch = this.read();
                    if (ch == 61) {
                        return 283;
                    }
                    if (ch == 62) {
                        ch = this.read();
                        if (ch == 13) {
                            ch = this.read();
                        }
                        if (ch != 10) {
                            this._peek = ch;
                        }
                        return this.parsePhpText();
                    }
                    this._peek = ch;
                    return 37;
                }
                case 58: {
                    ch = this.read();
                    if (ch == 58) {
                        return 291;
                    }
                    this._peek = ch;
                    return 58;
                }
                case 61: {
                    ch = this.read();
                    if (ch == 61) {
                        ch = this.read();
                        if (ch == 61) {
                            return 271;
                        }
                        this._peek = ch;
                        return 263;
                    }
                    if (ch == 62) {
                        return 294;
                    }
                    this._peek = ch;
                    return 61;
                }
                case 33: {
                    ch = this.read();
                    if (ch == 61) {
                        ch = this.read();
                        if (ch == 61) {
                            return 272;
                        }
                        this._peek = ch;
                        return 270;
                    }
                    this._peek = ch;
                    return 33;
                }
                case 38: {
                    ch = this.read();
                    if (ch == 38) {
                        return 273;
                    }
                    if (ch == 61) {
                        return 284;
                    }
                    this._peek = ch;
                    return 38;
                }
                case 94: {
                    ch = this.read();
                    if (ch == 61) {
                        return 286;
                    }
                    this._peek = ch;
                    return 94;
                }
                case 124: {
                    ch = this.read();
                    if (ch == 124) {
                        return 274;
                    }
                    if (ch == 61) {
                        return 285;
                    }
                    this._peek = ch;
                    return 124;
                }
                case 60: {
                    ch = this.read();
                    if (ch == 60) {
                        ch = this.read();
                        if (ch == 61) {
                            return 287;
                        }
                        if (ch == 60) {
                            ch = this.read();
                            if (ch == 39) {
                                return this.parseNowdoc();
                            }
                            if (ch == 34) {
                                return this.parseHeredocToken(true);
                            }
                            this._peek = ch;
                            return this.parseHeredocToken(false);
                        }
                        this._peek = ch;
                        return 260;
                    }
                    if (ch == 61) {
                        return 268;
                    }
                    if (ch == 62) {
                        return 270;
                    }
                    if (ch == 47) {
                        StringValue sb = this.createStringBuilder();
                        if (!this.parseTextMatch(sb, "script")) {
                            throw this.error(L.l("expected 'script' at '{0}'", (Object)sb));
                        }
                        this.expect(62);
                        return this.parsePhpText();
                    }
                    this._peek = ch;
                    return 60;
                }
                case 62: {
                    ch = this.read();
                    if (ch == 62) {
                        ch = this.read();
                        if (ch == 61) {
                            return 288;
                        }
                        this._peek = ch;
                        return 261;
                    }
                    if (ch == 61) {
                        return 269;
                    }
                    this._peek = ch;
                    return 62;
                }
                case 63: {
                    ch = this.read();
                    if (ch == 62) {
                        ch = this.read();
                        if (ch == 13) {
                            ch = this.read();
                        }
                        if (ch != 10) {
                            this._peek = ch;
                        }
                        return this.parsePhpText();
                    }
                    this._peek = ch;
                    return 63;
                }
                case 46: {
                    ch = this.read();
                    if (ch == 61) {
                        return 280;
                    }
                    this._peek = ch;
                    if (48 <= ch && ch <= 57) {
                        return this.parseNumberToken(46);
                    }
                    return 46;
                }
                case 48: 
                case 49: 
                case 50: 
                case 51: 
                case 52: 
                case 53: 
                case 54: 
                case 55: 
                case 56: 
                case 57: {
                    return this.parseNumberToken(ch);
                }
                default: {
                    if (ch == 98) {
                        int ch2 = this.read();
                        if (ch2 == 39) {
                            this.parseStringToken(39, false);
                            return 297;
                        }
                        if (ch2 == 34) {
                            int token = this.parseEscapedString('\"', false);
                            switch (token) {
                                case 257: {
                                    return 297;
                                }
                                case 295: {
                                    return 298;
                                }
                                case 296: {
                                    return 299;
                                }
                            }
                            return token;
                        }
                        this._peek = ch2;
                    }
                    return this.parseNamespaceIdentifier(ch);
                }
            }
        }
    }

    private StringValue parseIdentifier() throws IOException {
        int token = this._peekToken;
        this._peekToken = -1;
        if (token <= 0) {
            token = this.parseIdentifier(this.read());
        }
        if (token != 256 && token < 512) {
            throw this.error(L.l("expected identifier at {0}.", (Object)this.tokenName(token)));
        }
        if (this._lexeme.indexOf('\\') >= 0) {
            throw this.error(L.l("namespace identifier is not allowed at '{0}'", (Object)this._lexeme));
        }
        if (this._peek == 92) {
            throw this.error(L.l("namespace identifier is not allowed at '{0}\\'", (Object)this._lexeme));
        }
        return this._lexeme;
    }

    private StringValue parseNamespaceIdentifier() throws IOException {
        int token = this._peekToken;
        this._peekToken = -1;
        if (token <= 0) {
            token = this.parseNamespaceIdentifier(this.read());
        }
        if (token == 256) {
            return this.resolveIdentifier(this._lexeme);
        }
        if (512 <= token) {
            return this.resolveIdentifier(this._lexeme);
        }
        throw this.error(L.l("expected identifier at {0}.", (Object)this.tokenName(token)));
    }

    public StringValue getSystemFunctionName(StringValue name) {
        int p = name.lastIndexOf('\\');
        if (p < 0) {
            return name;
        }
        StringValue systemName = name.substring(p + 1);
        if (this._quercus.findFunction(systemName) != null) {
            return systemName;
        }
        return null;
    }

    private StringValue resolveIdentifier(StringValue id) {
        if (id.startsWith("\\")) {
            return id.substring(1);
        }
        int ns = id.indexOf('\\');
        if (ns > 0) {
            StringValue prefix = id.substring(0, ns);
            StringValue use = null;
            if (this._namespaceUseMap.size() > 0 && (use = this._namespaceUseMap.get(prefix)) == null) {
                use = this._namespaceUseMap.get(prefix.toLowerCase());
            }
            if (use != null) {
                return this.createStringBuilder().append(use).append(id.substring(ns));
            }
            if (this._namespace.length() == 0) {
                return id;
            }
            return this.createStringBuilder().append(this._namespace).append("\\").append(id);
        }
        StringValue use = null;
        if (this._namespaceUseMap.size() > 0 && (use = this._namespaceUseMap.get(id)) == null) {
            use = this._namespaceUseMap.get(id.toLowerCase());
        }
        if (use != null) {
            return use;
        }
        if (this._namespace.length() == 0) {
            return id;
        }
        return this.createStringBuilder().append(this._namespace).append('\\').append(id);
    }

    private int parseIdentifier(int ch) throws IOException {
        while (Character.isWhitespace(ch)) {
            ch = this.read();
        }
        if (this.isIdentifierStart(ch)) {
            this._sb.setLength(0);
            this._sb.append((char)ch);
            ch = this.read();
            while (this.isIdentifierPart(ch)) {
                this._sb.append((char)ch);
                ch = this.read();
            }
            this._peek = ch;
            return this.lexemeToToken();
        }
        throw this.error("expected identifier at " + (char)ch);
    }

    private int parseNamespaceIdentifier(int ch) throws IOException {
        while (Character.isWhitespace(ch)) {
            ch = this.read();
        }
        if (this.isNamespaceIdentifierStart(ch)) {
            this._sb.setLength(0);
            this._sb.append((char)ch);
            ch = this.read();
            while (this.isNamespaceIdentifierPart(ch)) {
                this._sb.append((char)ch);
                ch = this.read();
            }
            this._peek = ch;
            return this.lexemeToToken();
        }
        throw this.error("unknown lexeme:" + (char)ch);
    }

    private int lexemeToToken() throws IOException {
        this._lexeme = this.copyStringValue(this._sb);
        if (this._peek == 58 && this._lexeme.equalsString("static")) {
            return 256;
        }
        String name = this._lexeme.toString();
        int reserved = _reserved.get(name);
        if (reserved > 0) {
            return reserved;
        }
        reserved = _insensitiveReserved.get(name.toLowerCase(Locale.ENGLISH));
        if (reserved > 0) {
            return reserved;
        }
        return 256;
    }

    private void parseMultilineComment() throws IOException {
        int ch = this.read();
        if (ch == 42) {
            this._sb.setLength(0);
            this._sb.append('/');
            this._sb.append('*');
            do {
                if (ch != 42) {
                    this._sb.append((char)ch);
                    continue;
                }
                ch = this.read();
                if (ch == 47) {
                    this._sb.append('*');
                    this._sb.append('/');
                    this._comment = this._sb.toString();
                    return;
                }
                this._sb.append('*');
                this._peek = ch;
            } while ((ch = this.read()) >= 0);
            this._comment = this._sb.toString();
        } else if (ch >= 0) {
            do {
                if (ch != 42) continue;
                ch = this.read();
                if (ch == 47) {
                    return;
                }
                this._peek = ch;
            } while ((ch = this.read()) >= 0);
        }
    }

    private int parsePhpText() throws IOException {
        StringValue sb = this.createStringBuilder();
        int ch = this.read();
        while (ch > 0) {
            if (ch == 60) {
                ch = this.read();
                if (ch == 115 || ch == 83) {
                    this._peek = ch;
                    if (this.parseScriptBegin(sb)) {
                        this._lexeme = sb;
                        return 538;
                    }
                    ch = this.read();
                    continue;
                }
                if (ch == 37) {
                    ch = this.read();
                    if (ch == 61) {
                        this._lexeme = sb;
                        return 550;
                    }
                    if (!Character.isWhitespace(ch)) continue;
                    this._lexeme = sb;
                    return 538;
                }
                if (ch != 63) {
                    sb.append('<');
                    continue;
                }
                ch = this.read();
                if (ch == 61) {
                    this._lexeme = sb;
                    return 550;
                }
                if (ch != 112 && ch != 80 && !this.isShortOpenTag()) {
                    sb.append('<');
                    sb.append('?');
                    sb.append((char)ch);
                    ch = this.read();
                    continue;
                }
                this._lexeme = sb;
                this._peek = ch;
                if (ch == 112 || ch == 80) {
                    return 576;
                }
                return 538;
            }
            sb.append((char)ch);
            ch = this.read();
        }
        this._lexeme = sb;
        return 538;
    }

    private boolean parseScriptBegin(StringValue sb) throws IOException {
        int begin = sb.length();
        sb.append('<');
        if (!this.parseTextMatch(sb, "script")) {
            return false;
        }
        this.parseWhitespace(sb);
        if (!this.parseTextMatch(sb, "language=")) {
            return false;
        }
        int openingParentheses = this.read();
        if (openingParentheses == 39 || openingParentheses == 34) {
            if (!this.parseTextMatch(sb, "php")) {
                sb.append((char)openingParentheses);
                return false;
            }
            int closingParentheses = this.read();
            if (openingParentheses != closingParentheses) {
                sb.append((char)closingParentheses);
                return false;
            }
        }
        this.parseWhitespace(sb);
        int ch = this.read();
        if (ch == 62) {
            sb.setLength(begin);
            return true;
        }
        this._peek = ch;
        return false;
    }

    private boolean parseTextMatch(StringValue sb, String text) throws IOException {
        int len = text.length();
        for (int i = 0; i < len; ++i) {
            int ch = this.read();
            if (ch < 0) {
                return false;
            }
            if (Character.toLowerCase(ch) != text.charAt(i)) {
                this._peek = ch;
                return false;
            }
            sb.append((char)ch);
        }
        return true;
    }

    private void parseWhitespace(StringValue sb) throws IOException {
        int ch;
        while (Character.isWhitespace(ch = this.read())) {
            sb.append((char)ch);
        }
        this._peek = ch;
    }

    private void parseStringToken(int end) throws IOException {
        this.parseStringToken(end, this.isUnicodeSemantics());
    }

    /*
     * Enabled aggressive block sorting
     */
    private void parseStringToken(int end, boolean isUnicode) throws IOException {
        this._sb.setLength(0);
        int ch = this.read();
        while (ch >= 0 && ch != end) {
            block11: {
                block12: {
                    block13: {
                        int value;
                        block14: {
                            if (ch != 92) break block12;
                            ch = this.read();
                            if (!isUnicode) break block13;
                            if (ch != 117) break block14;
                            value = this.parseUnicodeEscape(false);
                            if (value < 0) {
                                this._sb.append('\\');
                                this._sb.append('u');
                                break block11;
                            } else {
                                this._sb.append((char)value);
                            }
                            break block11;
                        }
                        if (ch != 85) break block13;
                        value = this.parseUnicodeEscape(true);
                        if (value < 0) {
                            this._sb.append('\\');
                            this._sb.append('U');
                            break block11;
                        } else {
                            this._sb.append((char)value);
                        }
                        break block11;
                    }
                    if (end == 34) {
                        this._sb.append('\\');
                        if (ch >= 0) {
                            this._sb.append((char)ch);
                        }
                        break block11;
                    } else {
                        switch (ch) {
                            case 39: 
                            case 92: {
                                this._sb.append((char)ch);
                                break;
                            }
                            default: {
                                this._sb.append('\\');
                                this._sb.append((char)ch);
                                break;
                            }
                        }
                    }
                    break block11;
                }
                this._sb.append((char)ch);
            }
            ch = this.read();
        }
        this._lexeme = this.copyStringValue(this._sb);
    }

    private int parseNowdoc() throws IOException {
        int ch;
        this._sb.setLength(0);
        while ((ch = this.read()) >= 0 && ch != 39 && !Character.isWhitespace(ch)) {
            this._sb.append((char)ch);
        }
        if (ch != 39) {
            throw this.expect("'", ch);
        }
        ch = this.read();
        if (ch == 13) {
            ch = this.read();
        }
        if (ch != 10) {
            throw this.expect(L.l("nowdoc newline"), ch);
        }
        String nowdocName = this._sb.toString();
        this._sb.setLength(0);
        while ((ch = this.read()) >= 0) {
            if (ch == 13) {
                ch = this.read();
                if (ch == 10) {
                    if (this.parseNowdocEnd(nowdocName)) break;
                    this._sb.append('\r');
                    this._sb.append((char)ch);
                    continue;
                }
                this._sb.append('\r');
                continue;
            }
            if (ch == 10) {
                if (this.parseNowdocEnd(nowdocName)) break;
                this._sb.append((char)ch);
                continue;
            }
            this._sb.append((char)ch);
        }
        this._lexeme = this.createStringValue(this._sb.toString());
        return 257;
    }

    private boolean parseNowdocEnd(String nowdocName) throws IOException {
        int i;
        int len = nowdocName.length();
        int ch = this.read();
        for (i = 0; i < len && nowdocName.charAt(i) == ch; ++i) {
            ch = this.read();
        }
        this._peek = ch;
        if (i == len) {
            return true;
        }
        this._sb.append(nowdocName, 0, i);
        return false;
    }

    private int parseHeredocToken(boolean isQuoted) throws IOException {
        int ch;
        this._sb.setLength(0);
        while ((ch = this.read()) >= 0 && (ch == 32 || ch == 9)) {
        }
        this._peek = ch;
        while (!((ch = this.read()) < 0 || Character.isWhitespace(ch) || isQuoted && ch == 34)) {
            this._sb.append((char)ch);
        }
        this._heredocEnd = this._sb.toString();
        if (isQuoted && ch == 34) {
            ch = this.read();
            if (ch == 13) {
                ch = this.read();
            }
            if (ch != 10) {
                throw this.expect("\n", ch);
            }
        } else if (ch != 10) {
            if (ch == 13) {
                ch = this.read();
                if (ch != 10) {
                    this._peek = ch;
                }
            } else {
                this._peek = ch;
            }
        }
        return this.parseEscapedString('\"');
    }

    private Expr parseEscapedString(StringValue prefix, int token, boolean isSystem) throws IOException {
        return this.parseEscapedString(prefix, token, isSystem, true);
    }

    private Expr parseEscapedString(StringValue prefix, int token, boolean isSystem, boolean isUnicode) throws IOException {
        Expr expr = isUnicode ? this.createStringExpr(prefix) : this.createBinaryExpr(prefix.toBinaryValue(this._scriptEncoding));
        do {
            Expr tail;
            if (token == 296 || token == 299) {
                tail = this.parseExpr();
                this.expect(125);
            } else if (token == 295 || token == 298) {
                int ch = this.read();
                this._sb.setLength(0);
                while (this.isIdentifierPart(ch)) {
                    this._sb.append((char)ch);
                    ch = this.read();
                }
                this._peek = ch;
                tail = this._sb.equalsString("this") ? this._factory.createThis(this._classDef) : this._factory.createVar(this._function.createVar(this.copyStringValue(this._sb)));
                ch = this.read();
                if (ch == 91 || ch == 45) {
                    if (ch == 91) {
                        tail = this.parseSimpleArrayTail(tail);
                        ch = this.read();
                    } else {
                        ch = this.read();
                        if (ch != 62) {
                            tail = this._factory.createAppend(tail, this.createStringExpr("-"));
                        } else {
                            ch = this.read();
                            if (this.isIdentifierPart(ch)) {
                                this._sb.setLength(0);
                                while (this.isIdentifierPart(ch)) {
                                    this._sb.append((char)ch);
                                    ch = this.read();
                                }
                                tail = tail.createFieldGet(this._factory, this.getLocation(), this.copyStringValue(this._sb));
                            } else {
                                tail = this._factory.createAppend(tail, this.createStringExpr("->"));
                            }
                        }
                        this._peek = ch;
                    }
                }
                this._peek = ch;
            } else {
                throw this.error("unexpected token");
            }
            expr = this._factory.createAppend(expr, tail);
            token = isSystem ? this.parseEscapedString('`') : this.parseEscapedString('\"');
            if (this._sb.length() <= 0) continue;
            Expr string = isUnicode ? this.createStringExpr(this.copyStringValue(this._sb)) : this.createBinaryExpr(this.copyStringValue(this._sb.toBinaryValue(this._scriptEncoding)));
            expr = this._factory.createAppend(expr, string);
        } while (token != 257);
        return expr;
    }

    private Expr parseSimpleArrayTail(Expr tail) throws IOException {
        int ch = this.read();
        this._sb.setLength(0);
        if (ch == 36) {
            ch = this.read();
            while (this.isIdentifierPart(ch)) {
                this._sb.append((char)ch);
                ch = this.read();
            }
            StringValue nameV = this.copyStringValue(this._sb);
            VarExpr var = this._factory.createVar(this._function.createVar(nameV));
            tail = this._factory.createArrayGet(this.getLocation(), tail, var);
        } else if (48 <= ch && ch <= 57) {
            long index = ch - 48;
            ch = this.read();
            while (48 <= ch && ch <= 57) {
                index = 10L * index + (long)ch - 48L;
                ch = this.read();
            }
            tail = this._factory.createArrayGet(this.getLocation(), tail, this._factory.createLong(index));
        } else if (this.isIdentifierPart(ch)) {
            while (this.isIdentifierPart(ch)) {
                this._sb.append((char)ch);
                ch = this.read();
            }
            ConstExpr constExpr = this._factory.createConst(this._sb.toString());
            tail = this._factory.createArrayGet(this.getLocation(), tail, constExpr);
        } else {
            throw this.error(L.l("Unexpected character at {0}", (Object)String.valueOf((char)ch)));
        }
        if (ch != 93) {
            throw this.error(L.l("Expected ']' at {0}", (Object)String.valueOf((char)ch)));
        }
        return tail;
    }

    private Expr createStringExpr(String lexeme) {
        StringValue value = this.createStringValue(lexeme);
        return this.createStringExpr(value);
    }

    private Expr createStringExpr(StringValue lexeme) {
        if (lexeme.isUnicode()) {
            return this._factory.createUnicode((UnicodeValue)lexeme);
        }
        return this._factory.createString(lexeme);
    }

    private Expr createBinaryExpr(StringValue lexeme) {
        if (lexeme.isUnicode()) {
            return this._factory.createBinary((BinaryValue)lexeme);
        }
        return this._factory.createString(lexeme);
    }

    private StringValue createStringValue(String lexeme) {
        if (this.isUnicodeSemantics()) {
            return new UnicodeBuilderValue(lexeme);
        }
        return new ConstStringValue(lexeme);
    }

    private StringValue copyStringValue(StringValue value) {
        if (value instanceof StringBuilderValue) {
            return new ConstStringValue((StringBuilderValue)value);
        }
        return value.createStringBuilder().append(value);
    }

    private StringValue createStringBuilder() {
        if (this.isUnicodeSemantics()) {
            return new UnicodeBuilderValue();
        }
        return new StringBuilderValue();
    }

    private int parseEscapedString(char end) throws IOException {
        return this.parseEscapedString(end, this.isUnicodeSemantics());
    }

    private int parseEscapedString(char end, boolean isUnicode) throws IOException {
        int ch;
        this._sb.setLength(0);
        block12: while ((ch = this.read()) > 0) {
            if (this._heredocEnd == null && ch == end) {
                this._lexeme = this.copyStringValue(this._sb);
                return 257;
            }
            if (ch == 92) {
                ch = this.read();
                switch (ch) {
                    case 48: 
                    case 49: 
                    case 50: 
                    case 51: {
                        this._sb.append((char)this.parseOctalEscape(ch));
                        continue block12;
                    }
                    case 116: {
                        this._sb.append('\t');
                        continue block12;
                    }
                    case 114: {
                        this._sb.append('\r');
                        continue block12;
                    }
                    case 110: {
                        this._sb.append('\n');
                        continue block12;
                    }
                    case 34: 
                    case 96: {
                        if (this._heredocEnd != null) {
                            this._sb.append('\\');
                        }
                        this._sb.append((char)ch);
                        continue block12;
                    }
                    case 36: 
                    case 92: {
                        this._sb.append((char)ch);
                        continue block12;
                    }
                    case 120: {
                        int value = this.parseHexEscape();
                        if (value >= 0) {
                            this._sb.append((char)value);
                            continue block12;
                        }
                        this._sb.append('\\');
                        this._sb.append('x');
                        continue block12;
                    }
                    case 117: {
                        int result;
                        if (isUnicode) {
                            result = this.parseUnicodeEscape(false);
                            if (result < 0) {
                                this._sb.append('\\');
                                this._sb.append('u');
                                continue block12;
                            }
                            this._sb.append(Character.toChars(result));
                            continue block12;
                        }
                        this._sb.append('\\');
                        this._sb.append((char)ch);
                        continue block12;
                    }
                    case 85: {
                        int result;
                        if (isUnicode) {
                            result = this.parseUnicodeEscape(true);
                            if (result < 0) {
                                this._sb.append('\\');
                                this._sb.append('U');
                                continue block12;
                            }
                            this._sb.append(Character.toChars(result));
                            continue block12;
                        }
                        this._sb.append('\\');
                        this._sb.append((char)ch);
                        continue block12;
                    }
                    case 123: {
                        this._peek = ch = this.read();
                        if (ch == 36 && this._heredocEnd == null) {
                            this._sb.append('{');
                            continue block12;
                        }
                        this._sb.append("\\{");
                        continue block12;
                    }
                }
                this._sb.append('\\');
                this._sb.append((char)ch);
                continue;
            }
            if (ch == 36) {
                ch = this.read();
                if (ch == 123) {
                    this._peek = 36;
                    this._lexeme = this.copyStringValue(this._sb);
                    return 296;
                }
                if (this.isIdentifierStart(ch)) {
                    this._peek = ch;
                    this._lexeme = this.copyStringValue(this._sb);
                    return 295;
                }
                this._sb.append('$');
                this._peek = ch;
                continue;
            }
            if (ch == 123) {
                ch = this.read();
                if (ch == 36) {
                    this._peek = ch;
                    this._lexeme = this.copyStringValue(this._sb);
                    return 296;
                }
                this._peek = ch;
                this._sb.append('{');
                continue;
            }
            this._sb.append((char)ch);
            if (this._heredocEnd == null || !this._sb.endsWith(this._heredocEnd) || this._sb.length() != this._heredocEnd.length() && this._sb.charAt(this._sb.length() - this._heredocEnd.length() - 1) != '\n' && this._sb.charAt(this._sb.length() - this._heredocEnd.length() - 1) != '\r') continue;
            this._sb.setLength(this._sb.length() - this._heredocEnd.length());
            if (this._sb.length() > 0 && this._sb.charAt(this._sb.length() - 1) == '\n') {
                this._sb.setLength(this._sb.length() - 1);
            }
            if (this._sb.length() > 0 && this._sb.charAt(this._sb.length() - 1) == '\r') {
                this._sb.setLength(this._sb.length() - 1);
            }
            this._heredocEnd = null;
            this._lexeme = this.copyStringValue(this._sb);
            return 257;
        }
        this._lexeme = this.copyStringValue(this._sb);
        return 257;
    }

    private boolean isNamespaceIdentifierStart(int ch) {
        return this.isIdentifierStart(ch) || ch == 92;
    }

    private boolean isIdentifierStart(int ch) {
        if (ch < 0) {
            return false;
        }
        return 97 <= ch && ch <= 122 || 65 <= ch && ch <= 90 || ch == 95 || 127 <= ch && ch <= 255 || Character.isLetter(ch);
    }

    private boolean isNamespaceIdentifierPart(int ch) {
        return this.isIdentifierPart(ch) || ch == 92;
    }

    private boolean isIdentifierPart(int ch) {
        if (ch < 0) {
            return false;
        }
        return 97 <= ch && ch <= 122 || 65 <= ch && ch <= 90 || ch >= 48 && ch <= 57 || ch == 95 || 127 <= ch && ch <= 255 || Character.isLetterOrDigit(ch);
    }

    private int parseOctalEscape(int ch) throws IOException {
        int value = ch - 48;
        ch = this.read();
        if (ch < 48 || ch > 55) {
            this._peek = ch;
            return value;
        }
        value = 8 * value + ch - 48;
        ch = this.read();
        if (ch < 48 || ch > 55) {
            this._peek = ch;
            return value;
        }
        value = 8 * value + ch - 48;
        return value;
    }

    private int parseHexEscape() throws IOException {
        int value = 0;
        int ch = this.read();
        if (48 <= ch && ch <= 57) {
            value = 16 * value + ch - 48;
        } else if (97 <= ch && ch <= 102) {
            value = 16 * value + 10 + ch - 97;
        } else if (65 <= ch && ch <= 70) {
            value = 16 * value + 10 + ch - 65;
        } else {
            this._peek = ch;
            return -1;
        }
        ch = this.read();
        if (48 <= ch && ch <= 57) {
            value = 16 * value + ch - 48;
        } else if (97 <= ch && ch <= 102) {
            value = 16 * value + 10 + ch - 97;
        } else if (65 <= ch && ch <= 70) {
            value = 16 * value + 10 + ch - 65;
        } else {
            this._peek = ch;
            return value;
        }
        return value;
    }

    private int parseUnicodeEscape(boolean isLongForm) throws IOException {
        int codePoint = this.parseHexEscape();
        if (codePoint < 0) {
            return -1;
        }
        int low = this.parseHexEscape();
        if (low < 0) {
            return codePoint;
        }
        codePoint = codePoint * 256 + low;
        if (isLongForm) {
            low = this.parseHexEscape();
            if (low < 0) {
                return codePoint;
            }
            codePoint = codePoint * 256 + low;
        }
        return codePoint;
    }

    private int parseNumberToken(int ch) throws IOException {
        int ch0 = ch;
        if (ch == 48) {
            ch = this.read();
            if (ch == 120 || ch == 88) {
                return this.parseHex();
            }
            if (ch == 98 || ch == 66) {
                return this.parseBinary();
            }
            if (ch == 48) {
                return this.parseNumberToken(ch);
            }
            this._peek = ch;
            ch = 48;
        }
        this._sb.setLength(0);
        int token = 258;
        while (48 <= ch && ch <= 57) {
            this._sb.append((char)ch);
            ch = this.read();
        }
        if (ch == 46) {
            token = 259;
            this._sb.append((char)ch);
            ch = this.read();
            while (48 <= ch && ch <= 57) {
                this._sb.append((char)ch);
                ch = this.read();
            }
        }
        if (ch == 101 || ch == 69) {
            token = 259;
            this._sb.append((char)ch);
            ch = this.read();
            if (ch == 43 || ch == 45) {
                this._sb.append((char)ch);
                ch = this.read();
            }
            if (48 <= ch && ch <= 57) {
                while (48 <= ch && ch <= 57) {
                    this._sb.append((char)ch);
                    ch = this.read();
                }
            } else {
                throw this.error(L.l("illegal exponent"));
            }
        }
        this._peek = ch;
        if (ch0 == 48 && token == 258) {
            int len = this._sb.length();
            int value = 0;
            for (int i = 0; i < len && 48 <= (ch = (int)this._sb.charAt(i)) && ch <= 55; ++i) {
                value = value * 8 + ch - 48;
            }
            this._lexeme = this.createStringValue(String.valueOf(value));
        } else {
            this._lexeme = this.copyStringValue(this._sb);
        }
        return token;
    }

    private int parseHex() throws IOException {
        int ch;
        long value = 0L;
        double dValue = 0.0;
        while (true) {
            if (48 <= (ch = this.read()) && ch <= 57) {
                value = 16L * value + (long)ch - 48L;
                dValue = 16.0 * dValue + (double)ch - 48.0;
                continue;
            }
            if (97 <= ch && ch <= 102) {
                value = 16L * value + (long)ch - 97L + 10L;
                dValue = 16.0 * dValue + (double)ch - 97.0 + 10.0;
                continue;
            }
            if (65 > ch || ch > 70) break;
            value = 16L * value + (long)ch - 65L + 10L;
            dValue = 16.0 * dValue + (double)ch - 65.0 + 10.0;
        }
        this._peek = ch;
        if ((double)value == dValue) {
            this._lexeme = this.createStringValue(String.valueOf(value));
            return 258;
        }
        this._lexeme = this.createStringValue(String.valueOf(dValue));
        return 259;
    }

    private int parseBinary() throws IOException {
        int ch;
        long value = 0L;
        double dValue = 0.0;
        while ((ch = this.read()) == 48 || ch == 49) {
            value = (value << 1) + (long)ch - 48L;
            dValue = dValue * 2.0 + (double)ch - 48.0;
        }
        this._peek = ch;
        if ((double)value == dValue) {
            this._lexeme = this.createStringValue(String.valueOf(value));
            return 258;
        }
        this._lexeme = this.createStringValue(String.valueOf(dValue));
        return 259;
    }

    private int parseOctal(int ch) throws IOException {
        long value = 0L;
        double dValue = 0.0;
        while (true) {
            if (48 > ch || ch > 55) {
                while (48 <= ch && ch <= 57) {
                    ch = this.read();
                }
                break;
            }
            value = 8L * value + (long)ch - 48L;
            dValue = 8.0 * dValue + (double)ch - 48.0;
            ch = this.read();
        }
        this._peek = ch;
        if ((double)value == dValue) {
            this._lexeme = this.createStringValue(String.valueOf(value));
            return 258;
        }
        this._lexeme = this.createStringValue(String.valueOf(dValue));
        return 259;
    }

    private void expect(int expect) throws IOException {
        int token = this.parseToken();
        if (token != expect) {
            throw this.error(L.l("expected {0} at {1}", (Object)this.tokenName(expect), (Object)this.tokenName(token)));
        }
    }

    private int read() throws IOException {
        int peek = this._peek;
        if (peek >= 0) {
            this._peek = -1;
            return peek;
        }
        try {
            int ch = this.readInternal();
            if (ch == 13) {
                this._parserLocation.incrementLineNumber();
                this._hasCr = true;
            } else if (ch == 10 && !this._hasCr) {
                this._parserLocation.incrementLineNumber();
            } else {
                this._hasCr = false;
            }
            return ch;
        }
        catch (CharConversionException e) {
            throw new QuercusParseException(this.getFileName() + ":" + this.getLine() + ": " + e + "\nCheck that the script-encoding setting matches the source file's encoding", e);
        }
        catch (IOException e) {
            throw new IOExceptionWrapper(this.getFileName() + ":" + this.getLine() + ":" + e, e);
        }
    }

    private int readInternal() throws IOException {
        if (this._reader != null) {
            return this._reader.read();
        }
        return this._is.readChar();
    }

    private QuercusParseException expect(String expected, int token) {
        return this.error(L.l("expected {0} at {1}", (Object)expected, (Object)this.tokenName(token)));
    }

    public QuercusParseException error(String msg) {
        int lines;
        int first;
        int lineNumber = this._parserLocation.getLineNumber();
        String[] sourceLines = Env.getSourceLine(this._sourceFile, lineNumber - (first = (lines = 5) / 2) + this._sourceOffset, lines);
        if (sourceLines != null && sourceLines.length > 0) {
            StringBuilder sb = new StringBuilder();
            String shortFile = this._parserLocation.getFileName();
            int p = shortFile.lastIndexOf(47);
            if (p > 0) {
                shortFile = shortFile.substring(p + 1);
            }
            sb.append(this._parserLocation.toString()).append(msg).append(" in");
            for (int i = 0; i < sourceLines.length; ++i) {
                if (sourceLines[i] == null) continue;
                sb.append("\n");
                sb.append(shortFile).append(":").append(lineNumber - first + i).append(": ").append(sourceLines[i]);
            }
            return new QuercusParseException(sb.toString());
        }
        return new QuercusParseException(this._parserLocation.toString() + msg);
    }

    private String tokenName(int token) {
        switch (token) {
            case -1: {
                return "end of file";
            }
            case 39: {
                return "'";
            }
            case 537: {
                return "'as'";
            }
            case 561: {
                return "true";
            }
            case 562: {
                return "false";
            }
            case 557: {
                return "'and'";
            }
            case 558: {
                return "'or'";
            }
            case 556: {
                return "'xor'";
            }
            case 273: {
                return "'&&'";
            }
            case 274: {
                return "'||'";
            }
            case 514: {
                return "'if'";
            }
            case 528: {
                return "'else'";
            }
            case 545: {
                return "'elseif'";
            }
            case 551: {
                return "'endif'";
            }
            case 515: {
                return "'while'";
            }
            case 552: {
                return "'endwhile'";
            }
            case 525: {
                return "'do'";
            }
            case 524: {
                return "'for'";
            }
            case 553: {
                return "'endfor'";
            }
            case 536: {
                return "'foreach'";
            }
            case 554: {
                return "'endforeach'";
            }
            case 540: {
                return "'switch'";
            }
            case 555: {
                return "'endswitch'";
            }
            case 512: {
                return "'echo'";
            }
            case 546: {
                return "'print'";
            }
            case 559: {
                return "'list'";
            }
            case 541: {
                return "'case'";
            }
            case 542: {
                return "'default'";
            }
            case 517: {
                return "'class'";
            }
            case 572: {
                return "'interface'";
            }
            case 573: {
                return "'trait'";
            }
            case 579: {
                return "'insteadof'";
            }
            case 529: {
                return "'extends'";
            }
            case 574: {
                return "'implements'";
            }
            case 519: {
                return "'return'";
            }
            case 568: {
                return "'die'";
            }
            case 543: {
                return "'exit'";
            }
            case 569: {
                return "'throw'";
            }
            case 563: {
                return "'clone'";
            }
            case 564: {
                return "'instanceof'";
            }
            case 295: {
                return "string";
            }
            case 296: {
                return "string";
            }
            case 532: {
                return "'require'";
            }
            case 534: {
                return "'require_once'";
            }
            case 521: {
                return "'private'";
            }
            case 522: {
                return "'protected'";
            }
            case 523: {
                return "'public'";
            }
            case 530: {
                return "'static'";
            }
            case 567: {
                return "'final'";
            }
            case 566: {
                return "'abstract'";
            }
            case 565: {
                return "'const'";
            }
            case 544: {
                return "'global'";
            }
            case 516: {
                return "'function'";
            }
            case 560: {
                return "'this'";
            }
            case 294: {
                return "'=>'";
            }
            case 260: {
                return "'<<'";
            }
            case 256: {
                return "'" + this._lexeme + "'";
            }
            case 258: {
                return "integer (" + this._lexeme + ")";
            }
            case 259: {
                return "double (" + this._lexeme + ")";
            }
            case 538: {
                return "TEXT (token " + token + ")";
            }
            case 257: {
                return "string(" + this._lexeme + ")";
            }
            case 550: {
                return "<?=";
            }
            case 291: {
                return "SCOPE (" + this._lexeme + ")";
            }
            case 577: {
                return "NAMESPACE";
            }
            case 578: {
                return "USE";
            }
        }
        if (32 <= token && token < 127) {
            return "'" + (char)token + "'";
        }
        return "(token " + token + ")";
    }

    public Location getLocation() {
        return this._parserLocation.getLocation();
    }

    private String pushWhileLabel() {
        return this.pushLoopLabel(this.createWhileLabel());
    }

    private String pushDoLabel() {
        return this.pushLoopLabel(this.createDoLabel());
    }

    private String pushForLabel() {
        return this.pushLoopLabel(this.createForLabel());
    }

    private String pushForeachLabel() {
        return this.pushLoopLabel(this.createForeachLabel());
    }

    private String pushSwitchLabel() {
        return this.pushLoopLabel(this.createSwitchLabel());
    }

    private String pushLoopLabel(String label) {
        this._loopLabelList.add(label);
        return label;
    }

    private String popLoopLabel() {
        int size = this._loopLabelList.size();
        if (size == 0) {
            return null;
        }
        return this._loopLabelList.remove(size - 1);
    }

    private String createWhileLabel() {
        return "while_" + this._labelsCreated++;
    }

    private String createDoLabel() {
        return "do_" + this._labelsCreated++;
    }

    private String createForLabel() {
        return "for_" + this._labelsCreated++;
    }

    private String createForeachLabel() {
        return "foreach_" + this._labelsCreated++;
    }

    private String createSwitchLabel() {
        return "switch_" + this._labelsCreated++;
    }

    public static boolean isSwitchLabel(String label) {
        return label != null && label.startsWith("switch");
    }

    public void close() {
        ReadStream is = this._is;
        this._is = null;
        if (is != null) {
            try {
                is.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        Reader reader = this._reader;
        this._reader = null;
        if (reader != null) {
            try {
                reader.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    static {
        _insensitiveReserved.put("echo", 512);
        _insensitiveReserved.put("print", 546);
        _insensitiveReserved.put("if", 514);
        _insensitiveReserved.put("else", 528);
        _insensitiveReserved.put("elseif", 545);
        _insensitiveReserved.put("do", 525);
        _insensitiveReserved.put("while", 515);
        _insensitiveReserved.put("for", 524);
        _insensitiveReserved.put("function", 516);
        _insensitiveReserved.put("class", 517);
        _insensitiveReserved.put("new", 518);
        _insensitiveReserved.put("return", 519);
        _insensitiveReserved.put("break", 526);
        _insensitiveReserved.put("continue", 527);
        _insensitiveReserved.put("this", 560);
        _insensitiveReserved.put("private", 521);
        _insensitiveReserved.put("protected", 522);
        _insensitiveReserved.put("public", 523);
        _insensitiveReserved.put("and", 557);
        _insensitiveReserved.put("xor", 556);
        _insensitiveReserved.put("or", 558);
        _insensitiveReserved.put("extends", 529);
        _insensitiveReserved.put("static", 530);
        _insensitiveReserved.put("include", 531);
        _insensitiveReserved.put("require", 532);
        _insensitiveReserved.put("include_once", 533);
        _insensitiveReserved.put("require_once", 534);
        _insensitiveReserved.put("unset", 535);
        _insensitiveReserved.put("empty", 580);
        _insensitiveReserved.put("foreach", 536);
        _insensitiveReserved.put("as", 537);
        _insensitiveReserved.put("switch", 540);
        _insensitiveReserved.put("case", 541);
        _insensitiveReserved.put("default", 542);
        _insensitiveReserved.put("die", 568);
        _insensitiveReserved.put("exit", 543);
        _insensitiveReserved.put("global", 544);
        _insensitiveReserved.put("list", 559);
        _insensitiveReserved.put("endif", 551);
        _insensitiveReserved.put("endwhile", 552);
        _insensitiveReserved.put("endfor", 553);
        _insensitiveReserved.put("endforeach", 554);
        _insensitiveReserved.put("endswitch", 555);
        _insensitiveReserved.put("true", 561);
        _insensitiveReserved.put("false", 562);
        _insensitiveReserved.put("null", 513);
        _insensitiveReserved.put("clone", 563);
        _insensitiveReserved.put("instanceof", 564);
        _insensitiveReserved.put("const", 565);
        _insensitiveReserved.put("final", 567);
        _insensitiveReserved.put("abstract", 566);
        _insensitiveReserved.put("throw", 569);
        _insensitiveReserved.put("try", 570);
        _insensitiveReserved.put("catch", 571);
        _insensitiveReserved.put("interface", 572);
        _insensitiveReserved.put("trait", 573);
        _insensitiveReserved.put("insteadof", 579);
        _insensitiveReserved.put("implements", 574);
        _insensitiveReserved.put("import", 575);
        _insensitiveReserved.put("namespace", 577);
        _insensitiveReserved.put("use", 578);
    }

    private class ParserLocation {
        private int _lineNumber = 1;
        private String _fileName;
        private String _userPath;
        private String _lastClassName;
        private String _lastFunctionName;
        private Location _location;

        private ParserLocation() {
        }

        public int getLineNumber() {
            return this._lineNumber;
        }

        public void setLineNumber(int lineNumber) {
            this._lineNumber = lineNumber;
            this._location = null;
        }

        public void incrementLineNumber() {
            ++this._lineNumber;
            this._location = null;
        }

        public String getFileName() {
            return this._fileName;
        }

        public void setFileName(String fileName) {
            this._fileName = fileName;
            this._userPath = fileName;
            this._location = null;
        }

        public void setFileName(Path path) {
            this._fileName = path.getNativePath();
            this._userPath = path.getUserPath();
        }

        public String getUserPath() {
            return this._userPath;
        }

        public Location getLocation() {
            String currentClassName;
            String currentFunctionName = null;
            if (QuercusParser.this._function != null && !QuercusParser.this._function.isPageMain()) {
                currentFunctionName = QuercusParser.this._function.getName();
            }
            String string = currentClassName = QuercusParser.this._classDef == null ? null : QuercusParser.this._classDef.getName();
            if (this._location != null) {
                if (!this.equals(currentFunctionName, this._lastFunctionName)) {
                    this._location = null;
                } else if (!this.equals(currentClassName, this._lastClassName)) {
                    this._location = null;
                }
            }
            if (this._location == null) {
                this._location = new Location(this._fileName, this._userPath, this._lineNumber, currentClassName, currentFunctionName);
            }
            this._lastFunctionName = currentFunctionName;
            this._lastClassName = currentClassName;
            return this._location;
        }

        private boolean equals(String s1, String s2) {
            return s1 == null || s2 == null ? s1 == s2 : s1.equals(s2);
        }

        public String toString() {
            return this._fileName + ":" + this._lineNumber + ": ";
        }
    }
}

