/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.quercus.program;

import com.caucho.quercus.Location;
import com.caucho.quercus.env.Env;
import com.caucho.quercus.env.FieldVisibility;
import com.caucho.quercus.env.ObjectExtValue;
import com.caucho.quercus.env.ObjectValue;
import com.caucho.quercus.env.QuercusClass;
import com.caucho.quercus.env.StringValue;
import com.caucho.quercus.env.Value;
import com.caucho.quercus.expr.Expr;
import com.caucho.quercus.function.AbstractFunction;
import com.caucho.quercus.program.ClassField;
import com.caucho.quercus.program.InstanceInitializer;
import com.caucho.quercus.program.TraitAliasMap;
import com.caucho.quercus.program.TraitInsteadofMap;
import com.caucho.util.L10N;
import java.util.HashSet;
import java.util.Locale;
import java.util.Map;
import java.util.Set;

public abstract class ClassDef
implements InstanceInitializer {
    private static final L10N L = new L10N(ClassDef.class);
    private final Location _location;
    private final String _name;
    private final String _parentName;
    private String[] _ifaceList;
    private String[] _traitList;
    private TraitInsteadofMap _traitInsteadofMap;
    private TraitAliasMap _traitAliasMap;
    protected static final String[] NULL_STRING_ARRAY = new String[0];

    protected ClassDef(Location location, String name, String parentName) {
        this(location, name, parentName, NULL_STRING_ARRAY, NULL_STRING_ARRAY);
    }

    protected ClassDef(Location location, String name, String parentName, String[] ifaceList) {
        this(location, name, parentName, ifaceList, NULL_STRING_ARRAY);
    }

    protected ClassDef(Location location, String name, String parentName, String[] ifaceList, String[] traitList) {
        this._location = location;
        this._name = name;
        this._parentName = parentName;
        this._ifaceList = ifaceList;
        this._traitList = traitList;
    }

    public Location getLocation() {
        return this._location;
    }

    public String getName() {
        return this._name;
    }

    public String getParentName() {
        return this._parentName;
    }

    public String getExtension() {
        return null;
    }

    protected void addInterface(String iface) {
        for (int i = 0; i < this._ifaceList.length; ++i) {
            if (!this._ifaceList[i].equals(iface)) continue;
            return;
        }
        String[] ifaceList = new String[this._ifaceList.length + 1];
        System.arraycopy(this._ifaceList, 0, ifaceList, 0, this._ifaceList.length);
        ifaceList[ifaceList.length - 1] = iface;
        this._ifaceList = ifaceList;
    }

    public void addTrait(String trait) {
        for (int i = 0; i < this._traitList.length; ++i) {
            if (!this._traitList[i].equals(trait)) continue;
            return;
        }
        String[] traitList = new String[this._traitList.length + 1];
        System.arraycopy(this._traitList, 0, traitList, 0, this._traitList.length);
        traitList[traitList.length - 1] = trait;
        this._traitList = traitList;
    }

    public boolean hasTrait(String traitName) {
        for (String trait : this._traitList) {
            if (!trait.equals(traitName)) continue;
            return true;
        }
        return false;
    }

    public final TraitInsteadofMap getTraitInsteadofMap() {
        return this._traitInsteadofMap;
    }

    public final TraitAliasMap getTraitAliasMap() {
        return this._traitAliasMap;
    }

    public void addTraitInsteadOf(StringValue funName, String traitName, String insteadofTraitName) {
        TraitInsteadofMap traitInsteadofMap = this._traitInsteadofMap;
        if (traitInsteadofMap == null) {
            this._traitInsteadofMap = traitInsteadofMap = new TraitInsteadofMap();
        }
        traitInsteadofMap.put(funName, traitName, insteadofTraitName);
    }

    public void addTraitAlias(StringValue funName, StringValue funNameAlias, String traitName) {
        TraitAliasMap traitAliasMap = this._traitAliasMap;
        if (traitAliasMap == null) {
            this._traitAliasMap = traitAliasMap = new TraitAliasMap();
        }
        traitAliasMap.put(funName, funNameAlias, traitName);
    }

    public ClassDef loadClassDef() {
        return this;
    }

    public AbstractFunction getCall() {
        return null;
    }

    public AbstractFunction getCallStatic() {
        return null;
    }

    public AbstractFunction getSerialize() {
        return null;
    }

    public AbstractFunction getUnserialize() {
        return null;
    }

    public void init() {
    }

    public void init(QuercusClass cl) {
    }

    public String[] getInterfaces() {
        return this._ifaceList;
    }

    public String[] getTraits() {
        return this._traitList;
    }

    public void addInterfaces(HashSet<String> interfaceSet) {
        interfaceSet.add(this.getName().toLowerCase(Locale.ENGLISH));
        for (String name : this.getInterfaces()) {
            interfaceSet.add(name.toLowerCase(Locale.ENGLISH));
        }
    }

    public void addTraits(HashSet<String> traitSet) {
        for (String name : this.getTraits()) {
            traitSet.add(name.toLowerCase(Locale.ENGLISH));
        }
    }

    public boolean isAbstract() {
        return false;
    }

    public boolean isInterface() {
        return false;
    }

    public boolean isTrait() {
        return false;
    }

    public boolean isFinal() {
        return false;
    }

    public boolean hasNonPublicMethods() {
        return false;
    }

    public void initClassMethods(QuercusClass cl, String bindingClassName) {
    }

    public void initClassFields(QuercusClass cl, String bindingClassName) {
    }

    public ObjectValue createObject(Env env, QuercusClass cls) {
        if (this.isAbstract()) {
            throw env.createErrorException(L.l("abstract class '{0}' cannot be instantiated.", (Object)this.getName()));
        }
        if (this.isInterface()) {
            throw env.createErrorException(L.l("interface '{0}' cannot be instantiated.", (Object)this.getName()));
        }
        return new ObjectExtValue(env, cls);
    }

    public Value callNew(Env env, Expr[] args) {
        return null;
    }

    public Value callNew(Env env, Value[] args) {
        return null;
    }

    public boolean isA(Env env, String name) {
        if (this._name.equalsIgnoreCase(name)) {
            return true;
        }
        for (int i = 0; i < this._ifaceList.length; ++i) {
            if (!this._ifaceList[i].equalsIgnoreCase(name)) continue;
            return true;
        }
        return false;
    }

    public abstract AbstractFunction findConstructor();

    public Expr findConstant(String name) {
        return null;
    }

    public String getComment() {
        return null;
    }

    public String getFieldComment(StringValue name) {
        return null;
    }

    public String getStaticFieldComment(StringValue name) {
        return null;
    }

    public String toString() {
        return this.getClass().getSimpleName() + "@" + System.identityHashCode(this) + "[" + this._name + "]";
    }

    public Set<Map.Entry<StringValue, ClassField>> fieldSet() {
        return null;
    }

    public ClassField getField(StringValue name) {
        return null;
    }

    public Set<Map.Entry<StringValue, StaticFieldEntry>> staticFieldSet() {
        return null;
    }

    public Set<Map.Entry<StringValue, AbstractFunction>> functionSet() {
        return null;
    }

    public static class StaticFieldEntry {
        private final Expr _value;
        private final String _comment;

        public StaticFieldEntry(Expr value) {
            this._value = value;
            this._comment = null;
        }

        public StaticFieldEntry(Expr value, String comment) {
            this._value = value;
            this._comment = comment;
        }

        public Expr getValue() {
            return this._value;
        }

        public String getComment() {
            return this._comment;
        }
    }

    public static class FieldEntry {
        private final Expr _value;
        private final FieldVisibility _visibility;
        private final String _comment;

        public FieldEntry(Expr value, FieldVisibility visibility) {
            this._value = value;
            this._visibility = visibility;
            this._comment = null;
        }

        public FieldEntry(Expr value, FieldVisibility visibility, String comment) {
            this._value = value;
            this._visibility = visibility;
            this._comment = comment;
        }

        public Expr getValue() {
            return this._value;
        }

        public FieldVisibility getVisibility() {
            return this._visibility;
        }

        public String getComment() {
            return this._comment;
        }
    }
}

